#ifndef KYBER_SELFTEST_TESTVECTORS_H
#define KYBER_SELFTEST_TESTVECTORS_H
#include "fips_mode.h"
#include "kyber_type.h"
struct kyber_testvector {
	const struct lc_kyber_pk pk;
	const struct lc_kyber_sk sk;
	const struct lc_kyber_ct ct;
	const struct lc_kyber_ss ss;
};

LC_FIPS_RODATA_SECTION
static const struct kyber_testvector kyber_testvectors[] =
{
	{
		.pk.pk = {
			FIPS140_MOD(0xc2), 0x9a, 0xc6, 0x6c, 0x84, 0xbe, 0xe3, 0xf1,
			0x29, 0x50, 0x8c, 0x2b, 0x8c, 0x79, 0x0c, 0x99,
			0xa5, 0xca, 0x41, 0xe5, 0x70, 0x7e, 0x9b, 0x8c,
			0x75, 0xc0, 0x4d, 0x7e, 0xa8, 0xa4, 0x81, 0x98,
			0x0a, 0x35, 0x8b, 0x06, 0x6a, 0x4a, 0x7e, 0x28,
			0xd1, 0x5d, 0x10, 0x37, 0x4f, 0x75, 0xc3, 0x3d,
			0xa6, 0x02, 0x9c, 0xd4, 0x90, 0x74, 0x6f, 0xb5,
			0x5f, 0x5f, 0xea, 0xb2, 0xce, 0x82, 0x3d, 0xec,
			0x18, 0x30, 0xc0, 0xc1, 0x8e, 0xf8, 0x9b, 0xa3,
			0xcc, 0x3b, 0xce, 0x4d, 0x25, 0x2a, 0x07, 0xa4,
			0x0d, 0x40, 0x1a, 0x4c, 0x8d, 0x27, 0x36, 0x18,
			0xb5, 0x95, 0xdb, 0x21, 0xca, 0x4a, 0x95, 0x9e,
			0xb4, 0xd1, 0x33, 0x55, 0x68, 0x01, 0xb2, 0xb7,
			0x82, 0x54, 0xb2, 0xb5, 0x95, 0x5c, 0x04, 0x00,
			0x96, 0x2d, 0xbb, 0x5a, 0x48, 0x7a, 0xaa, 0x24,
			0xa4, 0x30, 0xb6, 0x14, 0xe2, 0xaf, 0x93, 0x38,
			0xaf, 0xd4, 0xb0, 0x33, 0x9b, 0xd8, 0x30, 0xa9,
			0xcb, 0x76, 0x1d, 0xb1, 0xa8, 0x32, 0x20, 0x35,
			0x2d, 0xd5, 0x23, 0xb8, 0xa5, 0x83, 0x02, 0x2c,
			0xa1, 0x3e, 0x24, 0x65, 0x06, 0x54, 0x8c, 0x57,
			0xba, 0x38, 0x50, 0xac, 0x5c, 0x50, 0xd8, 0x64,
			0xe2, 0xd4, 0x8b, 0x89, 0x69, 0x42, 0x77, 0xcc,
			0x7a, 0x81, 0x74, 0xad, 0x7b, 0x1b, 0xa2, 0xee,
			0x62, 0x1d, 0x57, 0xd2, 0x9b, 0x23, 0xc2, 0x2d,
			0xf8, 0x31, 0x87, 0x20, 0x51, 0x14, 0x5d, 0x25,
			0x35, 0xdb, 0xb0, 0x25, 0xe2, 0x9c, 0x6d, 0xa3,
			0x8c, 0xb4, 0x75, 0x95, 0x8e, 0x2a, 0x88, 0x08,
			0xa4, 0x31, 0xbe, 0xd5, 0xb4, 0x86, 0x82, 0x1a,
			0x15, 0x13, 0xa7, 0x29, 0xcd, 0x97, 0x9b, 0x6c,
			0x8b, 0x38, 0x25, 0x03, 0xcf, 0x53, 0x33, 0x76,
			0x16, 0xe1, 0x05, 0x9d, 0xdc, 0x59, 0x97, 0x72,
			0x19, 0xd2, 0xf1, 0x7b, 0x32, 0xac, 0xab, 0xbe,
			0x86, 0xc4, 0x68, 0xc1, 0x26, 0x7b, 0x2b, 0x86,
			0x2a, 0xc5, 0x65, 0xa7, 0xe2, 0x32, 0x26, 0x6c,
			0x83, 0xfc, 0x70, 0x0c, 0xda, 0x19, 0xb6, 0x16,
			0x37, 0x73, 0x89, 0x42, 0x8e, 0x62, 0x61, 0x4c,
			0xd6, 0xac, 0x9f, 0x08, 0xfb, 0x12, 0xd2, 0x18,
			0x27, 0xfe, 0xb3, 0x24, 0xb1, 0x4b, 0xc1, 0x6c,
			0xc0, 0xc2, 0x09, 0x04, 0xb3, 0x97, 0x3b, 0x9d,
			0xfe, 0x60, 0xaf, 0x57, 0x77, 0x76, 0x44, 0x9a,
			0xc3, 0x4e, 0xb0, 0x09, 0x89, 0xe5, 0xa8, 0x76,
			0x14, 0x3b, 0xc9, 0xb9, 0x30, 0xa3, 0xc2, 0xa5,
			0xbb, 0x86, 0x12, 0x08, 0xf2, 0x25, 0xdd, 0x97,
			0x62, 0x5b, 0xb3, 0x6b, 0x2d, 0x88, 0x10, 0xd0,
			0x45, 0x2e, 0x45, 0x89, 0x68, 0xb9, 0x0c, 0x6a,
			0x6d, 0x97, 0xc2, 0xdf, 0xca, 0x73, 0x41, 0xd5,
			0x3c, 0x74, 0x1a, 0x60, 0xe2, 0xb9, 0x13, 0x85,
			0xc8, 0x6b, 0xb3, 0xb1, 0xbe, 0x5f, 0x10, 0x70,
			0x8c, 0x54, 0x6a, 0xe6, 0x31, 0x82, 0x09, 0xba,
			0x26, 0x8d, 0xd2, 0xb4, 0xe3, 0xe4, 0x72, 0x27,
			0x61, 0x49, 0x1a, 0xe2, 0x15, 0x60, 0x02, 0x48,
			0xe7, 0x54, 0x1e, 0x60, 0x80, 0xb8, 0x65, 0xf4,
			0x4a, 0x16, 0x9c, 0x02, 0xa5, 0xb3, 0x74, 0xf1,
			0xfa, 0x55, 0x02, 0x33, 0x37, 0x53, 0x97, 0x9c,
			0x9d, 0xa7, 0x54, 0x52, 0xc4, 0x81, 0x4a, 0x8b,
			0x8f, 0xd6, 0x82, 0xb8, 0xe0, 0x37, 0x06, 0x99,
			0x29, 0x6b, 0xc2, 0xf4, 0x2d, 0x38, 0xe5, 0xa2,
			0xde, 0x92, 0xc5, 0xf5, 0xf6, 0x1f, 0x24, 0xb6,
			0x5e, 0x1b, 0x9b, 0x75, 0x24, 0x9b, 0x87, 0x59,
			0x70, 0x87, 0x06, 0x64, 0x00, 0x00, 0xb4, 0x90,
			0x93, 0x76, 0x83, 0xe1, 0xcc, 0xbb, 0xf3, 0x9a,
			0x0b, 0xae, 0xcb, 0x1e, 0xdd, 0x62, 0x82, 0x67,
			0x21, 0x52, 0x4b, 0xcc, 0x4d, 0x3b, 0xf0, 0x6f,
			0x8e, 0x5a, 0xb3, 0x68, 0xaa, 0x42, 0x6e, 0xb4,
			0x2c, 0x70, 0x18, 0x39, 0xe8, 0xbb, 0xcc, 0x69,
			0xdb, 0xcc, 0xd2, 0x75, 0x7f, 0x84, 0xc6, 0x0a,
			0x40, 0x9b, 0x66, 0x29, 0xd9, 0x8d, 0xc9, 0x29,
			0x47, 0x36, 0x7c, 0x52, 0xf0, 0x69, 0x8c, 0x3c,
			0x41, 0xc0, 0x11, 0x10, 0xba, 0xfb, 0xeb, 0x06,
			0x21, 0xcc, 0x17, 0x51, 0x70, 0x37, 0x5f, 0x82,
			0x50, 0xc0, 0xf6, 0x24, 0x06, 0xe3, 0x2e, 0x10,
			0x72, 0x5b, 0x47, 0xe3, 0xc1, 0x65, 0x84, 0x5a,
			0x7a, 0xda, 0x8f, 0xb2, 0xc5, 0x55, 0x55, 0xf5,
			0xcc, 0x86, 0x02, 0x24, 0x6f, 0xe0, 0x6f, 0x87,
			0x5a, 0x6e, 0xb5, 0xc9, 0x45, 0x9d, 0xd1, 0x92,
			0x92, 0x42, 0x84, 0x92, 0xa7, 0x67, 0x38, 0xb8,
			0x05, 0x7e, 0x84, 0xc8, 0xe1, 0x14, 0x36, 0xc4,
			0xeb, 0x78, 0x8e, 0x49, 0x4e, 0x39, 0x52, 0x65,
			0x7e, 0xd3, 0x31, 0xa2, 0xe4, 0xa4, 0x7d, 0x75,
			0x49, 0x23, 0x65, 0xc4, 0x73, 0xf4, 0x84, 0x20,
			0x05, 0x02, 0x86, 0x8c, 0x73, 0x3b, 0xb9, 0xb2,
			0xb3, 0xe4, 0x4a, 0xf2, 0xc9, 0x8a, 0xdf, 0xb9,
			0x1a, 0x4e, 0x1a, 0x14, 0x4e, 0xec, 0x5a, 0x32,
			0xd2, 0x4f, 0x13, 0xc7, 0x87, 0x75, 0xf2, 0x06,
			0xd7, 0xa9, 0x4d, 0xee, 0x12, 0x00, 0x7f, 0x77,
			0x8e, 0x48, 0x4a, 0x14, 0x30, 0x66, 0x6b, 0xfe,
			0xda, 0x6d, 0xbb, 0x31, 0xb7, 0x57, 0xd7, 0x2b,
			0x5c, 0x79, 0xa4, 0x69, 0x52, 0x2f, 0xe6, 0x59,
			0x9a, 0xbb, 0x45, 0xb5, 0x2c, 0xc6, 0x40, 0x3c,
			0x49, 0x70, 0xf6, 0x56, 0x84, 0xbb, 0x77, 0x0c,
			0xa7, 0x88, 0x93, 0xba, 0x43, 0x90, 0x57, 0x01,
			0x36, 0x55, 0x30, 0x9c, 0xd8, 0x4c, 0x52, 0x4c,
			0x9c, 0xa5, 0x58, 0xe3, 0x61, 0x20, 0x41, 0xb7,
			0xb2, 0x02, 0x6e, 0x21, 0x87, 0x59, 0x8a, 0xfb,
			0x46, 0xf1, 0xd4, 0xca, 0x85, 0x09, 0x6d, 0xbc,
			0x9b, 0xcc, 0x1c, 0x25, 0x77, 0x9d, 0xfb, 0x60,
			0x70, 0x52, 0xe1, 0x16, 0x49, 0xbb, 0x7f, 0x5f,
			0x72, 0x68, 0xf9, 0x79, 0xc4, 0xd8, 0x14, 0x0a,
			0xfe, 0x6c, 0xe5, 0x38, 0x30, 0xf3, 0x86, 0x02,
			0x29, 0x0d, 0x75, 0x14, 0x27, 0xf0, 0x7b, 0x27,
			},
		.sk.sk = {
			FIPS140_MOD(0x7c), 0xf1, 0x08, 0xc7, 0x5a, 0x4d, 0x35, 0x92,
			0x05, 0x3d, 0x0c, 0xa7, 0x9c, 0xe5, 0x27, 0xec,
			0x17, 0x34, 0xf7, 0x02, 0x36, 0x56, 0xe2, 0x62,
			0x53, 0xe2, 0xbf, 0xc6, 0x89, 0x60, 0xde, 0xa7,
			0x3d, 0x28, 0xd7, 0xa9, 0x82, 0x15, 0x97, 0xb4,
			0x8b, 0x45, 0x04, 0x83, 0x7e, 0x27, 0x13, 0x2c,
			0x8e, 0xbc, 0x48, 0x50, 0x53, 0x03, 0xae, 0xb5,
			0x68, 0xf9, 0xd1, 0x92, 0x8f, 0x72, 0x44, 0xcf,
			0x98, 0xb4, 0xa8, 0x88, 0x43, 0xc5, 0xdb, 0x69,
			0x84, 0x5a, 0xbf, 0xc4, 0xe4, 0x06, 0x83, 0xdc,
			0xa3, 0xbd, 0xe6, 0x94, 0x44, 0x5c, 0x63, 0xcc,
			0x51, 0x2b, 0xd2, 0xe4, 0x60, 0x8e, 0x91, 0xa5,
			0x69, 0x77, 0x38, 0xbb, 0xca, 0x3b, 0x09, 0xa9,
			0x8d, 0xa4, 0x97, 0x57, 0xad, 0x65, 0xc0, 0x85,
			0x12, 0x5d, 0x11, 0xd0, 0x11, 0x78, 0xd1, 0x5a,
			0xcb, 0x25, 0x1f, 0x41, 0x7c, 0xbe, 0xff, 0x2a,
			0x2a, 0xc1, 0xb0, 0x5d, 0xc7, 0x08, 0x39, 0xff,
			0xb2, 0x97, 0xbe, 0x20, 0x51, 0x52, 0xe9, 0x83,
			0x71, 0x74, 0x5d, 0xe7, 0x62, 0x43, 0xd3, 0xa3,
			0x02, 0xdf, 0xda, 0x7f, 0x16, 0xf5, 0xa8, 0xf0,
			0xd2, 0xb7, 0x30, 0x21, 0xa7, 0xf5, 0xc0, 0x49,
			0x0f, 0xf6, 0xb5, 0xa4, 0x12, 0x58, 0x43, 0x88,
			0x93, 0x64, 0x28, 0x8b, 0xed, 0xe4, 0x30, 0x83,
			0x5c, 0xce, 0x5b, 0xf8, 0xb8, 0x63, 0x77, 0x13,
			0x2a, 0xea, 0x3c, 0xed, 0x91, 0x13, 0x11, 0xa4,
			0x3b, 0x87, 0xe1, 0x0a, 0xe4, 0x71, 0xb4, 0x9f,
			0x1a, 0x31, 0xb6, 0x36, 0xce, 0x5d, 0x7c, 0x41,
			0x5d, 0x7c, 0x17, 0x53, 0x95, 0x75, 0x72, 0x4c,
			0x31, 0x66, 0xab, 0x23, 0xca, 0x18, 0x3f, 0x99,
			0x62, 0xa0, 0xb1, 0x71, 0x90, 0xf3, 0xdc, 0x20,
			0x4d, 0xc2, 0x55, 0x1e, 0xec, 0x23, 0x4b, 0x7c,
			0x4e, 0x29, 0x8a, 0x4e, 0x60, 0xf1, 0x5d, 0x4e,
			0x40, 0xbc, 0xaf, 0x1b, 0xa0, 0xea, 0xa8, 0x06,
			0xe2, 0x14, 0xbd, 0xa0, 0xa0, 0xb0, 0xe0, 0xf5,
			0x1b, 0x34, 0x74, 0x5e, 0x14, 0x82, 0x90, 0xe2,
			0x22, 0xa4, 0x49, 0x6c, 0x94, 0x67, 0x66, 0x02,
			0x9c, 0xd8, 0x29, 0x64, 0x42, 0x9f, 0xd8, 0x5a,
			0x30, 0xee, 0x3c, 0x0c, 0x6d, 0xea, 0x4e, 0x6b,
			0xc8, 0x40, 0x23, 0x7c, 0x38, 0xd8, 0xe9, 0xb6,
			0xa8, 0x93, 0x70, 0x24, 0x44, 0xbf, 0xee, 0xf7,
			0x83, 0xa1, 0x04, 0xa8, 0xb4, 0x6b, 0x83, 0x09,
			0xa9, 0x14, 0xcb, 0xaa, 0xa8, 0xce, 0xc9, 0xc0,
			0x8b, 0xb5, 0x4a, 0x3c, 0xfc, 0x1a, 0x22, 0xc5,
			0xa9, 0xd1, 0xb8, 0x76, 0x85, 0xa3, 0x04, 0x17,
			0xd8, 0x46, 0xd5, 0xe2, 0x22, 0x42, 0xe8, 0xc0,
			0xc8, 0x31, 0x6c, 0xb7, 0xf1, 0x58, 0x32, 0xb7,
			0x0b, 0x4b, 0xbc, 0x45, 0x3b, 0xb6, 0x74, 0x85,
			0xe3, 0x4c, 0x87, 0xd9, 0xa2, 0xd4, 0xb2, 0x94,
			0xd2, 0x57, 0xa9, 0x8d, 0x86, 0x4a, 0xfa, 0xb4,
			0x45, 0xae, 0xa6, 0xbf, 0x48, 0x30, 0x40, 0x4d,
			0x17, 0x0c, 0xa7, 0x48, 0x4c, 0xc7, 0x99, 0xb7,
			0x3a, 0xe3, 0xce, 0x37, 0x5c, 0x3a, 0x13, 0xd1,
			0x31, 0x8b, 0xd2, 0x91, 0x58, 0x62, 0x03, 0x28,
			0xc8, 0xbc, 0x22, 0xd8, 0x12, 0xd2, 0x69, 0xc8,
			0xec, 0x13, 0x3c, 0xe4, 0xf9, 0x77, 0xbd, 0x95,
			0x30, 0x00, 0x54, 0xb5, 0xef, 0x24, 0x6b, 0xb0,
			0x86, 0xa6, 0xd3, 0x34, 0x05, 0x75, 0x46, 0x41,
			0x83, 0xe1, 0x0d, 0xb1, 0xa1, 0x26, 0xf8, 0x1a,
			0x43, 0xd2, 0xf8, 0x00, 0xe9, 0x62, 0x56, 0x8d,
			0xe3, 0x41, 0x15, 0x15, 0xb9, 0x0d, 0xc1, 0x25,
			0x64, 0x46, 0xcf, 0x8f, 0xc3, 0x31, 0x49, 0xe6,
			0x6a, 0x86, 0x57, 0xc2, 0x21, 0x33, 0x5e, 0xb5,
			0x7a, 0x8c, 0xa6, 0x26, 0x2b, 0x06, 0x98, 0x1a,
			0x03, 0x28, 0x23, 0x22, 0x2c, 0x9d, 0xa2, 0x28,
			0x35, 0x27, 0x10, 0x33, 0x21, 0x2b, 0x4e, 0x9d,
			0x51, 0x61, 0x32, 0xa4, 0x28, 0x70, 0x9b, 0x58,
			0x82, 0xab, 0x87, 0x64, 0x77, 0x18, 0x32, 0x96,
			0x8d, 0xc7, 0x3c, 0x4c, 0xd2, 0x41, 0xad, 0xb1,
			0x45, 0xb5, 0xe6, 0x54, 0xb3, 0x8b, 0xab, 0x03,
			0xe3, 0x52, 0x4f, 0x11, 0x35, 0x25, 0xdd, 0x0a,
			0x63, 0xe8, 0xf1, 0x95, 0xfc, 0xeb, 0x26, 0xb8,
			0xb0, 0x30, 0x63, 0xc4, 0x86, 0x34, 0x59, 0xcc,
			0x10, 0xc5, 0x88, 0x4c, 0xac, 0x01, 0x6e, 0xeb,
			0xb7, 0xaf, 0xa2, 0x51, 0x9b, 0x27, 0x29, 0x3b,
			0x84, 0x5e, 0x7e, 0x89, 0x3e, 0x70, 0xbb, 0x21,
			0xd0, 0xe0, 0x04, 0xf1, 0xd0, 0x50, 0x15, 0xdc,
			0x71, 0xfc, 0xf6, 0xb1, 0x50, 0xc7, 0x50, 0xaa,
			0x98, 0xc9, 0x6f, 0x89, 0xc8, 0xda, 0x19, 0x9e,
			0xef, 0xc1, 0x71, 0x2c, 0x40, 0x9b, 0xc8, 0x33,
			0xa8, 0x4d, 0x40, 0x4a, 0xd7, 0x2c, 0x87, 0x3b,
			0xf9, 0x10, 0xc9, 0x19, 0x06, 0x45, 0xb9, 0x4d,
			0xd2, 0xa3, 0x13, 0x47, 0x59, 0x60, 0x29, 0xd2,
			0x2a, 0xbd, 0x07, 0x1f, 0x53, 0x87, 0x58, 0x8a,
			0x99, 0x17, 0xfe, 0xe4, 0xb3, 0x3d, 0x1b, 0xbc,
			0xfa, 0x18, 0x58, 0x39, 0x06, 0x62, 0xb6, 0x56,
			0xc0, 0x9f, 0xf8, 0x24, 0xed, 0x17, 0x7a, 0xbf,
			0x44, 0xa1, 0x18, 0xb7, 0xc7, 0x8b, 0xba, 0x96,
			0xb9, 0xf9, 0xb5, 0xa3, 0xa5, 0x4e, 0x59, 0x78,
			0x29, 0xbe, 0x68, 0x68, 0x68, 0xe5, 0x46, 0x3f,
			0x99, 0xbe, 0x58, 0xda, 0x0b, 0xe7, 0x88, 0x65,
			0x01, 0x73, 0x0e, 0x01, 0xe2, 0x6a, 0xad, 0x05,
			0x35, 0x89, 0x66, 0x16, 0xd9, 0x81, 0x25, 0xc3,
			0x8b, 0x3e, 0xb7, 0x78, 0x11, 0x41, 0x76, 0xb1,
			0xbd, 0x49, 0x8e, 0xbd, 0x92, 0xb5, 0xbd, 0x0a,
			0x98, 0xa0, 0xa3, 0x9f, 0x77, 0xb5, 0x99, 0xc3,
			0xe6, 0x3e, 0x66, 0xfb, 0x62, 0x16, 0x7b, 0x06,
			0xc2, 0x9a, 0xc6, 0x6c, 0x84, 0xbe, 0xe3, 0xf1,
			0x29, 0x50, 0x8c, 0x2b, 0x8c, 0x79, 0x0c, 0x99,
			0xa5, 0xca, 0x41, 0xe5, 0x70, 0x7e, 0x9b, 0x8c,
			0x75, 0xc0, 0x4d, 0x7e, 0xa8, 0xa4, 0x81, 0x98,
			0x0a, 0x35, 0x8b, 0x06, 0x6a, 0x4a, 0x7e, 0x28,
			0xd1, 0x5d, 0x10, 0x37, 0x4f, 0x75, 0xc3, 0x3d,
			0xa6, 0x02, 0x9c, 0xd4, 0x90, 0x74, 0x6f, 0xb5,
			0x5f, 0x5f, 0xea, 0xb2, 0xce, 0x82, 0x3d, 0xec,
			0x18, 0x30, 0xc0, 0xc1, 0x8e, 0xf8, 0x9b, 0xa3,
			0xcc, 0x3b, 0xce, 0x4d, 0x25, 0x2a, 0x07, 0xa4,
			0x0d, 0x40, 0x1a, 0x4c, 0x8d, 0x27, 0x36, 0x18,
			0xb5, 0x95, 0xdb, 0x21, 0xca, 0x4a, 0x95, 0x9e,
			0xb4, 0xd1, 0x33, 0x55, 0x68, 0x01, 0xb2, 0xb7,
			0x82, 0x54, 0xb2, 0xb5, 0x95, 0x5c, 0x04, 0x00,
			0x96, 0x2d, 0xbb, 0x5a, 0x48, 0x7a, 0xaa, 0x24,
			0xa4, 0x30, 0xb6, 0x14, 0xe2, 0xaf, 0x93, 0x38,
			0xaf, 0xd4, 0xb0, 0x33, 0x9b, 0xd8, 0x30, 0xa9,
			0xcb, 0x76, 0x1d, 0xb1, 0xa8, 0x32, 0x20, 0x35,
			0x2d, 0xd5, 0x23, 0xb8, 0xa5, 0x83, 0x02, 0x2c,
			0xa1, 0x3e, 0x24, 0x65, 0x06, 0x54, 0x8c, 0x57,
			0xba, 0x38, 0x50, 0xac, 0x5c, 0x50, 0xd8, 0x64,
			0xe2, 0xd4, 0x8b, 0x89, 0x69, 0x42, 0x77, 0xcc,
			0x7a, 0x81, 0x74, 0xad, 0x7b, 0x1b, 0xa2, 0xee,
			0x62, 0x1d, 0x57, 0xd2, 0x9b, 0x23, 0xc2, 0x2d,
			0xf8, 0x31, 0x87, 0x20, 0x51, 0x14, 0x5d, 0x25,
			0x35, 0xdb, 0xb0, 0x25, 0xe2, 0x9c, 0x6d, 0xa3,
			0x8c, 0xb4, 0x75, 0x95, 0x8e, 0x2a, 0x88, 0x08,
			0xa4, 0x31, 0xbe, 0xd5, 0xb4, 0x86, 0x82, 0x1a,
			0x15, 0x13, 0xa7, 0x29, 0xcd, 0x97, 0x9b, 0x6c,
			0x8b, 0x38, 0x25, 0x03, 0xcf, 0x53, 0x33, 0x76,
			0x16, 0xe1, 0x05, 0x9d, 0xdc, 0x59, 0x97, 0x72,
			0x19, 0xd2, 0xf1, 0x7b, 0x32, 0xac, 0xab, 0xbe,
			0x86, 0xc4, 0x68, 0xc1, 0x26, 0x7b, 0x2b, 0x86,
			0x2a, 0xc5, 0x65, 0xa7, 0xe2, 0x32, 0x26, 0x6c,
			0x83, 0xfc, 0x70, 0x0c, 0xda, 0x19, 0xb6, 0x16,
			0x37, 0x73, 0x89, 0x42, 0x8e, 0x62, 0x61, 0x4c,
			0xd6, 0xac, 0x9f, 0x08, 0xfb, 0x12, 0xd2, 0x18,
			0x27, 0xfe, 0xb3, 0x24, 0xb1, 0x4b, 0xc1, 0x6c,
			0xc0, 0xc2, 0x09, 0x04, 0xb3, 0x97, 0x3b, 0x9d,
			0xfe, 0x60, 0xaf, 0x57, 0x77, 0x76, 0x44, 0x9a,
			0xc3, 0x4e, 0xb0, 0x09, 0x89, 0xe5, 0xa8, 0x76,
			0x14, 0x3b, 0xc9, 0xb9, 0x30, 0xa3, 0xc2, 0xa5,
			0xbb, 0x86, 0x12, 0x08, 0xf2, 0x25, 0xdd, 0x97,
			0x62, 0x5b, 0xb3, 0x6b, 0x2d, 0x88, 0x10, 0xd0,
			0x45, 0x2e, 0x45, 0x89, 0x68, 0xb9, 0x0c, 0x6a,
			0x6d, 0x97, 0xc2, 0xdf, 0xca, 0x73, 0x41, 0xd5,
			0x3c, 0x74, 0x1a, 0x60, 0xe2, 0xb9, 0x13, 0x85,
			0xc8, 0x6b, 0xb3, 0xb1, 0xbe, 0x5f, 0x10, 0x70,
			0x8c, 0x54, 0x6a, 0xe6, 0x31, 0x82, 0x09, 0xba,
			0x26, 0x8d, 0xd2, 0xb4, 0xe3, 0xe4, 0x72, 0x27,
			0x61, 0x49, 0x1a, 0xe2, 0x15, 0x60, 0x02, 0x48,
			0xe7, 0x54, 0x1e, 0x60, 0x80, 0xb8, 0x65, 0xf4,
			0x4a, 0x16, 0x9c, 0x02, 0xa5, 0xb3, 0x74, 0xf1,
			0xfa, 0x55, 0x02, 0x33, 0x37, 0x53, 0x97, 0x9c,
			0x9d, 0xa7, 0x54, 0x52, 0xc4, 0x81, 0x4a, 0x8b,
			0x8f, 0xd6, 0x82, 0xb8, 0xe0, 0x37, 0x06, 0x99,
			0x29, 0x6b, 0xc2, 0xf4, 0x2d, 0x38, 0xe5, 0xa2,
			0xde, 0x92, 0xc5, 0xf5, 0xf6, 0x1f, 0x24, 0xb6,
			0x5e, 0x1b, 0x9b, 0x75, 0x24, 0x9b, 0x87, 0x59,
			0x70, 0x87, 0x06, 0x64, 0x00, 0x00, 0xb4, 0x90,
			0x93, 0x76, 0x83, 0xe1, 0xcc, 0xbb, 0xf3, 0x9a,
			0x0b, 0xae, 0xcb, 0x1e, 0xdd, 0x62, 0x82, 0x67,
			0x21, 0x52, 0x4b, 0xcc, 0x4d, 0x3b, 0xf0, 0x6f,
			0x8e, 0x5a, 0xb3, 0x68, 0xaa, 0x42, 0x6e, 0xb4,
			0x2c, 0x70, 0x18, 0x39, 0xe8, 0xbb, 0xcc, 0x69,
			0xdb, 0xcc, 0xd2, 0x75, 0x7f, 0x84, 0xc6, 0x0a,
			0x40, 0x9b, 0x66, 0x29, 0xd9, 0x8d, 0xc9, 0x29,
			0x47, 0x36, 0x7c, 0x52, 0xf0, 0x69, 0x8c, 0x3c,
			0x41, 0xc0, 0x11, 0x10, 0xba, 0xfb, 0xeb, 0x06,
			0x21, 0xcc, 0x17, 0x51, 0x70, 0x37, 0x5f, 0x82,
			0x50, 0xc0, 0xf6, 0x24, 0x06, 0xe3, 0x2e, 0x10,
			0x72, 0x5b, 0x47, 0xe3, 0xc1, 0x65, 0x84, 0x5a,
			0x7a, 0xda, 0x8f, 0xb2, 0xc5, 0x55, 0x55, 0xf5,
			0xcc, 0x86, 0x02, 0x24, 0x6f, 0xe0, 0x6f, 0x87,
			0x5a, 0x6e, 0xb5, 0xc9, 0x45, 0x9d, 0xd1, 0x92,
			0x92, 0x42, 0x84, 0x92, 0xa7, 0x67, 0x38, 0xb8,
			0x05, 0x7e, 0x84, 0xc8, 0xe1, 0x14, 0x36, 0xc4,
			0xeb, 0x78, 0x8e, 0x49, 0x4e, 0x39, 0x52, 0x65,
			0x7e, 0xd3, 0x31, 0xa2, 0xe4, 0xa4, 0x7d, 0x75,
			0x49, 0x23, 0x65, 0xc4, 0x73, 0xf4, 0x84, 0x20,
			0x05, 0x02, 0x86, 0x8c, 0x73, 0x3b, 0xb9, 0xb2,
			0xb3, 0xe4, 0x4a, 0xf2, 0xc9, 0x8a, 0xdf, 0xb9,
			0x1a, 0x4e, 0x1a, 0x14, 0x4e, 0xec, 0x5a, 0x32,
			0xd2, 0x4f, 0x13, 0xc7, 0x87, 0x75, 0xf2, 0x06,
			0xd7, 0xa9, 0x4d, 0xee, 0x12, 0x00, 0x7f, 0x77,
			0x8e, 0x48, 0x4a, 0x14, 0x30, 0x66, 0x6b, 0xfe,
			0xda, 0x6d, 0xbb, 0x31, 0xb7, 0x57, 0xd7, 0x2b,
			0x5c, 0x79, 0xa4, 0x69, 0x52, 0x2f, 0xe6, 0x59,
			0x9a, 0xbb, 0x45, 0xb5, 0x2c, 0xc6, 0x40, 0x3c,
			0x49, 0x70, 0xf6, 0x56, 0x84, 0xbb, 0x77, 0x0c,
			0xa7, 0x88, 0x93, 0xba, 0x43, 0x90, 0x57, 0x01,
			0x36, 0x55, 0x30, 0x9c, 0xd8, 0x4c, 0x52, 0x4c,
			0x9c, 0xa5, 0x58, 0xe3, 0x61, 0x20, 0x41, 0xb7,
			0xb2, 0x02, 0x6e, 0x21, 0x87, 0x59, 0x8a, 0xfb,
			0x46, 0xf1, 0xd4, 0xca, 0x85, 0x09, 0x6d, 0xbc,
			0x9b, 0xcc, 0x1c, 0x25, 0x77, 0x9d, 0xfb, 0x60,
			0x70, 0x52, 0xe1, 0x16, 0x49, 0xbb, 0x7f, 0x5f,
			0x72, 0x68, 0xf9, 0x79, 0xc4, 0xd8, 0x14, 0x0a,
			0xfe, 0x6c, 0xe5, 0x38, 0x30, 0xf3, 0x86, 0x02,
			0x29, 0x0d, 0x75, 0x14, 0x27, 0xf0, 0x7b, 0x27,
			0xcd, 0xa9, 0x3d, 0xec, 0x4c, 0x4d, 0xc4, 0xd8,
			0x48, 0x44, 0x57, 0xfd, 0x88, 0x23, 0x99, 0xc4,
			0xb9, 0x18, 0xc4, 0x9f, 0xa8, 0x38, 0x9a, 0x1d,
			0xfa, 0x8c, 0x9f, 0x92, 0xf3, 0x9b, 0x00, 0xcf,
			0x3c, 0xb1, 0xee, 0xa9, 0x88, 0x00, 0x4b, 0x93,
			0x10, 0x3c, 0xfb, 0x0a, 0xee, 0xfd, 0x2a, 0x68,
			0x6e, 0x01, 0xfa, 0x4a, 0x58, 0xe8, 0xa3, 0x63,
			0x9c, 0xa8, 0xa1, 0xe3, 0xf9, 0xae, 0x57, 0xe2,
			},
		.ct.ct = {
			0x5a, 0x64, 0x51, 0x20, 0xb8, 0x78, 0x93, 0x6d,
			0x20, 0x2e, 0xfc, 0x48, 0x51, 0xf3, 0x8e, 0x6b,
			0xb6, 0x57, 0x3c, 0x3b, 0x14, 0xb0, 0xb9, 0xbb,
			0x44, 0xbf, 0x37, 0x2d, 0x8b, 0x1a, 0xa8, 0x03,
			0x4a, 0x9f, 0x1a, 0x15, 0x84, 0x07, 0x6f, 0x0a,
			0x38, 0xe8, 0x9a, 0x9d, 0x49, 0xa5, 0x0b, 0x79,
			0x2a, 0xce, 0x75, 0x84, 0x98, 0x1b, 0xe8, 0xe2,
			0x39, 0x27, 0x2d, 0xee, 0xf9, 0x14, 0x41, 0x8f,
			0xef, 0xe2, 0xda, 0xd9, 0x7d, 0xc0, 0xec, 0x20,
			0xcf, 0xe8, 0xa9, 0x59, 0x9b, 0x9b, 0xbe, 0x3e,
			0xcc, 0xe9, 0x1f, 0x97, 0xe1, 0x0c, 0xd9, 0xef,
			0x2c, 0x49, 0x50, 0xe3, 0xea, 0x3c, 0x46, 0xfe,
			0x48, 0x1e, 0xb0, 0xd2, 0x48, 0x78, 0xc4, 0x62,
			0x4a, 0xd3, 0x44, 0xf0, 0xdc, 0x98, 0x63, 0xe7,
			0xd1, 0x70, 0x93, 0x7a, 0x8c, 0xec, 0xc6, 0xf7,
			0xd0, 0x0f, 0x95, 0x65, 0x52, 0x9d, 0x57, 0x29,
			0x59, 0xcc, 0x49, 0xd0, 0xf7, 0x04, 0x2f, 0xf4,
			0x3b, 0x7d, 0x1d, 0x71, 0xef, 0xd2, 0x2f, 0x26,
			0x54, 0xe1, 0x4e, 0x78, 0xc3, 0x1f, 0x34, 0xa2,
			0x6a, 0xe5, 0x3b, 0x06, 0x7a, 0xe0, 0x38, 0x0a,
			0x65, 0xa7, 0x32, 0x45, 0x95, 0x03, 0xda, 0x5e,
			0x94, 0x06, 0xd5, 0x0a, 0x70, 0xe3, 0xd5, 0xeb,
			0xdb, 0xf3, 0xc9, 0xc0, 0x1c, 0xad, 0x1c, 0xc0,
			0x01, 0xeb, 0xe6, 0x9e, 0x6c, 0xff, 0x20, 0xe6,
			0x4c, 0xe5, 0xc8, 0x02, 0xb6, 0x91, 0x58, 0x7e,
			0x40, 0x4c, 0xf6, 0xef, 0xa2, 0x79, 0x9a, 0x2f,
			0xfd, 0x35, 0x34, 0x92, 0xa7, 0x5f, 0x0e, 0x2e,
			0xa5, 0x2a, 0x97, 0x4e, 0x05, 0x45, 0xa0, 0x86,
			0xa3, 0xbd, 0x14, 0xb6, 0x90, 0x45, 0x23, 0x81,
			0x40, 0xa7, 0x20, 0x0b, 0x10, 0xc3, 0x27, 0x6c,
			0xc6, 0xb2, 0xa6, 0x7c, 0x17, 0x3f, 0x7c, 0x1a,
			0xd6, 0x45, 0x45, 0xad, 0xb8, 0xeb, 0xdf, 0x78,
			0x35, 0xe9, 0xaa, 0x1f, 0x54, 0xf6, 0x89, 0x13,
			0x69, 0x98, 0x8f, 0x36, 0x25, 0xc4, 0x5f, 0x2f,
			0xec, 0x8d, 0x9a, 0x07, 0xb9, 0x11, 0xd3, 0x2b,
			0xa6, 0x9d, 0x9f, 0xf5, 0xd7, 0x4f, 0x10, 0xa6,
			0x80, 0x8b, 0x25, 0xa3, 0xc8, 0x17, 0x09, 0x94,
			0x5b, 0xf2, 0x13, 0xc3, 0x45, 0x0d, 0x74, 0x48,
			0x1f, 0x06, 0x50, 0x42, 0x18, 0x6b, 0x0d, 0x36,
			0xfb, 0x55, 0x27, 0x11, 0x62, 0xdf, 0xaf, 0x41,
			0xe5, 0x16, 0xa4, 0x08, 0xf8, 0x3c, 0xca, 0xbe,
			0x8a, 0x0b, 0xa7, 0xef, 0xfa, 0x16, 0xf8, 0x8f,
			0x6d, 0x7d, 0xbd, 0xb6, 0x4e, 0x60, 0x8c, 0x8f,
			0x18, 0xd6, 0x86, 0xc7, 0xe5, 0xd5, 0x48, 0xd7,
			0x37, 0x11, 0x6f, 0xa5, 0x62, 0xdc, 0x76, 0xe7,
			0x99, 0x4a, 0x86, 0x37, 0x4a, 0x9c, 0x85, 0xb8,
			0xb1, 0x7c, 0x4f, 0x02, 0x5f, 0xa2, 0x3a, 0x4d,
			0xe1, 0xa9, 0x97, 0xa8, 0x7e, 0x5a, 0x65, 0xf5,
			0xc5, 0x38, 0x67, 0x72, 0x49, 0x1f, 0xd8, 0xd1,
			0x07, 0x31, 0xf5, 0xf5, 0xaa, 0x60, 0x36, 0x6f,
			0xfe, 0x3f, 0xd2, 0x09, 0xcb, 0x7b, 0x7a, 0x86,
			0x15, 0x32, 0x0a, 0xd0, 0x72, 0x8f, 0x41, 0xe8,
			0x12, 0xbd, 0x88, 0xd2, 0xd6, 0x10, 0x47, 0x53,
			0x91, 0x7e, 0x89, 0xe1, 0xca, 0x0f, 0x10, 0x17,
			0x7c, 0xf5, 0xda, 0xb0, 0x40, 0xe4, 0x66, 0x90,
			0x8b, 0x27, 0x44, 0x62, 0x15, 0x70, 0x9b, 0x09,
			0x12, 0x97, 0x2c, 0x42, 0x8c, 0x4d, 0x9a, 0xad,
			0x94, 0x32, 0xd9, 0xa1, 0x59, 0x06, 0x9c, 0x96,
			0x15, 0x40, 0x01, 0xcb, 0x0b, 0xe4, 0xde, 0x59,
			0x7e, 0x98, 0x71, 0xb0, 0x4b, 0xdd, 0xaa, 0x45,
			0x39, 0xf8, 0x38, 0xbc, 0x12, 0xab, 0x0a, 0x3e,
			0xa7, 0xe8, 0xc8, 0x48, 0x1b, 0xcd, 0xfc, 0xc1,
			0x83, 0x43, 0x69, 0xfc, 0xf0, 0x61, 0xf7, 0xc5,
			0x99, 0xef, 0xdc, 0x4f, 0x6c, 0x43, 0x41, 0x02,
			0x99, 0x14, 0x46, 0xae, 0xa1, 0x28, 0x81, 0xe1,
			0x63, 0xfd, 0x4e, 0xe6, 0xc4, 0x58, 0xb8, 0x2e,
			0x42, 0x75, 0x9f, 0x8b, 0x11, 0xb0, 0x61, 0x2c,
			0x12, 0xd5, 0xa7, 0x77, 0xac, 0xf4, 0xc7, 0xcd,
			0xd2, 0x6f, 0xb7, 0xda, 0x0b, 0x90, 0x98, 0xdc,
			0x4a, 0xf9, 0x47, 0x04, 0xda, 0xa5, 0x29, 0x94,
			0x5a, 0xb1, 0x69, 0xcd, 0xb2, 0x2d, 0x39, 0x66,
			0xfc, 0xd2, 0x69, 0x50, 0xe2, 0x41, 0x8c, 0xac,
			0x9b, 0xc7, 0xdc, 0x32, 0xc4, 0xa6, 0x04, 0xf3,
			0x68, 0xf0, 0xf8, 0xa9, 0xc7, 0xdd, 0xce, 0x8b,
			0x5e, 0x47, 0x6b, 0x26, 0xb3, 0x31, 0x16, 0xd6,
			0x07, 0xdf, 0x1b, 0x49, 0xc2, 0x05, 0xad, 0xa0,
			0xd2, 0xea, 0x5a, 0x5a, 0x64, 0xee, 0xcb, 0x22,
			0x54, 0x9d, 0xdf, 0x18, 0xa0, 0xda, 0xed, 0x2e,
			0x5d, 0x44, 0xcb, 0x61, 0x74, 0xb9, 0x78, 0x12,
			0x36, 0xee, 0xe1, 0x1f, 0x95, 0xab, 0x0c, 0x45,
			0x83, 0x6b, 0xca, 0xfc, 0x73, 0xaf, 0x3b, 0xec,
			0x11, 0x44, 0x0b, 0xc1, 0xc6, 0x05, 0x66, 0x9e,
			0xb0, 0x19, 0xcf, 0xac, 0x00, 0x97, 0x94, 0x3c,
			0xf2, 0x9b, 0xbf, 0xfc, 0xe0, 0xf8, 0x23, 0x29,
			0x3d, 0xa6, 0x23, 0xe5, 0xfa, 0x6d, 0x2a, 0x7e,
			0xe0, 0xc7, 0xb4, 0x50, 0x75, 0x96, 0xa6, 0x2e,
			0xf4, 0x6b, 0xbe, 0x4e, 0x1b, 0x63, 0xcc, 0x96,
			0xba, 0x98, 0x78, 0xa7, 0xb3, 0x9f, 0x84, 0xb5,
			0x9d, 0xd3, 0x36, 0xf1, 0x65, 0x9a, 0x24, 0xcb,
			0xb3, 0x30, 0x15, 0xd5, 0x15, 0xe9, 0xe8, 0x0e,
			0x3e, 0x79, 0x02, 0xb1, 0xd5, 0x83, 0xf8, 0xee,
			0x97, 0x15, 0x3c, 0xd8, 0xba, 0x1f, 0xad, 0xeb,
			0x9e, 0xe7, 0xe2, 0xf2, 0xc2, 0x3d, 0xfe, 0xe8,
			0x5a, 0x50, 0xd5, 0xc3, 0x55, 0x4b, 0x79, 0x92,
			0x2a, 0x45, 0x37, 0xd6, 0xdc, 0x4f, 0x09, 0x41,
			0x8d, 0xfd, 0xd7, 0x44, 0x59, 0x6c, 0xbf, 0x68,
			},
		.ss.ss = {
			0x22, 0x1d, 0x7d, 0x86, 0x01, 0x16, 0x59, 0x31,
			0x3c, 0x83, 0xce, 0x3f, 0xd0, 0xab, 0x26, 0x79,
			0x7e, 0xf2, 0x17, 0xe1, 0x1d, 0x1f, 0x0b, 0xc7,
			0x6e, 0x79, 0x52, 0xfb, 0xe5, 0x2a, 0x0a, 0x58,
			},
	},
	/* Implicit Kyber dec rejection testing: modify last bit of CT */
	{
		.ct.ct = {
			0x5a, 0x64, 0x51, 0x20, 0xb8, 0x78, 0x93, 0x6d,
			0x20, 0x2e, 0xfc, 0x48, 0x51, 0xf3, 0x8e, 0x6b,
			0xb6, 0x57, 0x3c, 0x3b, 0x14, 0xb0, 0xb9, 0xbb,
			0x44, 0xbf, 0x37, 0x2d, 0x8b, 0x1a, 0xa8, 0x03,
			0x4a, 0x9f, 0x1a, 0x15, 0x84, 0x07, 0x6f, 0x0a,
			0x38, 0xe8, 0x9a, 0x9d, 0x49, 0xa5, 0x0b, 0x79,
			0x2a, 0xce, 0x75, 0x84, 0x98, 0x1b, 0xe8, 0xe2,
			0x39, 0x27, 0x2d, 0xee, 0xf9, 0x14, 0x41, 0x8f,
			0xef, 0xe2, 0xda, 0xd9, 0x7d, 0xc0, 0xec, 0x20,
			0xcf, 0xe8, 0xa9, 0x59, 0x9b, 0x9b, 0xbe, 0x3e,
			0xcc, 0xe9, 0x1f, 0x97, 0xe1, 0x0c, 0xd9, 0xef,
			0x2c, 0x49, 0x50, 0xe3, 0xea, 0x3c, 0x46, 0xfe,
			0x48, 0x1e, 0xb0, 0xd2, 0x48, 0x78, 0xc4, 0x62,
			0x4a, 0xd3, 0x44, 0xf0, 0xdc, 0x98, 0x63, 0xe7,
			0xd1, 0x70, 0x93, 0x7a, 0x8c, 0xec, 0xc6, 0xf7,
			0xd0, 0x0f, 0x95, 0x65, 0x52, 0x9d, 0x57, 0x29,
			0x59, 0xcc, 0x49, 0xd0, 0xf7, 0x04, 0x2f, 0xf4,
			0x3b, 0x7d, 0x1d, 0x71, 0xef, 0xd2, 0x2f, 0x26,
			0x54, 0xe1, 0x4e, 0x78, 0xc3, 0x1f, 0x34, 0xa2,
			0x6a, 0xe5, 0x3b, 0x06, 0x7a, 0xe0, 0x38, 0x0a,
			0x65, 0xa7, 0x32, 0x45, 0x95, 0x03, 0xda, 0x5e,
			0x94, 0x06, 0xd5, 0x0a, 0x70, 0xe3, 0xd5, 0xeb,
			0xdb, 0xf3, 0xc9, 0xc0, 0x1c, 0xad, 0x1c, 0xc0,
			0x01, 0xeb, 0xe6, 0x9e, 0x6c, 0xff, 0x20, 0xe6,
			0x4c, 0xe5, 0xc8, 0x02, 0xb6, 0x91, 0x58, 0x7e,
			0x40, 0x4c, 0xf6, 0xef, 0xa2, 0x79, 0x9a, 0x2f,
			0xfd, 0x35, 0x34, 0x92, 0xa7, 0x5f, 0x0e, 0x2e,
			0xa5, 0x2a, 0x97, 0x4e, 0x05, 0x45, 0xa0, 0x86,
			0xa3, 0xbd, 0x14, 0xb6, 0x90, 0x45, 0x23, 0x81,
			0x40, 0xa7, 0x20, 0x0b, 0x10, 0xc3, 0x27, 0x6c,
			0xc6, 0xb2, 0xa6, 0x7c, 0x17, 0x3f, 0x7c, 0x1a,
			0xd6, 0x45, 0x45, 0xad, 0xb8, 0xeb, 0xdf, 0x78,
			0x35, 0xe9, 0xaa, 0x1f, 0x54, 0xf6, 0x89, 0x13,
			0x69, 0x98, 0x8f, 0x36, 0x25, 0xc4, 0x5f, 0x2f,
			0xec, 0x8d, 0x9a, 0x07, 0xb9, 0x11, 0xd3, 0x2b,
			0xa6, 0x9d, 0x9f, 0xf5, 0xd7, 0x4f, 0x10, 0xa6,
			0x80, 0x8b, 0x25, 0xa3, 0xc8, 0x17, 0x09, 0x94,
			0x5b, 0xf2, 0x13, 0xc3, 0x45, 0x0d, 0x74, 0x48,
			0x1f, 0x06, 0x50, 0x42, 0x18, 0x6b, 0x0d, 0x36,
			0xfb, 0x55, 0x27, 0x11, 0x62, 0xdf, 0xaf, 0x41,
			0xe5, 0x16, 0xa4, 0x08, 0xf8, 0x3c, 0xca, 0xbe,
			0x8a, 0x0b, 0xa7, 0xef, 0xfa, 0x16, 0xf8, 0x8f,
			0x6d, 0x7d, 0xbd, 0xb6, 0x4e, 0x60, 0x8c, 0x8f,
			0x18, 0xd6, 0x86, 0xc7, 0xe5, 0xd5, 0x48, 0xd7,
			0x37, 0x11, 0x6f, 0xa5, 0x62, 0xdc, 0x76, 0xe7,
			0x99, 0x4a, 0x86, 0x37, 0x4a, 0x9c, 0x85, 0xb8,
			0xb1, 0x7c, 0x4f, 0x02, 0x5f, 0xa2, 0x3a, 0x4d,
			0xe1, 0xa9, 0x97, 0xa8, 0x7e, 0x5a, 0x65, 0xf5,
			0xc5, 0x38, 0x67, 0x72, 0x49, 0x1f, 0xd8, 0xd1,
			0x07, 0x31, 0xf5, 0xf5, 0xaa, 0x60, 0x36, 0x6f,
			0xfe, 0x3f, 0xd2, 0x09, 0xcb, 0x7b, 0x7a, 0x86,
			0x15, 0x32, 0x0a, 0xd0, 0x72, 0x8f, 0x41, 0xe8,
			0x12, 0xbd, 0x88, 0xd2, 0xd6, 0x10, 0x47, 0x53,
			0x91, 0x7e, 0x89, 0xe1, 0xca, 0x0f, 0x10, 0x17,
			0x7c, 0xf5, 0xda, 0xb0, 0x40, 0xe4, 0x66, 0x90,
			0x8b, 0x27, 0x44, 0x62, 0x15, 0x70, 0x9b, 0x09,
			0x12, 0x97, 0x2c, 0x42, 0x8c, 0x4d, 0x9a, 0xad,
			0x94, 0x32, 0xd9, 0xa1, 0x59, 0x06, 0x9c, 0x96,
			0x15, 0x40, 0x01, 0xcb, 0x0b, 0xe4, 0xde, 0x59,
			0x7e, 0x98, 0x71, 0xb0, 0x4b, 0xdd, 0xaa, 0x45,
			0x39, 0xf8, 0x38, 0xbc, 0x12, 0xab, 0x0a, 0x3e,
			0xa7, 0xe8, 0xc8, 0x48, 0x1b, 0xcd, 0xfc, 0xc1,
			0x83, 0x43, 0x69, 0xfc, 0xf0, 0x61, 0xf7, 0xc5,
			0x99, 0xef, 0xdc, 0x4f, 0x6c, 0x43, 0x41, 0x02,
			0x99, 0x14, 0x46, 0xae, 0xa1, 0x28, 0x81, 0xe1,
			0x63, 0xfd, 0x4e, 0xe6, 0xc4, 0x58, 0xb8, 0x2e,
			0x42, 0x75, 0x9f, 0x8b, 0x11, 0xb0, 0x61, 0x2c,
			0x12, 0xd5, 0xa7, 0x77, 0xac, 0xf4, 0xc7, 0xcd,
			0xd2, 0x6f, 0xb7, 0xda, 0x0b, 0x90, 0x98, 0xdc,
			0x4a, 0xf9, 0x47, 0x04, 0xda, 0xa5, 0x29, 0x94,
			0x5a, 0xb1, 0x69, 0xcd, 0xb2, 0x2d, 0x39, 0x66,
			0xfc, 0xd2, 0x69, 0x50, 0xe2, 0x41, 0x8c, 0xac,
			0x9b, 0xc7, 0xdc, 0x32, 0xc4, 0xa6, 0x04, 0xf3,
			0x68, 0xf0, 0xf8, 0xa9, 0xc7, 0xdd, 0xce, 0x8b,
			0x5e, 0x47, 0x6b, 0x26, 0xb3, 0x31, 0x16, 0xd6,
			0x07, 0xdf, 0x1b, 0x49, 0xc2, 0x05, 0xad, 0xa0,
			0xd2, 0xea, 0x5a, 0x5a, 0x64, 0xee, 0xcb, 0x22,
			0x54, 0x9d, 0xdf, 0x18, 0xa0, 0xda, 0xed, 0x2e,
			0x5d, 0x44, 0xcb, 0x61, 0x74, 0xb9, 0x78, 0x12,
			0x36, 0xee, 0xe1, 0x1f, 0x95, 0xab, 0x0c, 0x45,
			0x83, 0x6b, 0xca, 0xfc, 0x73, 0xaf, 0x3b, 0xec,
			0x11, 0x44, 0x0b, 0xc1, 0xc6, 0x05, 0x66, 0x9e,
			0xb0, 0x19, 0xcf, 0xac, 0x00, 0x97, 0x94, 0x3c,
			0xf2, 0x9b, 0xbf, 0xfc, 0xe0, 0xf8, 0x23, 0x29,
			0x3d, 0xa6, 0x23, 0xe5, 0xfa, 0x6d, 0x2a, 0x7e,
			0xe0, 0xc7, 0xb4, 0x50, 0x75, 0x96, 0xa6, 0x2e,
			0xf4, 0x6b, 0xbe, 0x4e, 0x1b, 0x63, 0xcc, 0x96,
			0xba, 0x98, 0x78, 0xa7, 0xb3, 0x9f, 0x84, 0xb5,
			0x9d, 0xd3, 0x36, 0xf1, 0x65, 0x9a, 0x24, 0xcb,
			0xb3, 0x30, 0x15, 0xd5, 0x15, 0xe9, 0xe8, 0x0e,
			0x3e, 0x79, 0x02, 0xb1, 0xd5, 0x83, 0xf8, 0xee,
			0x97, 0x15, 0x3c, 0xd8, 0xba, 0x1f, 0xad, 0xeb,
			0x9e, 0xe7, 0xe2, 0xf2, 0xc2, 0x3d, 0xfe, 0xe8,
			0x5a, 0x50, 0xd5, 0xc3, 0x55, 0x4b, 0x79, 0x92,
			0x2a, 0x45, 0x37, 0xd6, 0xdc, 0x4f, 0x09, 0x41,
			0x8d, 0xfd, 0xd7, 0x44, 0x59, 0x6c, 0xbf, 0x69,
			},
		.ss.ss = {
			0x7c, 0x08, 0x9d, 0x37, 0xbb, 0xbd, 0x44, 0x86, 0x25, 0xf1, 0x09, 0xe2, 0x46, 0x02, 0x2e, 0xce, 0xae, 0xea, 0x6b, 0xca, 0x3f, 0x73, 0x7b, 0xda, 0x86, 0xda, 0xbd, 0x47, 0xac, 0x70, 0x9d, 0x7b
			},
	},
};
#endif
