/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.booleans;

import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.booleans.BooleanCollection;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.booleans.BooleanImmutableList;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.booleans.BooleanIterators;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.booleans.BooleanListIterator;
import it.unimi.dsi.fastutil.booleans.BooleanLists;
import it.unimi.dsi.fastutil.booleans.BooleanSpliterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

public class BooleanImmutableList
extends BooleanLists.ImmutableListBase
implements BooleanList,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 0L;
    static final BooleanImmutableList EMPTY = new BooleanImmutableList(BooleanArrays.EMPTY_ARRAY);
    private final boolean[] a;

    public BooleanImmutableList(boolean[] a) {
        this.a = a;
    }

    public BooleanImmutableList(Collection<? extends Boolean> c) {
        this(c.isEmpty() ? BooleanArrays.EMPTY_ARRAY : BooleanIterators.unwrap((BooleanIterator)BooleanIterators.asBooleanIterator(c.iterator())));
    }

    public BooleanImmutableList(BooleanCollection c) {
        this(c.isEmpty() ? BooleanArrays.EMPTY_ARRAY : BooleanIterators.unwrap((BooleanIterator)c.iterator()));
    }

    public BooleanImmutableList(BooleanList l) {
        this(l.isEmpty() ? BooleanArrays.EMPTY_ARRAY : new boolean[l.size()]);
        l.getElements(0, this.a, 0, l.size());
    }

    public BooleanImmutableList(boolean[] a, int offset, int length) {
        this(length == 0 ? BooleanArrays.EMPTY_ARRAY : new boolean[length]);
        System.arraycopy(a, offset, this.a, 0, length);
    }

    public BooleanImmutableList(BooleanIterator i) {
        this(i.hasNext() ? BooleanIterators.unwrap((BooleanIterator)i) : BooleanArrays.EMPTY_ARRAY);
    }

    public static BooleanImmutableList of() {
        return EMPTY;
    }

    public static BooleanImmutableList of(boolean ... init) {
        return init.length == 0 ? BooleanImmutableList.of() : new BooleanImmutableList(init);
    }

    @Override
    public boolean getBoolean(int index) {
        if (index >= this.a.length) {
            throw new IndexOutOfBoundsException("Index (" + index + ") is greater than or equal to list size (" + this.a.length + ")");
        }
        return this.a[index];
    }

    @Override
    public int indexOf(boolean k) {
        boolean[] a = this.a;
        int size = a.length;
        for (int i = 0; i < size; ++i) {
            if (k != a[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(boolean k) {
        boolean[] a = this.a;
        int i = a.length;
        while (i-- != 0) {
            if (k != a[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int size() {
        return this.a.length;
    }

    @Override
    public boolean isEmpty() {
        return this.a.length == 0;
    }

    @Override
    public void getElements(int from, boolean[] a, int offset, int length) {
        BooleanArrays.ensureOffsetLength(a, offset, length);
        System.arraycopy(this.a, from, a, offset, length);
    }

    @Override
    public void forEach(BooleanConsumer action) {
        boolean[] a = this.a;
        for (int i = 0; i < a.length; ++i) {
            action.accept(a[i]);
        }
    }

    @Override
    public boolean[] toBooleanArray() {
        if (this.a.length == 0) {
            return BooleanArrays.EMPTY_ARRAY;
        }
        return (boolean[])this.a.clone();
    }

    @Override
    public boolean[] toArray(boolean[] a) {
        if (a == null || a.length < this.size()) {
            a = new boolean[this.a.length];
        }
        System.arraycopy(this.a, 0, a, 0, a.length);
        return a;
    }

    @Override
    public BooleanListIterator listIterator(int index) {
        this.ensureIndex(index);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Override
    public BooleanSpliterator spliterator() {
        return new Spliterator(this);
    }

    @Override
    public BooleanList subList(int from, int to) {
        if (from == 0 && to == this.size()) {
            return this;
        }
        this.ensureIndex(from);
        this.ensureIndex(to);
        if (from == to) {
            return EMPTY;
        }
        if (from > to) {
            throw new IllegalArgumentException("Start index (" + from + ") is greater than end index (" + to + ")");
        }
        return new ImmutableSubList(this, from, to);
    }

    public BooleanImmutableList clone() {
        return this;
    }

    public boolean equals(BooleanImmutableList l) {
        if (l == this) {
            return true;
        }
        if (this.a == l.a) {
            return true;
        }
        int s = this.size();
        if (s != l.size()) {
            return false;
        }
        boolean[] a1 = this.a;
        boolean[] a2 = l.a;
        return Arrays.equals(a1, a2);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof List)) {
            return false;
        }
        if (o instanceof BooleanImmutableList) {
            return this.equals((BooleanImmutableList)o);
        }
        if (o instanceof ImmutableSubList) {
            return ((ImmutableSubList)o).equals((Object)this);
        }
        return super.equals(o);
    }

    @Override
    public int compareTo(BooleanImmutableList l) {
        int i;
        if (this.a == l.a) {
            return 0;
        }
        int s1 = this.size();
        int s2 = l.size();
        boolean[] a1 = this.a;
        boolean[] a2 = l.a;
        for (i = 0; i < s1 && i < s2; ++i) {
            boolean e1 = a1[i];
            boolean e2 = a2[i];
            int r = Boolean.compare(e1, e2);
            if (r == 0) continue;
            return r;
        }
        return i < s2 ? -1 : (i < s1 ? 1 : 0);
    }

    @Override
    public int compareTo(List<? extends Boolean> l) {
        if (l instanceof BooleanImmutableList) {
            return this.compareTo((BooleanImmutableList)l);
        }
        if (l instanceof ImmutableSubList) {
            ImmutableSubList other = (ImmutableSubList)l;
            return -other.compareTo((List)this);
        }
        return super.compareTo(l);
    }

    static /* synthetic */ boolean[] access$000(BooleanImmutableList x0) {
        return x0.a;
    }
}

