//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by defaulter-gen. DO NOT EDIT.

package v1beta1

import (
	v1 "k8s.io/api/core/v1"
	storagev1beta1 "k8s.io/api/storage/v1beta1"
	runtime "k8s.io/apimachinery/pkg/runtime"
	corev1 "k8s.io/kubernetes/pkg/apis/core/v1"
)

// RegisterDefaults adds defaulters functions to the given scheme.
// Public to allow building arbitrary schemes.
// All generated defaulters are covering - they call all nested defaulters.
func RegisterDefaults(scheme *runtime.Scheme) error {
	scheme.AddTypeDefaultingFunc(&storagev1beta1.CSIDriver{}, func(obj interface{}) { SetObjectDefaults_CSIDriver(obj.(*storagev1beta1.CSIDriver)) })
	scheme.AddTypeDefaultingFunc(&storagev1beta1.CSIDriverList{}, func(obj interface{}) { SetObjectDefaults_CSIDriverList(obj.(*storagev1beta1.CSIDriverList)) })
	scheme.AddTypeDefaultingFunc(&storagev1beta1.StorageClass{}, func(obj interface{}) { SetObjectDefaults_StorageClass(obj.(*storagev1beta1.StorageClass)) })
	scheme.AddTypeDefaultingFunc(&storagev1beta1.StorageClassList{}, func(obj interface{}) { SetObjectDefaults_StorageClassList(obj.(*storagev1beta1.StorageClassList)) })
	scheme.AddTypeDefaultingFunc(&storagev1beta1.VolumeAttachment{}, func(obj interface{}) { SetObjectDefaults_VolumeAttachment(obj.(*storagev1beta1.VolumeAttachment)) })
	scheme.AddTypeDefaultingFunc(&storagev1beta1.VolumeAttachmentList{}, func(obj interface{}) {
		SetObjectDefaults_VolumeAttachmentList(obj.(*storagev1beta1.VolumeAttachmentList))
	})
	return nil
}

func SetObjectDefaults_CSIDriver(in *storagev1beta1.CSIDriver) {
	SetDefaults_CSIDriver(in)
}

func SetObjectDefaults_CSIDriverList(in *storagev1beta1.CSIDriverList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_CSIDriver(a)
	}
}

func SetObjectDefaults_StorageClass(in *storagev1beta1.StorageClass) {
	SetDefaults_StorageClass(in)
}

func SetObjectDefaults_StorageClassList(in *storagev1beta1.StorageClassList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_StorageClass(a)
	}
}

func SetObjectDefaults_VolumeAttachment(in *storagev1beta1.VolumeAttachment) {
	if in.Spec.Source.InlineVolumeSpec != nil {
		corev1.SetDefaults_ResourceList(&in.Spec.Source.InlineVolumeSpec.Capacity)
		if in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.HostPath != nil {
			corev1.SetDefaults_HostPathVolumeSource(in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.HostPath)
		}
		if in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.RBD != nil {
			if in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.RBD.RBDPool == "" {
				in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.RBD.RBDPool = "rbd"
			}
			if in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.RBD.RadosUser == "" {
				in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.RBD.RadosUser = "admin"
			}
			if in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.RBD.Keyring == "" {
				in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.RBD.Keyring = "/etc/ceph/keyring"
			}
		}
		if in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.ISCSI != nil {
			if in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.ISCSI.ISCSIInterface == "" {
				in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.ISCSI.ISCSIInterface = "default"
			}
		}
		if in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.AzureDisk != nil {
			if in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.AzureDisk.CachingMode == nil {
				ptrVar1 := v1.AzureDataDiskCachingMode(v1.AzureDataDiskCachingReadWrite)
				in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.AzureDisk.CachingMode = &ptrVar1
			}
			if in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.AzureDisk.FSType == nil {
				var ptrVar1 string = "ext4"
				in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.AzureDisk.FSType = &ptrVar1
			}
			if in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.AzureDisk.ReadOnly == nil {
				var ptrVar1 bool = false
				in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.AzureDisk.ReadOnly = &ptrVar1
			}
			if in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.AzureDisk.Kind == nil {
				ptrVar1 := v1.AzureDataDiskKind(v1.AzureSharedBlobDisk)
				in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.AzureDisk.Kind = &ptrVar1
			}
		}
		if in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.ScaleIO != nil {
			if in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.ScaleIO.StorageMode == "" {
				in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.ScaleIO.StorageMode = "ThinProvisioned"
			}
			if in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.ScaleIO.FSType == "" {
				in.Spec.Source.InlineVolumeSpec.PersistentVolumeSource.ScaleIO.FSType = "xfs"
			}
		}
	}
}

func SetObjectDefaults_VolumeAttachmentList(in *storagev1beta1.VolumeAttachmentList) {
	for i := range in.Items {
		a := &in.Items[i]
		SetObjectDefaults_VolumeAttachment(a)
	}
}
