#include "Python.h"
#include "sites.h"

#include "fract4dc/common.h"
#include "fract4dc/pysite.h"
#include "model/site.h"

namespace sites {

    PyObject * pyfdsite_create([[maybe_unused]] PyObject *self, PyObject *args)
    {
        int fd;
        if (!PyArg_ParseTuple(args, "i", &fd))
        {
            return NULL;
        }

        IFractalSite *site = new FDSite(fd);

        PyObject *pyret = PyCapsule_New(site, OBTYPE_SITE, pysite_delete);

        return pyret;
    }

    PyObject * pysite_create([[maybe_unused]] PyObject *self, PyObject *args)
    {
        PyObject *pysite;
        if (!PyArg_ParseTuple(
                args,
                "O",
                &pysite))
        {
            return NULL;
        }

        IFractalSite *site = new PySite(pysite);

        //fprintf(stderr,"pysite_create: %p\n",site);
        PyObject *pyret = PyCapsule_New(site, OBTYPE_SITE, pysite_delete);

        return pyret;
    }

    void pysite_delete(PyObject *pysite)
    {
        IFractalSite *site = site_fromcapsule(pysite);
        delete site;
    }

    IFractalSite * site_fromcapsule(PyObject *pysite)
    {
        IFractalSite *site = (IFractalSite *)PyCapsule_GetPointer(pysite, OBTYPE_SITE);
        if (NULL == site)
        {
            fprintf(stderr, "%p : ST : BAD\n", static_cast<void *>(pysite));
        }
        return site;
    }

}
