/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.type;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.type.AbstractType;
import net.sf.hibernate.type.AssociationType;

public abstract class PersistentCollectionType
extends AbstractType
implements AssociationType {
    private final String role;
    private static final int[] NO_INTS = new int[0];

    public PersistentCollectionType(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public boolean isPersistentCollectionType() {
        return true;
    }

    public final boolean equals(Object x, Object y) {
        return x == y;
    }

    public abstract PersistentCollection instantiate(SessionImplementor var1, CollectionPersister var2) throws HibernateException;

    public Object nullSafeGet(ResultSet rs, String name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        throw new AssertionFailure("bug in PersistentCollectionType");
    }

    public Object nullSafeGet(ResultSet rs, String[] name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return this.resolveIdentifier(this.hydrate(rs, name, session, owner), session, owner);
    }

    public Object getCollection(Serializable id, Object owner, SessionImplementor session) throws HibernateException {
        PersistentCollection collection = session.getLoadingCollection(this.role, id);
        if (collection != null) {
            return collection.getCachedValue();
        }
        CollectionPersister persister = session.getFactory().getCollectionPersister(this.role);
        collection = persister.getCachedCollection(id, owner, session);
        if (collection != null) {
            session.addInitializedCollection(collection, persister, id);
            return collection.getCachedValue();
        }
        collection = this.instantiate(session, persister);
        session.addUninitializedCollection(collection, persister, id);
        return collection.getInitialValue(persister.isLazy());
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SessionImplementor session) throws HibernateException, SQLException {
    }

    public int[] sqlTypes(Mapping session) throws MappingException {
        return NO_INTS;
    }

    public int getColumnSpan(Mapping session) throws MappingException {
        return 0;
    }

    public String toXML(Object value, SessionFactoryImplementor factory) {
        return value == null ? null : value.toString();
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public String getName() {
        return this.getReturnedClass().getName();
    }

    public Iterator getElementsIterator(Object collection) {
        return ((Collection)collection).iterator();
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value, SessionImplementor session) throws HibernateException {
        if (value == null) {
            return null;
        }
        Serializable id = session.getLoadedCollectionKey((PersistentCollection)value);
        if (id == null) {
            throw new AssertionFailure("Null collection id");
        }
        return id;
    }

    public Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        return this.resolveIdentifier(cached, session, owner);
    }

    public boolean isDirty(Object old, Object current, SessionImplementor session) throws HibernateException {
        Class ownerClass = session.getFactory().getCollectionPersister(this.role).getOwnerClass();
        if (!session.getFactory().getPersister(ownerClass).isVersioned()) {
            return false;
        }
        return super.isDirty(old, current, session);
    }

    public boolean hasNiceEquals() {
        return false;
    }

    public abstract PersistentCollection wrap(SessionImplementor var1, Object var2);

    public boolean isAssociationType() {
        return true;
    }

    public AssociationType.ForeignKeyType getForeignKeyType() {
        return AssociationType.FOREIGN_KEY_TO_PARENT;
    }

    public Object hydrate(ResultSet rs, String[] name, SessionImplementor session, Object owner) throws HibernateException, SQLException {
        return session.getEntityIdentifier(owner);
    }

    public Object resolveIdentifier(Object value, SessionImplementor session, Object owner) throws HibernateException {
        if (value == null) {
            return null;
        }
        return this.getCollection((Serializable)value, owner, session);
    }

    public boolean isArrayType() {
        return false;
    }

    public abstract PersistentCollection assembleCachedCollection(SessionImplementor var1, CollectionPersister var2, Serializable var3, Object var4) throws HibernateException;
}

