.\"
.\" Copyright (c) Mark J. Kilgard, 1996.
.\"
.\" See the file "man/LICENSE" for information on usage and redistribution
.\"
.TH glutPostRedisplay 3 "April 2025" "freeglut" "freeglut"
.SH NAME
glutPostRedisplay, glutPostWindowRedisplay - marks the current or specified window as needing to be
redisplayed.
.SH SYNTAX
.nf
.LP
void glutPostRedisplay(void);
void glutPostWindowRedisplay(int win);
.fi
.SH DESCRIPTION
glutPostRedisplay marks the normal plane of current window as needing to be redisplayed.
glutPostWindowRedisplay works the specified window as needing to be redisplayed.
After either call, the next iteration through glutMainLoop, the window's display
callback will be called to redisplay the window's normal plane. Multiple
calls to glutPostRedisplay before the next display callback
opportunity generates only a single redisplay callback.
glutPostRedisplay may be called within a window's display or
overlay display callback to re-mark that window for redisplay.

Logically, normal plane damage notification for a window is treated as a
glutPostRedisplay on the damaged window. Unlike damage
reported by the window system, glutPostRedisplay will not set to
true the normal plane's damaged status (returned by
glutLayerGet(GLUT_NORMAL_DAMAGED).

If the window you want to post a redisplay on is not already current
(and you do not require it to be immediately made current), using
glutPostWindowRedisplay is more efficient that calling glutSetWindow to
the desired window and then calling glutPostRedisplay.
.SH SEE ALSO
glutPostOverlayRedisplay, glutDisplayFunc
.SH AUTHOR
Mark J. Kilgard (mjk@nvidia.com)
