// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`ListParts`](crate::operation::list_parts::builders::ListPartsFluentBuilder) operation.
    /// This operation supports pagination; See [`into_paginator()`](crate::operation::list_parts::builders::ListPartsFluentBuilder::into_paginator).
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::set_bucket):<br>required: **true**<br><p>The name of the bucket to which the parts are being uploaded.</p> <p><b>Directory buckets</b> - When you use this operation with a directory bucket, you must use virtual-hosted-style requests in the format <code> <i>Bucket-name</i>.s3express-<i>zone-id</i>.<i>region-code</i>.amazonaws.com</code>. Path-style requests are not supported. Directory bucket names must be unique in the chosen Zone (Availability Zone or Local Zone). Bucket names must follow the format <code> <i>bucket-base-name</i>--<i>zone-id</i>--x-s3</code> (for example, <code> <i>amzn-s3-demo-bucket</i>--<i>usw2-az1</i>--x-s3</code>). For information about bucket naming restrictions, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-bucket-naming-rules.html">Directory bucket naming rules</a> in the <i>Amazon S3 User Guide</i>.</p> <p><b>Access points</b> - When you use this action with an access point for general purpose buckets, you must provide the alias of the access point in place of the bucket name or specify the access point ARN. When you use this action with an access point for directory buckets, you must provide the access point name in place of the bucket name. When using the access point ARN, you must direct requests to the access point hostname. The access point hostname takes the form <i>AccessPointName</i>-<i>AccountId</i>.s3-accesspoint.<i>Region</i>.amazonaws.com. When using this action with an access point through the Amazon Web Services SDKs, you provide the access point ARN in place of the bucket name. For more information about access point ARNs, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html">Using access points</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>Object Lambda access points are not supported by directory buckets.</p> </note> <p><b>S3 on Outposts</b> - When you use this action with S3 on Outposts, you must direct requests to the S3 on Outposts hostname. The S3 on Outposts hostname takes the form <code> <i>AccessPointName</i>-<i>AccountId</i>.<i>outpostID</i>.s3-outposts.<i>Region</i>.amazonaws.com</code>. When you use this action with S3 on Outposts, the destination bucket must be the Outposts access point ARN or the access point alias. For more information about S3 on Outposts, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html">What is S3 on Outposts?</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`key(impl Into<String>)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::key) / [`set_key(Option<String>)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::set_key):<br>required: **true**<br><p>Object key for which the multipart upload was initiated.</p><br>
    ///   - [`max_parts(i32)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::max_parts) / [`set_max_parts(Option<i32>)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::set_max_parts):<br>required: **false**<br><p>Sets the maximum number of parts to return.</p><br>
    ///   - [`part_number_marker(impl Into<String>)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::part_number_marker) / [`set_part_number_marker(Option<String>)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::set_part_number_marker):<br>required: **false**<br><p>Specifies the part after which listing should begin. Only parts with higher part numbers will be listed.</p><br>
    ///   - [`upload_id(impl Into<String>)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::upload_id) / [`set_upload_id(Option<String>)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::set_upload_id):<br>required: **true**<br><p>Upload ID identifying the multipart upload whose parts are being listed.</p><br>
    ///   - [`request_payer(RequestPayer)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::request_payer) / [`set_request_payer(Option<RequestPayer>)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::set_request_payer):<br>required: **false**<br><p>Confirms that the requester knows that they will be charged for the request. Bucket owners need not specify this parameter in their requests. If either the source or destination S3 bucket has Requester Pays enabled, the requester will pay for corresponding charges to copy the object. For information about downloading objects from Requester Pays buckets, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html">Downloading Objects in Requester Pays Buckets</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><br>
    ///   - [`sse_customer_algorithm(impl Into<String>)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::sse_customer_algorithm) / [`set_sse_customer_algorithm(Option<String>)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::set_sse_customer_algorithm):<br>required: **false**<br><p>The server-side encryption (SSE) algorithm used to encrypt the object. This parameter is needed only when the object was created using a checksum algorithm. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Protecting data using SSE-C keys</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`sse_customer_key(impl Into<String>)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::sse_customer_key) / [`set_sse_customer_key(Option<String>)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::set_sse_customer_key):<br>required: **false**<br><p>The server-side encryption (SSE) customer managed key. This parameter is needed only when the object was created using a checksum algorithm. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Protecting data using SSE-C keys</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    ///   - [`sse_customer_key_md5(impl Into<String>)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::sse_customer_key_md5) / [`set_sse_customer_key_md5(Option<String>)`](crate::operation::list_parts::builders::ListPartsFluentBuilder::set_sse_customer_key_md5):<br>required: **false**<br><p>The MD5 server-side encryption (SSE) customer managed key. This parameter is needed only when the object was created using a checksum algorithm. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/ServerSideEncryptionCustomerKeys.html">Protecting data using SSE-C keys</a> in the <i>Amazon S3 User Guide</i>.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note><br>
    /// - On success, responds with [`ListPartsOutput`](crate::operation::list_parts::ListPartsOutput) with field(s):
    ///   - [`abort_date(Option<DateTime>)`](crate::operation::list_parts::ListPartsOutput::abort_date): <p>If the bucket has a lifecycle rule configured with an action to abort incomplete multipart uploads and the prefix in the lifecycle rule matches the object name in the request, then the response includes this header indicating when the initiated multipart upload will become eligible for abort operation. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html#mpu-abort-incomplete-mpu-lifecycle-config">Aborting Incomplete Multipart Uploads Using a Bucket Lifecycle Configuration</a>.</p> <p>The response will also include the <code>x-amz-abort-rule-id</code> header that will provide the ID of the lifecycle configuration rule that defines this action.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`abort_rule_id(Option<String>)`](crate::operation::list_parts::ListPartsOutput::abort_rule_id): <p>This header is returned along with the <code>x-amz-abort-date</code> header. It identifies applicable lifecycle configuration rule that defines the action to abort incomplete multipart uploads.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`bucket(Option<String>)`](crate::operation::list_parts::ListPartsOutput::bucket): <p>The name of the bucket to which the multipart upload was initiated. Does not return the access point ARN or access point alias if used.</p>
    ///   - [`key(Option<String>)`](crate::operation::list_parts::ListPartsOutput::key): <p>Object key for which the multipart upload was initiated.</p>
    ///   - [`upload_id(Option<String>)`](crate::operation::list_parts::ListPartsOutput::upload_id): <p>Upload ID identifying the multipart upload whose parts are being listed.</p>
    ///   - [`part_number_marker(Option<String>)`](crate::operation::list_parts::ListPartsOutput::part_number_marker): <p>Specifies the part after which listing should begin. Only parts with higher part numbers will be listed.</p>
    ///   - [`next_part_number_marker(Option<String>)`](crate::operation::list_parts::ListPartsOutput::next_part_number_marker): <p>When a list is truncated, this element specifies the last part in the list, as well as the value to use for the <code>part-number-marker</code> request parameter in a subsequent request.</p>
    ///   - [`max_parts(Option<i32>)`](crate::operation::list_parts::ListPartsOutput::max_parts): <p>Maximum number of parts that were allowed in the response.</p>
    ///   - [`is_truncated(Option<bool>)`](crate::operation::list_parts::ListPartsOutput::is_truncated): <p>Indicates whether the returned list of parts is truncated. A true value indicates that the list was truncated. A list can be truncated if the number of parts exceeds the limit returned in the MaxParts element.</p>
    ///   - [`parts(Option<Vec::<Part>>)`](crate::operation::list_parts::ListPartsOutput::parts): <p>Container for elements related to a particular part. A response can contain zero or more <code>Part</code> elements.</p>
    ///   - [`initiator(Option<Initiator>)`](crate::operation::list_parts::ListPartsOutput::initiator): <p>Container element that identifies who initiated the multipart upload. If the initiator is an Amazon Web Services account, this element provides the same information as the <code>Owner</code> element. If the initiator is an IAM User, this element provides the user ARN and display name.</p>
    ///   - [`owner(Option<Owner>)`](crate::operation::list_parts::ListPartsOutput::owner): <p>Container element that identifies the object owner, after the object is created. If multipart upload is initiated by an IAM user, this element provides the parent account ID and display name.</p><note>  <p><b>Directory buckets</b> - The bucket owner is returned as the object owner for all the parts.</p> </note>
    ///   - [`storage_class(Option<StorageClass>)`](crate::operation::list_parts::ListPartsOutput::storage_class): <p>The class of storage used to store the uploaded object.</p><note>  <p><b>Directory buckets</b> - Directory buckets only support <code>EXPRESS_ONEZONE</code> (the S3 Express One Zone storage class) in Availability Zones and <code>ONEZONE_IA</code> (the S3 One Zone-Infrequent Access storage class) in Dedicated Local Zones.</p> </note>
    ///   - [`request_charged(Option<RequestCharged>)`](crate::operation::list_parts::ListPartsOutput::request_charged): <p>If present, indicates that the requester was successfully charged for the request.</p><note>  <p>This functionality is not supported for directory buckets.</p> </note>
    ///   - [`checksum_algorithm(Option<ChecksumAlgorithm>)`](crate::operation::list_parts::ListPartsOutput::checksum_algorithm): <p>The algorithm that was used to create a checksum of the object.</p>
    ///   - [`checksum_type(Option<ChecksumType>)`](crate::operation::list_parts::ListPartsOutput::checksum_type): <p>The checksum type, which determines how part-level checksums are combined to create an object-level checksum for multipart objects. You can use this header response to verify that the checksum type that is received is the same checksum type that was specified in <code>CreateMultipartUpload</code> request. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity in the Amazon S3 User Guide</a>.</p>
    /// - On failure, responds with [`SdkError<ListPartsError>`](crate::operation::list_parts::ListPartsError)
    pub fn list_parts(&self) -> crate::operation::list_parts::builders::ListPartsFluentBuilder {
        crate::operation::list_parts::builders::ListPartsFluentBuilder::new(self.handle.clone())
    }
}
