/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.internal;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.asamk.signal.manager.config.ServiceEnvironmentConfig;
import org.asamk.signal.manager.internal.SignalWebSocketHealthMonitor;
import org.asamk.signal.manager.util.Utils;
import org.signal.libsignal.metadata.certificate.CertificateValidator;
import org.signal.libsignal.net.Network;
import org.signal.libsignal.protocol.UsePqRatchet;
import org.signal.libsignal.zkgroup.profiles.ClientZkProfileOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.SignalServiceAccountManager;
import org.whispersystems.signalservice.api.SignalServiceDataStore;
import org.whispersystems.signalservice.api.SignalServiceMessageReceiver;
import org.whispersystems.signalservice.api.SignalServiceMessageSender;
import org.whispersystems.signalservice.api.SignalSessionLock;
import org.whispersystems.signalservice.api.account.AccountApi;
import org.whispersystems.signalservice.api.attachment.AttachmentApi;
import org.whispersystems.signalservice.api.cds.CdsApi;
import org.whispersystems.signalservice.api.certificate.CertificateApi;
import org.whispersystems.signalservice.api.crypto.SignalServiceCipher;
import org.whispersystems.signalservice.api.groupsv2.ClientZkOperations;
import org.whispersystems.signalservice.api.groupsv2.GroupsV2Api;
import org.whispersystems.signalservice.api.groupsv2.GroupsV2Operations;
import org.whispersystems.signalservice.api.keys.KeysApi;
import org.whispersystems.signalservice.api.link.LinkDeviceApi;
import org.whispersystems.signalservice.api.message.MessageApi;
import org.whispersystems.signalservice.api.profiles.ProfileApi;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.ServiceIdType;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;
import org.whispersystems.signalservice.api.ratelimit.RateLimitChallengeApi;
import org.whispersystems.signalservice.api.registration.RegistrationApi;
import org.whispersystems.signalservice.api.services.ProfileService;
import org.whispersystems.signalservice.api.storage.StorageServiceApi;
import org.whispersystems.signalservice.api.storage.StorageServiceRepository;
import org.whispersystems.signalservice.api.svr.SecureValueRecovery;
import org.whispersystems.signalservice.api.username.UsernameApi;
import org.whispersystems.signalservice.api.util.CredentialsProvider;
import org.whispersystems.signalservice.api.util.SleepTimer;
import org.whispersystems.signalservice.api.util.UptimeSleepTimer;
import org.whispersystems.signalservice.api.websocket.HealthMonitor;
import org.whispersystems.signalservice.api.websocket.SignalWebSocket;
import org.whispersystems.signalservice.internal.configuration.SignalServiceConfiguration;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.websocket.OkHttpWebSocketConnection;

public class SignalDependencies {
    private static final Logger logger = LoggerFactory.getLogger(SignalDependencies.class);
    private final Object LOCK = new Object();
    private final ServiceEnvironmentConfig serviceEnvironmentConfig;
    private final String userAgent;
    private final CredentialsProvider credentialsProvider;
    private final SignalServiceDataStore dataStore;
    private final ExecutorService executor;
    private final SignalSessionLock sessionLock;
    private boolean allowStories = true;
    private SignalServiceAccountManager accountManager;
    private AccountApi accountApi;
    private RateLimitChallengeApi rateLimitChallengeApi;
    private CdsApi cdsApi;
    private UsernameApi usernameApi;
    private GroupsV2Api groupsV2Api;
    private RegistrationApi registrationApi;
    private LinkDeviceApi linkDeviceApi;
    private StorageServiceApi storageServiceApi;
    private CertificateApi certificateApi;
    private AttachmentApi attachmentApi;
    private MessageApi messageApi;
    private KeysApi keysApi;
    private GroupsV2Operations groupsV2Operations;
    private ClientZkOperations clientZkOperations;
    private PushServiceSocket pushServiceSocket;
    private Network libSignalNetwork;
    private SignalWebSocket.AuthenticatedWebSocket authenticatedSignalWebSocket;
    private SignalWebSocket.UnauthenticatedWebSocket unauthenticatedSignalWebSocket;
    private SignalServiceMessageReceiver messageReceiver;
    private SignalServiceMessageSender messageSender;
    private List<SecureValueRecovery> secureValueRecovery;
    private ProfileService profileService;
    private ProfileApi profileApi;

    SignalDependencies(ServiceEnvironmentConfig serviceEnvironmentConfig, String userAgent, CredentialsProvider credentialsProvider, SignalServiceDataStore dataStore, ExecutorService executor, SignalSessionLock sessionLock) {
        this.serviceEnvironmentConfig = serviceEnvironmentConfig;
        this.userAgent = userAgent;
        this.credentialsProvider = credentialsProvider;
        this.dataStore = dataStore;
        this.executor = executor;
        this.sessionLock = sessionLock;
    }

    public void resetAfterAddressChange() {
        if (this.pushServiceSocket != null) {
            this.pushServiceSocket.close();
            this.pushServiceSocket = null;
            this.accountManager = null;
            this.messageReceiver = null;
            this.messageSender = null;
            this.profileService = null;
            this.groupsV2Api = null;
            this.registrationApi = null;
            this.secureValueRecovery = null;
        }
        if (this.authenticatedSignalWebSocket != null) {
            this.authenticatedSignalWebSocket.forceNewWebSocket();
        }
        if (this.unauthenticatedSignalWebSocket != null) {
            this.unauthenticatedSignalWebSocket.forceNewWebSocket();
        }
    }

    public void setAllowStories(boolean allowStories) {
        this.allowStories = allowStories;
    }

    public ServiceEnvironmentConfig getServiceEnvironmentConfig() {
        return this.serviceEnvironmentConfig;
    }

    public SignalSessionLock getSessionLock() {
        return this.sessionLock;
    }

    public PushServiceSocket getPushServiceSocket() {
        return this.getOrCreate(() -> this.pushServiceSocket, () -> {
            this.pushServiceSocket = new PushServiceSocket(this.serviceEnvironmentConfig.signalServiceConfiguration(), this.credentialsProvider, this.userAgent, true);
        });
    }

    public Network getLibSignalNetwork() {
        return this.getOrCreate(() -> this.libSignalNetwork, () -> {
            this.libSignalNetwork = new Network(this.serviceEnvironmentConfig.netEnvironment(), this.userAgent);
            this.setSignalNetworkProxy(this.libSignalNetwork);
        });
    }

    private void setSignalNetworkProxy(Network libSignalNetwork) {
        Proxy proxy = Utils.getHttpsProxy();
        SocketAddress socketAddress = proxy.address();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress addr = (InetSocketAddress)socketAddress;
            switch (proxy.type()) {
                case DIRECT: {
                    break;
                }
                case HTTP: {
                    try {
                        libSignalNetwork.setProxy("http", addr.getHostName(), Integer.valueOf(addr.getPort()), null, null);
                    }
                    catch (IOException e) {
                        logger.warn("Failed to set http proxy", (Throwable)e);
                    }
                    break;
                }
                case SOCKS: {
                    try {
                        libSignalNetwork.setProxy("socks", addr.getHostName(), Integer.valueOf(addr.getPort()), null, null);
                        break;
                    }
                    catch (IOException e) {
                        logger.warn("Failed to set socks proxy", (Throwable)e);
                    }
                }
            }
        }
    }

    public SignalServiceAccountManager getAccountManager() {
        return this.getOrCreate(() -> this.accountManager, () -> {
            this.accountManager = new SignalServiceAccountManager(this.getAuthenticatedSignalWebSocket(), this.getAccountApi(), this.getPushServiceSocket(), this.getGroupsV2Operations());
        });
    }

    public SignalServiceAccountManager createUnauthenticatedAccountManager(String number, String password) {
        return SignalServiceAccountManager.createWithStaticCredentials((SignalServiceConfiguration)this.getServiceEnvironmentConfig().signalServiceConfiguration(), null, null, (String)number, (int)1, (String)password, (String)this.userAgent, (boolean)true, (int)1001);
    }

    public AccountApi getAccountApi() {
        return this.getOrCreate(() -> this.accountApi, () -> {
            this.accountApi = new AccountApi(this.getAuthenticatedSignalWebSocket());
        });
    }

    public RateLimitChallengeApi getRateLimitChallengeApi() {
        return this.getOrCreate(() -> this.rateLimitChallengeApi, () -> {
            this.rateLimitChallengeApi = new RateLimitChallengeApi(this.getAuthenticatedSignalWebSocket());
        });
    }

    public CdsApi getCdsApi() {
        return this.getOrCreate(() -> this.cdsApi, () -> {
            this.cdsApi = new CdsApi(this.getAuthenticatedSignalWebSocket());
        });
    }

    public UsernameApi getUsernameApi() {
        return this.getOrCreate(() -> this.usernameApi, () -> {
            this.usernameApi = new UsernameApi(this.getUnauthenticatedSignalWebSocket());
        });
    }

    public GroupsV2Api getGroupsV2Api() {
        return this.getOrCreate(() -> this.groupsV2Api, () -> {
            this.groupsV2Api = this.getAccountManager().getGroupsV2Api();
        });
    }

    public RegistrationApi getRegistrationApi() {
        return this.getOrCreate(() -> this.registrationApi, () -> {
            this.registrationApi = this.getAccountManager().getRegistrationApi();
        });
    }

    public LinkDeviceApi getLinkDeviceApi() {
        return this.getOrCreate(() -> this.linkDeviceApi, () -> {
            this.linkDeviceApi = new LinkDeviceApi(this.getAuthenticatedSignalWebSocket());
        });
    }

    private StorageServiceApi getStorageServiceApi() {
        return this.getOrCreate(() -> this.storageServiceApi, () -> {
            this.storageServiceApi = new StorageServiceApi(this.getAuthenticatedSignalWebSocket(), this.getPushServiceSocket());
        });
    }

    public StorageServiceRepository getStorageServiceRepository() {
        return new StorageServiceRepository(this.getStorageServiceApi());
    }

    public CertificateApi getCertificateApi() {
        return this.getOrCreate(() -> this.certificateApi, () -> {
            this.certificateApi = new CertificateApi(this.getAuthenticatedSignalWebSocket());
        });
    }

    public AttachmentApi getAttachmentApi() {
        return this.getOrCreate(() -> this.attachmentApi, () -> {
            this.attachmentApi = new AttachmentApi(this.getAuthenticatedSignalWebSocket(), this.getPushServiceSocket());
        });
    }

    public MessageApi getMessageApi() {
        return this.getOrCreate(() -> this.messageApi, () -> {
            this.messageApi = new MessageApi(this.getAuthenticatedSignalWebSocket(), this.getUnauthenticatedSignalWebSocket());
        });
    }

    public KeysApi getKeysApi() {
        return this.getOrCreate(() -> this.keysApi, () -> {
            this.keysApi = new KeysApi(this.getAuthenticatedSignalWebSocket(), this.getUnauthenticatedSignalWebSocket());
        });
    }

    public GroupsV2Operations getGroupsV2Operations() {
        return this.getOrCreate(() -> this.groupsV2Operations, () -> {
            this.groupsV2Operations = new GroupsV2Operations(ClientZkOperations.create((SignalServiceConfiguration)this.serviceEnvironmentConfig.signalServiceConfiguration()), 1001);
        });
    }

    private ClientZkOperations getClientZkOperations() {
        return this.getOrCreate(() -> this.clientZkOperations, () -> {
            this.clientZkOperations = ClientZkOperations.create((SignalServiceConfiguration)this.serviceEnvironmentConfig.signalServiceConfiguration());
        });
    }

    private ClientZkProfileOperations getClientZkProfileOperations() {
        ClientZkOperations clientZkOperations = this.getClientZkOperations();
        return clientZkOperations.getProfileOperations();
    }

    public SignalWebSocket.AuthenticatedWebSocket getAuthenticatedSignalWebSocket() {
        return this.getOrCreate(() -> this.authenticatedSignalWebSocket, () -> {
            UptimeSleepTimer timer = new UptimeSleepTimer();
            SignalWebSocketHealthMonitor healthMonitor = new SignalWebSocketHealthMonitor((SleepTimer)timer);
            this.authenticatedSignalWebSocket = new SignalWebSocket.AuthenticatedWebSocket(() -> new OkHttpWebSocketConnection("normal", this.serviceEnvironmentConfig.signalServiceConfiguration(), Optional.of(this.credentialsProvider), this.userAgent, (HealthMonitor)healthMonitor, this.allowStories), () -> true, (SleepTimer)timer, TimeUnit.SECONDS.toMillis(10L));
            healthMonitor.monitor((SignalWebSocket)this.authenticatedSignalWebSocket);
        });
    }

    public SignalWebSocket.UnauthenticatedWebSocket getUnauthenticatedSignalWebSocket() {
        return this.getOrCreate(() -> this.unauthenticatedSignalWebSocket, () -> {
            UptimeSleepTimer timer = new UptimeSleepTimer();
            SignalWebSocketHealthMonitor healthMonitor = new SignalWebSocketHealthMonitor((SleepTimer)timer);
            this.unauthenticatedSignalWebSocket = new SignalWebSocket.UnauthenticatedWebSocket(() -> new OkHttpWebSocketConnection("unidentified", this.serviceEnvironmentConfig.signalServiceConfiguration(), Optional.empty(), this.userAgent, (HealthMonitor)healthMonitor, this.allowStories), () -> true, (SleepTimer)timer, TimeUnit.SECONDS.toMillis(10L));
            healthMonitor.monitor((SignalWebSocket)this.unauthenticatedSignalWebSocket);
        });
    }

    public SignalServiceMessageReceiver getMessageReceiver() {
        return this.getOrCreate(() -> this.messageReceiver, () -> {
            this.messageReceiver = new SignalServiceMessageReceiver(this.getPushServiceSocket());
        });
    }

    public SignalServiceMessageSender getMessageSender() {
        return this.getOrCreate(() -> this.messageSender, () -> {
            this.messageSender = new SignalServiceMessageSender(this.getPushServiceSocket(), this.dataStore, this.sessionLock, this.getAttachmentApi(), this.getMessageApi(), this.getKeysApi(), Optional.empty(), this.executor, 0L, () -> true, UsePqRatchet.NO, Optional.empty());
        });
    }

    public List<SecureValueRecovery> getSecureValueRecovery() {
        return this.getOrCreate(() -> this.secureValueRecovery, () -> {
            this.secureValueRecovery = this.serviceEnvironmentConfig.svr2Mrenclaves().stream().map(mr -> this.getAccountManager().getSecureValueRecoveryV2(mr)).toList();
        });
    }

    public ProfileApi getProfileApi() {
        return this.getOrCreate(() -> this.profileApi, () -> {
            this.profileApi = new ProfileApi(this.getAuthenticatedSignalWebSocket(), this.getUnauthenticatedSignalWebSocket(), this.getPushServiceSocket(), this.getClientZkProfileOperations());
        });
    }

    public ProfileService getProfileService() {
        return this.getOrCreate(() -> this.profileService, () -> {
            this.profileService = new ProfileService(this.getClientZkProfileOperations(), this.getAuthenticatedSignalWebSocket(), this.getUnauthenticatedSignalWebSocket());
        });
    }

    public SignalServiceCipher getCipher(ServiceIdType serviceIdType) {
        CertificateValidator certificateValidator = new CertificateValidator(this.serviceEnvironmentConfig.unidentifiedSenderTrustRoot());
        SignalServiceAddress address = new SignalServiceAddress((ServiceId)this.credentialsProvider.getAci(), this.credentialsProvider.getE164());
        int deviceId = this.credentialsProvider.getDeviceId();
        return new SignalServiceCipher(address, deviceId, serviceIdType == ServiceIdType.ACI ? this.dataStore.aci() : this.dataStore.pni(), this.sessionLock, certificateValidator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getOrCreate(Supplier<T> supplier, Callable creator) {
        T value = supplier.get();
        if (value != null) {
            return value;
        }
        Object object = this.LOCK;
        synchronized (object) {
            value = supplier.get();
            if (value != null) {
                return value;
            }
            creator.call();
            return supplier.get();
        }
    }

    private static interface Callable {
        public void call();
    }
}

