/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.syncStorage;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Optional;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.GroupIdV1;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.groups.GroupInfo;
import org.asamk.signal.manager.storage.groups.GroupInfoV1;
import org.asamk.signal.manager.storage.groups.GroupInfoV2;
import org.asamk.signal.manager.syncStorage.DefaultStorageRecordProcessor;
import org.asamk.signal.manager.syncStorage.StorageRecordUpdate;
import org.asamk.signal.manager.syncStorage.StorageSyncModels;
import org.asamk.signal.manager.util.KeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.storage.SignalGroupV1Record;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.internal.storage.protos.GroupV1Record;

public final class GroupV1RecordProcessor
extends DefaultStorageRecordProcessor<SignalGroupV1Record> {
    private static final Logger logger = LoggerFactory.getLogger(GroupV1RecordProcessor.class);
    private final SignalAccount account;
    private final Connection connection;

    public GroupV1RecordProcessor(SignalAccount account, Connection connection) {
        this.account = account;
        this.connection = connection;
    }

    @Override
    protected boolean isInvalid(SignalGroupV1Record remote) throws SQLException {
        try {
            GroupId id = GroupId.unknownVersion(remote.getProto().id.toByteArray());
            if (!(id instanceof GroupIdV1)) {
                return true;
            }
            GroupInfo group = this.account.getGroupStore().getGroup(this.connection, id);
            if (group instanceof GroupInfoV2) {
                logger.debug("We already have an upgraded V2 group for this V1 group -- marking as invalid.");
                return true;
            }
            return false;
        }
        catch (AssertionError e) {
            logger.debug("Bad Group ID -- marking as invalid.");
            return true;
        }
    }

    @Override
    protected Optional<SignalGroupV1Record> getMatching(SignalGroupV1Record remote) throws SQLException {
        GroupIdV1 id = GroupId.v1(remote.getProto().id.toByteArray());
        GroupInfoV1 group = this.account.getGroupStore().getGroup(this.connection, id);
        if (group == null) {
            return Optional.empty();
        }
        StorageId storageId = this.account.getGroupStore().getGroupStorageId(this.connection, id);
        return Optional.of(new SignalGroupV1Record(storageId, StorageSyncModels.localToRemoteRecord(group)));
    }

    @Override
    protected SignalGroupV1Record merge(SignalGroupV1Record remoteRecord, SignalGroupV1Record localRecord) {
        GroupV1Record remote = remoteRecord.getProto();
        GroupV1Record local = localRecord.getProto();
        GroupV1Record.Builder mergedBuilder = remote.newBuilder().id(remote.id).blocked(remote.blocked).whitelisted(remote.whitelisted).markedUnread(remote.markedUnread).mutedUntilTimestamp(remote.mutedUntilTimestamp).archived(remote.archived);
        GroupV1Record merged = mergedBuilder.build();
        boolean matchesRemote = GroupV1RecordProcessor.doProtosMatch(merged, remote);
        if (matchesRemote) {
            return remoteRecord;
        }
        boolean matchesLocal = GroupV1RecordProcessor.doProtosMatch(merged, local);
        if (matchesLocal) {
            return localRecord;
        }
        return new SignalGroupV1Record(StorageId.forGroupV1((byte[])KeyUtils.createRawStorageId()), mergedBuilder.build());
    }

    @Override
    protected void insertLocal(SignalGroupV1Record record) throws SQLException {
        StorageRecordUpdate<SignalGroupV1Record> update = new StorageRecordUpdate<SignalGroupV1Record>(null, record);
        this.updateLocal(update);
    }

    @Override
    protected void updateLocal(StorageRecordUpdate<SignalGroupV1Record> update) throws SQLException {
        SignalGroupV1Record groupV1Record = update.newRecord();
        GroupV1Record groupV1Proto = groupV1Record.getProto();
        GroupIdV1 groupIdV1 = GroupId.v1(groupV1Proto.id.toByteArray());
        GroupInfoV1 group = this.account.getGroupStore().getOrCreateGroupV1(this.connection, groupIdV1);
        if (group != null) {
            group.setBlocked(groupV1Proto.blocked);
            this.account.getGroupStore().updateGroup(this.connection, group);
            this.account.getGroupStore().storeStorageRecord(this.connection, group.getGroupId(), groupV1Record.getId(), groupV1Proto.encode());
        }
    }

    @Override
    public int compare(SignalGroupV1Record lhs, SignalGroupV1Record rhs) {
        if (lhs.getProto().id.equals((Object)rhs.getProto().id)) {
            return 0;
        }
        return 1;
    }

    private static boolean doProtosMatch(GroupV1Record merged, GroupV1Record other) {
        return Arrays.equals(merged.encode(), other.encode());
    }
}

