/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.signal.core.util.InputStreamExtensionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/signal/core/util/stream/TrimmingInputStream;", "Ljava/io/FilterInputStream;", "inputStream", "Ljava/io/InputStream;", "trimSize", "", "drain", "", "<init>", "(Ljava/io/InputStream;IZ)V", "trimBuffer", "", "trimBufferSize", "streamEnded", "hasDrained", "internalBuffer", "internalBufferPosition", "internalBufferSize", "read", "b", "outputBuffer", "outputOffset", "readLength", "skip", "", "skipCount", "readNextByte", "drainIfNecessary", "", "core-util-jvm"})
public final class TrimmingInputStream
extends FilterInputStream {
    @NotNull
    private final InputStream inputStream;
    private final int trimSize;
    private final boolean drain;
    @NotNull
    private final byte[] trimBuffer;
    private int trimBufferSize;
    private boolean streamEnded;
    private boolean hasDrained;
    @NotNull
    private byte[] internalBuffer;
    private int internalBufferPosition;
    private int internalBufferSize;

    public TrimmingInputStream(@NotNull InputStream inputStream, int trimSize, boolean drain) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        super(inputStream);
        this.inputStream = inputStream;
        this.trimSize = trimSize;
        this.drain = drain;
        this.trimBuffer = new byte[this.trimSize];
        this.internalBuffer = new byte[4096];
    }

    public /* synthetic */ TrimmingInputStream(InputStream inputStream, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        this(inputStream, n, bl);
    }

    @Override
    public int read() throws IOException {
        byte[] singleByteBuffer = new byte[1];
        int bytesRead = this.read(singleByteBuffer, 0, 1);
        return bytesRead == -1 ? -1 : singleByteBuffer[0] & 0xFF;
    }

    @Override
    public int read(@NotNull byte[] b) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(@NotNull byte[] outputBuffer, int outputOffset, int readLength) throws IOException {
        int n;
        Intrinsics.checkNotNullParameter((Object)outputBuffer, (String)"outputBuffer");
        if (this.streamEnded) {
            return -1;
        }
        if (this.trimSize == 0) {
            return super.read(outputBuffer, outputOffset, readLength);
        }
        int outputCount = 0;
        while (outputCount < readLength) {
            int nextByte = this.readNextByte();
            if (nextByte == -1) {
                this.streamEnded = true;
                this.drainIfNecessary();
                break;
            }
            if (this.trimBufferSize < this.trimSize) {
                this.trimBuffer[this.trimBufferSize] = (byte)nextByte;
                int n2 = this.trimBufferSize;
                this.trimBufferSize = n2 + 1;
                continue;
            }
            outputBuffer[outputOffset + outputCount] = this.trimBuffer[0];
            ++outputCount;
            System.arraycopy(this.trimBuffer, 1, this.trimBuffer, 0, this.trimSize - 1);
            this.trimBuffer[this.trimSize - 1] = (byte)nextByte;
        }
        if (outputCount == 0) {
            this.drainIfNecessary();
            n = -1;
        } else {
            n = outputCount;
        }
        return n;
    }

    @Override
    public long skip(long skipCount) throws IOException {
        int toRead;
        long totalSkipped;
        int bytesRead;
        if (skipCount <= 0L) {
            return 0L;
        }
        byte[] buffer = new byte[8192];
        for (totalSkipped = 0L; totalSkipped < skipCount && (bytesRead = this.read(buffer, 0, toRead = Math.min((int)(skipCount - totalSkipped), buffer.length))) != -1; totalSkipped += (long)bytesRead) {
        }
        return totalSkipped;
    }

    private final int readNextByte() {
        boolean hitEndOfStream;
        if (this.internalBufferPosition >= this.internalBufferSize) {
            this.internalBufferPosition = 0;
            this.internalBufferSize = super.read(this.internalBuffer, 0, this.internalBuffer.length);
            v0 = this.internalBufferSize <= 0;
        } else {
            v0 = hitEndOfStream = false;
        }
        if (hitEndOfStream) {
            this.drainIfNecessary();
            return -1;
        }
        int n = this.internalBufferPosition;
        this.internalBufferPosition = n + 1;
        return this.internalBuffer[n] & 0xFF;
    }

    private final void drainIfNecessary() {
        if (this.drain && !this.hasDrained) {
            InputStreamExtensionsKt.drain(this.inputStream);
            this.hasDrained = true;
        }
    }
}

