/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kotlin.Unit;
import org.signal.core.util.StreamUtil;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.whispersystems.signalservice.api.NetworkResult;
import org.whispersystems.signalservice.api.backup.MediaRootBackupKey;
import org.whispersystems.signalservice.api.crypto.AttachmentCipherInputStream;
import org.whispersystems.signalservice.api.crypto.AttachmentCipherStreamUtil;
import org.whispersystems.signalservice.api.crypto.ProfileCipherInputStream;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachment;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentPointer;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachmentRemoteId;
import org.whispersystems.signalservice.api.messages.SignalServiceStickerManifest;
import org.whispersystems.signalservice.api.push.exceptions.MissingConfigurationException;
import org.whispersystems.signalservice.internal.crypto.PaddingInputStream;
import org.whispersystems.signalservice.internal.push.PushServiceSocket;
import org.whispersystems.signalservice.internal.sticker.Pack;
import org.whispersystems.signalservice.internal.util.Util;

public class SignalServiceMessageReceiver {
    private final PushServiceSocket socket;

    public SignalServiceMessageReceiver(PushServiceSocket socket) {
        this.socket = socket;
    }

    public InputStream retrieveAttachment(SignalServiceAttachmentPointer pointer, File destination, long maxSizeBytes, AttachmentCipherInputStream.IntegrityCheck integrityCheck) throws IOException, InvalidMessageException, MissingConfigurationException {
        return this.retrieveAttachment(pointer, destination, maxSizeBytes, integrityCheck, null);
    }

    public InputStream retrieveProfileAvatar(String path, File destination, ProfileKey profileKey, long maxSizeBytes) throws IOException {
        this.socket.retrieveProfileAvatar(path, destination, maxSizeBytes);
        return new ProfileCipherInputStream(new FileInputStream(destination), profileKey);
    }

    public FileInputStream retrieveGroupsV2ProfileAvatar(String path, File destination, long maxSizeBytes) throws IOException {
        this.socket.retrieveProfileAvatar(path, destination, maxSizeBytes);
        return new FileInputStream(destination);
    }

    public InputStream retrieveAttachment(SignalServiceAttachmentPointer pointer, File destination, long maxSizeBytes, AttachmentCipherInputStream.IntegrityCheck integrityCheck, SignalServiceAttachment.ProgressListener listener) throws IOException, InvalidMessageException, MissingConfigurationException {
        if (integrityCheck == null) {
            throw new InvalidMessageException("No integrity check!");
        }
        if (pointer.getKey() == null) {
            throw new InvalidMessageException("No key!");
        }
        this.socket.retrieveAttachment(pointer.getCdnNumber(), Collections.emptyMap(), pointer.getRemoteId(), destination, maxSizeBytes, listener);
        byte[] iv = new byte[16];
        try (FileInputStream tempStream = new FileInputStream(destination);){
            StreamUtil.readFully((InputStream)tempStream, (byte[])iv);
        }
        return AttachmentCipherInputStream.createForAttachment(destination, pointer.getSize().orElse(0).intValue(), pointer.getKey(), integrityCheck, null, 0);
    }

    public InputStream retrieveArchivedAttachment(@Nonnull MediaRootBackupKey.MediaKeyMaterial archivedMediaKeyMaterial, @Nonnull byte[] plaintextHash, @Nonnull Map<String, String> readCredentialHeaders, @Nonnull File archiveDestination, @Nonnull SignalServiceAttachmentPointer pointer, long maxSizeBytes, @Nullable SignalServiceAttachment.ProgressListener listener) throws IOException, InvalidMessageException, MissingConfigurationException {
        if (pointer.getKey() == null) {
            throw new InvalidMessageException("No key!");
        }
        this.socket.retrieveAttachment(pointer.getCdnNumber(), readCredentialHeaders, pointer.getRemoteId(), archiveDestination, maxSizeBytes, listener);
        long originalCipherLength = pointer.getSize().filter(s -> s > 0).map(s -> AttachmentCipherStreamUtil.getCiphertextLength(PaddingInputStream.getPaddedSize(s.intValue()))).orElse(0L);
        return AttachmentCipherInputStream.createForArchivedMedia(archivedMediaKeyMaterial, archiveDestination, originalCipherLength, pointer.getSize().orElse(0).intValue(), pointer.getKey(), plaintextHash, null, 0);
    }

    public InputStream retrieveArchivedThumbnail(@Nonnull MediaRootBackupKey.MediaKeyMaterial archivedMediaKeyMaterial, @Nonnull Map<String, String> readCredentialHeaders, @Nonnull File archiveDestination, @Nonnull SignalServiceAttachmentPointer pointer, long maxSizeBytes, @Nullable SignalServiceAttachment.ProgressListener listener) throws IOException, InvalidMessageException, MissingConfigurationException {
        if (pointer.getKey() == null) {
            throw new InvalidMessageException("No key!");
        }
        this.socket.retrieveAttachment(pointer.getCdnNumber(), readCredentialHeaders, pointer.getRemoteId(), archiveDestination, maxSizeBytes, listener);
        return AttachmentCipherInputStream.createForArchivedThumbnail(archivedMediaKeyMaterial, archiveDestination, pointer.getKey());
    }

    public void retrieveBackup(int cdnNumber, Map<String, String> headers, String cdnPath, File destination, SignalServiceAttachment.ProgressListener listener) throws MissingConfigurationException, IOException {
        this.socket.retrieveBackup(cdnNumber, headers, cdnPath, destination, 1000000000L, listener);
    }

    @Nonnull
    public NetworkResult<Unit> retrieveLinkAndSyncBackup(int cdn, @Nonnull String key, @Nonnull File destination, @Nullable SignalServiceAttachment.ProgressListener listener) {
        return NetworkResult.fromFetch(() -> {
            this.socket.retrieveAttachment(cdn, Collections.emptyMap(), new SignalServiceAttachmentRemoteId.V4(key), destination, 1000000000L, listener);
            return Unit.INSTANCE;
        });
    }

    @Nonnull
    public ZonedDateTime getCdnLastModifiedTime(int cdnNumber, Map<String, String> headers, String cdnPath) throws MissingConfigurationException, IOException {
        return this.socket.getCdnLastModifiedTime(cdnNumber, headers, cdnPath);
    }

    public InputStream retrieveSticker(byte[] packId, byte[] packKey, int stickerId) throws IOException, InvalidMessageException {
        byte[] data = this.socket.retrieveSticker(packId, stickerId);
        return AttachmentCipherInputStream.createForStickerData(data, packKey);
    }

    public SignalServiceStickerManifest retrieveStickerManifest(byte[] packId, byte[] packKey) throws IOException, InvalidMessageException {
        byte[] manifestBytes = this.socket.retrieveStickerManifest(packId);
        InputStream cipherStream = AttachmentCipherInputStream.createForStickerData(manifestBytes, packKey);
        Pack pack = (Pack)((Object)Pack.ADAPTER.decode(Util.readFullyAsBytes(cipherStream)));
        ArrayList<SignalServiceStickerManifest.StickerInfo> stickers = new ArrayList<SignalServiceStickerManifest.StickerInfo>(pack.stickers.size());
        SignalServiceStickerManifest.StickerInfo cover = pack.cover != null ? new SignalServiceStickerManifest.StickerInfo(pack.cover.id, pack.cover.emoji, pack.cover.contentType) : null;
        for (Pack.Sticker sticker : pack.stickers) {
            stickers.add(new SignalServiceStickerManifest.StickerInfo(sticker.id, sticker.emoji, sticker.contentType));
        }
        return new SignalServiceStickerManifest(pack.title, pack.author, cover, stickers);
    }
}

