/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.crypto;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import javax.crypto.Mac;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.signal.libsignal.protocol.InvalidMessageException;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\tH\u0016J \u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e8\u0006@BX\u0087\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001c"}, d2={"Lorg/whispersystems/signalservice/api/crypto/MacValidatingInputStream;", "Ljava/io/FilterInputStream;", "inputStream", "Ljava/io/InputStream;", "mac", "Ljavax/crypto/Mac;", "<init>", "(Ljava/io/InputStream;Ljavax/crypto/Mac;)V", "macBuffer", "", "macLength", "", "macBufferPosition", "streamEnded", "", "value", "validationAttempted", "getValidationAttempted", "()Z", "read", "b", "outputBuffer", "outputOffset", "readLength", "validateMacAndMarkStreamEnded", "", "minOf", "a", "signal-service-java"})
public final class MacValidatingInputStream
extends FilterInputStream {
    @NotNull
    private final Mac mac;
    @NotNull
    private final byte[] macBuffer;
    private final int macLength;
    private int macBufferPosition;
    private boolean streamEnded;
    @VisibleForTesting
    private boolean validationAttempted;

    public MacValidatingInputStream(@NotNull InputStream inputStream, @NotNull Mac mac) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)mac, (String)"mac");
        super(inputStream);
        this.mac = mac;
        this.macBuffer = new byte[this.mac.getMacLength()];
        this.macLength = this.mac.getMacLength();
    }

    public final boolean getValidationAttempted() {
        return this.validationAttempted;
    }

    @Override
    public int read() throws IOException {
        byte[] singleByteBuffer = new byte[1];
        int bytesRead = this.read(singleByteBuffer, 0, 1);
        return bytesRead == -1 ? -1 : singleByteBuffer[0] & 0xFF;
    }

    @Override
    public int read(@NotNull byte[] b) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(@NotNull byte[] outputBuffer, int outputOffset, int readLength) throws IOException {
        Intrinsics.checkNotNullParameter((Object)outputBuffer, (String)"outputBuffer");
        if (this.streamEnded) {
            return -1;
        }
        int bytesRead = super.read(outputBuffer, outputOffset, readLength);
        if (bytesRead == -1) {
            if (this.macBufferPosition < this.macLength) {
                throw new InvalidMessageException("Stream ended before MAC could be read. Expected " + this.macLength + " bytes, got " + this.macBufferPosition);
            }
            this.validateMacAndMarkStreamEnded();
            return -1;
        }
        if (bytesRead >= this.macLength) {
            if (this.macBufferPosition > 0) {
                this.mac.update(this.macBuffer, 0, this.macBufferPosition);
                this.macBufferPosition = 0;
            }
            ArraysKt.copyInto((byte[])outputBuffer, (byte[])this.macBuffer, (int)0, (int)(outputOffset + bytesRead - this.macLength), (int)(outputOffset + bytesRead));
            this.macBufferPosition = this.macLength;
            if (bytesRead > this.macLength) {
                this.mac.update(outputBuffer, outputOffset, bytesRead - this.macLength);
            }
        } else {
            int totalBytesAvailable = this.macBufferPosition + bytesRead;
            if (totalBytesAvailable <= this.macLength) {
                ArraysKt.copyInto((byte[])outputBuffer, (byte[])this.macBuffer, (int)this.macBufferPosition, (int)outputOffset, (int)(outputOffset + bytesRead));
                this.macBufferPosition = totalBytesAvailable;
            } else {
                int bytesOfReadRemaining;
                int bytesToDigest = totalBytesAvailable - this.macLength;
                int bytesOfBufferToDigest = this.minOf(this.macBufferPosition, bytesToDigest);
                int bytesOfReadToDigest = bytesToDigest - bytesOfBufferToDigest;
                this.mac.update(this.macBuffer, 0, bytesOfBufferToDigest);
                ArraysKt.copyInto((byte[])this.macBuffer, (byte[])this.macBuffer, (int)0, (int)bytesOfBufferToDigest, (int)this.macBufferPosition);
                this.macBufferPosition -= bytesOfBufferToDigest;
                if (bytesOfReadToDigest > 0) {
                    this.mac.update(outputBuffer, outputOffset, bytesOfReadToDigest);
                }
                if ((bytesOfReadRemaining = bytesRead - bytesOfReadToDigest) > 0) {
                    ArraysKt.copyInto((byte[])outputBuffer, (byte[])this.macBuffer, (int)this.macBufferPosition, (int)(outputOffset + bytesOfReadToDigest), (int)(outputOffset + bytesRead));
                    this.macBufferPosition += bytesOfReadRemaining;
                }
            }
        }
        return bytesRead;
    }

    private final void validateMacAndMarkStreamEnded() throws InvalidMessageException {
        if (this.validationAttempted) {
            return;
        }
        this.validationAttempted = true;
        this.streamEnded = true;
        byte[] calculatedMac = this.mac.doFinal();
        if (!MessageDigest.isEqual(calculatedMac, this.macBuffer)) {
            throw new InvalidMessageException("MAC validation failed!");
        }
    }

    private final int minOf(int a, int b) {
        return a < b ? a : b;
    }
}

