
use builtin;
use str;

set edit:completion:arg-completer[pk] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'pk'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'pk'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
            cand completion 'Generate shell completion'
            cand cpv 'Cpv commands'
            cand dep 'Dependency commands'
            cand pkg 'Package commands'
            cand repo 'Repository commands'
            cand version 'Version commands'
        }
        &'pk;completion'= {
            cand -d 'Target directory for completion files'
            cand --dir 'Target directory for completion files'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;cpv'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
            cand compare 'Compare two cpvs'
            cand intersect 'Determine if a cpv intersects another value'
            cand parse 'Parse cpv and optionally print formatted output'
            cand set 'Collapse cpvs into a set'
            cand sort 'Sort cpvs'
        }
        &'pk;cpv;compare'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'pk;cpv;intersect'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;cpv;parse'= {
            cand -f 'Output using a custom format'
            cand --format 'Output using a custom format'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;cpv;set'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;cpv;sort'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;dep'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
            cand compare 'Compare two deps'
            cand intersect 'Determine if a dep intersects another value'
            cand parse 'Parse a dep and optionally print formatted output'
            cand set 'Collapse deps into a set'
            cand sort 'Sort deps'
        }
        &'pk;dep;compare'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'pk;dep;intersect'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;dep;parse'= {
            cand --eapi 'Use a specific EAPI'
            cand -f 'Output using a custom format'
            cand --format 'Output using a custom format'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;dep;set'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;dep;sort'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;pkg'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
            cand env 'Output ebuild environment'
            cand fetch 'Fetch distfiles'
            cand manifest 'Update manifests'
            cand metadata 'Manipulate package metadata'
            cand pretend 'Run the pkg_pretend phase'
            cand revdeps 'Output reverse dependencies'
            cand showkw 'Output package keywords'
            cand source 'Benchmark ebuild sourcing'
        }
        &'pk;pkg;env'= {
            cand -f 'Variable filtering'
            cand --filter 'Variable filtering'
            cand -r 'Target repo'
            cand --repo 'Target repo'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -i 'Ignore invalid packages'
            cand --ignore 'Ignore invalid packages'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;pkg;fetch'= {
            cand -c 'Concurrent downloads'
            cand --concurrent 'Concurrent downloads'
            cand -d 'Download directory'
            cand --dir 'Download directory'
            cand -F 'Filter URLs via regex'
            cand --filter 'Filter URLs via regex'
            cand -t 'Connection timeout in seconds'
            cand --timeout 'Connection timeout in seconds'
            cand -r 'Target repo'
            cand --repo 'Target repo'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -f 'Overwrite existing files'
            cand --force 'Overwrite existing files'
            cand -i 'Ignore invalid packages'
            cand --ignore 'Ignore invalid packages'
            cand -I 'Ignore invalid service certificates'
            cand --insecure 'Ignore invalid service certificates'
            cand -m 'Try fetching from default mirrors'
            cand --mirrors 'Try fetching from default mirrors'
            cand -n 'Disable progress output'
            cand --no-progress 'Disable progress output'
            cand -p 'Output targets instead of fetching them'
            cand --pretend 'Output targets instead of fetching them'
            cand --restrict 'Process fetch-restricted URLS'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;pkg;manifest'= {
            cand -c 'Concurrent downloads'
            cand --concurrent 'Concurrent downloads'
            cand -d 'Download directory'
            cand --dir 'Download directory'
            cand -t 'Connection timeout in seconds'
            cand --timeout 'Connection timeout in seconds'
            cand -r 'Target repo'
            cand --repo 'Target repo'
            cand --thick 'Force manifest type'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -f 'Force remanifest'
            cand --force 'Force remanifest'
            cand -i 'Ignore invalid service certificates'
            cand --insecure 'Ignore invalid service certificates'
            cand -m 'Try fetching from default mirrors'
            cand --mirrors 'Try fetching from default mirrors'
            cand -n 'Disable progress output'
            cand --no-progress 'Disable progress output'
            cand --stdout 'Output to stdout'
            cand --restrict 'Process fetch-restricted URLS'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;pkg;metadata'= {
            cand -j 'Parallel jobs to run'
            cand --jobs 'Parallel jobs to run'
            cand -p 'Custom cache path'
            cand --path 'Custom cache path'
            cand --format 'Custom cache format'
            cand -r 'Target repo'
            cand --repo 'Target repo'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -f 'Force regeneration to occur'
            cand --force 'Force regeneration to occur'
            cand -V 'Verify metadata without updating cache'
            cand --verify 'Verify metadata without updating cache'
            cand -R 'Remove cache entries'
            cand --remove 'Remove cache entries'
            cand -n 'Disable progress bar'
            cand --no-progress 'Disable progress bar'
            cand -o 'Capture stderr and stdout'
            cand --output 'Capture stderr and stdout'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;pkg;pretend'= {
            cand -r 'Target repo'
            cand --repo 'Target repo'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -i 'Ignore invalid packages'
            cand --ignore 'Ignore invalid packages'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;pkg;revdeps'= {
            cand -r 'Target repository'
            cand --repo 'Target repository'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -i 'Ignore invalid packages'
            cand --ignore 'Ignore invalid packages'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;pkg;showkw'= {
            cand -r 'Target repo'
            cand --repo 'Target repo'
            cand -a 'Target arches'
            cand --arches 'Target arches'
            cand -f 'Set the tabular format'
            cand --format 'Set the tabular format'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -i 'Ignore invalid packages'
            cand --ignore 'Ignore invalid packages'
            cand -p 'Show prefix arches'
            cand --prefix 'Show prefix arches'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;pkg;source'= {
            cand -j 'Parallel jobs to run'
            cand --jobs 'Parallel jobs to run'
            cand -b 'Benchmark for a duration or number of runs'
            cand --bench 'Benchmark for a duration or number of runs'
            cand -B 'Apply bounds to elapsed time'
            cand --bound 'Apply bounds to elapsed time'
            cand -c 'Benchmark across all targets cumulatively'
            cand --cumulative 'Benchmark across all targets cumulatively'
            cand -f 'f'
            cand --format 'format'
            cand -r 'Target repo'
            cand --repo 'Target repo'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand --sort 'Sort output in ascending order for elapsed time'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'pk;repo'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
            cand add 'Add repository to config'
            cand eapi 'Output EAPI statistics'
            cand eclass 'Output eclass statistics'
            cand leaf 'Output leaf packages'
            cand license 'Output license statistics'
            cand list 'List repositories'
            cand metadata 'Manipulate repo metadata'
            cand mirror 'Output mirror statistics'
            cand remove 'Remove repositories'
            cand revdeps 'Output revdeps cache'
            cand sync 'Sync repos'
        }
        &'pk;repo;add'= {
            cand -n 'Repository name'
            cand --name 'Repository name'
            cand -p 'Repository priority'
            cand --priority 'Repository priority'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -f 'Only create the config file'
            cand --file 'Only create the config file'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;repo;eapi'= {
            cand --eapi 'Output packages for a target EAPI'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -i 'Ignore invalid packages'
            cand --ignore 'Ignore invalid packages'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;repo;eclass'= {
            cand --eclass 'Output packages for a target eclass'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -i 'Ignore invalid packages'
            cand --ignore 'Ignore invalid packages'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;repo;leaf'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -i 'Ignore invalid packages'
            cand --ignore 'Ignore invalid packages'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;repo;license'= {
            cand --licenses 'Output packages for target licenses'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -i 'Ignore invalid packages'
            cand --ignore 'Ignore invalid packages'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;repo;list'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -f 'Output full repository info'
            cand --full 'Output full repository info'
            cand -p 'Output repository paths'
            cand --path 'Output repository paths'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;repo;metadata'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
            cand clean 'Clean metadata cache'
            cand regen 'Regenerate metadata cache'
            cand remove 'Remove metadata cache'
        }
        &'pk;repo;metadata;clean'= {
            cand -p 'Custom cache path'
            cand --path 'Custom cache path'
            cand --format 'Custom cache format'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;repo;metadata;regen'= {
            cand -j 'Parallel jobs to run'
            cand --jobs 'Parallel jobs to run'
            cand -p 'Custom cache path'
            cand --path 'Custom cache path'
            cand --format 'Custom cache format'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -f 'Force regeneration to occur'
            cand --force 'Force regeneration to occur'
            cand -n 'Disable progress bar'
            cand --no-progress 'Disable progress bar'
            cand -o 'Capture stderr and stdout'
            cand --output 'Capture stderr and stdout'
            cand --use-local 'Update local USE cache'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;repo;metadata;remove'= {
            cand -p 'Custom cache path'
            cand --path 'Custom cache path'
            cand --format 'Custom cache format'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;repo;mirror'= {
            cand --mirror 'Output packages for a target mirror'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -i 'Ignore invalid packages'
            cand --ignore 'Ignore invalid packages'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;repo;remove'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;repo;revdeps'= {
            cand -d 'Target directory'
            cand --dir 'Target directory'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -i 'Ignore invalid packages'
            cand --ignore 'Ignore invalid packages'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;repo;sync'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;version'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
            cand compare 'Compare two versions'
            cand intersect 'Determine if two versions intersect'
            cand parse 'Parse a version and optionally print formatted output'
            cand set 'Collapse versions into a set'
            cand sort 'Sort versions'
        }
        &'pk;version;compare'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'pk;version;intersect'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;version;parse'= {
            cand -f 'Output using a custom format'
            cand --format 'Output using a custom format'
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;version;set'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'pk;version;sort'= {
            cand --color 'Enable/disable color support'
            cand --config 'Use a custom config'
            cand -v 'Increase logging verbosity'
            cand --verbose 'Increase logging verbosity'
            cand -q 'Decrease logging verbosity'
            cand --quiet 'Decrease logging verbosity'
            cand --portage 'Load repos from portage'
            cand -h 'Print help'
            cand --help 'Print help'
        }
    ]
    $completions[$command]
}
