/*
 * Decompiled with CFR 0.152.
 */
package org.pantsbuild.jarjar.util;

import java.io.IOException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.pantsbuild.jarjar.util.EntryStruct;
import org.pantsbuild.jarjar.util.GetNameClassWriter;
import org.pantsbuild.jarjar.util.JarProcessor;

public abstract class JarTransformer
implements JarProcessor {
    @Override
    public boolean process(EntryStruct entryStruct) throws IOException {
        if (entryStruct.name.endsWith(".class") && !entryStruct.skipTransform) {
            ClassReader classReader;
            try {
                classReader = new ClassReader(entryStruct.data);
            }
            catch (RuntimeException runtimeException) {
                System.err.println("Unable to read bytecode from " + entryStruct.name);
                runtimeException.printStackTrace();
                return true;
            }
            GetNameClassWriter getNameClassWriter = new GetNameClassWriter(1);
            try {
                classReader.accept(this.transform(getNameClassWriter), 8);
            }
            catch (RuntimeException runtimeException) {
                throw new IOException("Unable to transform " + entryStruct.name, runtimeException);
            }
            entryStruct.data = getNameClassWriter.toByteArray();
            entryStruct.name = JarTransformer.pathFromName(getNameClassWriter.getClassName());
        }
        return true;
    }

    protected abstract ClassVisitor transform(ClassVisitor var1);

    private static String pathFromName(String string) {
        return string.replace('.', '/') + ".class";
    }
}

