import _defineProperty from "@babel/runtime/helpers/defineProperty";
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { default as AnalyticsReactContext } from '@atlaskit/analytics-next-stable-react-context';
const ContextTypes = {
  getAtlaskitAnalyticsEventHandlers: PropTypes.func,
  getAtlaskitAnalyticsContext: PropTypes.func
};
const noop = () => [];

// eslint-disable-next-line @repo/internal/react/no-class-components
class AnalyticsListener extends Component {
  constructor(props) {
    super(props);
    _defineProperty(this, "getChildContext", () => ({
      getAtlaskitAnalyticsEventHandlers: this.getAnalyticsEventHandlers,
      getAtlaskitAnalyticsContext: this.getAtlaskitAnalyticsContext
    }));
    _defineProperty(this, "getAnalyticsEventHandlers", () => {
      const {
        channel,
        onEvent
      } = this.props;
      const {
        getAtlaskitAnalyticsEventHandlers = noop
      } = this.context;
      const handler = (event, eventChannel) => {
        if (channel === '*' || channel === eventChannel) {
          onEvent(event, eventChannel);
        }
      };
      return [handler, ...getAtlaskitAnalyticsEventHandlers()];
    });
    _defineProperty(this, "getAtlaskitAnalyticsContext", () => {
      const {
        getAtlaskitAnalyticsContext = noop
      } = this.context;
      return getAtlaskitAnalyticsContext();
    });
    this.contextValue = {
      getAtlaskitAnalyticsContext: this.getAtlaskitAnalyticsContext,
      getAtlaskitAnalyticsEventHandlers: this.getAnalyticsEventHandlers
    };
  }
  render() {
    const {
      children
    } = this.props;
    return /*#__PURE__*/React.createElement(AnalyticsReactContext.Provider, {
      value: this.contextValue
    }, children);
  }
}
_defineProperty(AnalyticsListener, "contextTypes", ContextTypes);
_defineProperty(AnalyticsListener, "childContextTypes", ContextTypes);
export default AnalyticsListener;