// Copyright (C) 2018 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR GPL-3.0-only

import QtQuick 2.12
import QtQuick.Window 2.3

Item {
    width: 640
    height: 450

    property alias tableView: tableView

    TableView {
        id: tableView
        width: 600
        height: 400
        clip: true
        delegate: tableViewDelegate
    }

    Component {
        id: tableViewDelegate
        Item {
            id: delegate
            implicitWidth: 100
            implicitHeight: 50
            focus: true

            property alias delegateRoot: delegate
            property alias delegateChild: textInput

            TextInput {
                id: textInput
                width: parent.width
                height: parent.height
                text: "TextInput"
            }
        }
    }

}
