/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSNumberFormatter;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSStepper;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSText;
import org.eclipse.swt.internal.cocoa.NSTextField;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTStepper;
import org.eclipse.swt.internal.cocoa.SWTTextField;
import org.eclipse.swt.internal.cocoa.SWTView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Spinner
extends Composite {
    NSTextField textView;
    NSNumberFormatter textFormatter;
    NSStepper buttonView;
    int pageIncrement = 10;
    int digits = 0;
    int textLimit = LIMIT;
    static int GAP = 0;
    public static final int LIMIT = Integer.MAX_VALUE;

    public Spinner(Composite parent, int style) {
        super(parent, Spinner.checkStyle(style));
    }

    @Override
    boolean acceptsFirstResponder(long id2, long sel) {
        if (id2 == this.view.id) {
            return false;
        }
        return super.acceptsFirstResponder(id2, sel);
    }

    @Override
    boolean accessibilityIsIgnored(long id2, long sel) {
        if (id2 == this.view.id) {
            return true;
        }
        return super.accessibilityIsIgnored(id2, sel);
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        double width = 0.0;
        double height = 0.0;
        String string = Double.toString(this.buttonView.maxValue());
        Font font = Font.cocoa_new(this.display, this.textView.font());
        NSAttributedString str = this.parent.createString(string, font, null, 0, false, true, false);
        NSSize size = str.size();
        str.release();
        width = (float)size.width;
        height = (float)size.height;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, (int)Math.ceil(width), (int)Math.ceil(height));
        if (hHint == -1) {
            size = this.buttonView.cell().cellSize();
            trim.height = Math.max(trim.height, (int)size.height);
        }
        return new Point(trim.width, trim.height);
    }

    @Override
    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        NSRect frameRect = this.textView.frame();
        NSCell cell = new NSCell(this.textView.cell());
        NSRect cellRect = cell.drawingRectForBounds(frameRect);
        width = (int)((double)width + (frameRect.width - cellRect.width));
        height = (int)((double)height + (frameRect.height - cellRect.height));
        width += GAP;
        NSSize size = this.buttonView.cell().cellSize();
        return new Rectangle(x, y, width += (int)size.width, height);
    }

    public void copy() {
        this.checkWidget();
        NSText fieldEditor = this.textView.currentEditor();
        if (fieldEditor != null) {
            fieldEditor.copy(null);
        }
    }

    @Override
    void createHandle() {
        NSView widget = (NSView)new SWTView().alloc();
        widget.init();
        NSStepper buttonWidget = (NSStepper)new SWTStepper().alloc();
        buttonWidget.init();
        buttonWidget.setValueWraps((this.style & 0x40) != 0);
        buttonWidget.setTarget(buttonWidget);
        buttonWidget.setAction(OS.sel_sendSelection);
        buttonWidget.setMaxValue(100.0);
        NSTextField textWidget = (NSTextField)new SWTTextField().alloc();
        textWidget.init();
        textWidget.setEditable((this.style & 8) == 0);
        if ((this.style & 0x800) == 0) {
            textWidget.setFocusRingType(1L);
            textWidget.setBordered(false);
        }
        this.textFormatter = (NSNumberFormatter)new NSNumberFormatter().alloc();
        this.textFormatter.init();
        widget.addSubview(textWidget);
        widget.addSubview(buttonWidget);
        this.buttonView = buttonWidget;
        this.textView = textWidget;
        this.view = widget;
        this.setSelection(0, false, true, false);
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        NSText fieldEditor = this.textView.currentEditor();
        if (fieldEditor != null) {
            fieldEditor.cut(null);
        }
    }

    @Override
    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        this.buttonView.setEnabled(enabled);
        this.textView.setEnabled(enabled);
    }

    @Override
    NSFont defaultNSFont() {
        return this.display.textFieldFont;
    }

    @Override
    void deregister() {
        super.deregister();
        if (this.textView != null) {
            this.display.removeWidget(this.textView);
            this.display.removeWidget(this.textView.cell());
        }
        if (this.buttonView != null) {
            this.display.removeWidget(this.buttonView);
            this.display.removeWidget(this.buttonView.cell());
        }
    }

    @Override
    void drawBackground(long id2, NSGraphicsContext context, NSRect rect) {
        NSText text;
        if (this.backgroundImage == null) {
            return;
        }
        if (new NSView(id2).isKindOfClass(OS.class_NSText) && !(text = new NSText(id2)).isFieldEditor()) {
            return;
        }
        this.fillBackground(this.view, context, rect, -1);
    }

    @Override
    void drawInteriorWithFrame_inView(long id2, long sel, NSRect cellFrame, long viewid) {
        Image image;
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        if ((image = control.backgroundImage) != null && !image.isDisposed()) {
            NSGraphicsContext context = NSGraphicsContext.currentContext();
            control.fillBackground(this.view, context, cellFrame, -1);
        }
        super.drawInteriorWithFrame_inView(id2, sel, cellFrame, viewid);
    }

    @Override
    Cursor findCursor() {
        Cursor cursor = super.findCursor();
        return cursor != null || (this.style & 8) != 0 ? cursor : this.display.getSystemCursor(19);
    }

    @Override
    NSView focusView() {
        return this.textView;
    }

    public int getDigits() {
        this.checkWidget();
        return this.digits;
    }

    public int getIncrement() {
        this.checkWidget();
        return (int)this.buttonView.increment();
    }

    public int getMaximum() {
        this.checkWidget();
        return (int)this.buttonView.maxValue();
    }

    public int getMinimum() {
        this.checkWidget();
        return (int)this.buttonView.minValue();
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        return (int)this.buttonView.doubleValue();
    }

    int getSelectionText(boolean[] parseFail) {
        String string = this.textView.stringValue().getString();
        try {
            int value;
            if (this.digits > 0) {
                String decimalSeparator = this.textFormatter.decimalSeparator().getString();
                int index = string.indexOf(decimalSeparator);
                if (index != -1) {
                    int startIndex = string.startsWith("+") || string.startsWith("-") ? 1 : 0;
                    String wholePart = startIndex != index ? string.substring(startIndex, index) : "0";
                    String decimalPart = string.substring(index + 1);
                    if (decimalPart.length() > this.digits) {
                        decimalPart = decimalPart.substring(0, this.digits);
                    } else {
                        int i = this.digits - decimalPart.length();
                        for (int j = 0; j < i; ++j) {
                            decimalPart = decimalPart + "0";
                        }
                    }
                    int wholeValue = Integer.parseInt(wholePart);
                    int decimalValue = Integer.parseInt(decimalPart);
                    for (int i = 0; i < this.digits; ++i) {
                        wholeValue *= 10;
                    }
                    value = wholeValue + decimalValue;
                    if (string.startsWith("-")) {
                        value = -value;
                    }
                } else {
                    value = Integer.parseInt(string);
                    for (int i = 0; i < this.digits; ++i) {
                        value *= 10;
                    }
                }
            } else {
                value = Integer.parseInt(string);
            }
            int max = this.getMaximum();
            int min = this.getMinimum();
            if (min <= value && value <= max) {
                return value;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        parseFail[0] = true;
        return -1;
    }

    public String getText() {
        this.checkWidget();
        NSString str = new NSTextFieldCell(this.textView.cell()).title();
        return str.getString();
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    @Override
    boolean handleIsAccessible(long id2) {
        return true;
    }

    @Override
    boolean isEventView(long id2) {
        return true;
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        NSText fieldEditor = this.textView.currentEditor();
        if (fieldEditor != null) {
            fieldEditor.paste(null);
        }
    }

    @Override
    void register() {
        super.register();
        if (this.textView != null) {
            this.display.addWidget(this.textView, this);
            this.display.addWidget(this.textView.cell(), this);
        }
        if (this.buttonView != null) {
            this.display.addWidget(this.buttonView, this);
            this.display.addWidget(this.buttonView.cell(), this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.textFormatter != null) {
            this.textFormatter.release();
        }
        if (this.buttonView != null) {
            this.buttonView.release();
        }
        if (this.textView != null) {
            this.textView.release();
        }
        this.textFormatter = null;
        this.buttonView = null;
        this.textView = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.textView != null) {
            this.textView.abortEditing();
        }
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    @Override
    void resized() {
        super.resized();
        this.buttonView.sizeToFit();
        NSSize textSize = this.textView.cell().cellSize();
        NSRect buttonFrame = this.buttonView.bounds();
        NSRect frame = this.view.frame();
        buttonFrame.x = frame.width - buttonFrame.width;
        buttonFrame.y = (frame.height - buttonFrame.height) / 2.0;
        int textHeight = (int)Math.min(textSize.height, frame.height);
        frame.x = 0.0;
        frame.y = (frame.height - (double)textHeight) / 2.0;
        frame.width -= buttonFrame.width + (double)GAP;
        frame.height = textHeight;
        this.textView.setFrame(frame);
        this.buttonView.setFrame(buttonFrame);
    }

    @Override
    boolean sendKeyEvent(NSEvent nsEvent, int type) {
        boolean result = super.sendKeyEvent(nsEvent, type);
        if (!result) {
            return result;
        }
        if (type != 1) {
            return result;
        }
        int delta = 0;
        short keyCode = nsEvent.keyCode();
        switch (keyCode) {
            case 36: 
            case 76: {
                this.sendSelectionEvent(14);
                return true;
            }
            case 116: {
                delta = this.pageIncrement;
                break;
            }
            case 121: {
                delta = -this.pageIncrement;
                break;
            }
            case 125: {
                delta = -this.getIncrement();
                break;
            }
            case 126: {
                delta = this.getIncrement();
            }
        }
        if (delta != 0) {
            boolean[] parseFail = new boolean[1];
            int value = this.getSelectionText(parseFail);
            if (parseFail[0]) {
                value = (int)this.buttonView.doubleValue();
            }
            int newValue = value + delta;
            int max = (int)this.buttonView.maxValue();
            int min = (int)this.buttonView.minValue();
            if ((this.style & 0x40) != 0) {
                if (newValue > max) {
                    newValue = min;
                }
                if (newValue < min) {
                    newValue = max;
                }
            }
            if (value != (newValue = Math.min(Math.max(min, newValue), max))) {
                this.setSelection(newValue, true, true, true);
            }
            result = false;
        } else {
            int pos;
            boolean[] parseFail = new boolean[1];
            int value = this.getSelectionText(parseFail);
            if (!parseFail[0] && (pos = (int)this.buttonView.doubleValue()) != value) {
                this.setSelection(value, true, false, true);
            }
        }
        return result;
    }

    @Override
    void sendSelection() {
        this.setSelection(this.getSelection(), false, true, true);
    }

    @Override
    void setBackgroundColor(NSColor nsColor) {
        this.textView.setBackgroundColor(nsColor);
    }

    @Override
    void setBackgroundImage(NSImage image) {
        NSTextField widget = this.textView;
        widget.setDrawsBackground(image == null);
        NSText editor = widget.window().fieldEditor(true, widget);
        editor.setDrawsBackground(image == null);
    }

    public void setDigits(int value) {
        this.checkWidget();
        if (value < 0) {
            this.error(5);
        }
        if (value == this.digits) {
            return;
        }
        this.digits = value;
        int pos = (int)this.buttonView.doubleValue();
        this.setSelection(pos, false, true, false);
    }

    @Override
    void setFont(NSFont font) {
        this.textView.setFont(font);
    }

    @Override
    void setForeground(double[] color) {
        NSColor nsColor = color == null ? NSColor.textColor() : NSColor.colorWithDeviceRed(color[0], color[1], color[2], 1.0);
        this.textView.setTextColor(nsColor);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.buttonView.setIncrement(value);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        int min = this.getMinimum();
        if (value < min) {
            return;
        }
        int pos = this.getSelection();
        this.buttonView.setMaxValue(value);
        if (pos > value) {
            this.setSelection(value, true, true, false);
        }
    }

    public void setMinimum(int value) {
        this.checkWidget();
        int max = this.getMaximum();
        if (value > max) {
            return;
        }
        int pos = this.getSelection();
        this.buttonView.setMinValue(value);
        if (pos < value) {
            this.setSelection(value, true, true, false);
        }
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.pageIncrement = value;
    }

    @Override
    void setOrientation() {
        int direction = (this.style & 0x4000000) != 0 ? 1 : 0;
        this.textView.setBaseWritingDirection(direction);
    }

    public void setSelection(int value) {
        this.checkWidget();
        int min = this.getMinimum();
        int max = this.getMaximum();
        value = Math.min(Math.max(min, value), max);
        this.setSelection(value, true, true, false);
    }

    void setSelection(int value, boolean setPos, boolean setText, boolean notify) {
        if (setPos) {
            this.buttonView.setDoubleValue(value);
        }
        if (setText) {
            int length;
            String string = String.valueOf(value);
            if (this.digits > 0) {
                String decimalSeparator = this.textFormatter.decimalSeparator().getString();
                int index = string.length() - this.digits;
                StringBuilder buffer = new StringBuilder();
                if (index > 0) {
                    buffer.append(string.substring(0, index));
                    buffer.append(decimalSeparator);
                    buffer.append(string.substring(index));
                } else {
                    buffer.append("0");
                    buffer.append(decimalSeparator);
                    while (index++ < 0) {
                        buffer.append("0");
                    }
                    buffer.append(string);
                }
                string = buffer.toString();
            }
            NSCell cell = new NSCell(this.textView.cell());
            if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, length = (int)cell.title().length(), null)) == null) {
                return;
            }
            this.textView.setStringValue(NSString.stringWith(string));
            NSRange selection = new NSRange();
            selection.location = 0L;
            selection.length = string.length();
            NSText fieldEditor = this.textView.currentEditor();
            if (fieldEditor != null) {
                fieldEditor.setSelectedRange(selection);
            }
            this.sendEvent(24);
        }
        if (notify) {
            this.sendSelectionEvent(13);
        }
    }

    @Override
    void setSmallSize() {
        this.textView.cell().setControlSize(1L);
        this.buttonView.cell().setControlSize(1L);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        this.textLimit = limit;
    }

    public void setValues(int selection, int minimum, int maximum, int digits, int increment, int pageIncrement) {
        this.checkWidget();
        if (maximum < minimum) {
            return;
        }
        if (digits < 0) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        selection = Math.min(Math.max(minimum, selection), maximum);
        this.pageIncrement = pageIncrement;
        this.digits = digits;
        this.buttonView.setIncrement(increment);
        this.buttonView.setMaxValue(maximum);
        this.buttonView.setMinValue(minimum);
        this.setSelection(selection, true, true, false);
    }

    @Override
    boolean shouldChangeTextInRange_replacementString(long id2, long sel, long affectedCharRange, long replacementString) {
        NSRange range = new NSRange();
        OS.memmove(range, affectedCharRange, (long)NSRange.sizeof);
        boolean result = this.callSuperBoolean(id2, sel, range, replacementString);
        if (this.hooks(25)) {
            String newText;
            String text = new NSString(replacementString).getString();
            NSEvent currentEvent = this.display.application.currentEvent();
            long type = currentEvent.type();
            if (type != 10L && type != 11L) {
                currentEvent = null;
            }
            if ((newText = this.verifyText(text, (int)range.location, (int)(range.location + range.length), currentEvent)) == null) {
                return false;
            }
            if (text != newText) {
                int length = newText.length();
                NSText fieldEditor = this.textView.currentEditor();
                if (fieldEditor != null) {
                    long charCount;
                    NSRange selectedRange = fieldEditor.selectedRange();
                    if (this.textLimit != LIMIT && (charCount = fieldEditor.string().length()) - selectedRange.length + (long)length > (long)this.textLimit) {
                        length = (int)((long)this.textLimit - charCount + selectedRange.length);
                    }
                    char[] buffer = new char[length];
                    newText.getChars(0, buffer.length, buffer, 0);
                    NSString nsstring = NSString.stringWithCharacters(buffer, buffer.length);
                    fieldEditor.replaceCharactersInRange(fieldEditor.selectedRange(), nsstring);
                    result = false;
                }
            }
            if (!result) {
                this.sendEvent(24);
            }
        }
        return result;
    }

    @Override
    void textDidChange(long id2, long sel, long aNotification) {
        int pos;
        super.textDidChange(id2, sel, aNotification);
        boolean[] parseFail = new boolean[1];
        int value = this.getSelectionText(parseFail);
        if (!parseFail[0] && value != (pos = (int)this.buttonView.doubleValue())) {
            this.setSelection(value, true, false, true);
        }
        this.postEvent(24);
    }

    @Override
    NSRange textView_willChangeSelectionFromCharacterRange_toCharacterRange(long id2, long sel, long aTextView, long oldSelectedCharRange, long newSelectedCharRange) {
        NSRange result = new NSRange();
        OS.memmove(result, newSelectedCharRange, (long)NSRange.sizeof);
        return result;
    }

    @Override
    void textDidEndEditing(long id2, long sel, long aNotification) {
        boolean[] parseFail = new boolean[1];
        int value = this.getSelectionText(parseFail);
        if (parseFail[0]) {
            value = (int)this.buttonView.doubleValue();
            this.setSelection(value, false, true, false);
        }
        super.textDidEndEditing(id2, sel, aNotification);
    }

    @Override
    void updateCursorRects(boolean enabled) {
        super.updateCursorRects(enabled);
        this.updateCursorRects(enabled, this.textView);
        this.updateCursorRects(enabled, this.buttonView);
    }

    String verifyText(String string, int start, int end, NSEvent keyEvent) {
        Event event = new Event();
        if (keyEvent != null) {
            this.setKeyState(event, 3, keyEvent);
        }
        event.text = string;
        event.start = start;
        event.end = end;
        int index = 0;
        if (this.digits > 0) {
            String decimalSeparator = ".";
            index = string.indexOf(decimalSeparator);
            if (index != -1) {
                string = string.substring(0, index) + string.substring(index + 1);
            }
            index = 0;
        }
        while (index < string.length() && Character.isDigit(string.charAt(index))) {
            ++index;
        }
        event.doit = index == string.length();
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

