module Tests

open System.Threading.Tasks
open Expecto

[<Tests>]
let tests =
  testList "samples" [
    testCase "universe exists (╭ರᴥ•́)" <| fun _ ->
      let subject = true
      Expect.isTrue subject "I compute, therefore I am."

    testCase "when true is not (should fail)" <| fun _ ->
      let subject = false
      Expect.isTrue subject "I should fail because the subject is false"

    testCase "I'm skipped (should skip)" <| fun _ ->
      Tests.skiptest "Yup, waiting for a sunny day..."

    testCase "I'm always fail (should fail)" <| fun _ ->
      Tests.failtest "This was expected..."

    testCase "contains things" <| fun _ ->
      Expect.containsAll [| 2; 3; 4 |] [| 2; 4 |]
                         "This is the case; {2,3,4} contains {2,4}"

    testCase "contains things (should fail)" <| fun _ ->
      Expect.containsAll [| 2; 3; 4 |] [| 2; 4; 1 |]
                         "Expecting we have one (1) in there"

    testCase "Sometimes I want to ༼ノಠل͟ಠ༽ノ ︵ ┻━┻" <| fun _ ->
      Expect.equal "abcdëf" "abcdef" "These should equal"

    test "I am (should fail)" {
      "╰〳 ಠ 益 ಠೃ 〵╯" |> Expect.equal true false
    }

    testTask "simple task" {
      do! Task.Delay 1
      Expect.equal 1 1 "1=1"
    }

    testAsync "simple async" {
      Expect.equal 4 (2+2) "2+2"
    }

    testCaseAsync "async test case backpipe" <| async {
        Expect.equal 4 (2+2) "2+2"
      }

    testCaseAsync "async test case paren"(async {
        Expect.equal 4 (2+2) "2+2"
      })

    testTheory "odd numbers" [1; 3; 5] ( fun x ->
      Expect.isTrue (x % 2 = 1) "should be odd" )

    testTheoryAsync "async even numbers" [2; 4; 6] ( fun x -> async {
      Expect.isTrue (x % 2 = 0) "should be even"
    })

    testTheoryTask "task odd numbers" [1; 3; 5;] <| fun x -> task {
      Expect.isTrue (x % 2 = 1) "should be odd"
    }
  ]
