// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/integrations/v1alpha/log_entries.proto

package integrations

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// PostMethod Enum
type ExecutionInfo_PostMethod int32

const (
	// Default value.
	ExecutionInfo_POST_METHOD_UNSPECIFIED ExecutionInfo_PostMethod = 0
	// Sync post.
	ExecutionInfo_POST ExecutionInfo_PostMethod = 1
	// Async post with schedule time.
	ExecutionInfo_SCHEDULE ExecutionInfo_PostMethod = 2
)

// Enum value maps for ExecutionInfo_PostMethod.
var (
	ExecutionInfo_PostMethod_name = map[int32]string{
		0: "POST_METHOD_UNSPECIFIED",
		1: "POST",
		2: "SCHEDULE",
	}
	ExecutionInfo_PostMethod_value = map[string]int32{
		"POST_METHOD_UNSPECIFIED": 0,
		"POST":                    1,
		"SCHEDULE":                2,
	}
)

func (x ExecutionInfo_PostMethod) Enum() *ExecutionInfo_PostMethod {
	p := new(ExecutionInfo_PostMethod)
	*p = x
	return p
}

func (x ExecutionInfo_PostMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecutionInfo_PostMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_integrations_v1alpha_log_entries_proto_enumTypes[0].Descriptor()
}

func (ExecutionInfo_PostMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_integrations_v1alpha_log_entries_proto_enumTypes[0]
}

func (x ExecutionInfo_PostMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecutionInfo_PostMethod.Descriptor instead.
func (ExecutionInfo_PostMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_integrations_v1alpha_log_entries_proto_rawDescGZIP(), []int{0, 0}
}

// Enum EventExecutionState.
type EventExecutionDetails_EventExecutionState int32

const (
	// Default value.
	EventExecutionDetails_EVENT_EXECUTION_STATE_UNSPECIFIED EventExecutionDetails_EventExecutionState = 0
	// Event is received and waiting for the execution. This happens when
	// firing the event via "postToQueue" or "schedule".
	EventExecutionDetails_ON_HOLD EventExecutionDetails_EventExecutionState = 1
	// Event is under processing.
	EventExecutionDetails_IN_PROCESS EventExecutionDetails_EventExecutionState = 2
	// Event execution successfully finished. There's no more change after
	// this state.
	EventExecutionDetails_SUCCEEDED EventExecutionDetails_EventExecutionState = 3
	// Event execution failed. There's no more change after this state.
	EventExecutionDetails_FAILED EventExecutionDetails_EventExecutionState = 4
	// Event execution canceled by user. There's no more change after this
	// state.
	EventExecutionDetails_CANCELLED EventExecutionDetails_EventExecutionState = 5
	// Event execution failed and waiting for retry.
	EventExecutionDetails_RETRY_ON_HOLD EventExecutionDetails_EventExecutionState = 6
	// Event execution suspended and waiting for manual intervention.
	EventExecutionDetails_SUSPENDED EventExecutionDetails_EventExecutionState = 7
)

// Enum value maps for EventExecutionDetails_EventExecutionState.
var (
	EventExecutionDetails_EventExecutionState_name = map[int32]string{
		0: "EVENT_EXECUTION_STATE_UNSPECIFIED",
		1: "ON_HOLD",
		2: "IN_PROCESS",
		3: "SUCCEEDED",
		4: "FAILED",
		5: "CANCELLED",
		6: "RETRY_ON_HOLD",
		7: "SUSPENDED",
	}
	EventExecutionDetails_EventExecutionState_value = map[string]int32{
		"EVENT_EXECUTION_STATE_UNSPECIFIED": 0,
		"ON_HOLD":                           1,
		"IN_PROCESS":                        2,
		"SUCCEEDED":                         3,
		"FAILED":                            4,
		"CANCELLED":                         5,
		"RETRY_ON_HOLD":                     6,
		"SUSPENDED":                         7,
	}
)

func (x EventExecutionDetails_EventExecutionState) Enum() *EventExecutionDetails_EventExecutionState {
	p := new(EventExecutionDetails_EventExecutionState)
	*p = x
	return p
}

func (x EventExecutionDetails_EventExecutionState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EventExecutionDetails_EventExecutionState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_integrations_v1alpha_log_entries_proto_enumTypes[1].Descriptor()
}

func (EventExecutionDetails_EventExecutionState) Type() protoreflect.EnumType {
	return &file_google_cloud_integrations_v1alpha_log_entries_proto_enumTypes[1]
}

func (x EventExecutionDetails_EventExecutionState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use EventExecutionDetails_EventExecutionState.Descriptor instead.
func (EventExecutionDetails_EventExecutionState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_integrations_v1alpha_log_entries_proto_rawDescGZIP(), []int{1, 0}
}

// Enum TaskExecutionState.
type TaskExecutionDetails_TaskExecutionState int32

const (
	// Default value.
	TaskExecutionDetails_TASK_EXECUTION_STATE_UNSPECIFIED TaskExecutionDetails_TaskExecutionState = 0
	// Task is waiting for its precondition tasks to finish to start the
	// execution.
	TaskExecutionDetails_PENDING_EXECUTION TaskExecutionDetails_TaskExecutionState = 1
	// Task is under processing.
	TaskExecutionDetails_IN_PROCESS TaskExecutionDetails_TaskExecutionState = 2
	// Task execution successfully finished. There's no more change after
	// this state.
	TaskExecutionDetails_SUCCEED TaskExecutionDetails_TaskExecutionState = 3
	// Task execution failed. There's no more change after this state.
	TaskExecutionDetails_FAILED TaskExecutionDetails_TaskExecutionState = 4
	// Task execution failed and cause the whole event execution to fail
	// immediately. There's no more change after this state.
	TaskExecutionDetails_FATAL TaskExecutionDetails_TaskExecutionState = 5
	// Task execution failed and waiting for retry.
	TaskExecutionDetails_RETRY_ON_HOLD TaskExecutionDetails_TaskExecutionState = 6
	// Task execution skipped. This happens when its precondition wasn't met,
	// or the event execution been canceled before reach to the task.
	// There's no more changes after this state.
	TaskExecutionDetails_SKIPPED TaskExecutionDetails_TaskExecutionState = 7
	// Task execution canceled when in progress. This happens when event
	// execution been canceled or any other task fall in fatal state.
	TaskExecutionDetails_CANCELLED TaskExecutionDetails_TaskExecutionState = 8
	// Task is waiting for its dependency tasks' rollback to finish to start
	// its rollback.
	TaskExecutionDetails_PENDING_ROLLBACK TaskExecutionDetails_TaskExecutionState = 9
	// Task is rolling back.
	TaskExecutionDetails_ROLLBACK_IN_PROCESS TaskExecutionDetails_TaskExecutionState = 10
	// Task is rolled back. This is the state we will set regardless of
	// rollback succeeding or failing.
	TaskExecutionDetails_ROLLEDBACK TaskExecutionDetails_TaskExecutionState = 11
	// Task is a SuspensionTask which has executed once, creating a pending
	// suspension.
	TaskExecutionDetails_SUSPENDED TaskExecutionDetails_TaskExecutionState = 12
)

// Enum value maps for TaskExecutionDetails_TaskExecutionState.
var (
	TaskExecutionDetails_TaskExecutionState_name = map[int32]string{
		0:  "TASK_EXECUTION_STATE_UNSPECIFIED",
		1:  "PENDING_EXECUTION",
		2:  "IN_PROCESS",
		3:  "SUCCEED",
		4:  "FAILED",
		5:  "FATAL",
		6:  "RETRY_ON_HOLD",
		7:  "SKIPPED",
		8:  "CANCELLED",
		9:  "PENDING_ROLLBACK",
		10: "ROLLBACK_IN_PROCESS",
		11: "ROLLEDBACK",
		12: "SUSPENDED",
	}
	TaskExecutionDetails_TaskExecutionState_value = map[string]int32{
		"TASK_EXECUTION_STATE_UNSPECIFIED": 0,
		"PENDING_EXECUTION":                1,
		"IN_PROCESS":                       2,
		"SUCCEED":                          3,
		"FAILED":                           4,
		"FATAL":                            5,
		"RETRY_ON_HOLD":                    6,
		"SKIPPED":                          7,
		"CANCELLED":                        8,
		"PENDING_ROLLBACK":                 9,
		"ROLLBACK_IN_PROCESS":              10,
		"ROLLEDBACK":                       11,
		"SUSPENDED":                        12,
	}
)

func (x TaskExecutionDetails_TaskExecutionState) Enum() *TaskExecutionDetails_TaskExecutionState {
	p := new(TaskExecutionDetails_TaskExecutionState)
	*p = x
	return p
}

func (x TaskExecutionDetails_TaskExecutionState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TaskExecutionDetails_TaskExecutionState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_integrations_v1alpha_log_entries_proto_enumTypes[2].Descriptor()
}

func (TaskExecutionDetails_TaskExecutionState) Type() protoreflect.EnumType {
	return &file_google_cloud_integrations_v1alpha_log_entries_proto_enumTypes[2]
}

func (x TaskExecutionDetails_TaskExecutionState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TaskExecutionDetails_TaskExecutionState.Descriptor instead.
func (TaskExecutionDetails_TaskExecutionState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_integrations_v1alpha_log_entries_proto_rawDescGZIP(), []int{3, 0}
}

// Log entry to log execution info for the monitored resource
// `integrations.googleapis.com/IntegrationVersion`.
type ExecutionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Auto-generated primary key.
	EventExecutionInfoId string `protobuf:"bytes,1,opt,name=event_execution_info_id,json=eventExecutionInfoId,proto3" json:"event_execution_info_id,omitempty"`
	// Name of the integration.
	Integration string `protobuf:"bytes,2,opt,name=integration,proto3" json:"integration,omitempty"`
	// Pointer to the active version it is executing.
	IntegrationVersion string `protobuf:"bytes,3,opt,name=integration_version,json=integrationVersion,proto3" json:"integration_version,omitempty"`
	// The event data user sends as request.
	ProjectId string `protobuf:"bytes,4,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The trigger id of the integration trigger config. If both trigger_id
	// and client_id is present, the integration is executed from the start tasks
	// provided by the matching trigger config otherwise it is executed from the
	// default start tasks.
	TriggerId string `protobuf:"bytes,5,opt,name=trigger_id,json=triggerId,proto3" json:"trigger_id,omitempty"`
	// Event parameters come in as part of the request.
	RequestParams map[string]*EventParameter `protobuf:"bytes,6,rep,name=request_params,json=requestParams,proto3" json:"request_params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Event parameters come out as part of the response.
	ResponseParams map[string]*EventParameter `protobuf:"bytes,7,rep,name=response_params,json=responseParams,proto3" json:"response_params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The ways user posts this event.
	PostMethod ExecutionInfo_PostMethod `protobuf:"varint,8,opt,name=post_method,json=postMethod,proto3,enum=google.cloud.integrations.v1alpha.ExecutionInfo_PostMethod" json:"post_method,omitempty"`
	// The execution info about this event.
	EventExecutionDetails *EventExecutionDetails `protobuf:"bytes,9,opt,name=event_execution_details,json=eventExecutionDetails,proto3" json:"event_execution_details,omitempty"`
	// Errors, warnings, and informationals associated with the workflow/task.
	// The order in which the errors were added by the workflow/task is
	// maintained.
	Errors []*ErrorDetail `protobuf:"bytes,10,rep,name=errors,proto3" json:"errors,omitempty"`
	// Which Google product the execution_info belongs to. If not set, the
	// execution_info belongs to Integration Platform by default.
	Product Product `protobuf:"varint,11,opt,name=product,proto3,enum=google.cloud.integrations.v1alpha.Product" json:"product,omitempty"`
	// This is used to de-dup incoming request.
	RequestId string `protobuf:"bytes,12,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The configuration details for a task.
	TaskConfigs []*TaskConfig `protobuf:"bytes,13,rep,name=task_configs,json=taskConfigs,proto3" json:"task_configs,omitempty"`
}

func (x *ExecutionInfo) Reset() {
	*x = ExecutionInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionInfo) ProtoMessage() {}

func (x *ExecutionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionInfo.ProtoReflect.Descriptor instead.
func (*ExecutionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_integrations_v1alpha_log_entries_proto_rawDescGZIP(), []int{0}
}

func (x *ExecutionInfo) GetEventExecutionInfoId() string {
	if x != nil {
		return x.EventExecutionInfoId
	}
	return ""
}

func (x *ExecutionInfo) GetIntegration() string {
	if x != nil {
		return x.Integration
	}
	return ""
}

func (x *ExecutionInfo) GetIntegrationVersion() string {
	if x != nil {
		return x.IntegrationVersion
	}
	return ""
}

func (x *ExecutionInfo) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ExecutionInfo) GetTriggerId() string {
	if x != nil {
		return x.TriggerId
	}
	return ""
}

func (x *ExecutionInfo) GetRequestParams() map[string]*EventParameter {
	if x != nil {
		return x.RequestParams
	}
	return nil
}

func (x *ExecutionInfo) GetResponseParams() map[string]*EventParameter {
	if x != nil {
		return x.ResponseParams
	}
	return nil
}

func (x *ExecutionInfo) GetPostMethod() ExecutionInfo_PostMethod {
	if x != nil {
		return x.PostMethod
	}
	return ExecutionInfo_POST_METHOD_UNSPECIFIED
}

func (x *ExecutionInfo) GetEventExecutionDetails() *EventExecutionDetails {
	if x != nil {
		return x.EventExecutionDetails
	}
	return nil
}

func (x *ExecutionInfo) GetErrors() []*ErrorDetail {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *ExecutionInfo) GetProduct() Product {
	if x != nil {
		return x.Product
	}
	return Product_PRODUCT_UNSPECIFIED
}

func (x *ExecutionInfo) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *ExecutionInfo) GetTaskConfigs() []*TaskConfig {
	if x != nil {
		return x.TaskConfigs
	}
	return nil
}

// Contains the details of the execution info of this event: this includes
// the tasks execution details plus the event execution statistics.
type EventExecutionDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The execution state of this event.
	EventExecutionState EventExecutionDetails_EventExecutionState `protobuf:"varint,1,opt,name=event_execution_state,json=eventExecutionState,proto3,enum=google.cloud.integrations.v1alpha.EventExecutionDetails_EventExecutionState" json:"event_execution_state,omitempty"`
	// After snapshot migration, this field will no longer be populated, but old
	// execution snapshots will still be accessible.
	EventExecutionSnapshot []*EventExecutionSnapshot `protobuf:"bytes,2,rep,name=event_execution_snapshot,json=eventExecutionSnapshot,proto3" json:"event_execution_snapshot,omitempty"`
	// Status for the current event execution attempt.
	EventAttemptStats []*AttemptStats `protobuf:"bytes,3,rep,name=event_attempt_stats,json=eventAttemptStats,proto3" json:"event_attempt_stats,omitempty"`
	// Next scheduled execution time in case the execution status was
	// RETRY_ON_HOLD.
	NextExecutionTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=next_execution_time,json=nextExecutionTime,proto3" json:"next_execution_time,omitempty"`
	// Indicates the number of times the execution has restarted from the
	// beginning.
	EventRetriesCount int32 `protobuf:"varint,5,opt,name=event_retries_count,json=eventRetriesCount,proto3" json:"event_retries_count,omitempty"`
}

func (x *EventExecutionDetails) Reset() {
	*x = EventExecutionDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventExecutionDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventExecutionDetails) ProtoMessage() {}

func (x *EventExecutionDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventExecutionDetails.ProtoReflect.Descriptor instead.
func (*EventExecutionDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_integrations_v1alpha_log_entries_proto_rawDescGZIP(), []int{1}
}

func (x *EventExecutionDetails) GetEventExecutionState() EventExecutionDetails_EventExecutionState {
	if x != nil {
		return x.EventExecutionState
	}
	return EventExecutionDetails_EVENT_EXECUTION_STATE_UNSPECIFIED
}

func (x *EventExecutionDetails) GetEventExecutionSnapshot() []*EventExecutionSnapshot {
	if x != nil {
		return x.EventExecutionSnapshot
	}
	return nil
}

func (x *EventExecutionDetails) GetEventAttemptStats() []*AttemptStats {
	if x != nil {
		return x.EventAttemptStats
	}
	return nil
}

func (x *EventExecutionDetails) GetNextExecutionTime() *timestamppb.Timestamp {
	if x != nil {
		return x.NextExecutionTime
	}
	return nil
}

func (x *EventExecutionDetails) GetEventRetriesCount() int32 {
	if x != nil {
		return x.EventRetriesCount
	}
	return 0
}

// Contains the snapshot of the event execution for a given checkpoint.
type EventExecutionSnapshot struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates "right after which checkpoint task's execution" this snapshot
	// is taken.
	CheckpointTaskNumber string `protobuf:"bytes,1,opt,name=checkpoint_task_number,json=checkpointTaskNumber,proto3" json:"checkpoint_task_number,omitempty"`
	// Indicates when this snapshot is taken.
	SnapshotTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=snapshot_time,json=snapshotTime,proto3" json:"snapshot_time,omitempty"`
	// Snapshot metadata.
	EventExecutionSnapshotMetadata *EventExecutionSnapshot_EventExecutionSnapshotMetadata `protobuf:"bytes,3,opt,name=event_execution_snapshot_metadata,json=eventExecutionSnapshotMetadata,proto3" json:"event_execution_snapshot_metadata,omitempty"`
	// All of the task execution details at the given point of time.
	TaskExecutionDetails []*TaskExecutionDetails `protobuf:"bytes,4,rep,name=task_execution_details,json=taskExecutionDetails,proto3" json:"task_execution_details,omitempty"`
	// All of the computed conditions that been calculated.
	ConditionResults []*ConditionResult `protobuf:"bytes,5,rep,name=condition_results,json=conditionResults,proto3" json:"condition_results,omitempty"`
	// The parameters in Event object.
	EventParams map[string]*EventParameter `protobuf:"bytes,6,rep,name=event_params,json=eventParams,proto3" json:"event_params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The parameters in Event object that differs from last snapshot.
	DiffParams map[string]*EventParameter `protobuf:"bytes,7,rep,name=diff_params,json=diffParams,proto3" json:"diff_params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *EventExecutionSnapshot) Reset() {
	*x = EventExecutionSnapshot{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventExecutionSnapshot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventExecutionSnapshot) ProtoMessage() {}

func (x *EventExecutionSnapshot) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventExecutionSnapshot.ProtoReflect.Descriptor instead.
func (*EventExecutionSnapshot) Descriptor() ([]byte, []int) {
	return file_google_cloud_integrations_v1alpha_log_entries_proto_rawDescGZIP(), []int{2}
}

func (x *EventExecutionSnapshot) GetCheckpointTaskNumber() string {
	if x != nil {
		return x.CheckpointTaskNumber
	}
	return ""
}

func (x *EventExecutionSnapshot) GetSnapshotTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SnapshotTime
	}
	return nil
}

func (x *EventExecutionSnapshot) GetEventExecutionSnapshotMetadata() *EventExecutionSnapshot_EventExecutionSnapshotMetadata {
	if x != nil {
		return x.EventExecutionSnapshotMetadata
	}
	return nil
}

func (x *EventExecutionSnapshot) GetTaskExecutionDetails() []*TaskExecutionDetails {
	if x != nil {
		return x.TaskExecutionDetails
	}
	return nil
}

func (x *EventExecutionSnapshot) GetConditionResults() []*ConditionResult {
	if x != nil {
		return x.ConditionResults
	}
	return nil
}

func (x *EventExecutionSnapshot) GetEventParams() map[string]*EventParameter {
	if x != nil {
		return x.EventParams
	}
	return nil
}

func (x *EventExecutionSnapshot) GetDiffParams() map[string]*EventParameter {
	if x != nil {
		return x.DiffParams
	}
	return nil
}

// Contains the details of the execution of this task.
type TaskExecutionDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Pointer to the task config it used for execution.
	TaskNumber string `protobuf:"bytes,1,opt,name=task_number,json=taskNumber,proto3" json:"task_number,omitempty"`
	// The execution state of this task.
	TaskExecutionState TaskExecutionDetails_TaskExecutionState `protobuf:"varint,2,opt,name=task_execution_state,json=taskExecutionState,proto3,enum=google.cloud.integrations.v1alpha.TaskExecutionDetails_TaskExecutionState" json:"task_execution_state,omitempty"`
	// Status for the current task execution attempt.
	TaskAttemptStats []*AttemptStats `protobuf:"bytes,3,rep,name=task_attempt_stats,json=taskAttemptStats,proto3" json:"task_attempt_stats,omitempty"`
}

func (x *TaskExecutionDetails) Reset() {
	*x = TaskExecutionDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TaskExecutionDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TaskExecutionDetails) ProtoMessage() {}

func (x *TaskExecutionDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TaskExecutionDetails.ProtoReflect.Descriptor instead.
func (*TaskExecutionDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_integrations_v1alpha_log_entries_proto_rawDescGZIP(), []int{3}
}

func (x *TaskExecutionDetails) GetTaskNumber() string {
	if x != nil {
		return x.TaskNumber
	}
	return ""
}

func (x *TaskExecutionDetails) GetTaskExecutionState() TaskExecutionDetails_TaskExecutionState {
	if x != nil {
		return x.TaskExecutionState
	}
	return TaskExecutionDetails_TASK_EXECUTION_STATE_UNSPECIFIED
}

func (x *TaskExecutionDetails) GetTaskAttemptStats() []*AttemptStats {
	if x != nil {
		return x.TaskAttemptStats
	}
	return nil
}

// Status for the execution attempt.
type AttemptStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The start time of the event execution for current attempt. This could be
	// in the future if it's been scheduled.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The end time of the event execution for current attempt.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *AttemptStats) Reset() {
	*x = AttemptStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttemptStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttemptStats) ProtoMessage() {}

func (x *AttemptStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttemptStats.ProtoReflect.Descriptor instead.
func (*AttemptStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_integrations_v1alpha_log_entries_proto_rawDescGZIP(), []int{4}
}

func (x *AttemptStats) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *AttemptStats) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// An error, warning, or information message associated with an integration.
type ErrorDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The full text of the error message, including any parameters that were
	// thrown along with the exception.
	ErrorMessage string `protobuf:"bytes,1,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// The task try-number, in which, the error occurred.  If zero, the error
	// happened at the event level.
	TaskNumber int32 `protobuf:"varint,2,opt,name=task_number,json=taskNumber,proto3" json:"task_number,omitempty"`
}

func (x *ErrorDetail) Reset() {
	*x = ErrorDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ErrorDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ErrorDetail) ProtoMessage() {}

func (x *ErrorDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ErrorDetail.ProtoReflect.Descriptor instead.
func (*ErrorDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_integrations_v1alpha_log_entries_proto_rawDescGZIP(), []int{5}
}

func (x *ErrorDetail) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (x *ErrorDetail) GetTaskNumber() int32 {
	if x != nil {
		return x.TaskNumber
	}
	return 0
}

// Contains the combined condition calculation results.
type ConditionResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// the current task number.
	CurrentTaskNumber string `protobuf:"bytes,1,opt,name=current_task_number,json=currentTaskNumber,proto3" json:"current_task_number,omitempty"`
	// the next task number.
	NextTaskNumber string `protobuf:"bytes,2,opt,name=next_task_number,json=nextTaskNumber,proto3" json:"next_task_number,omitempty"`
	// the result comes out after evaluate the combined condition. True if there's
	// no combined condition specified.
	Result bool `protobuf:"varint,3,opt,name=result,proto3" json:"result,omitempty"`
}

func (x *ConditionResult) Reset() {
	*x = ConditionResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConditionResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConditionResult) ProtoMessage() {}

func (x *ConditionResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConditionResult.ProtoReflect.Descriptor instead.
func (*ConditionResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_integrations_v1alpha_log_entries_proto_rawDescGZIP(), []int{6}
}

func (x *ConditionResult) GetCurrentTaskNumber() string {
	if x != nil {
		return x.CurrentTaskNumber
	}
	return ""
}

func (x *ConditionResult) GetNextTaskNumber() string {
	if x != nil {
		return x.NextTaskNumber
	}
	return ""
}

func (x *ConditionResult) GetResult() bool {
	if x != nil {
		return x.Result
	}
	return false
}

// Metadata for the event/task retry.
type EventExecutionSnapshot_EventExecutionSnapshotMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The task number associated with this snapshot. Could be empty.
	TaskNumber string `protobuf:"bytes,1,opt,name=task_number,json=taskNumber,proto3" json:"task_number,omitempty"`
	// the task name associated with this snapshot. Could be empty.
	Task string `protobuf:"bytes,2,opt,name=task,proto3" json:"task,omitempty"`
	// the event attempt number this snapshot belongs to.
	EventAttemptNum int32 `protobuf:"varint,3,opt,name=event_attempt_num,json=eventAttemptNum,proto3" json:"event_attempt_num,omitempty"`
	// the task attempt number this snapshot belongs to. Could be empty.
	TaskAttemptNum int32 `protobuf:"varint,4,opt,name=task_attempt_num,json=taskAttemptNum,proto3" json:"task_attempt_num,omitempty"`
}

func (x *EventExecutionSnapshot_EventExecutionSnapshotMetadata) Reset() {
	*x = EventExecutionSnapshot_EventExecutionSnapshotMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventExecutionSnapshot_EventExecutionSnapshotMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventExecutionSnapshot_EventExecutionSnapshotMetadata) ProtoMessage() {}

func (x *EventExecutionSnapshot_EventExecutionSnapshotMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventExecutionSnapshot_EventExecutionSnapshotMetadata.ProtoReflect.Descriptor instead.
func (*EventExecutionSnapshot_EventExecutionSnapshotMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_integrations_v1alpha_log_entries_proto_rawDescGZIP(), []int{2, 0}
}

func (x *EventExecutionSnapshot_EventExecutionSnapshotMetadata) GetTaskNumber() string {
	if x != nil {
		return x.TaskNumber
	}
	return ""
}

func (x *EventExecutionSnapshot_EventExecutionSnapshotMetadata) GetTask() string {
	if x != nil {
		return x.Task
	}
	return ""
}

func (x *EventExecutionSnapshot_EventExecutionSnapshotMetadata) GetEventAttemptNum() int32 {
	if x != nil {
		return x.EventAttemptNum
	}
	return 0
}

func (x *EventExecutionSnapshot_EventExecutionSnapshotMetadata) GetTaskAttemptNum() int32 {
	if x != nil {
		return x.TaskAttemptNum
	}
	return 0
}

var File_google_cloud_integrations_v1alpha_log_entries_proto protoreflect.FileDescriptor

var file_google_cloud_integrations_v1alpha_log_entries_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x69,
	0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2f, 0x6c, 0x6f, 0x67, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xaf, 0x09, 0x0a, 0x0d, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x35, 0x0a, 0x17, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x49,
	0x64, 0x12, 0x20, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x2f, 0x0a, 0x13, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x12, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f, 0x69,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x6a, 0x0a, 0x0e, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x0d, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x6d,
	0x0a, 0x0f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x72,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x5c, 0x0a,
	0x0b, 0x70, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x50, 0x6f, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x52,
	0x0a, 0x70, 0x6f, 0x73, 0x74, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x70, 0x0a, 0x17, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x15, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x46, 0x0a,
	0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x52, 0x06, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x44, 0x0a, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x50, 0x72, 0x6f, 0x64, 0x75,
	0x63, 0x74, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x0c, 0x74, 0x61,
	0x73, 0x6b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x0b, 0x74, 0x61, 0x73, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x1a, 0x73, 0x0a, 0x12,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x47, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x1a, 0x74, 0x0a, 0x13, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x47, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x41, 0x0a, 0x0a, 0x50, 0x6f, 0x73, 0x74, 0x4d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x4f, 0x53, 0x54, 0x5f, 0x4d, 0x45,
	0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x50, 0x4f, 0x53, 0x54, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08,
	0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x10, 0x02, 0x22, 0x94, 0x05, 0x0a, 0x15, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x80, 0x01, 0x0a, 0x15, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x13, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x73, 0x0a, 0x18, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x52, 0x16, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x5f, 0x0a, 0x13,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x74,
	0x74, 0x65, 0x6d, 0x70, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x11, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x4a, 0x0a,
	0x13, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x11, 0x6e, 0x65, 0x78, 0x74, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x74,
	0x72, 0x69, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0xa5, 0x01, 0x0a, 0x13, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x25, 0x0a, 0x21, 0x45, 0x56, 0x45, 0x4e, 0x54, 0x5f, 0x45, 0x58, 0x45, 0x43, 0x55,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x4f, 0x4e, 0x5f, 0x48,
	0x4f, 0x4c, 0x44, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x43,
	0x45, 0x53, 0x53, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44,
	0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04,
	0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12,
	0x11, 0x0a, 0x0d, 0x52, 0x45, 0x54, 0x52, 0x59, 0x5f, 0x4f, 0x4e, 0x5f, 0x48, 0x4f, 0x4c, 0x44,
	0x10, 0x06, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10,
	0x07, 0x22, 0xf3, 0x08, 0x0a, 0x16, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x34, 0x0a, 0x16,
	0x63, 0x68, 0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f,
	0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x63, 0x68,
	0x65, 0x63, 0x6b, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x4e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x12, 0x3f, 0x0a, 0x0d, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0xa3, 0x01, 0x0a, 0x21, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x65, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69,
	0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x1e, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x6d, 0x0a, 0x16, 0x74, 0x61, 0x73,
	0x6b, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x54, 0x61,
	0x73, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x52, 0x14, 0x74, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x5f, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x64,
	0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x10, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x6d, 0x0a, 0x0c, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69,
	0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x12, 0x6a, 0x0a, 0x0b, 0x64, 0x69, 0x66, 0x66,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x49, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x2e, 0x44, 0x69, 0x66, 0x66, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x64, 0x69, 0x66, 0x66, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x1a, 0xab, 0x01, 0x0a, 0x1e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x61, 0x73, 0x6b, 0x5f,
	0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x61,
	0x73, 0x6b, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x61, 0x73, 0x6b,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x73, 0x6b, 0x12, 0x2a, 0x0a, 0x11,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x5f, 0x6e, 0x75,
	0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x41, 0x74,
	0x74, 0x65, 0x6d, 0x70, 0x74, 0x4e, 0x75, 0x6d, 0x12, 0x28, 0x0a, 0x10, 0x74, 0x61, 0x73, 0x6b,
	0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x0e, 0x74, 0x61, 0x73, 0x6b, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x4e,
	0x75, 0x6d, 0x1a, 0x71, 0x0a, 0x10, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x47, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x70, 0x0a, 0x0f, 0x44, 0x69, 0x66, 0x66, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x47, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x99, 0x04, 0x0a, 0x14, 0x54, 0x61, 0x73, 0x6b,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x61, 0x73, 0x6b, 0x4e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x12, 0x7c, 0x0a, 0x14, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69,
	0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x65,
	0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x12, 0x74, 0x61, 0x73,
	0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x5d, 0x0a, 0x12, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x10, 0x74, 0x61,
	0x73, 0x6b, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x22, 0x82,
	0x02, 0x0a, 0x12, 0x54, 0x61, 0x73, 0x6b, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x24, 0x0a, 0x20, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x45, 0x58,
	0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x50,
	0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x45, 0x58, 0x45, 0x43, 0x55, 0x54, 0x49, 0x4f, 0x4e,
	0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45, 0x53, 0x53,
	0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x10, 0x03, 0x12,
	0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x46,
	0x41, 0x54, 0x41, 0x4c, 0x10, 0x05, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x45, 0x54, 0x52, 0x59, 0x5f,
	0x4f, 0x4e, 0x5f, 0x48, 0x4f, 0x4c, 0x44, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x4b, 0x49,
	0x50, 0x50, 0x45, 0x44, 0x10, 0x07, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c,
	0x4c, 0x45, 0x44, 0x10, 0x08, 0x12, 0x14, 0x0a, 0x10, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47,
	0x5f, 0x52, 0x4f, 0x4c, 0x4c, 0x42, 0x41, 0x43, 0x4b, 0x10, 0x09, 0x12, 0x17, 0x0a, 0x13, 0x52,
	0x4f, 0x4c, 0x4c, 0x42, 0x41, 0x43, 0x4b, 0x5f, 0x49, 0x4e, 0x5f, 0x50, 0x52, 0x4f, 0x43, 0x45,
	0x53, 0x53, 0x10, 0x0a, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x4f, 0x4c, 0x4c, 0x45, 0x44, 0x42, 0x41,
	0x43, 0x4b, 0x10, 0x0b, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45,
	0x44, 0x10, 0x0c, 0x22, 0x80, 0x01, 0x0a, 0x0c, 0x41, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x53, 0x0a, 0x0b, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x61,
	0x73, 0x6b, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x0a, 0x74, 0x61, 0x73, 0x6b, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x22, 0x83, 0x01, 0x0a, 0x0f,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x2e, 0x0a, 0x13, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f,
	0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x63, 0x75,
	0x72, 0x72, 0x65, 0x6e, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12,
	0x28, 0x0a, 0x10, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x6e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6e, 0x65, 0x78, 0x74, 0x54,
	0x61, 0x73, 0x6b, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x42, 0x89, 0x01, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x42, 0x0f, 0x4c, 0x6f, 0x67,
	0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4d,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x69, 0x6e, 0x74, 0x65,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x3b, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_integrations_v1alpha_log_entries_proto_rawDescOnce sync.Once
	file_google_cloud_integrations_v1alpha_log_entries_proto_rawDescData = file_google_cloud_integrations_v1alpha_log_entries_proto_rawDesc
)

func file_google_cloud_integrations_v1alpha_log_entries_proto_rawDescGZIP() []byte {
	file_google_cloud_integrations_v1alpha_log_entries_proto_rawDescOnce.Do(func() {
		file_google_cloud_integrations_v1alpha_log_entries_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_integrations_v1alpha_log_entries_proto_rawDescData)
	})
	return file_google_cloud_integrations_v1alpha_log_entries_proto_rawDescData
}

var file_google_cloud_integrations_v1alpha_log_entries_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_integrations_v1alpha_log_entries_proto_goTypes = []interface{}{
	(ExecutionInfo_PostMethod)(0),                  // 0: google.cloud.integrations.v1alpha.ExecutionInfo.PostMethod
	(EventExecutionDetails_EventExecutionState)(0), // 1: google.cloud.integrations.v1alpha.EventExecutionDetails.EventExecutionState
	(TaskExecutionDetails_TaskExecutionState)(0),   // 2: google.cloud.integrations.v1alpha.TaskExecutionDetails.TaskExecutionState
	(*ExecutionInfo)(nil),                          // 3: google.cloud.integrations.v1alpha.ExecutionInfo
	(*EventExecutionDetails)(nil),                  // 4: google.cloud.integrations.v1alpha.EventExecutionDetails
	(*EventExecutionSnapshot)(nil),                 // 5: google.cloud.integrations.v1alpha.EventExecutionSnapshot
	(*TaskExecutionDetails)(nil),                   // 6: google.cloud.integrations.v1alpha.TaskExecutionDetails
	(*AttemptStats)(nil),                           // 7: google.cloud.integrations.v1alpha.AttemptStats
	(*ErrorDetail)(nil),                            // 8: google.cloud.integrations.v1alpha.ErrorDetail
	(*ConditionResult)(nil),                        // 9: google.cloud.integrations.v1alpha.ConditionResult
	nil,                                            // 10: google.cloud.integrations.v1alpha.ExecutionInfo.RequestParamsEntry
	nil,                                            // 11: google.cloud.integrations.v1alpha.ExecutionInfo.ResponseParamsEntry
	(*EventExecutionSnapshot_EventExecutionSnapshotMetadata)(nil), // 12: google.cloud.integrations.v1alpha.EventExecutionSnapshot.EventExecutionSnapshotMetadata
	nil,                           // 13: google.cloud.integrations.v1alpha.EventExecutionSnapshot.EventParamsEntry
	nil,                           // 14: google.cloud.integrations.v1alpha.EventExecutionSnapshot.DiffParamsEntry
	(Product)(0),                  // 15: google.cloud.integrations.v1alpha.Product
	(*TaskConfig)(nil),            // 16: google.cloud.integrations.v1alpha.TaskConfig
	(*timestamppb.Timestamp)(nil), // 17: google.protobuf.Timestamp
	(*EventParameter)(nil),        // 18: google.cloud.integrations.v1alpha.EventParameter
}
var file_google_cloud_integrations_v1alpha_log_entries_proto_depIdxs = []int32{
	10, // 0: google.cloud.integrations.v1alpha.ExecutionInfo.request_params:type_name -> google.cloud.integrations.v1alpha.ExecutionInfo.RequestParamsEntry
	11, // 1: google.cloud.integrations.v1alpha.ExecutionInfo.response_params:type_name -> google.cloud.integrations.v1alpha.ExecutionInfo.ResponseParamsEntry
	0,  // 2: google.cloud.integrations.v1alpha.ExecutionInfo.post_method:type_name -> google.cloud.integrations.v1alpha.ExecutionInfo.PostMethod
	4,  // 3: google.cloud.integrations.v1alpha.ExecutionInfo.event_execution_details:type_name -> google.cloud.integrations.v1alpha.EventExecutionDetails
	8,  // 4: google.cloud.integrations.v1alpha.ExecutionInfo.errors:type_name -> google.cloud.integrations.v1alpha.ErrorDetail
	15, // 5: google.cloud.integrations.v1alpha.ExecutionInfo.product:type_name -> google.cloud.integrations.v1alpha.Product
	16, // 6: google.cloud.integrations.v1alpha.ExecutionInfo.task_configs:type_name -> google.cloud.integrations.v1alpha.TaskConfig
	1,  // 7: google.cloud.integrations.v1alpha.EventExecutionDetails.event_execution_state:type_name -> google.cloud.integrations.v1alpha.EventExecutionDetails.EventExecutionState
	5,  // 8: google.cloud.integrations.v1alpha.EventExecutionDetails.event_execution_snapshot:type_name -> google.cloud.integrations.v1alpha.EventExecutionSnapshot
	7,  // 9: google.cloud.integrations.v1alpha.EventExecutionDetails.event_attempt_stats:type_name -> google.cloud.integrations.v1alpha.AttemptStats
	17, // 10: google.cloud.integrations.v1alpha.EventExecutionDetails.next_execution_time:type_name -> google.protobuf.Timestamp
	17, // 11: google.cloud.integrations.v1alpha.EventExecutionSnapshot.snapshot_time:type_name -> google.protobuf.Timestamp
	12, // 12: google.cloud.integrations.v1alpha.EventExecutionSnapshot.event_execution_snapshot_metadata:type_name -> google.cloud.integrations.v1alpha.EventExecutionSnapshot.EventExecutionSnapshotMetadata
	6,  // 13: google.cloud.integrations.v1alpha.EventExecutionSnapshot.task_execution_details:type_name -> google.cloud.integrations.v1alpha.TaskExecutionDetails
	9,  // 14: google.cloud.integrations.v1alpha.EventExecutionSnapshot.condition_results:type_name -> google.cloud.integrations.v1alpha.ConditionResult
	13, // 15: google.cloud.integrations.v1alpha.EventExecutionSnapshot.event_params:type_name -> google.cloud.integrations.v1alpha.EventExecutionSnapshot.EventParamsEntry
	14, // 16: google.cloud.integrations.v1alpha.EventExecutionSnapshot.diff_params:type_name -> google.cloud.integrations.v1alpha.EventExecutionSnapshot.DiffParamsEntry
	2,  // 17: google.cloud.integrations.v1alpha.TaskExecutionDetails.task_execution_state:type_name -> google.cloud.integrations.v1alpha.TaskExecutionDetails.TaskExecutionState
	7,  // 18: google.cloud.integrations.v1alpha.TaskExecutionDetails.task_attempt_stats:type_name -> google.cloud.integrations.v1alpha.AttemptStats
	17, // 19: google.cloud.integrations.v1alpha.AttemptStats.start_time:type_name -> google.protobuf.Timestamp
	17, // 20: google.cloud.integrations.v1alpha.AttemptStats.end_time:type_name -> google.protobuf.Timestamp
	18, // 21: google.cloud.integrations.v1alpha.ExecutionInfo.RequestParamsEntry.value:type_name -> google.cloud.integrations.v1alpha.EventParameter
	18, // 22: google.cloud.integrations.v1alpha.ExecutionInfo.ResponseParamsEntry.value:type_name -> google.cloud.integrations.v1alpha.EventParameter
	18, // 23: google.cloud.integrations.v1alpha.EventExecutionSnapshot.EventParamsEntry.value:type_name -> google.cloud.integrations.v1alpha.EventParameter
	18, // 24: google.cloud.integrations.v1alpha.EventExecutionSnapshot.DiffParamsEntry.value:type_name -> google.cloud.integrations.v1alpha.EventParameter
	25, // [25:25] is the sub-list for method output_type
	25, // [25:25] is the sub-list for method input_type
	25, // [25:25] is the sub-list for extension type_name
	25, // [25:25] is the sub-list for extension extendee
	0,  // [0:25] is the sub-list for field type_name
}

func init() { file_google_cloud_integrations_v1alpha_log_entries_proto_init() }
func file_google_cloud_integrations_v1alpha_log_entries_proto_init() {
	if File_google_cloud_integrations_v1alpha_log_entries_proto != nil {
		return
	}
	file_google_cloud_integrations_v1alpha_event_parameter_proto_init()
	file_google_cloud_integrations_v1alpha_product_proto_init()
	file_google_cloud_integrations_v1alpha_task_config_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventExecutionDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventExecutionSnapshot); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TaskExecutionDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttemptStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ErrorDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConditionResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventExecutionSnapshot_EventExecutionSnapshotMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_integrations_v1alpha_log_entries_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_integrations_v1alpha_log_entries_proto_goTypes,
		DependencyIndexes: file_google_cloud_integrations_v1alpha_log_entries_proto_depIdxs,
		EnumInfos:         file_google_cloud_integrations_v1alpha_log_entries_proto_enumTypes,
		MessageInfos:      file_google_cloud_integrations_v1alpha_log_entries_proto_msgTypes,
	}.Build()
	File_google_cloud_integrations_v1alpha_log_entries_proto = out.File
	file_google_cloud_integrations_v1alpha_log_entries_proto_rawDesc = nil
	file_google_cloud_integrations_v1alpha_log_entries_proto_goTypes = nil
	file_google_cloud_integrations_v1alpha_log_entries_proto_depIdxs = nil
}
