/*
 * Copyright (C) 2025-2026 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

#include "shared/test/common/test_macros/hw_test_base.h"

HWTEST_EXCLUDE_PRODUCT(ProductHelperTest, givenProductHelperWhenAskedIfBlitterForImagesIsSupportedThenFalseIsReturned, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(CommandEncodeStatesTest, givenOverrideSlmTotalSizeDebugVariableWhenDispatchingKernelThenSharedMemorySizeIsSetCorrectly, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(ImageSurfaceStateTests, givenGmmWhenSetAuxParamsForCCSThenAuxiliarySurfaceModeIsSet, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(WalkerPartitionTests, givenMiAtomicWhenItIsProgrammedThenAllFieldsAreSetCorrectly, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(WalkerPartitionTests, givenProgramBatchBufferStartCommandWhenItIsCalledThenCommandIsProgrammedCorrectly, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(GfxCoreHelperTest, whenAdjustPreemptionSurfaceSizeIsCalledThenCsrSizeDoesntChange, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(GfxCoreHelperTest, whenSetSipKernelDataIsCalledThenSipKernelDataDoesntChange, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(GfxCoreHelperTest, givenDefaultGfxCoreHelperHwWhenMinimalSIMDSizeIsQueriedThen8IsReturned, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(GfxCoreHelperTest, givenGfxCoreHelperWhenAskingForTimestampPacketAlignmentThenReturnFourCachelines, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(GfxCoreHelperTest, whenSetCompressedFlagThenProperFlagSet, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(GfxCoreHelperTest, whenIsSipKernelAsHexadecimalArrayPreferredIsCalledThenReturnFalse, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(PipeControlHelperTests, givenGfxCoreHelperwhenAskingForDcFlushThenReturnTrue, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(XeHPAndLaterPreemptionTests, whenProgramStateSipIsCalledThenStateSipCmdIsNotAddedToStream, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(XeHPAndLaterPreemptionTests, WhenProgrammingPreemptionThenExpectLoadRegisterCommandRemapFlagEnabled, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(BlitTests, givenXyCopyBltCommandWhenAppendBlitCommandsMemCopyIsCalledThenNothingChanged, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(ProductHelperTest, givenProductHelperWhenisReleaseGlobalFenceInCommandStreamRequiredThenFalseIsReturned, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(MemoryManagerGetAlloctionDataTests, givenCommandBufferAllocationTypeWhenGetAllocationDataIsCalledThenSystemMemoryIsRequested, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(ProductHelperTest, givenProductHelperWhenAskedIfPatIndexProgrammingSupportedThenReturnFalse, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(GfxCoreHelperTest, givenNumGrfAndSimdSizeWhenAdjustingMaxWorkGroupSizeThenAlwaysReturnDeviceDefault, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(GfxCoreHelperTest, givenDefaultGfxCoreHelperHwWhenMinimalGrfSizeIsQueriedThen128IsReturned, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(ProductHelperTest, givenProductHelperWhenCheckingIsTranslationExceptionSupportedThenReturnFalse, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(GmmCompressionTests, givenAllValidInputsWhenQueryingThenSetAppropriateFlags, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(GmmCompressionTests, givenNotAllowedCompressionAndEnabledDebugFlagWhenQueryingThenSetAppropriateFlags, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(GmmCompressionTests, whenConstructedWithPreferCompressionFlagThenApplyAuxFlags, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(GmmCompressionTests, givenDisabledE2ECAndEnabledDebugFlagWhenApplyingForBuffersThenSetValidFlags, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(GmmCompressionTests, givenEnabledAndPreferredE2ECWhenApplyingForBuffersThenSetValidFlags, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(ProductHelperTest, givenBooleanUncachedWhenCallOverridePatIndexThenProperPatIndexIsReturned, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(GfxCoreHelperTest, whenEncodeAdditionalTimestampOffsetsThenNothingEncoded, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(BlitTests, givenPlatformWithBlitSyncPropertiesWithAndWithoutUseAdditionalPropertiesWhenCallingDispatchBlitCommandForBufferRegionThenValidateMiFlushBehavior_WithoutGen12Lp, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(BlitTests, givenPlatformWithBlitSyncPropertiesWithAndWithoutUseAdditionalPropertiesWhenCallingDispatchBlitCommandForBufferPerRowThenValidateMiFlushBehavior_WithoutGen12Lp, IGFX_XE3_CORE);
HWTEST_EXCLUDE_PRODUCT(BlitTests, givenPlatformWithBlitSyncPropertiesWithAndWithoutUseAdditionalPropertiesWhenCallingDispatchBlitCommandForImageRegionThenValidateMiFlushBehavior_WithoutGen12Lp, IGFX_XE3_CORE);