/*
** msx.c : driver for MSX
**
** Todo:
** - Add support for other MSX models (de,fr,jp,ru etc.)
*/

#include "driver.h"
#include "vidhrdw/generic.h"
#include "machine/8255ppi.h"
#include "vidhrdw/tms9928a.h"
#include "vidhrdw/v9938.h"
#include "includes/msx_slot.h"
#include "includes/msx.h"
#include "devices/basicdsk.h"
#include "devices/printer.h"
#include "devices/cartslot.h"
#include "devices/cassette.h"
#include "formats/fmsx_cas.h"
#include "sound/ay8910.h"

static ADDRESS_MAP_START (readmem, ADDRESS_SPACE_PROGRAM, 8)
	AM_RANGE( 0x0000, 0x1fff) AM_READ( MRA8_BANK1 )
	AM_RANGE( 0x2000, 0x3fff) AM_READ( MRA8_BANK2 )
	AM_RANGE( 0x4000, 0x5fff) AM_READ( MRA8_BANK3 )
	AM_RANGE( 0x6000, 0x7ff7) AM_READ( MRA8_BANK4 )
	AM_RANGE( 0x7ff8, 0x7fff) AM_READ( MRA8_BANK5 )
	AM_RANGE( 0x8000, 0x97ff) AM_READ( MRA8_BANK6 )
	AM_RANGE( 0x9800, 0x9fff) AM_READ( MRA8_BANK7 )
	AM_RANGE( 0xa000, 0xb7ff) AM_READ( MRA8_BANK8 )
	AM_RANGE( 0xb800, 0xbfff) AM_READ( MRA8_BANK9 )
	AM_RANGE( 0xc000, 0xdfff) AM_READ( MRA8_BANK10 )
	AM_RANGE( 0xe000, 0xfffe) AM_READ( MRA8_BANK11 )
	AM_RANGE( 0xffff, 0xffff) AM_READ( msx_sec_slot_r )
ADDRESS_MAP_END

static ADDRESS_MAP_START( writemem , ADDRESS_SPACE_PROGRAM, 8)
	AM_RANGE( 0x0000, 0x0000) AM_WRITE( msx_superloadrunner_w )
	AM_RANGE( 0x0001, 0x3fff) AM_WRITE( msx_page0_w )
	AM_RANGE( 0x4000, 0x7fff) AM_WRITE( msx_page1_w )
	AM_RANGE( 0x8000, 0xbfff) AM_WRITE( msx_page2_w )
	AM_RANGE( 0xc000, 0xfffe) AM_WRITE( msx_page3_w )
	AM_RANGE( 0xffff, 0xffff) AM_WRITE( msx_sec_slot_w )
ADDRESS_MAP_END


static ADDRESS_MAP_START (readport, ADDRESS_SPACE_IO, 8)
	ADDRESS_MAP_FLAGS( AMEF_UNMAP(0xff) )
	ADDRESS_MAP_FLAGS( AMEF_ABITS(8) )
	AM_RANGE( 0x90, 0x91) AM_READ( msx_printer_r )
	AM_RANGE( 0xa0, 0xa7) AM_READ( msx_psg_r )
	AM_RANGE( 0xa8, 0xab) AM_READ( ppi8255_0_r )
	AM_RANGE( 0x98, 0x98) AM_READ( TMS9928A_vram_r )
	AM_RANGE( 0x99, 0x99) AM_READ( TMS9928A_register_r )
	AM_RANGE( 0xd9, 0xd9) AM_READ( msx_kanji_r )
ADDRESS_MAP_END

static ADDRESS_MAP_START (writeport, ADDRESS_SPACE_IO, 8)
	ADDRESS_MAP_FLAGS( AMEF_ABITS(8) )
	AM_RANGE( 0x77, 0x77) AM_WRITE( msx_90in1_w )
	AM_RANGE( 0x7c, 0x7d) AM_WRITE( msx_fmpac_w )
	AM_RANGE( 0x90, 0x91) AM_WRITE( msx_printer_w )
	AM_RANGE( 0xa0, 0xa7) AM_WRITE( msx_psg_w )
	AM_RANGE( 0xa8, 0xab) AM_WRITE( ppi8255_0_w )
	AM_RANGE( 0x98, 0x98) AM_WRITE( TMS9928A_vram_w )
	AM_RANGE( 0x99, 0x99) AM_WRITE( TMS9928A_register_w )
	AM_RANGE( 0xd8, 0xd9) AM_WRITE( msx_kanji_w )
ADDRESS_MAP_END

static ADDRESS_MAP_START (readport2, ADDRESS_SPACE_IO, 8)
	ADDRESS_MAP_FLAGS( AMEF_UNMAP(0xff) )
	ADDRESS_MAP_FLAGS( AMEF_ABITS(8) )
	AM_RANGE( 0x90, 0x91) AM_READ( msx_printer_r )
	AM_RANGE( 0xa0, 0xa7) AM_READ( msx_psg_r )
	AM_RANGE( 0xa8, 0xab) AM_READ( ppi8255_0_r )
	AM_RANGE( 0x98, 0x98) AM_READ( v9938_vram_r )
	AM_RANGE( 0x99, 0x99) AM_READ( v9938_status_r )
	AM_RANGE( 0xb5, 0xb5) AM_READ( msx_rtc_reg_r )
	AM_RANGE( 0xd9, 0xd9) AM_READ( msx_kanji_r )
	AM_RANGE( 0xfc, 0xff) AM_READ( msx_ram_mapper_r )
ADDRESS_MAP_END

static ADDRESS_MAP_START (writeport2, ADDRESS_SPACE_IO, 8)
	ADDRESS_MAP_FLAGS( AMEF_ABITS(8) )
	AM_RANGE( 0x77, 0x77) AM_WRITE( msx_90in1_w )
	AM_RANGE( 0x7c, 0x7d) AM_WRITE( msx_fmpac_w )
	AM_RANGE( 0x90, 0x91) AM_WRITE( msx_printer_w )
	AM_RANGE( 0xa0, 0xa7) AM_WRITE( msx_psg_w )
	AM_RANGE( 0xa8, 0xab) AM_WRITE( ppi8255_0_w )
	AM_RANGE( 0x98, 0x98) AM_WRITE( v9938_vram_w )
	AM_RANGE( 0x99, 0x99) AM_WRITE( v9938_command_w )
	AM_RANGE( 0x9a, 0x9a) AM_WRITE( v9938_palette_w )
	AM_RANGE( 0x9b, 0x9b) AM_WRITE( v9938_register_w )
	AM_RANGE( 0xb4, 0xb4) AM_WRITE( msx_rtc_latch_w )
	AM_RANGE( 0xb5, 0xb5) AM_WRITE( msx_rtc_reg_w )
	AM_RANGE( 0xd8, 0xd9) AM_WRITE( msx_kanji_w )
	AM_RANGE( 0xfc, 0xff) AM_WRITE( msx_ram_mapper_w )
ADDRESS_MAP_END

/* start define for the special ports (DIPS, joystick, mouse) */
static INPUT_PORTS_START( msx_dips )
	PORT_START /* 6 */
	PORT_BIT (0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_UP)
	PORT_BIT (0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN)
	PORT_BIT (0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT)
	PORT_BIT (0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT)
	PORT_BIT (0x10, IP_ACTIVE_LOW, IPT_BUTTON1)
	PORT_BIT (0x20, IP_ACTIVE_LOW, IPT_BUTTON2)
	PORT_BIT (0x40, IP_ACTIVE_LOW, IPT_UNUSED)
	PORT_DIPNAME( 0x80, 0, "Game port 1")
	PORT_DIPSETTING(    0x00, DEF_STR( Joystick ))
	PORT_DIPSETTING(    0x80, "Mouse")

	PORT_START /* 7 */
	PORT_BIT (0x01, IP_ACTIVE_LOW, IPT_JOYSTICK_UP)     PORT_PLAYER(2)
	PORT_BIT (0x02, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN)	  PORT_PLAYER(2)
	PORT_BIT (0x04, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT)	  PORT_PLAYER(2)
	PORT_BIT (0x08, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT)	   PORT_PLAYER(2)
	PORT_BIT (0x10, IP_ACTIVE_LOW, IPT_BUTTON1)     PORT_PLAYER(2)
	PORT_BIT (0x20, IP_ACTIVE_LOW, IPT_BUTTON2)     PORT_PLAYER(2)
	PORT_BIT (0x40, IP_ACTIVE_LOW, IPT_UNUSED)
	PORT_DIPNAME( 0x80, 0, "Game port 2")
	PORT_DIPSETTING( 0x00, DEF_STR( Joystick ))
	PORT_DIPSETTING( 0x80, "Mouse")

	PORT_START /* 8 */
	PORT_DIPNAME( 0x40, 0, "Swap game port 1 and 2")
	PORT_DIPSETTING( 0, DEF_STR( No ) )
	PORT_DIPSETTING( 0x40, DEF_STR( Yes ) )
	PORT_DIPNAME( 0x80, 0, "SIMPL")
	PORT_DIPSETTING( 0x00, DEF_STR ( Off ) )
	PORT_DIPSETTING( 0x80, DEF_STR ( On ) )
	PORT_DIPNAME( 0x20, 0x20, "Enforce 4/8 sprites/line")
	PORT_DIPSETTING( 0, DEF_STR( No ) )
	PORT_DIPSETTING( 0x20, DEF_STR( Yes ) )
	PORT_DIPNAME ( 0x03, 0, "Render resolution")
	PORT_DIPSETTING( 0, DEF_STR( High ))
	PORT_DIPSETTING( 1, DEF_STR( Low ))
	PORT_DIPSETTING( 2, "Auto" )

	PORT_START /* 9 */
	PORT_BIT( 0xff00, 0x00, IPT_TRACKBALL_X) PORT_SENSITIVITY(100) PORT_KEYDELTA(0) PORT_MINMAX(0,0) PORT_PLAYER(1)
	PORT_BIT( 0x00ff, 0x00, IPT_TRACKBALL_Y) PORT_SENSITIVITY(100) PORT_KEYDELTA(0) PORT_MINMAX(0,0) PORT_PLAYER(1)

	PORT_START /* 10 */
	PORT_BIT( 0xff00, 0x00, IPT_TRACKBALL_X) PORT_SENSITIVITY(100) PORT_KEYDELTA(0) PORT_MINMAX(0,0) PORT_PLAYER(2)
	PORT_BIT( 0x00ff, 0x00, IPT_TRACKBALL_Y) PORT_SENSITIVITY(100) PORT_KEYDELTA(0) PORT_MINMAX(0,0) PORT_PLAYER(2)
	/* end define for the special ports (DIPS, joystick, mouse) */
INPUT_PORTS_END


#define KEYB_ROW0	\
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("0 )") PORT_CODE(KEYCODE_0)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("1 !") PORT_CODE(KEYCODE_1)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("2 @") PORT_CODE(KEYCODE_2)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("3 #") PORT_CODE(KEYCODE_3)	\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("4 $") PORT_CODE(KEYCODE_4)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("5 %") PORT_CODE(KEYCODE_5)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("6 ^") PORT_CODE(KEYCODE_6)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("7 &") PORT_CODE(KEYCODE_7)

#define KEYB_EXPERT11_ROW0	 \
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("0 )") PORT_CODE(KEYCODE_0)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("1 !") PORT_CODE(KEYCODE_1)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("2 \"") PORT_CODE(KEYCODE_2)	 \
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("3 #") PORT_CODE(KEYCODE_3)	\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("4 $") PORT_CODE(KEYCODE_4)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("5 %") PORT_CODE(KEYCODE_5)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("6 ^") PORT_CODE(KEYCODE_6)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("7 &") PORT_CODE(KEYCODE_7)

#define KEYB_HOTBIT_ROW0   \
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("0 )") PORT_CODE(KEYCODE_0)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("1 !") PORT_CODE(KEYCODE_1)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("2 @") PORT_CODE(KEYCODE_2)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("3 #") PORT_CODE(KEYCODE_3)	\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("4 $") PORT_CODE(KEYCODE_4)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("5 %") PORT_CODE(KEYCODE_5)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("6 \"") PORT_CODE(KEYCODE_6)	 \
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("7 &") PORT_CODE(KEYCODE_7)

#define KEYB_ROW1	\
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("8 *") PORT_CODE(KEYCODE_8)	\
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("9 (") PORT_CODE(KEYCODE_9)	\
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("- _") PORT_CODE(KEYCODE_MINUS)	\
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("= +") PORT_CODE(KEYCODE_EQUALS)	\
  PORT_BIT (0x1000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("\\ |") PORT_CODE(KEYCODE_BACKSLASH)	\
  PORT_BIT (0x2000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("[ {") PORT_CODE(KEYCODE_OPENBRACE)	\
  PORT_BIT (0x4000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("] }") PORT_CODE(KEYCODE_CLOSEBRACE)	\
  PORT_BIT (0x8000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("; :") PORT_CODE(KEYCODE_COLON)

#define KEYB_HOTBIT_ROW1   \
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("8 *") PORT_CODE(KEYCODE_8)	\
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("9 (") PORT_CODE(KEYCODE_9)	\
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("- _") PORT_CODE(KEYCODE_MINUS)	\
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("= +") PORT_CODE(KEYCODE_EQUALS)	\
  PORT_BIT (0x1000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("\\ ^") PORT_CODE(KEYCODE_BACKSLASH)	\
  PORT_BIT (0x2000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("' `") PORT_CODE(KEYCODE_QUOTE)	\
  PORT_BIT (0x4000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("\" `") PORT_CODE(KEYCODE_BACKSLASH2)	 \
  PORT_BIT (0x8000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("\xc7 \xe7") PORT_CODE(KEYCODE_ASTERISK)

#define KEYB_EXPERT11_ROW1	 \
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("8 '") PORT_CODE(KEYCODE_8)	\
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("9 (") PORT_CODE(KEYCODE_9)	\
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("- _") PORT_CODE(KEYCODE_MINUS)	\
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("= +") PORT_CODE(KEYCODE_EQUALS)	\
  PORT_BIT (0x1000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("{ }") PORT_CODE(KEYCODE_OPENBRACE)   \
  PORT_BIT (0x2000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("' `") PORT_CODE(KEYCODE_QUOTE)	\
  PORT_BIT (0x4000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("[ ]") PORT_CODE(KEYCODE_CLOSEBRACE)	\
  PORT_BIT (0x8000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("~ ^") PORT_CODE(KEYCODE_TILDE)

#define KEYB_ROW2	\
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("' \"") PORT_CODE(KEYCODE_QUOTE)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("` ~") PORT_CODE(KEYCODE_TILDE)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(", <") PORT_CODE(KEYCODE_COMMA)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(". >") PORT_CODE(KEYCODE_STOP)		\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("/ ?") PORT_CODE(KEYCODE_SLASH)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("Dead Key")	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("a A") PORT_CODE(KEYCODE_A)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("b B") PORT_CODE(KEYCODE_B)

#define KEYB_HOTBIT_ROW2   \
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("~ ^") PORT_CODE(KEYCODE_TILDE)   \
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("[ ]") PORT_CODE(KEYCODE_OPENBRACE)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(", ;") PORT_CODE(KEYCODE_COMMA)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(". :") PORT_CODE(KEYCODE_STOP)		\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("/ ?") PORT_CODE(KEYCODE_SLASH)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("< >") PORT_CODE(KEYCODE_CLOSEBRACE)	 \
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("a A") PORT_CODE(KEYCODE_A)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("b B") PORT_CODE(KEYCODE_B)

#define KEYB_EXPERT10_ROW2	 \
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("' \"") PORT_CODE(KEYCODE_QUOTE)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("\xc7 \xe7") PORT_CODE(KEYCODE_TILDE)	  \
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(", <") PORT_CODE(KEYCODE_COMMA)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(". >") PORT_CODE(KEYCODE_STOP)		\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("/ ?") PORT_CODE(KEYCODE_SLASH)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("Dead Key")	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("a A") PORT_CODE(KEYCODE_A)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("b B") PORT_CODE(KEYCODE_B)

#define KEYB_EXPERT11_ROW2	 \
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("* @") PORT_CODE(KEYCODE_ASTERISK)   \
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("\xc7 \xe7") PORT_CODE(KEYCODE_BACKSLASH)	  \
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(", <") PORT_CODE(KEYCODE_COMMA)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(". >") PORT_CODE(KEYCODE_STOP)		\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("/ ?") PORT_CODE(KEYCODE_SLASH)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(": ;") PORT_CODE(KEYCODE_COLON)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("a A") PORT_CODE(KEYCODE_A)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("b B") PORT_CODE(KEYCODE_B)

#define KEYB_ROW3	\
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("c C") PORT_CODE(KEYCODE_C)	\
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("d D") PORT_CODE(KEYCODE_D)	\
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("e E") PORT_CODE(KEYCODE_E)	\
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("f F") PORT_CODE(KEYCODE_F)	\
  PORT_BIT (0x1000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("g G") PORT_CODE(KEYCODE_G)	\
  PORT_BIT (0x2000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("h H") PORT_CODE(KEYCODE_H)	\
  PORT_BIT (0x4000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("i I") PORT_CODE(KEYCODE_I)	\
  PORT_BIT (0x8000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("j J") PORT_CODE(KEYCODE_J)

#define KEYB_ROW4	\
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("k K") PORT_CODE(KEYCODE_K)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("l L") PORT_CODE(KEYCODE_L)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("m M") PORT_CODE(KEYCODE_M)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("n N") PORT_CODE(KEYCODE_N)	\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("o O") PORT_CODE(KEYCODE_O)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("p P") PORT_CODE(KEYCODE_P)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("q Q") PORT_CODE(KEYCODE_Q)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("r R") PORT_CODE(KEYCODE_R)

#define KEYB_ROW5	\
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("s S") PORT_CODE(KEYCODE_S)	\
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("t T") PORT_CODE(KEYCODE_T)	\
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("u U") PORT_CODE(KEYCODE_U)	\
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("v V") PORT_CODE(KEYCODE_V)	\
  PORT_BIT (0x1000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("w W") PORT_CODE(KEYCODE_W)	\
  PORT_BIT (0x2000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("x X") PORT_CODE(KEYCODE_X)	\
  PORT_BIT (0x4000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("y Y") PORT_CODE(KEYCODE_Y)	\
  PORT_BIT (0x8000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("z Z") PORT_CODE(KEYCODE_Z)

#define KEYB_ROW6	\
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("SHIFT") PORT_CODE(KEYCODE_LSHIFT)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CTRL") PORT_CODE(KEYCODE_LCONTROL)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("GRAPH") PORT_CODE(KEYCODE_PGUP)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CAPS") PORT_CODE(KEYCODE_CAPSLOCK)	\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CODE") PORT_CODE(KEYCODE_PGDN)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F1") PORT_CODE(KEYCODE_F1)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F2") PORT_CODE(KEYCODE_F2)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F3") PORT_CODE(KEYCODE_F3)

#define KEYB_EXPERT11_ROW6	 \
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("SHIFT") PORT_CODE(KEYCODE_LSHIFT) \
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CTRL") PORT_CODE(KEYCODE_LCONTROL)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("LGRAPH") PORT_CODE(KEYCODE_PGUP)	 \
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CAPS") PORT_CODE(KEYCODE_CAPSLOCK)	\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("RGRAPH") PORT_CODE(KEYCODE_PGDN)	  \
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F1") PORT_CODE(KEYCODE_F1)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F2") PORT_CODE(KEYCODE_F2)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F3") PORT_CODE(KEYCODE_F3)

#define KEYB_ROW7	\
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F4") PORT_CODE(KEYCODE_F4)	\
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F5") PORT_CODE(KEYCODE_F5)	\
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("ESC") PORT_CODE(KEYCODE_ESC)	\
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("TAB") PORT_CODE(KEYCODE_TAB)	\
  PORT_BIT (0x1000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("STOP") PORT_CODE(KEYCODE_RCONTROL)	\
  PORT_BIT (0x2000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("BACKSPACE") PORT_CODE(KEYCODE_BACKSPACE)	\
  PORT_BIT (0x4000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("SELECT") PORT_CODE(KEYCODE_END)	\
  PORT_BIT (0x8000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("ENTER") PORT_CODE(KEYCODE_ENTER)

#define KEYB_ROW8	\
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("SPACE") PORT_CODE(KEYCODE_SPACE)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("HOME") PORT_CODE(KEYCODE_HOME)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("INSERT") PORT_CODE(KEYCODE_INSERT)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("DEL") PORT_CODE(KEYCODE_DEL)	\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("LEFT") PORT_CODE(KEYCODE_LEFT)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("UP") PORT_CODE(KEYCODE_UP)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("DOWN") PORT_CODE(KEYCODE_DOWN)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("RIGHT") PORT_CODE(KEYCODE_RIGHT)

#define KEYB_ROW9	\
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM *") PORT_CODE(KEYCODE_ASTERISK)	\
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM +") PORT_CODE(KEYCODE_PLUS_PAD)	\
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM /") PORT_CODE(KEYCODE_SLASH_PAD)	\
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 0") PORT_CODE(KEYCODE_0_PAD)	\
  PORT_BIT (0x1000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 1") PORT_CODE(KEYCODE_1_PAD)	\
  PORT_BIT (0x2000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 2") PORT_CODE(KEYCODE_2_PAD)	\
  PORT_BIT (0x4000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 3") PORT_CODE(KEYCODE_3_PAD)	\
  PORT_BIT (0x8000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 4") PORT_CODE(KEYCODE_4_PAD)

#define KEYB_ROW10	\
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 5") PORT_CODE(KEYCODE_5_PAD)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 6") PORT_CODE(KEYCODE_6_PAD)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 7") PORT_CODE(KEYCODE_7_PAD)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 8") PORT_CODE(KEYCODE_8_PAD)	\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM 9") PORT_CODE(KEYCODE_9_PAD)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM -") PORT_CODE(KEYCODE_MINUS_PAD)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM ,") PORT_CODE(KEYCODE_ENTER_PAD)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("NUM .") PORT_CODE(KEYCODE_DEL_PAD)

INPUT_PORTS_START( msx )

 PORT_START /* 0 */
  KEYB_ROW0
  KEYB_ROW1

 PORT_START /* 1 */
  KEYB_ROW2
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  KEYB_ROW6
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  PORT_BIT (0xff00, IP_ACTIVE_LOW, IPT_UNUSED)	\

 PORT_START /* 5 */
  PORT_BIT (0xffff, IP_ACTIVE_LOW, IPT_UNUSED)	\

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END

INPUT_PORTS_START( msxuk )

 PORT_START /* 0 */
  KEYB_ROW0
  KEYB_ROW1

 PORT_START /* 1 */
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("' \"") PORT_CODE(KEYCODE_QUOTE)
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("\xa3 ~") PORT_CODE(KEYCODE_TILDE)
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(", <") PORT_CODE(KEYCODE_COMMA)
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(". >") PORT_CODE(KEYCODE_STOP)
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("/ ?") PORT_CODE(KEYCODE_SLASH)
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("Dead Key")
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("a A") PORT_CODE(KEYCODE_A)
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("b B") PORT_CODE(KEYCODE_B)
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  KEYB_ROW6
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  PORT_BIT (0xff00, IP_ACTIVE_LOW, IPT_UNUSED)	\

 PORT_START /* 5 */
  PORT_BIT (0xffff, IP_ACTIVE_LOW, IPT_UNUSED)	\

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END

#define KEYB_JAP_ROW0	\
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("0") PORT_CODE(KEYCODE_0)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("1 !") PORT_CODE(KEYCODE_1)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("2 \"") PORT_CODE(KEYCODE_2)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("3 #") PORT_CODE(KEYCODE_3)	\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("4 $") PORT_CODE(KEYCODE_4)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("5 %") PORT_CODE(KEYCODE_5)	\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("6 &") PORT_CODE(KEYCODE_6)	\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("7 '") PORT_CODE(KEYCODE_7)

#define KEYB_JAP_ROW1	\
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("8 (") PORT_CODE(KEYCODE_8)	\
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("9 )") PORT_CODE(KEYCODE_9)	\
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("- =") PORT_CODE(KEYCODE_MINUS)	\
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("^ ~") PORT_CODE(KEYCODE_EQUALS)	\
  PORT_BIT (0x1000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("\xa5 |") PORT_CODE(KEYCODE_BACKSLASH)	\
  PORT_BIT (0x2000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("@ `") PORT_CODE(KEYCODE_OPENBRACE)	\
  PORT_BIT (0x4000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("[ }") PORT_CODE(KEYCODE_CLOSEBRACE)	\
  PORT_BIT (0x8000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("; +") PORT_CODE(KEYCODE_COLON)

#define KEYB_KOR_ROW1	\
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("8 (") PORT_CODE(KEYCODE_8)	\
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("9 )") PORT_CODE(KEYCODE_9)	\
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("- =") PORT_CODE(KEYCODE_MINUS)	\
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("^ ~") PORT_CODE(KEYCODE_EQUALS)	\
  PORT_BIT (0x1000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("WON |") PORT_CODE(KEYCODE_BACKSLASH) \
  PORT_BIT (0x2000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("@ `") PORT_CODE(KEYCODE_OPENBRACE)	\
  PORT_BIT (0x4000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("[ }") PORT_CODE(KEYCODE_CLOSEBRACE)	\
  PORT_BIT (0x8000, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("; +") PORT_CODE(KEYCODE_COLON)

#define KEYB_JAP_ROW2	\
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(": *") PORT_CODE(KEYCODE_QUOTE)	\
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("] }") PORT_CODE(KEYCODE_TILDE)	\
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(", <") PORT_CODE(KEYCODE_COMMA)	\
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME(". >") PORT_CODE(KEYCODE_STOP)		\
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("/ ?") PORT_CODE(KEYCODE_SLASH)	\
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("  _") PORT_CODE(KEYCODE_F8)		\
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("a A") PORT_CODE(KEYCODE_A)		\
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("b B") PORT_CODE(KEYCODE_B)

INPUT_PORTS_START( msxjp )

 PORT_START /* 0 */
  KEYB_JAP_ROW0
  KEYB_JAP_ROW1

 PORT_START /* 1 */
  KEYB_JAP_ROW2
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("SHIFT") PORT_CODE(KEYCODE_LSHIFT)
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CTRL") PORT_CODE(KEYCODE_LCONTROL)
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("GRAPH") PORT_CODE(KEYCODE_PGUP)
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CAPS") PORT_CODE(KEYCODE_CAPSLOCK)
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("KANA") PORT_CODE(KEYCODE_PGDN)
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F1") PORT_CODE(KEYCODE_F1)
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F2") PORT_CODE(KEYCODE_F2)
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F3") PORT_CODE(KEYCODE_F3)
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  PORT_BIT (0xff00, IP_ACTIVE_LOW, IPT_UNUSED)	\

 PORT_START /* 5 */
  PORT_BIT (0xffff, IP_ACTIVE_LOW, IPT_UNUSED)	\

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END

INPUT_PORTS_START( msxkr )

 PORT_START /* 0 */
  KEYB_JAP_ROW0
  KEYB_KOR_ROW1

 PORT_START /* 1 */
  KEYB_JAP_ROW2
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("SHIFT") PORT_CODE(KEYCODE_LSHIFT)
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CTRL") PORT_CODE(KEYCODE_LCONTROL)
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("GRAPH") PORT_CODE(KEYCODE_PGUP)
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CAPS") PORT_CODE(KEYCODE_CAPSLOCK)
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("Hangul") PORT_CODE(KEYCODE_PGDN)
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F1") PORT_CODE(KEYCODE_F1)
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F2") PORT_CODE(KEYCODE_F2)
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F3") PORT_CODE(KEYCODE_F3)
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  PORT_BIT (0xff00, IP_ACTIVE_LOW, IPT_UNUSED)	\

 PORT_START /* 5 */
  PORT_BIT (0xffff, IP_ACTIVE_LOW, IPT_UNUSED)	\

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END

INPUT_PORTS_START( hotbit )

 PORT_START /* 0 */
  KEYB_HOTBIT_ROW0
  KEYB_HOTBIT_ROW1

 PORT_START /* 1 */
  KEYB_HOTBIT_ROW2
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  KEYB_ROW6
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  PORT_BIT (0xff00, IP_ACTIVE_LOW, IPT_UNUSED)	\

 PORT_START /* 5 */
  PORT_BIT (0xffff, IP_ACTIVE_LOW, IPT_UNUSED)	\

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END

#define KEYB_EXPERT11_ROW9	 \
  PORT_BIT (0x0100, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("+") PORT_CODE(KEYCODE_8)	  \
  PORT_BIT (0x0200, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("-") PORT_CODE(KEYCODE_9)	  \
  PORT_BIT (0x0400, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("*") PORT_CODE(KEYCODE_MINUS)	  \
  PORT_BIT (0x0800, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("/") PORT_CODE(KEYCODE_EQUALS)   \
  PORT_BIT (0xf000, IP_ACTIVE_LOW, IPT_UNUSED)	\

INPUT_PORTS_START( expert11 )

 PORT_START /* 0 */
  KEYB_EXPERT11_ROW0
  KEYB_EXPERT11_ROW1

 PORT_START /* 1 */
  KEYB_EXPERT11_ROW2
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  KEYB_EXPERT11_ROW6
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  KEYB_EXPERT11_ROW9

 PORT_START /* 5 */
  PORT_BIT (0xffff, IP_ACTIVE_LOW, IPT_UNUSED)	\

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END

INPUT_PORTS_START( expert10 )

 PORT_START /* 0 */
  KEYB_ROW0
  KEYB_ROW1

 PORT_START /* 1 */
  KEYB_EXPERT10_ROW2
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  KEYB_EXPERT11_ROW6
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  KEYB_EXPERT11_ROW9

 PORT_START /* 5 */
  PORT_BIT (0xffff, IP_ACTIVE_LOW, IPT_UNUSED)	\

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END

INPUT_PORTS_START( msx2 )

 PORT_START /* 0 */
  KEYB_ROW0
  KEYB_ROW1

 PORT_START /* 1 */
  KEYB_ROW2
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  KEYB_ROW6
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  KEYB_ROW9

 PORT_START /* 5 */
  KEYB_ROW10

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END

INPUT_PORTS_START( msx2jp )

 PORT_START /* 0 */
  KEYB_JAP_ROW0
  KEYB_JAP_ROW1

 PORT_START /* 1 */
  KEYB_JAP_ROW2
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("SHIFT") PORT_CODE(KEYCODE_LSHIFT)
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CTRL") PORT_CODE(KEYCODE_LCONTROL)
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("GRAPH") PORT_CODE(KEYCODE_PGUP)
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CAPS") PORT_CODE(KEYCODE_CAPSLOCK)
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("KANA") PORT_CODE(KEYCODE_PGDN)
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F1") PORT_CODE(KEYCODE_F1)
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F2") PORT_CODE(KEYCODE_F2)
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F3") PORT_CODE(KEYCODE_F3)
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  KEYB_ROW9

 PORT_START /* 5 */
  KEYB_ROW10

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END

INPUT_PORTS_START( msx2kr )

 PORT_START /* 0 */
  KEYB_JAP_ROW0
  KEYB_KOR_ROW1

 PORT_START /* 1 */
  KEYB_JAP_ROW2
  KEYB_ROW3

 PORT_START /* 2 */
  KEYB_ROW4
  KEYB_ROW5

 PORT_START /* 3 */
  PORT_BIT (0x0001, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("SHIFT") PORT_CODE(KEYCODE_LSHIFT)
  PORT_BIT (0x0002, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CTRL") PORT_CODE(KEYCODE_LCONTROL)
  PORT_BIT (0x0004, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("GRAPH") PORT_CODE(KEYCODE_PGUP)
  PORT_BIT (0x0008, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("CAPS") PORT_CODE(KEYCODE_CAPSLOCK)
  PORT_BIT (0x0010, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("Hangul") PORT_CODE(KEYCODE_PGDN)
  PORT_BIT (0x0020, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F1") PORT_CODE(KEYCODE_F1)
  PORT_BIT (0x0040, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F2") PORT_CODE(KEYCODE_F2)
  PORT_BIT (0x0080, IP_ACTIVE_LOW, IPT_KEYBOARD) PORT_NAME("F3") PORT_CODE(KEYCODE_F3)
  KEYB_ROW7

 PORT_START /* 4 */
  KEYB_ROW8
  PORT_BIT (0xff00, IP_ACTIVE_LOW, IPT_UNUSED)	\

 PORT_START /* 5 */
  PORT_BIT (0xffff, IP_ACTIVE_LOW, IPT_UNUSED)	\

	PORT_INCLUDE( msx_dips )
INPUT_PORTS_END


static struct AY8910interface ay8910_interface =
{
	msx_psg_port_a_r,
	msx_psg_port_b_r,
	msx_psg_port_a_w,
	msx_psg_port_b_w
};

static VIDEO_START( msx2 )
{
	return v9938_init (MODEL_V9938, 0x20000, msx_vdp_interrupt);
}

static const TMS9928a_interface tms9928a_interface =
{
	TMS99x8A,
	0x4000,
	msx_vdp_interrupt
};

static MACHINE_DRIVER_START( msx )
	/* basic machine hardware */
	MDRV_CPU_ADD(Z80, 3579545)		  /* 3.579545 Mhz */
	MDRV_CPU_PROGRAM_MAP(readmem,writemem)
	MDRV_CPU_IO_MAP(readport,writeport)
	MDRV_CPU_VBLANK_INT(msx_interrupt,1)
	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_REAL_60HZ_VBLANK_DURATION)
	MDRV_INTERLEAVE(1)

	MDRV_MACHINE_RESET( msx )

	/* video hardware */
	MDRV_TMS9928A( &tms9928a_interface )
	MDRV_SCREEN_SIZE(15 + 256 + 15, 27 + 192 + 24)
	MDRV_VISIBLE_AREA(15 - 8, 15 + 256 + 8 - 1, 27 - 24, 27 + 192 + 24 - 1)

	/* sound hardware */
	MDRV_SPEAKER_STANDARD_MONO("mono")
	MDRV_SOUND_ADD(DAC, 0)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.10)
	MDRV_SOUND_ADD(WAVE, 0)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.25)
	MDRV_SOUND_ADD(AY8910, 1789773)
	MDRV_SOUND_CONFIG(ay8910_interface)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.10)	
	MDRV_SOUND_ADD(K051649, 1789773)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.25)	
	MDRV_SOUND_ADD(YM2413, 3579545)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.40)	
MACHINE_DRIVER_END


static MACHINE_DRIVER_START( msx_pal )
	MDRV_IMPORT_FROM( msx )
	MDRV_FRAMES_PER_SECOND(50)
MACHINE_DRIVER_END


static MACHINE_DRIVER_START( msx2 )
	/* basic machine hardware */
	MDRV_CPU_ADD(Z80, 3579545)		  /* 3.579545 Mhz */
	MDRV_CPU_PROGRAM_MAP(readmem, writemem)
	MDRV_CPU_IO_MAP(readport2,writeport2)
	MDRV_CPU_VBLANK_INT(msx2_interrupt,262)
	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_REAL_60HZ_VBLANK_DURATION)
	MDRV_INTERLEAVE(1)

	MDRV_MACHINE_RESET( msx2 )

	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_UPDATE_BEFORE_VBLANK | VIDEO_TYPE_RASTER)
	MDRV_SCREEN_SIZE(512 + 32, (212 + 28) * 2)
	MDRV_VISIBLE_AREA(0, 512 + 32 - 1, 0, (212 + 28) * 2 - 1)
	MDRV_PALETTE_LENGTH(512)
	MDRV_COLORTABLE_LENGTH(512)
	MDRV_PALETTE_INIT( v9938 )

	MDRV_VIDEO_START( msx2 )
	MDRV_VIDEO_UPDATE( generic_bitmapped )

	/* sound hardware */
	MDRV_SPEAKER_STANDARD_MONO("mono")
	MDRV_SOUND_ADD(DAC, 0)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.10)
	MDRV_SOUND_ADD(WAVE, 0)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.25)
	MDRV_SOUND_ADD(AY8910, 1789773)
	MDRV_SOUND_CONFIG(ay8910_interface)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.10)	
	MDRV_SOUND_ADD(K051649, 1789773)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.25)	
	MDRV_SOUND_ADD(YM2413, 3579545)
	MDRV_SOUND_ROUTE(ALL_OUTPUTS, "mono", 0.40)	

	MDRV_NVRAM_HANDLER( msx2 )
MACHINE_DRIVER_END


/***************************************************************************

  Game driver(s)

***************************************************************************/

ROM_START (msx)
	ROM_REGION (0x8000, REGION_CPU1, 0)
	ROM_LOAD ("msx.rom", 0x0000, 0x8000, CRC(8205795e) SHA1(829c00c3114f25b3dae5157c0a238b52a3ac37db))
ROM_END

MSX_LAYOUT_INIT (msx)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
MSX_LAYOUT_END

ROM_START (hb75d)
	ROM_REGION (0xc000, REGION_CPU1, 0)
	ROM_LOAD ("75dbios.rom", 0x0000, 0x8000, CRC(7e2b32dd) SHA1(38a645febd0e0fe86d594f27c2d14be995acc730))
	ROM_LOAD ("75dnote.rom", 0x8000, 0x4000, CRC(8aae0494) SHA1(97ce59892573cac3c440efff6d74c8a1c29a5ad3))
ROM_END

MSX_LAYOUT_INIT (hb75d)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
	MSX_LAYOUT_SLOT (3, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
MSX_LAYOUT_END

ROM_START (hb75p)
	ROM_REGION (0xc000, REGION_CPU1, 0)
	ROM_LOAD ("75pbios.rom", 0x0000, 0x8000, CRC(e9ccd789) SHA1(8963fc041975f31dc2ab1019cfdd4967999de53e))
	ROM_LOAD ("75pnote.rom", 0x8000, 0x4000, CRC(492b12f8) SHA1(b262aedc71b445303f84efe5e865cbb71fd7d952))
ROM_END

MSX_LAYOUT_INIT (hb75p)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
	MSX_LAYOUT_SLOT (3, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
MSX_LAYOUT_END

ROM_START (hb501p)
	ROM_REGION (0x8000, REGION_CPU1, 0)
	ROM_LOAD ("501pbios.rom", 0x0000, 0x8000, CRC(0f488dd8) SHA1(5e7c8eab238712d1e18b0219c0f4d4dae180420d))
ROM_END

MSX_LAYOUT_INIT (hb501p)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
MSX_LAYOUT_END

ROM_START (hb201p)
	ROM_REGION (0xc000, REGION_CPU1, 0)
	ROM_LOAD ("201pbios.rom", 0x0000, 0x8000, CRC(0f488dd8) SHA1(5e7c8eab238712d1e18b0219c0f4d4dae180420d))
	ROM_LOAD ("201pnote.rom", 0x8000, 0x4000, CRC(1ff9b6ec) SHA1(e84d3ec7a595ee36b50e979683c84105c1871857))
ROM_END

MSX_LAYOUT_INIT (hb201p)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
MSX_LAYOUT_END

ROM_START (svi738)
	ROM_REGION (0x10000, REGION_CPU1, 0)
	ROM_LOAD ("738bios.rom", 0x0000, 0x8000, CRC(ad007d62) SHA1(c53b3f2c00f31683914f7452f3f4d94ae2929c0d))
	ROM_LOAD ("738disk.rom", 0x8000, 0x4000, CRC(acd27a36) SHA1(99a40266bc296cef1d432cb0caa8df1a7e570be4))
	ROM_LOAD ("738232c.rom", 0xc000, 0x4000, CRC(af568506) SHA1(9de525e042d7345f6b725a696bd1b6fef69ecbf1))
ROM_END

MSX_LAYOUT_INIT (svi738)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, RAM, 0x10000, 0x0000)  /* 64KB RAM */
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 1, 1, ROM, 0x4000, 0xc000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, DISK_ROM2, 0x4000, 0x8000)
MSX_LAYOUT_END

ROM_START (cf2000)
	ROM_REGION (0x8000, REGION_CPU1, 0)
	ROM_LOAD ("2000bios.rom", 0x0000, 0x8000, CRC(ee229390) SHA1(302afb5d8be26c758309ca3df611ae69cced2821))
ROM_END

MSX_LAYOUT_INIT (cf2000)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 3, 1, RAM, 0x4000, 0xC000)   /* 16KB RAM */
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
MSX_LAYOUT_END

ROM_START (cf1200)
	ROM_REGION (0x8000, REGION_CPU1, 0)
	ROM_LOAD ("1200bios.rom", 0x0000, 0x8000, CRC(5ad03407) SHA1(c7a2c5baee6a9f0e1c6ee7d76944c0ab1886796c))
ROM_END

MSX_LAYOUT_INIT (cf1200)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 3, 1, RAM, 0x4000, 0xC000)   /* 16KB RAM */
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
MSX_LAYOUT_END

ROM_START (cf2700)
	ROM_REGION (0x8000, REGION_CPU1, 0)
	ROM_LOAD ("2700bios.rom", 0x0000, 0x8000, CRC(5ad03407) SHA1(c7a2c5baee6a9f0e1c6ee7d76944c0ab1886796c))
ROM_END

MSX_LAYOUT_INIT (cf2700)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 2, RAM, 0x8000, 0x8000)   /* 32KB RAM */
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
MSX_LAYOUT_END

ROM_START (cf3000)
	ROM_REGION (0x8000, REGION_CPU1, 0)
	ROM_LOAD ("3000bios.rom", 0x0000, 0x8000, CRC(5ad03407) SHA1(c7a2c5baee6a9f0e1c6ee7d76944c0ab1886796c))
ROM_END

MSX_LAYOUT_INIT (cf3000)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, RAM, 0x10000, 0x0000)  /* 64KB RAM */
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
MSX_LAYOUT_END

ROM_START (cf3300)
	ROM_REGION (0xc000, REGION_CPU1, 0)
	ROM_LOAD ("3300bios.rom", 0x0000, 0x8000, CRC(5ad03407) SHA1(c7a2c5baee6a9f0e1c6ee7d76944c0ab1886796c))
	ROM_LOAD ("3300disk.rom", 0x8000, 0x4000, CRC(549f1d90) SHA1(f1525de4e0b60a6687156c2a96f8a8b2044b6c56))
ROM_END

MSX_LAYOUT_INIT (cf3300)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)  /* 64KB RAM */
  	MSX_LAYOUT_SLOT (3, 1, 1, 2, DISK_ROM2, 0x4000, 0x8000)
MSX_LAYOUT_END

ROM_START (fs4000)
	ROM_REGION (0x38000 ,REGION_CPU1, 0)
	ROM_LOAD ("4000bios.rom", 0x0000, 0x8000, CRC(071135e0) SHA1(df48902f5f12af8867ae1a87f255145f0e5e0774))
	ROM_LOAD ("4000word.rom", 0x8000, 0x8000, CRC(950b6c87) SHA1(931d6318774bd495a32ec3dabf8d0edfc9913324))
	ROM_LOAD ("4000kdr.rom", 0x10000, 0x8000, CRC(ebaa5a1e) SHA1(77bd67d5d10d459d343e79eafcd8e17eb0f209dd))
	ROM_LOAD ("4000kfn.rom", 0x18000, 0x20000, CRC(956dc96d) SHA1(9ed3ab6d893632b9246e91b412cd5db519e7586b))
ROM_END

MSX_LAYOUT_INIT (fs4000)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 2, ROM, 0x8000, 0x8000) 
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x10000) 
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
	MSX_LAYOUT_KANJI (0x18000)
MSX_LAYOUT_END

ROM_START (fs1300)
	ROM_REGION (0x8000, REGION_CPU1, 0)
	ROM_LOAD ("1300bios.rom", 0x0000, 0x8000, CRC(5ad03407) SHA1(c7a2c5baee6a9f0e1c6ee7d76944c0ab1886796c))
ROM_END

MSX_LAYOUT_INIT (fs1300)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)  /* 64KB RAM */
MSX_LAYOUT_END

ROM_START (hb201)
	ROM_REGION (0x10000, REGION_CPU1, 0)
	ROM_LOAD ("201bios.rom", 0x0000, 0x8000, CRC(ee229390) SHA1(302afb5d8be26c758309ca3df611ae69cced2821))
	ROM_LOAD ("201note.rom", 0x8000, 0x8000, CRC(d280186e) SHA1(1c8270207b5cc14414a52ffcdece65094f70774e))
ROM_END

MSX_LAYOUT_INIT (hb201)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 2, ROM, 0x8000, 0x8000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
MSX_LAYOUT_END

ROM_START (dpc100)
	ROM_REGION (0xc000, REGION_CPU1, 0)
	ROM_LOAD ("100bios.rom", 0x0000, 0x8000, CRC(3ab0cd3b) SHA1(171b587bd5a947a13f3114120b6e7baca3b57d78))
	ROM_LOAD ("100han.rom", 0x8000, 0x4000, CRC(97478efb) SHA1(4421fa2504cbce18f7c84b5ea97f04e017007f07))
ROM_END

MSX_LAYOUT_INIT (dpc100)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 3, 1, RAM, 0x4000, 0xC000)   /* 16KB RAM */
	MSX_LAYOUT_SLOT (3, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
MSX_LAYOUT_END

ROM_START (dpc180)
	ROM_REGION (0xc000, REGION_CPU1, 0)
	ROM_LOAD ("180bios.rom", 0x0000, 0x8000, CRC(3ab0cd3b) SHA1(171b587bd5a947a13f3114120b6e7baca3b57d78))
	ROM_LOAD ("180han.rom", 0x8000, 0x4000, CRC(97478efb) SHA1(4421fa2504cbce18f7c84b5ea97f04e017007f07))
ROM_END

MSX_LAYOUT_INIT (dpc180)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 2, 2, RAM, 0x8000, 0x8000)   /* 32KB RAM */
	MSX_LAYOUT_SLOT (3, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
MSX_LAYOUT_END


ROM_START (dpc200)
	ROM_REGION (0xc000, REGION_CPU1, 0)
	ROM_LOAD ("200bios.rom", 0x0000, 0x8000, CRC(3ab0cd3b) SHA1(171b587bd5a947a13f3114120b6e7baca3b57d78))
	ROM_LOAD ("200han.rom", 0x8000, 0x4000, CRC(97478efb) SHA1(4421fa2504cbce18f7c84b5ea97f04e017007f07))
ROM_END

MSX_LAYOUT_INIT (dpc200)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
	MSX_LAYOUT_SLOT (3, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
MSX_LAYOUT_END

ROM_START (hotbit11)
	ROM_REGION (0x8000, REGION_CPU1,0)
	ROM_LOAD ("hotbit11.rom", 0x0000, 0x8000, CRC(b6942694) SHA1(663f8c512d04d213fa616b0db5eefe3774012a4b))
ROM_END

MSX_LAYOUT_INIT (hotbit11)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
MSX_LAYOUT_END

ROM_START (hotbit12)
	ROM_REGION (0x8000, REGION_CPU1,0)
	ROM_LOAD ("hotbit12.rom", 0x0000, 0x8000, CRC(f59a4a0c) SHA1(9425815446d468058705bae545ffa13646744a87))
ROM_END

MSX_LAYOUT_INIT (hotbit12)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
MSX_LAYOUT_END

ROM_START (expert10)
	ROM_REGION (0x8000, REGION_CPU1,0)
	ROM_LOAD ("expbios.rom", 0x0000, 0x8000, CRC(07610d77) SHA1(ef3e010eb57e4476700a3bbff9d2119ab3acdf62))
ROM_END

MSX_LAYOUT_INIT (expert10)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
MSX_LAYOUT_END

ROM_START (expert11)
	ROM_REGION (0xc000, REGION_CPU1,0)
	ROM_LOAD ("exppbios.rom", 0x0000, 0x8000, CRC(efb4b972) SHA1(d6720845928ee848cfa88a86accb067397685f02))
	ROM_LOAD ("exppdemo.rom", 0x8000, 0x4000, CRC(a9bbef64) SHA1(d4cea8c815f3eeabe0c6a1c845f902ec4318bf6b))
ROM_END

MSX_LAYOUT_INIT (expert11)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
MSX_LAYOUT_END

ROM_START (expertdp)
	ROM_REGION (0xc000, REGION_CPU1,0)
	ROM_LOAD ("eddpbios.rom", 0x0000, 0x8000, CRC(efb4b972) SHA1(d6720845928ee848cfa88a86accb067397685f02))
	ROM_LOAD ("eddpdisk.rom", 0x8000, 0x4000, CRC(549f1d90) SHA1(f1525de4e0b60a6687156c2a96f8a8b2044b6c56))
ROM_END

MSX_LAYOUT_INIT (expertdp)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)  /* 64KB RAM */
  	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM2, 0x4000, 0x8000)
MSX_LAYOUT_END

ROM_START (msx2)
	ROM_REGION (0x20000, REGION_CPU1,0)
	ROM_LOAD ("msx2.rom", 0x0000, 0x8000, CRC(f05ed518) SHA1(5e1a4bd6826b29302a1eb88c340477e7cbd0b50a))
	ROM_LOAD ("msx2ext.rom", 0x8000, 0x4000, CRC(95db2959) SHA1(e7905d16d2ccd57a013c122dc432106cd59ef52c))
	ROM_LOAD_OPTIONAL ("disk.rom", 0xc000, 0x4000, CRC(b7c58fad) SHA1(bc517b4a248c3a1338c5efc937b0128b6a783808))
	ROM_LOAD_OPTIONAL ("fmpac.rom", 0x10000, 0x10000, CRC(0e84505d) SHA1(9d789166e3caf28e4742fe933d962e99618c633d))
ROM_END

MSX_LAYOUT_INIT (msx2)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (3, 3, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_RAMIO_SET_BITS (0xf8)
MSX_LAYOUT_END

ROM_START (nms8220)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("8220bios.rom", 0x0000, 0x8000, CRC(6cdaf3a5) SHA1(6103b39f1e38d1aa2d84b1c3219c44f1abb5436e))
	ROM_LOAD ("8220ext.rom", 0x8000, 0x4000, CRC(06e4f5e6) SHA1(f5eb0a396097572589f2a6efeed045044e9425e4))
	ROM_LOAD ("8220pen.rom", 0xc000, 0x4000, CRC(3d38c53e) SHA1(cb754aed85b3e97a7d3c5894310df7ca18f89f41))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (nms8220)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x10000, 0x0000)	/* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 1, ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_RAMIO_SET_BITS (0xf8)
MSX_LAYOUT_END

ROM_START (nms8220a)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("8220bios.rom", 0x0000, 0x8000, CRC(6cdaf3a5) SHA1(6103b39f1e38d1aa2d84b1c3219c44f1abb5436e))
	ROM_LOAD ("8220ext.rom", 0x8000, 0x4000, CRC(06e4f5e6) SHA1(f5eb0a396097572589f2a6efeed045044e9425e4))
	ROM_LOAD ("8220pena.rom", 0xc000, 0x4000, CRC(17817b5a) SHA1(5df95d033ae70b107697b69470126ce1b7ae9eb5))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (nms8220a)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x10000, 0x0000)	/* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 1, ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_RAMIO_SET_BITS (0xf8)
MSX_LAYOUT_END

ROM_START (vg8235)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("8235bios.rom", 0x0000, 0x8000, CRC(6cdaf3a5) SHA1(6103b39f1e38d1aa2d84b1c3219c44f1abb5436e))
	ROM_LOAD ("8235ext.rom", 0x8000, 0x4000, CRC(66237ecf) SHA1(5c1f9c7fb655e43d38e5dd1fcc6b942b2ff68b02))
	ROM_LOAD ("8235disk.rom", 0xc000, 0x4000, CRC(51daeb25) SHA1(8954e59aa79310c7b719ecf0cde1e82fb731dcd1))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (vg8235)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_RAMIO_SET_BITS (0xf8)
MSX_LAYOUT_END

ROM_START (nms8245)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("8245bios.rom", 0x0000, 0x8000, CRC(6cdaf3a5) SHA1(6103b39f1e38d1aa2d84b1c3219c44f1abb5436e))
	ROM_LOAD ("8245ext.rom", 0x8000, 0x4000, CRC(95db2959) SHA1(e7905d16d2ccd57a013c122dc432106cd59ef52c))
	ROM_LOAD ("8245disk.rom", 0xc000, 0x4000, CRC(ca3307d3) SHA1(c3efedda7ab947a06d9345f7b8261076fa7ceeef))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (nms8245)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_RAMIO_SET_BITS (0xf8)
MSX_LAYOUT_END

ROM_START (nms8250)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("8250bios.rom", 0x0000, 0x8000, CRC(6cdaf3a5) SHA1(6103b39f1e38d1aa2d84b1c3219c44f1abb5436e))
	ROM_LOAD ("8250ext.rom", 0x8000, 0x4000, CRC(66237ecf) SHA1(5c1f9c7fb655e43d38e5dd1fcc6b942b2ff68b02))
	ROM_LOAD ("8250disk.rom", 0xc000, 0x04000, CRC(ca3307d3) SHA1(c3efedda7ab947a06d9345f7b8261076fa7ceeef))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (nms8250)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_RAMIO_SET_BITS (0xf8)
MSX_LAYOUT_END

ROM_START (nms8255)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("8255bios.rom", 0x0000, 0x8000, CRC(6cdaf3a5) SHA1(6103b39f1e38d1aa2d84b1c3219c44f1abb5436e))
	ROM_LOAD ("8255ext.rom", 0x8000, 0x4000, CRC(66237ecf) SHA1(5c1f9c7fb655e43d38e5dd1fcc6b942b2ff68b02))
	ROM_LOAD ("8255disk.rom", 0xc000, 0x04000, CRC(ca3307d3) SHA1(c3efedda7ab947a06d9345f7b8261076fa7ceeef))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (nms8255)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_RAMIO_SET_BITS (0xf8)
MSX_LAYOUT_END

ROM_START (nms8280)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("8280bios.rom", 0x0000, 0x8000, CRC(6cdaf3a5) SHA1(6103b39f1e38d1aa2d84b1c3219c44f1abb5436e))
	ROM_LOAD ("8280ext.rom", 0x8000, 0x4000, CRC(66237ecf) SHA1(5c1f9c7fb655e43d38e5dd1fcc6b942b2ff68b02))
	ROM_LOAD ("8280disk.rom", 0xc000, 0x04000, CRC(ca3307d3) SHA1(c3efedda7ab947a06d9345f7b8261076fa7ceeef))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (nms8280)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_RAMIO_SET_BITS (0xf8)
MSX_LAYOUT_END

ROM_START (fs5500)
	ROM_REGION (0x50000, REGION_CPU1,0)
	ROM_LOAD ("5500bios.rom", 0x0000, 0x8000, CRC(5bf38e13) SHA1(44e0dd215b2a9f0770dd76fb49187c05b083eed9))
	ROM_LOAD ("5500ext.rom", 0x8000, 0x4000, CRC(3c42c367) SHA1(4be8371f3b03e70ddaca495958345f3c4f8e2d36))
	ROM_LOAD ("5500disk.rom", 0xc000, 0x4000, CRC(1e7d6512) SHA1(78cd7f847e77fd8cd51a647efb2725ba93f4c471))
	ROM_LOAD ("5500null.rom", 0x10000, 0x10000, CRC(deab7e4e) SHA1(472a55b0ba289b0f4e538bb4c8b826dede3a40bb))
	ROM_LOAD ("5500imp.rom", 0x20000, 0x8000, CRC(6173a88c) SHA1(b677a861b67e8763a11d5dcf52416b42493ade57))
	ROM_LOAD ("5500kdr.rom", 0x28000, 0x8000, CRC(b2db6bf5) SHA1(3a9a942ed888dd641cddf8deada1879c454df3c6))
	ROM_LOAD ("5500kfn.rom", 0x30000, 0x20000, CRC(956dc96d) SHA1(9ed3ab6d893632b9246e91b412cd5db519e7586b))
ROM_END

MSX_LAYOUT_INIT (fs5500)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 1, 0, 4, ROM, 0x10000, 0x10000)
	MSX_LAYOUT_SLOT (0, 2, 0, 4, ROM, 0x10000, 0x10000)
	MSX_LAYOUT_SLOT (0, 3, 0, 4, ROM, 0x10000, 0x10000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, ROM, 0x8000, 0x28000)
	MSX_LAYOUT_SLOT (3, 1, 1, 1, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM2, 0x4000, 0xc000)
	MSX_LAYOUT_KANJI (0x30000)
MSX_LAYOUT_END

ROM_START (fs4500)
	ROM_REGION (0x94000, REGION_CPU1,0)
	ROM_LOAD ("4500bios.rom", 0x0000, 0x8000, CRC(9b3e7b97) SHA1(0081ea0d25bc5cd8d70b60ad8cfdc7307812c0fd))
	ROM_LOAD ("4500ext.rom", 0x8000, 0x4000, CRC(4a48779c) SHA1(b8e30d604d319d511cbfbc61e5d8c38fbb9c5a33))
	ROM_FILL (0xc000, 0x14000, 0)
	ROM_LOAD ("4500font.rom", 0x20000, 0x4000, CRC(4bd54f95) SHA1(3ce8e35790eb4689b21e14c7ecdd4b63943ee158))
	ROM_LOAD ("4500buns.rom", 0x24000, 0x8000, CRC(c9398e11) SHA1(e89ea1e8e583392e2dd9debb8a4b6a162f58ba91))
	ROM_LOAD ("4500jush.rom", 0x2c000, 0x8000, CRC(4debfd2d) SHA1(6442c1c5cece64c6dae90cc6ae3675f070d93e06))
	ROM_LOAD ("4500wor1.rom", 0x34000, 0xc000, CRC(0c8b5cfb) SHA1(3f047469b62d93904005a0ea29092e892724ce0b))
	ROM_LOAD ("4500wor2.rom", 0x40000, 0xc000, CRC(d9909451) SHA1(4c8ea05c09b40c41888fa18db065575a317fda16))
	ROM_LOAD ("4500kdr1.rom", 0x4c000, 0x4000, CRC(f8c7f0db) SHA1(df07e89fa0b1c7874f9cdf184c136f964fea4ff4))
	ROM_LOAD ("4500kdr2.rom", 0x50000, 0x4000, CRC(69e87c31) SHA1(c63db26660da96af56f8a7d3ea18544b9ae5a37c))
	ROM_LOAD ("4500kfn.rom", 0x54000, 0x20000, CRC(956dc96d) SHA1(9ed3ab6d893632b9246e91b412cd5db519e7586b))
	ROM_LOAD ("4500budi.rom", 0x74000, 0x20000, CRC(f94590f8) SHA1(1ebb06062428fcdc66808a03761818db2bba3c73))
ROM_END

MSX_LAYOUT_INIT (fs4500)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (0, 2, 0, 1, ROM, 0x4000, 0x20000)
	MSX_LAYOUT_SLOT (0, 3, 1, 2, ROM, 0x8000, 0x2c000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 3, ROM, 0xc000, 0x34000)
	MSX_LAYOUT_SLOT (3, 0, 3, 1, ROM, 0x4000, 0x4c000)
	MSX_LAYOUT_SLOT (3, 1, 0, 3, ROM, 0xc000, 0x40000)
	MSX_LAYOUT_SLOT (3, 1, 3, 1, ROM, 0x4000, 0x50000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
	MSX_LAYOUT_KANJI (0x54000)
/*	MSX_LAYOUT_BUNSETSU (0x74000) */ /* Matsushita Bunsetsu Henkan ROM must be emulated */
MSX_LAYOUT_END

ROM_START (fs4700)
	ROM_REGION (0x94000, REGION_CPU1,0)
	ROM_LOAD ("4700bios.rom", 0x0000, 0x8000, CRC(9b3e7b97) SHA1(0081ea0d25bc5cd8d70b60ad8cfdc7307812c0fd))
	ROM_LOAD ("4700ext.rom", 0x8000, 0x4000, CRC(4a48779c) SHA1(b8e30d604d319d511cbfbc61e5d8c38fbb9c5a33))
	ROM_LOAD ("4700disk.rom", 0xc000, 0x4000, CRC(1e7d6512) SHA1(78cd7f847e77fd8cd51a647efb2725ba93f4c471))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("4700font.rom", 0x20000, 0x4000, CRC(4bd54f95) SHA1(3ce8e35790eb4689b21e14c7ecdd4b63943ee158))
	ROM_LOAD ("4700buns.rom", 0x24000, 0x8000, CRC(c9398e11) SHA1(e89ea1e8e583392e2dd9debb8a4b6a162f58ba91))
	ROM_LOAD ("4700jush.rom", 0x2c000, 0x8000, CRC(4debfd2d) SHA1(6442c1c5cece64c6dae90cc6ae3675f070d93e06))
	ROM_LOAD ("4700wor1.rom", 0x34000, 0xc000, CRC(5f39a727) SHA1(f5af1d2a8bcf247f78847e1a9d995e581df87e8e))
	ROM_LOAD ("4700wor2.rom", 0x40000, 0xc000, CRC(d9909451) SHA1(4c8ea05c09b40c41888fa18db065575a317fda16))
	ROM_LOAD ("4700kdr1.rom", 0x4c000, 0x4000, CRC(f8c7f0db) SHA1(df07e89fa0b1c7874f9cdf184c136f964fea4ff4))
	ROM_LOAD ("4700kdr2.rom", 0x50000, 0x4000, CRC(69e87c31) SHA1(c63db26660da96af56f8a7d3ea18544b9ae5a37c))
	ROM_LOAD ("4700kfn.rom", 0x54000, 0x20000, CRC(956dc96d) SHA1(9ed3ab6d893632b9246e91b412cd5db519e7586b))
	ROM_LOAD ("4700budi.rom", 0x74000, 0x20000, CRC(f94590f8) SHA1(1ebb06062428fcdc66808a03761818db2bba3c73))
ROM_END

MSX_LAYOUT_INIT (fs4700)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (0, 2, 0, 1, ROM, 0x4000, 0x20000)
	MSX_LAYOUT_SLOT (0, 3, 1, 2, ROM, 0x8000, 0x2c000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 3, ROM, 0xc000, 0x34000)
	MSX_LAYOUT_SLOT (3, 0, 3, 1, ROM, 0x4000, 0x4c000)
	MSX_LAYOUT_SLOT (3, 1, 0, 3, ROM, 0xc000, 0x40000)
	MSX_LAYOUT_SLOT (3, 1, 3, 1, ROM, 0x4000, 0x50000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM, 0x10000, 0x0000)	/* 64KB RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM2, 0x4000, 0xc000)
	MSX_LAYOUT_KANJI (0x54000)
/*	MSX_LAYOUT_BUNSETSU (0x74000) */ /* Matsushita Bunsetsu Henkan ROM must be emulated */
MSX_LAYOUT_END

ROM_START (fs5000)
	ROM_REGION (0x50000, REGION_CPU1,0)
	ROM_LOAD ("5000bios.rom", 0x0000, 0x8000, CRC(a44ea707) SHA1(59967765d6e9328909dee4dac1cbe4cf9d47d315))
	ROM_LOAD ("5000ext.rom", 0x8000, 0x4000, CRC(43e7a7fc) SHA1(0fbd45ef3dd7bb82d4c31f1947884f411f1ca344))
	ROM_LOAD ("5000disk.rom", 0xc000, 0x4000, CRC(ae4e65b7) SHA1(073feb8bb645d935e099afaf61e6f04f52adee42))
	ROM_LOAD ("5000null.rom", 0x10000, 0x10000, CRC(deab7e4e) SHA1(472a55b0ba289b0f4e538bb4c8b826dede3a40bb))
	ROM_LOAD ("5000rtc.rom", 0x20000, 0x8000, CRC(03351598) SHA1(98bbfa3ab07b7a5cad55d7ddf7cbd9440caa2a86))
	ROM_LOAD ("5000kdr.rom", 0x28000, 0x8000, CRC(b2db6bf5) SHA1(3a9a942ed888dd641cddf8deada1879c454df3c6))
	ROM_LOAD ("5000kfn.rom", 0x30000, 0x20000, CRC(c61ddc5d) SHA1(5e872d5853698731a0ed22fb72dbcdfd59cd19c3))
ROM_END

MSX_LAYOUT_INIT (fs5000)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 1, 0, 4, ROM, 0x10000, 0x10000)
	MSX_LAYOUT_SLOT (0, 2, 0, 4, ROM, 0x10000, 0x10000)
	MSX_LAYOUT_SLOT (0, 3, 0, 4, ROM, 0x10000, 0x10000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, ROM, 0x8000, 0x28000)
	MSX_LAYOUT_SLOT (3, 1, 1, 1, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x20000, 0x0000)   /* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM2, 0x4000, 0xc000)
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (fs4600)
	ROM_REGION (0x170000, REGION_CPU1,0)
	ROM_LOAD ("4600bios.rom", 0x0000, 0x8000, CRC(9b3e7b97) SHA1(0081ea0d25bc5cd8d70b60ad8cfdc7307812c0fd))
	ROM_LOAD ("4600ext.rom", 0x8000, 0x4000, CRC(43e7a7fc) SHA1(0fbd45ef3dd7bb82d4c31f1947884f411f1ca344))
	ROM_LOAD ("4600disk.rom", 0xc000, 0x4000, CRC(ae4e65b7) SHA1(073feb8bb645d935e099afaf61e6f04f52adee42))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("4600fon1.rom", 0x20000, 0x4000, CRC(7391389b) SHA1(31292b9ca9fe7d1d8833530f44c0a5671bfefe4e))
	ROM_LOAD ("4600fon2.rom", 0x24000, 0x4000, CRC(c3a6b445) SHA1(02155fc25c9bd23e1654fe81c74486351e1ecc28))
	ROM_LOAD ("4600kdr.rom", 0x28000, 0x8000, CRC(b2db6bf5) SHA1(3a9a942ed888dd641cddf8deada1879c454df3c6))
	ROM_LOAD ("4600kfn.rom", 0x30000, 0x20000, CRC(c61ddc5d) SHA1(5e872d5853698731a0ed22fb72dbcdfd59cd19c3))
	ROM_LOAD ("4600kf12.rom", 0x50000, 0x20000, CRC(340d1ef7) SHA1(a7a23dc01314e88381eee88b4878b39931ab4818))
	ROM_LOAD ("4600firm.rom", 0x70000, 0x100000, CRC(1df57472) SHA1(005794c10a4237de3907ba4a44d436078d3c06c2))
ROM_END

MSX_LAYOUT_INIT (fs4600)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (0, 2, 0, 1, ROM, 0x4000, 0x20000)
	MSX_LAYOUT_SLOT (0, 2, 1, 2, ROM, 0x8000, 0x28000)
	MSX_LAYOUT_SLOT (0, 3, 0, 1, ROM, 0x4000, 0x24000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 1, 0, 4, ASCII16, 0x100000, 0x70000) /* National FS-4600 Mapper must be emulated */
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x20000, 0x0000)   /* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, DISK_ROM2, 0x4000, 0xc000)
	MSX_LAYOUT_KANJI (0x30000)
/*	MSX_LAYOUT_KANJI_12 (0x50000) */ /* Matsushita 12 dots Kanji ROM must be emulated */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (fsa1)
	ROM_REGION (0x30000, REGION_CPU1,0)
	ROM_LOAD ("a1bios.rom", 0x0000, 0x8000, CRC(9b3e7b97) SHA1(0081ea0d25bc5cd8d70b60ad8cfdc7307812c0fd))
	ROM_LOAD ("a1ext.rom", 0x8000, 0x4000, CRC(43e7a7fc) SHA1(0fbd45ef3dd7bb82d4c31f1947884f411f1ca344))
	ROM_FILL (0xc000, 0x14000, 0)
	ROM_LOAD ("deskpac1.rom", 0x20000, 0x8000, CRC(99c48147) SHA1(63098f27beac9eca6b39d837d2a552395df33fe1))
	ROM_LOAD ("deskpac2.rom", 0x28000, 0x8000, CRC(7f6f4aa1) SHA1(7f5b76605e3d898cc4b5aacf1d7682b82fe84353))
ROM_END

MSX_LAYOUT_INIT (fsa1)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)  /* 64 KB RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 1, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (3, 3, 1, 2, ROM, 0x8000, 0x28000)
MSX_LAYOUT_END

ROM_START (fsa1a)
	ROM_REGION (0x30000, REGION_CPU1,0)
	ROM_LOAD ("a1bios.rom", 0x0000, 0x8000, CRC(9b3e7b97) SHA1(0081ea0d25bc5cd8d70b60ad8cfdc7307812c0fd))
	ROM_LOAD ("a1ext.rom", 0x8000, 0x4000, CRC(43e7a7fc) SHA1(0fbd45ef3dd7bb82d4c31f1947884f411f1ca344))
	ROM_FILL (0xc000, 0x14000, 0)
	ROM_LOAD ("deskpa1a.rom", 0x20000, 0x8000, CRC(25b5b170) SHA1(d9307bfdaab1312d25e38af7c0d3a7671a9f716b))
	ROM_LOAD ("deskpac2.rom", 0x28000, 0x8000, CRC(7f6f4aa1) SHA1(7f5b76605e3d898cc4b5aacf1d7682b82fe84353))
ROM_END

MSX_LAYOUT_INIT (fsa1a)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM, 0x10000, 0x0000)  /* 64KB RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 1, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (3, 3, 1, 2, ROM, 0x8000, 0x28000)
MSX_LAYOUT_END

ROM_START (fsa1mk2)
	ROM_REGION (0x34000, REGION_CPU1,0)
	ROM_LOAD ("a1mkbios.rom", 0x0000, 0x8000, CRC(9b3e7b97) SHA1(0081ea0d25bc5cd8d70b60ad8cfdc7307812c0fd))
	ROM_LOAD ("a1mk2ext.rom", 0x8000, 0x4000, CRC(43e7a7fc) SHA1(0fbd45ef3dd7bb82d4c31f1947884f411f1ca344))
	ROM_FILL (0xc000, 0x14000, 0)
	ROM_LOAD ("cockpit1.rom", 0x20000, 0x8000, CRC(0eda3f57) SHA1(2752cd89754c05abdf7c23cba132d38e3ef0f27d))
	ROM_LOAD ("cockpit2.rom", 0x28000, 0x4000, CRC(756d7128) SHA1(e194d290ebfa4595ce0349ea2fc15442508485b0))
	ROM_LOAD ("cockpit3.rom", 0x2c000, 0x8000, CRC(c1945676) SHA1(a3f4e2e4934074925d775afe30ac72f150ede543))
ROM_END

MSX_LAYOUT_INIT (fsa1mk2)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64 KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (3, 2, 1, 1, ROM, 0x4000, 0x28000)
	MSX_LAYOUT_SLOT (3, 3, 1, 2, ROM, 0x8000, 0x2c000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (fsa1f)
	ROM_REGION (0x50000, REGION_CPU1,0)
	ROM_LOAD ("a1fbios.rom", 0x0000, 0x8000, CRC(9b3e7b97) SHA1(0081ea0d25bc5cd8d70b60ad8cfdc7307812c0fd))
	ROM_LOAD ("a1fext.rom", 0x8000, 0x4000, CRC(43e7a7fc) SHA1(0fbd45ef3dd7bb82d4c31f1947884f411f1ca344))
	ROM_LOAD ("a1fdisk.rom", 0xc000, 0x4000, CRC(d24cd452) SHA1(141e61cc8e0e51382e508fbd77a34b778a4f8444))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("a1fkdr.rom", 0x20000, 0x8000, CRC(2dbea5ec) SHA1(ea35cc2cad9cfdf56cae224d8ee41579de37f000))
	ROM_LOAD ("a1fcock.rom", 0x28000, 0x8000, CRC(5c2948cd) SHA1(4a99f2444f29c2b642efd6f084081d6fd96bfa9b))
	ROM_LOAD ("a1fkfn.rom", 0x30000, 0x20000, CRC(c61ddc5d) SHA1(5e872d5853698731a0ed22fb72dbcdfd59cd19c3))
ROM_END

MSX_LAYOUT_INIT (fsa1f)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
/*	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) */ /* FDC Emulation of TC8566AF must be emulated */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, ROM, 0x8000, 0x28000)
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (fsa1fm)
	ROM_REGION (0x180000, REGION_CPU1,0)
	ROM_LOAD ("a1fmbios.rom", 0x0000, 0x8000, CRC(9b3e7b97) SHA1(0081ea0d25bc5cd8d70b60ad8cfdc7307812c0fd))
	ROM_LOAD ("a1fmext.rom", 0x8000, 0x4000, CRC(ad295b5d) SHA1(d552319a19814494e3016de4b8f010e8f7b97e02))
	ROM_LOAD ("a1fmdisk.rom", 0xc000, 0x4000, CRC(d24cd452) SHA1(141e61cc8e0e51382e508fbd77a34b778a4f8444))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("a1fmmod.rom", 0x20000, 0x20000, CRC(925dbeeb) SHA1(2367ad17bc6bfaaf7b94a009ae26d508bdcf5565))
	ROM_LOAD ("a1fmkfn.rom", 0x40000, 0x20000, CRC(c61ddc5d) SHA1(5e872d5853698731a0ed22fb72dbcdfd59cd19c3))
	ROM_LOAD ("a1fmkf12.rom", 0x60000, 0x20000, CRC(340d1ef7) SHA1(a7a23dc01314e88381eee88b4878b39931ab4818))
	ROM_LOAD ("a1fmfirm.rom", 0x80000, 0x100000, CRC(8ce0ece7) SHA1(f89e3d8f3b6855c29d71d3149cc762e0f6918ad5))
ROM_END

MSX_LAYOUT_INIT (fsa1fm)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
/*	MSX_LAYOUT_SLOT (3, 1, 1, 2, MODEM_ROM, 0x20000, 0x20000) */ /* Modem Mapper of FS-CM1/A1FM must be emulated */
/*	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) */ /* FDC Emulation of TC8566AF must be emulated */
/*	MSX_LAYOUT_SLOT (3, 3, 0, 4, FSA1FM_ROM, 0x100000, 0x80000) */ /* Panasonic FS-A1FM Mapper must be emulated */
	MSX_LAYOUT_KANJI (0x40000)
/*	MSX_LAYOUT_KANJI_12 (0x60000) */ /* Matsushita 12 dots Kanji ROM must be emulated */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf500)
	ROM_REGION (0x40000, REGION_CPU1, 0)
	ROM_LOAD ("f500bios.rom", 0x0000, 0x8000, CRC(9b3e7b97) SHA1(0081ea0d25bc5cd8d70b60ad8cfdc7307812c0fd))
	ROM_LOAD ("f500ext.rom", 0x8000, 0x4000, CRC(4a48779c) SHA1(b8e30d604d319d511cbfbc61e5d8c38fbb9c5a33))
	ROM_LOAD ("f500disk.rom", 0xc000, 0x4000, CRC(f7f5b0ea) SHA1(e93b8da1e8dddbb3742292b0e5e58731b90e9313))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("f500kfn.rom", 0x20000, 0x20000, CRC(5a59926e) SHA1(6acaf2eeb57f65f7408235d5e07b7563229de799))
ROM_END

MSX_LAYOUT_INIT (hbf500)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 2, RAM, 0x8000, 0x8000)   /* 32KB RAM */
	MSX_LAYOUT_SLOT (0, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (0, 1, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (0, 2, 0, 2, RAM, 0x8000, 0x0000)   /* 32KB RAM */
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_KANJI (0x20000)
MSX_LAYOUT_END

ROM_START (hbf900)
	ROM_REGION (0x44000, REGION_CPU1, 0)
	ROM_LOAD ("f900bios.rom", 0x0000, 0x8000, CRC(9b3e7b97) SHA1(0081ea0d25bc5cd8d70b60ad8cfdc7307812c0fd))
	ROM_LOAD ("f900ext.rom", 0x8000, 0x4000, CRC(43e7a7fc) SHA1(0fbd45ef3dd7bb82d4c31f1947884f411f1ca344))
	ROM_LOAD ("f900disk.rom", 0xc000, 0x4000, CRC(f83d0ea6) SHA1(fc760d1d7b16370abc7eea39955f230b95b37df6))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("f900util.rom", 0x20000, 0x4000, CRC(bc6c7c66) SHA1(558b7383544542cf7333700ff90c3efbf93ba2a3))
	ROM_LOAD ("f900kfn.rom", 0x24000, 0x20000, CRC(5a59926e) SHA1(6acaf2eeb57f65f7408235d5e07b7563229de799))
ROM_END

MSX_LAYOUT_INIT (hbf900)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (3, 1, 0, 4, RAM_MM, 0x40000, 0x0000)	/* 256KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 1, ROM, 0x4000, 0x10000) 
	MSX_LAYOUT_KANJI (0x24000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf900a)
	ROM_REGION (0x44000, REGION_CPU1, 0)
	ROM_LOAD ("f900bios.rom", 0x0000, 0x8000, CRC(9b3e7b97) SHA1(0081ea0d25bc5cd8d70b60ad8cfdc7307812c0fd))
	ROM_LOAD ("f900ext.rom", 0x8000, 0x4000, CRC(43e7a7fc) SHA1(0fbd45ef3dd7bb82d4c31f1947884f411f1ca344))
	ROM_LOAD ("f900disa.rom", 0xc000, 0x4000, CRC(54c73ad6) SHA1(12f2cc79b3d09723840bae774be48c0d721ec1c6))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("f900util.rom", 0x20000, 0x4000, CRC(bc6c7c66) SHA1(558b7383544542cf7333700ff90c3efbf93ba2a3))
	ROM_LOAD ("f900kfn.rom", 0x24000, 0x20000, CRC(5a59926e) SHA1(6acaf2eeb57f65f7408235d5e07b7563229de799))
ROM_END

MSX_LAYOUT_INIT (hbf900a)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (3, 1, 0, 4, RAM_MM, 0x40000, 0x0000)	/* 256KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 3, 1, 1, ROM, 0x4000, 0x10000) 
	MSX_LAYOUT_KANJI (0x24000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf1)
	ROM_REGION (0x34000, REGION_CPU1,0)
	ROM_LOAD ("f1bios.rom", 0x0000, 0x8000, CRC(9b3e7b97) SHA1(0081ea0d25bc5cd8d70b60ad8cfdc7307812c0fd))
	ROM_LOAD ("f1ext.rom", 0x8000, 0x4000, CRC(4a48779c) SHA1(b8e30d604d319d511cbfbc61e5d8c38fbb9c5a33))
	ROM_FILL (0xc000, 0x14000, 0)
	ROM_LOAD ("f1note1.rom", 0x20000, 0x4000, CRC(84810ea8) SHA1(9db72bb78792595a12499c821048504dc96ef848))
	ROM_LOAD ("f1note2.rom", 0x24000, 0x8000, CRC(e32e5ee0) SHA1(aa78fc9bcd2343f84cf790310a768ee47f90c841))
	ROM_LOAD ("f1note3.rom", 0x2c000, 0x8000, CRC(73eb9329) SHA1(58accf41a90693874b86ce98d8d43c27beb8b6dc))
ROM_END

MSX_LAYOUT_INIT (hbf1)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 1, ROM, 0x4000, 0x20000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x24000)
	MSX_LAYOUT_SLOT (3, 2, 1, 2, ROM, 0x8000, 0x2c000)
	MSX_LAYOUT_SLOT (3, 3, 0, 4, RAM, 0x10000, 0x0000)  /* 64KB RAM */
MSX_LAYOUT_END

ROM_START (hbf12)
	ROM_REGION (0x34000, REGION_CPU1,0)
	ROM_LOAD ("f12bios.rom", 0x0000, 0x8000, CRC(9b3e7b97) SHA1(0081ea0d25bc5cd8d70b60ad8cfdc7307812c0fd))
	ROM_LOAD ("f12ext.rom", 0x8000, 0x4000, CRC(43e7a7fc) SHA1(0fbd45ef3dd7bb82d4c31f1947884f411f1ca344))
	ROM_FILL (0xc000, 0x14000, 0)
	ROM_LOAD ("f12note1.rom", 0x20000, 0x4000, CRC(dcacf970) SHA1(30d914cda2180889a40a3328e0a0c1327f4eaa10))
	ROM_LOAD ("f12note2.rom", 0x24000, 0x8000, CRC(b0241a61) SHA1(ed2fea5c2a3c2e58d4f69f9d636e08574486a2b1))
	ROM_LOAD ("f12note3.rom", 0x2c000, 0x8000, CRC(44a10e6a) SHA1(917d1c079e03c4a44de864f123d03c4e32c8daae))
ROM_END

MSX_LAYOUT_INIT (hbf12)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 1, ROM, 0x4000, 0x20000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x24000)
	MSX_LAYOUT_SLOT (3, 2, 1, 2, ROM, 0x8000, 0x2c000)
	MSX_LAYOUT_SLOT (3, 3, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf1xd)
	ROM_REGION (0x20000, REGION_CPU1,0)
	ROM_LOAD ("f1xdbios.rom", 0x0000, 0x8000, CRC(ba81b3dd) SHA1(4ce41fcc1a603411ec4e99556409c442078f0ecf))
	ROM_LOAD ("f1xdext.rom", 0x8000, 0x4000, CRC(43e7a7fc) SHA1(0fbd45ef3dd7bb82d4c31f1947884f411f1ca344))
	ROM_LOAD ("f1xddisk.rom", 0xc000, 0x4000, CRC(54c73ad6) SHA1(12f2cc79b3d09723840bae774be48c0d721ec1c6))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (hbf1xd)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, DISK_ROM, 0x4000, 0xc000)
	MSX_LAYOUT_SLOT (3, 3, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf1xdm2)
	ROM_REGION (0x20000, REGION_CPU1,0)
	ROM_LOAD ("f1m2bios.rom", 0x0000, 0x8000, CRC(ba81b3dd) SHA1(4ce41fcc1a603411ec4e99556409c442078f0ecf))
	ROM_LOAD ("f1m2ext.rom", 0x8000, 0x4000, CRC(43e7a7fc) SHA1(0fbd45ef3dd7bb82d4c31f1947884f411f1ca344))
	ROM_LOAD ("f1m2disk.rom", 0xc000, 0x4000, CRC(54c73ad6) SHA1(12f2cc79b3d09723840bae774be48c0d721ec1c6))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (hbf1xdm2)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, DISK_ROM, 0x4000, 0xc000)
	MSX_LAYOUT_SLOT (3, 3, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (phc23)
	ROM_REGION (0x20000, REGION_CPU1,0)
	ROM_LOAD ("23bios.rom", 0x0000, 0x8000, CRC(ba81b3dd) SHA1(4ce41fcc1a603411ec4e99556409c442078f0ecf))
	ROM_LOAD ("23ext.rom", 0x8000, 0x4000, CRC(90ca25b5) SHA1(fd9fa78bac25aa3c0792425b21d14e364cf7eea4))
	ROM_FILL (0xc000, 0x14000, 0)
ROM_END

MSX_LAYOUT_INIT (phc23)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM, 0x10000, 0x0000)  /* 64KB RAM */
MSX_LAYOUT_END

ROM_START (cpc300)
	ROM_REGION (0x28000, REGION_CPU1, 0)
	ROM_LOAD ("300bios.rom", 0x0000, 0x8000, CRC(53850907) SHA1(affa3c5cd8db79a1450ad8a7f405a425b251653d))
	ROM_LOAD ("300ext.rom", 0x8000, 0x8000, CRC(d64da39c) SHA1(fb51c505adfbc174df94289fa894ef969f5357bc))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("300han.rom", 0x20000, 0x8000, CRC(e78cd87f) SHA1(47a9d9a24e4fc6f9467c6e7d61a02d45f5a753ef))
ROM_END

MSX_LAYOUT_INIT (cpc300)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 1, 1, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (0, 2, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (0, 3, 0, 2, ROM, 0x8000, 0x8000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (cpc400)
	ROM_REGION (0x50000, REGION_CPU1, 0)
	ROM_LOAD ("400bios.rom", 0x0000, 0x8000, CRC(53850907) SHA1(affa3c5cd8db79a1450ad8a7f405a425b251653d))
	ROM_LOAD ("400disk.rom", 0x8000, 0x4000, CRC(5fa517df) SHA1(914f6ccb25d78621186001f2f5e2aaa2d628cd0c))
	ROM_FILL (0xc000, 0x14000, 0)
	ROM_LOAD ("400ext.rom", 0x20000, 0x8000, CRC(2ba104a3) SHA1(b6d3649a6647fa9f6bd61efc317485a20901128f))
	ROM_LOAD ("400han.rom", 0x28000, 0x8000, CRC(a8ead5e3) SHA1(87936f808423dddfd00629056d6807b4be1dc63e))
	ROM_LOAD ("400kfn.rom", 0x30000, 0x20000, CRC(b663c605) SHA1(965f4982790f1817bcbabbb38c8777183b231a55))
ROM_END

MSX_LAYOUT_INIT (cpc400)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 1, 1, 2, ROM, 0x8000, 0x28000)
	MSX_LAYOUT_SLOT (0, 2, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (0, 3, 0, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 1, 2, DISK_ROM2, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (cpc400s)
	ROM_REGION (0x50000, REGION_CPU1, 0)
	ROM_LOAD ("400sbios.rom", 0x0000, 0x8000, CRC(53850907) SHA1(affa3c5cd8db79a1450ad8a7f405a425b251653d))
	ROM_LOAD ("400sdisk.rom", 0x8000, 0x4000, CRC(5fa517df) SHA1(914f6ccb25d78621186001f2f5e2aaa2d628cd0c))
	ROM_FILL (0xc000, 0x14000, 0)
	ROM_LOAD ("400sext.rom", 0x20000, 0x8000, CRC(2ba104a3) SHA1(b6d3649a6647fa9f6bd61efc317485a20901128f))
	ROM_LOAD ("400shan.rom", 0x28000, 0x8000, CRC(975e7a31) SHA1(6a50295ea35e720ba6f4ba5616c3441128b384ed))
	ROM_LOAD ("400skfn.rom", 0x30000, 0x20000, CRC(fa85368c) SHA1(30fff22e3e3d464993707488442721a5e56a9707))
ROM_END

MSX_LAYOUT_INIT (cpc400s)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 1, 1, 2, ROM, 0x8000, 0x28000)
	MSX_LAYOUT_SLOT (0, 2, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (0, 3, 0, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 1, 2, DISK_ROM2, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf9p)
	ROM_REGION (0x28000, REGION_CPU1, 0)
	ROM_LOAD ("f9pbios.rom", 0x0000, 0x8000, CRC(b31c851d) SHA1(0de3c802057560560a03d7965fcc4cff69f8575c))
	ROM_LOAD ("f9pext.rom", 0x8000, 0x4000, CRC(7c456c8b) SHA1(7b4a96402847decfc110ff9eda713bdcd218bd83))
	ROM_LOAD ("f9pfirm1.rom", 0xc000, 0x4000, CRC(dea2cb50) SHA1(8cc1f7ceeef745bb34e80253971e137213671486))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("f9pfirm2.rom", 0x20000, 0x8000, CRC(ea97069f) SHA1(2d1880d1f5a6944fcb1b198b997a3d90ecd1903d))
ROM_END

MSX_LAYOUT_INIT (hbf9p)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 1, ROM, 0x4000, 0xc000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000) 
	MSX_LAYOUT_SLOT (3, 2, 0, 4, RAM_MM, 0x20000, 0x0000)	/* 128KB Mapper RAM */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf500p)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("500pbios.rom", 0x0000, 0x8000, CRC(b31c851d) SHA1(0de3c802057560560a03d7965fcc4cff69f8575c))
	ROM_LOAD ("500pext.rom", 0x8000, 0x4000, CRC(8f84f783) SHA1(3288894e1be6af705871499b23c85732dbc40993))
	ROM_LOAD ("500pdisk.rom", 0xc000, 0x4000, CRC(54c73ad6) SHA1(12f2cc79b3d09723840bae774be48c0d721ec1c6))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (hbf500p)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 0, 2, 2, RAM, 0x8000, 0x8000)   /* 32KB RAM */
	MSX_LAYOUT_SLOT (0, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (0, 1, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (0, 2, 0, 2, RAM, 0x8000, 0x0000)   /* 32KB RAM */
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, ROM, 0x10000, 0x10000)
MSX_LAYOUT_END

ROM_START (hbf700d)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("700dbios.rom", 0x0000, 0x8000, CRC(e975aa79) SHA1(cef16eb95502ba6ab2265fcafcedde470a101541))
	ROM_LOAD ("700dext.rom", 0x8000, 0x4000, CRC(7c456c8b) SHA1(7b4a96402847decfc110ff9eda713bdcd218bd83))
	ROM_LOAD ("700ddisk.rom", 0xc000, 0x4000, CRC(54c73ad6) SHA1(12f2cc79b3d09723840bae774be48c0d721ec1c6))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (hbf700d)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (3, 3, 0, 4, RAM_MM, 0x40000, 0x0000)	/* 256KB Mapper RAM */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf700p)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("700pbios.rom", 0x0000, 0x8000, CRC(b31c851d) SHA1(0de3c802057560560a03d7965fcc4cff69f8575c))
	ROM_LOAD ("700pext.rom", 0x8000, 0x4000, CRC(8f84f783) SHA1(3288894e1be6af705871499b23c85732dbc40993))
	ROM_LOAD ("700pdisk.rom", 0xc000, 0x4000, CRC(1d9cc7f6) SHA1(3376cf9dd2b1ac9b41bf6bf6598b33136e86f9d5))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (hbf700p)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (3, 3, 0, 4, RAM_MM, 0x40000, 0x0000)	/* 256KB Mapper RAM */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf700s)
	ROM_REGION (0x20000, REGION_CPU1, 0)
	ROM_LOAD ("700sbios.rom", 0x0000, 0x8000, CRC(c2b889a5) SHA1(4811956f878c3e03da46317f787cdc4bebc86f47))
	ROM_LOAD ("700sext.rom", 0x8000, 0x4000, CRC(dc0951bd) SHA1(1e9a955943aeea9b1807ddf1250ba6436d8dd276))
	ROM_LOAD ("700sdisk.rom", 0xc000, 0x4000, CRC(1d9cc7f6) SHA1(3376cf9dd2b1ac9b41bf6bf6598b33136e86f9d5))
	ROM_FILL (0x10000, 0x10000, 0)
ROM_END

MSX_LAYOUT_INIT (hbf700s)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 0, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (3, 3, 0, 4, RAM_MM, 0x40000, 0x0000)	/* 256KB Mapper RAM */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbg900p)
	ROM_REGION (0x28000, REGION_CPU1, 0)
	ROM_LOAD ("g900bios.rom", 0x0000, 0x8000, CRC(b31c851d) SHA1(0de3c802057560560a03d7965fcc4cff69f8575c))
	ROM_LOAD ("g900ext.rom", 0x8000, 0x4000, CRC(8f84f783) SHA1(3288894e1be6af705871499b23c85732dbc40993))
	ROM_LOAD ("g900disk.rom", 0xc000, 0x4000, CRC(54c73ad6) SHA1(12f2cc79b3d09723840bae774be48c0d721ec1c6))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("g900232c.rom", 0x20000, 0x4000, CRC(06cf1da6) SHA1(373aa82d0426830880a7344ef98f7309d93814c7))
	ROM_LOAD ("g900util.rom", 0x24000, 0x4000, CRC(d0417c20) SHA1(8779b004e7605a3c419825f0373a5d8fa84e1d5b))
ROM_END

MSX_LAYOUT_INIT (hbg900p)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (0, 1, 1, 2, DISK_ROM, 0x4000, 0xc000) 
/*	MSX_LAYOUT_SLOT (0, 2, 1, 1, ROM, 0x4000, 0x20000) */ /* RS232C must be emulated */
	MSX_LAYOUT_SLOT (0, 3, 1, 1, ROM, 0x4000, 0x24000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000) 
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)	/* 64KB Mapper RAM */
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (msx2p)
	ROM_REGION (0x48000, REGION_CPU1,0)
	ROM_LOAD ("msx2p.rom", 0x0000, 0x8000, CRC(00870134) SHA1(e2fbd56e42da637609d23ae9df9efd1b4241b18a))
	ROM_LOAD ("msx2pext.rom", 0x8000, 0x4000, CRC(b8ba44d3) SHA1(fe0254cbfc11405b79e7c86c7769bd6322b04995))
	ROM_LOAD_OPTIONAL ("disk.rom", 0xc000, 0x4000, CRC(b7c58fad) SHA1(bc517b4a248c3a1338c5efc937b0128b6a783808))
	ROM_LOAD_OPTIONAL ("fmpac.rom", 0x10000, 0x10000, CRC(0e84505d) SHA1(9d789166e3caf28e4742fe933d962e99618c633d))
	ROM_LOAD ("msx2pkdr.rom", 0x20000, 0x8000, CRC(a068cba9) SHA1(1ef3956f7f918873fb9b031339bba45d1e5e5878))
	ROM_LOAD ("msx2pkfn.rom", 0x28000, 0x20000, CRC(b244f6cf) SHA1(e0e99cd91e88ce2676445663f832c835d74d6fd4))
ROM_END

MSX_LAYOUT_INIT (msx2p)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x20000, 0x0000)   /* 128KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_KANJI (0x28000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (fsa1fx)
	ROM_REGION (0x50000, REGION_CPU1,0)
	ROM_LOAD ("a1fxbios.rom", 0x0000, 0x8000, CRC(19771608) SHA1(e90f80a61d94c617850c415e12ad70ac41e66bb7))
	ROM_LOAD ("a1fxext.rom", 0x8000, 0x4000, CRC(b8ba44d3) SHA1(fe0254cbfc11405b79e7c86c7769bd6322b04995))
	ROM_LOAD ("a1fxdisk.rom", 0xc000, 0x4000, CRC(905daa1b) SHA1(bb59c849898d46a23fdbd0cc04ab35088e74a18d))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("a1fxkdr.rom", 0x20000, 0x8000, CRC(a068cba9) SHA1(1ef3956f7f918873fb9b031339bba45d1e5e5878))
	ROM_LOAD ("a1fxcock.rom", 0x28000, 0x8000, CRC(f662e6eb) SHA1(9d67fab55b85f4ac4f5924323a70020eb8589057))
	ROM_LOAD ("a1fxkfn.rom", 0x30000, 0x20000, CRC(b244f6cf) SHA1(e0e99cd91e88ce2676445663f832c835d74d6fd4))
ROM_END

MSX_LAYOUT_INIT (fsa1fx)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
/*	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) */ /* FDC Emulation of TC8566AF must be emulated */
	MSX_LAYOUT_SLOT (3, 3, 1, 2, ROM, 0x8000, 0x28000)
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (fsa1wx)
	ROM_REGION (0x270000, REGION_CPU1,0)
	ROM_LOAD ("a1wxbios.rom", 0x0000, 0x8000, CRC(19771608) SHA1(e90f80a61d94c617850c415e12ad70ac41e66bb7))
	ROM_LOAD ("a1wxext.rom", 0x8000, 0x4000, CRC(b8ba44d3) SHA1(fe0254cbfc11405b79e7c86c7769bd6322b04995))
	ROM_LOAD ("a1wxdisk.rom", 0xc000, 0x4000, CRC(905daa1b) SHA1(bb59c849898d46a23fdbd0cc04ab35088e74a18d))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("a1wxkdr.rom", 0x20000, 0x8000, CRC(a068cba9) SHA1(1ef3956f7f918873fb9b031339bba45d1e5e5878))
	ROM_LOAD ("a1wxmus.rom", 0x28000, 0x4000, CRC(5c32eb29) SHA1(aad42ba4289b33d8eed225d42cea930b7fc5c228))
	ROM_FILL (0x2c000, 0x4000, 0)
	ROM_LOAD ("a1wxkfn.rom", 0x30000, 0x40000, CRC(1f6406fb) SHA1(5aff2d9b6efc723bc395b0f96f0adfa83cc54a49))
	ROM_LOAD ("a1wxfirm.rom", 0x70000, 0x200000, CRC(283f3250) SHA1(d37ab4bd2bfddd8c97476cbe7347ae581a6f2972))
ROM_END

MSX_LAYOUT_INIT (fsa1wx)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 2, 1, 1, ROM, 0x4000, 0x28000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
/*	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) */ /* FDC Emulation of TC8566AF must be emulated */
/*	MSX_LAYOUT_SLOT (3, 3, 1, 4, PANASONIC08, 0x200000, 0x70000) */ /* Panasonic 08KB Mapper must be emulated */
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (fsa1wxa)
	ROM_REGION (0x270000, REGION_CPU1,0)
	ROM_LOAD ("a1wxbios.rom", 0x0000, 0x8000, CRC(19771608) SHA1(e90f80a61d94c617850c415e12ad70ac41e66bb7))
	ROM_LOAD ("a1wxext.rom", 0x8000, 0x4000, CRC(b8ba44d3) SHA1(fe0254cbfc11405b79e7c86c7769bd6322b04995))
	ROM_LOAD ("a1wxdisk.rom", 0xc000, 0x4000, CRC(905daa1b) SHA1(bb59c849898d46a23fdbd0cc04ab35088e74a18d))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("a1wxkdr.rom", 0x20000, 0x8000, CRC(a068cba9) SHA1(1ef3956f7f918873fb9b031339bba45d1e5e5878))
	ROM_LOAD ("a1wxmus.rom", 0x28000, 0x4000, CRC(5c32eb29) SHA1(aad42ba4289b33d8eed225d42cea930b7fc5c228))
	ROM_FILL (0x2c000, 0x4000, 0)
	ROM_LOAD ("a1wxkfn.rom", 0x30000, 0x40000, CRC(1f6406fb) SHA1(5aff2d9b6efc723bc395b0f96f0adfa83cc54a49))
	ROM_LOAD ("a1wxfira.rom", 0x70000, 0x200000, CRC(58440a8e) SHA1(8e0d4a77e7d5736e8225c2df4701509363eb230f))
ROM_END

MSX_LAYOUT_INIT (fsa1wxa)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 2, 1, 1, ROM, 0x4000, 0x28000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
/*	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) */ /* FDC Emulation of TC8566AF must be emulated */
/*	MSX_LAYOUT_SLOT (3, 3, 1, 4, PANASONIC08, 0x200000, 0x70000) */ /* Panasonic 08KB Mapper must be emulated */
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (fsa1wsx)
	ROM_REGION (0x270000, REGION_CPU1,0)
	ROM_LOAD ("a1wsbios.rom", 0x0000, 0x8000, CRC(358ec547) SHA1(f4433752d3bf876bfefb363c749d4d2e08a218b6))
	ROM_LOAD ("a1wsext.rom", 0x8000, 0x4000, CRC(b8ba44d3) SHA1(fe0254cbfc11405b79e7c86c7769bd6322b04995))
	ROM_LOAD ("a1wsdisk.rom", 0xc000, 0x4000, CRC(17fa392b) SHA1(7ed7c55e0359737ac5e68d38cb6903f9e5d7c2b6))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("a1wskdr.rom", 0x20000, 0x8000, CRC(b4fc574d) SHA1(dcc3a67732aa01c4f2ee8d1ad886444a4dbafe06))
	ROM_LOAD ("a1wsmus.rom", 0x28000, 0x4000, CRC(5c32eb29) SHA1(aad42ba4289b33d8eed225d42cea930b7fc5c228))
	ROM_FILL (0x2c000, 0x4000, 0)
	ROM_LOAD ("a1wskfn.rom", 0x30000, 0x40000, CRC(1f6406fb) SHA1(5aff2d9b6efc723bc395b0f96f0adfa83cc54a49))
	ROM_LOAD ("a1wsfirm.rom", 0x70000, 0x200000, CRC(e363595d) SHA1(3330d9b6b76e3c4ccb7cf252496ed15d08b95d3f))
ROM_END

MSX_LAYOUT_INIT (fsa1wsx)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (0, 2, 1, 1, ROM, 0x4000, 0x28000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
/*	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) */ /* FDC Emulation of TC8566AF must be emulated */
/*	MSX_LAYOUT_SLOT (3, 3, 1, 4, PANASONIC08, 0x200000, 0x70000) */ /* Panasonic 08KB Mapper must be emulated */
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf1xdj)
	ROM_REGION (0x170000, REGION_CPU1,0)
	ROM_LOAD ("f1xjbios.rom", 0x0000, 0x8000, CRC(00870134) SHA1(e2fbd56e42da637609d23ae9df9efd1b4241b18a))
	ROM_LOAD ("f1xjext.rom", 0x8000, 0x4000, CRC(b8ba44d3) SHA1(fe0254cbfc11405b79e7c86c7769bd6322b04995))
	ROM_LOAD ("f1xjdisk.rom", 0xc000, 0x4000, CRC(a21f5266) SHA1(c1bb307a570ab833e3bfcc4a58a4f4e12dc1df0f))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("f1xjkdr.rom", 0x20000, 0x8000, CRC(a068cba9) SHA1(1ef3956f7f918873fb9b031339bba45d1e5e5878))
	ROM_LOAD ("f1xjmus.rom", 0x28000, 0x4000, CRC(5c32eb29) SHA1(aad42ba4289b33d8eed225d42cea930b7fc5c228))
	ROM_FILL (0x2c000, 0x4000, 0)
	ROM_LOAD ("f1xjkfn.rom", 0x30000, 0x40000, CRC(7016dfd0) SHA1(218d91eb6df2823c924d3774a9f455492a10aecb))
	ROM_LOAD ("f1xjfirm.rom", 0x70000, 0x100000, CRC(77be583f) SHA1(ade0c5ba5574f8114d7079050317099b4519e88f))
ROM_END

MSX_LAYOUT_INIT (hbf1xdj)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
/*	MSX_LAYOUT_SLOT (0, 3, 1, 4, SONY08, 0x100000, 0x70000) */ /* Sony 08KB MSX-JE Mapper must be emulated */
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (3, 3, 1, 1, ROM, 0x4000, 0x28000)
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (hbf1xv)
	ROM_REGION (0x170000, REGION_CPU1,0)
	ROM_LOAD ("f1xvbios.rom", 0x0000, 0x8000, CRC(2c7ed27b) SHA1(174c9254f09d99361ff7607630248ff9d7d8d4d6))
	ROM_LOAD ("f1xvext.rom", 0x8000, 0x4000, CRC(b8ba44d3) SHA1(fe0254cbfc11405b79e7c86c7769bd6322b04995))
	ROM_LOAD ("f1xvdisk.rom", 0xc000, 0x4000, CRC(04e4e533) SHA1(5a4e7dbbfb759109c7d2a3b38bda9c60bf6ffef5))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("f1xvkdr.rom", 0x20000, 0x8000, CRC(b4fc574d) SHA1(dcc3a67732aa01c4f2ee8d1ad886444a4dbafe06))
	ROM_LOAD ("f1xvmus.rom", 0x28000, 0x4000, CRC(5c32eb29) SHA1(aad42ba4289b33d8eed225d42cea930b7fc5c228))
	ROM_FILL (0x2c000, 0x4000, 0)
	ROM_LOAD ("f1xvkfn.rom", 0x30000, 0x40000, CRC(7016dfd0) SHA1(218d91eb6df2823c924d3774a9f455492a10aecb))
	ROM_LOAD ("f1xvfirm.rom", 0x70000, 0x100000, CRC(77be583f) SHA1(ade0c5ba5574f8114d7079050317099b4519e88f))
ROM_END

MSX_LAYOUT_INIT (hbf1xv)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
/*	MSX_LAYOUT_SLOT (0, 3, 1, 4, SONY08, 0x100000, 0x70000) */ /* Sony 08KB MSX-JE Mapper must be emulated */
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) 
	MSX_LAYOUT_SLOT (3, 3, 1, 1, ROM, 0x4000, 0x28000)
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (phc70fd)
	ROM_REGION (0x50000, REGION_CPU1,0)
	ROM_LOAD ("70fdbios.rom", 0x0000, 0x8000, CRC(19771608) SHA1(e90f80a61d94c617850c415e12ad70ac41e66bb7))
	ROM_LOAD ("70fdext.rom", 0x8000, 0x4000, CRC(b8ba44d3) SHA1(fe0254cbfc11405b79e7c86c7769bd6322b04995))
	ROM_LOAD ("70fddisk.rom", 0xc000, 0x4000, CRC(db7f1125) SHA1(9efa744be8355675e7bfdd3976bbbfaf85d62e1d))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("70fdkdr.rom", 0x20000, 0x8000, CRC(a068cba9) SHA1(1ef3956f7f918873fb9b031339bba45d1e5e5878))
	ROM_LOAD ("70fdmus.rom", 0x28000, 0x4000, CRC(5c32eb29) SHA1(aad42ba4289b33d8eed225d42cea930b7fc5c228))
	ROM_LOAD ("70fdbas.rom", 0x2c000, 0x4000, CRC(da7be246) SHA1(22b3191d865010264001b9d896186a9818478a6b))
	ROM_LOAD ("70fdkfn.rom", 0x30000, 0x20000, CRC(c9651b32) SHA1(84a645becec0a25d3ab7a909cde1b242699a8662))
ROM_END

MSX_LAYOUT_INIT (phc70fd)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
/*	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) */ /* FDC Emulation of TC8566AF must be emulated */
	MSX_LAYOUT_SLOT (3, 3, 1, 1, ROM, 0x4000, 0x28000)
	MSX_LAYOUT_SLOT (3, 3, 2, 1, ROM, 0x4000, 0x2c000)
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (phc70fd2)
	ROM_REGION (0x70000, REGION_CPU1,0)
	ROM_LOAD ("70f2bios.rom", 0x0000, 0x8000, CRC(19771608) SHA1(e90f80a61d94c617850c415e12ad70ac41e66bb7))
	ROM_LOAD ("70f2ext.rom", 0x8000, 0x4000, CRC(b8ba44d3) SHA1(fe0254cbfc11405b79e7c86c7769bd6322b04995))
	ROM_LOAD ("70f2disk.rom", 0xc000, 0x4000, CRC(db7f1125) SHA1(9efa744be8355675e7bfdd3976bbbfaf85d62e1d))
	ROM_FILL (0x10000, 0x10000, 0)
	ROM_LOAD ("70f2kdr.rom", 0x20000, 0x8000, CRC(a068cba9) SHA1(1ef3956f7f918873fb9b031339bba45d1e5e5878))
	ROM_LOAD ("70f2mus.rom", 0x28000, 0x4000, CRC(5c32eb29) SHA1(aad42ba4289b33d8eed225d42cea930b7fc5c228))
	ROM_LOAD ("70f2bas.rom", 0x2c000, 0x4000, CRC(da7be246) SHA1(22b3191d865010264001b9d896186a9818478a6b))
	ROM_LOAD ("70f2kfn.rom", 0x30000, 0x40000, CRC(9a850db9) SHA1(bcdb4dae303dfe5234f372d70a5e0271d3202c36))
ROM_END

MSX_LAYOUT_INIT (phc70fd2)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
/*	MSX_LAYOUT_SLOT (3, 2, 1, 2, DISK_ROM, 0x4000, 0xc000) */ /* FDC Emulation of TC8566AF must be emulated */
	MSX_LAYOUT_SLOT (3, 3, 1, 1, ROM, 0x4000, 0x28000)
	MSX_LAYOUT_SLOT (3, 3, 2, 1, ROM, 0x4000, 0x2c000)
	MSX_LAYOUT_KANJI (0x30000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

ROM_START (phc35j)
	ROM_REGION (0x48000, REGION_CPU1,0)
	ROM_LOAD ("35jbios.rom", 0x0000, 0x8000, CRC(358ec547) SHA1(f4433752d3bf876bfefb363c749d4d2e08a218b6))
	ROM_LOAD ("35jext.rom", 0x8000, 0x4000, CRC(b8ba44d3) SHA1(fe0254cbfc11405b79e7c86c7769bd6322b04995))
	ROM_FILL (0xc000, 0x14000, 0)
	ROM_LOAD ("35jkdr.rom", 0x20000, 0x8000, CRC(b4fc574d) SHA1(dcc3a67732aa01c4f2ee8d1ad886444a4dbafe06))
	ROM_LOAD ("35jkfn.rom", 0x28000, 0x20000, CRC(c9651b32) SHA1(84a645becec0a25d3ab7a909cde1b242699a8662))
ROM_END

MSX_LAYOUT_INIT (phc35j)
	MSX_LAYOUT_SLOT (0, 0, 0, 2, ROM, 0x8000, 0x0000)
	MSX_LAYOUT_SLOT (1, 0, 0, 4, CARTRIDGE1, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (2, 0, 0, 4, CARTRIDGE2, 0x0000, 0x0000)
	MSX_LAYOUT_SLOT (3, 0, 0, 4, RAM_MM, 0x10000, 0x0000)   /* 64KB Mapper RAM */
	MSX_LAYOUT_SLOT (3, 1, 0, 1, ROM, 0x4000, 0x8000)
	MSX_LAYOUT_SLOT (3, 1, 1, 2, ROM, 0x8000, 0x20000)
	MSX_LAYOUT_KANJI (0x28000)
	MSX_LAYOUT_RAMIO_SET_BITS (0x80)
MSX_LAYOUT_END

static void msx_floppy_getinfo(const device_class *devclass, UINT32 state, union devinfo *info)
{
	/* floppy */
	switch(state)
	{
		/* --- the following bits of info are returned as 64-bit signed integers --- */
		case DEVINFO_INT_COUNT:							info->i = 2; break;

		/* --- the following bits of info are returned as pointers to data or functions --- */
		case DEVINFO_PTR_LOAD:							info->load = device_load_msx_floppy; break;

		/* --- the following bits of info are returned as NULL-terminated strings --- */
		case DEVINFO_STR_FILE_EXTENSIONS:				strcpy(info->s = device_temp_str(), "dsk"); break;

		default:										legacybasicdsk_device_getinfo(devclass, state, info); break;
	}
}

static void msx_cartslot_getinfo(const device_class *devclass, UINT32 state, union devinfo *info)
{
	/* cartslot */
	switch(state)
	{
		/* --- the following bits of info are returned as 64-bit signed integers --- */
		case DEVINFO_INT_COUNT:							info->i = MSX_MAX_CARTS; break;

		/* --- the following bits of info are returned as pointers to data or functions --- */
		case DEVINFO_PTR_LOAD:							info->load = device_load_msx_cart; break;
		case DEVINFO_PTR_UNLOAD:						info->unload = device_unload_msx_cart; break;

		/* --- the following bits of info are returned as NULL-terminated strings --- */
		case DEVINFO_STR_FILE_EXTENSIONS:				strcpy(info->s = device_temp_str(), "mx1,rom"); break;

		default:										cartslot_device_getinfo(devclass, state, info); break;
	}
}

static void msx_cassette_getinfo(const device_class *devclass, UINT32 state, union devinfo *info)
{
	/* cassette */
	switch(state)
	{
		/* --- the following bits of info are returned as 64-bit signed integers --- */
		case DEVINFO_INT_COUNT:							info->i = 1; break;

		/* --- the following bits of info are returned as pointers to data or functions --- */
		case DEVINFO_PTR_CASSETTE_FORMATS:				info->p = (void *) fmsx_cassette_formats; break;

		default:										cassette_device_getinfo(devclass, state, info); break;
	}
}

static void msx_printer_getinfo(const device_class *devclass, UINT32 state, union devinfo *info)
{
	/* printer */
	switch(state)
	{
		/* --- the following bits of info are returned as 64-bit signed integers --- */
		case DEVINFO_INT_COUNT:							info->i = 1; break;

		default:										printer_device_getinfo(devclass, state, info); break;
	}
}

SYSTEM_CONFIG_START(msx)
	CONFIG_DEVICE(msx_floppy_getinfo)
	CONFIG_DEVICE(msx_cartslot_getinfo)
	CONFIG_DEVICE(msx_cassette_getinfo)
	CONFIG_DEVICE(msx_printer_getinfo)
SYSTEM_CONFIG_END

MSX_DRIVER_LIST
	MSX_DRIVER (msx) 
	MSX_DRIVER (hb75d)
	MSX_DRIVER (hb75p)
	MSX_DRIVER (hb501p)
	MSX_DRIVER (hb201p)
	MSX_DRIVER (svi738)
	MSX_DRIVER (cf2000)
	MSX_DRIVER (cf1200)
	MSX_DRIVER (cf2700)
	MSX_DRIVER (cf3000)
	MSX_DRIVER (cf3300)
	MSX_DRIVER (fs4000)
	MSX_DRIVER (fs1300)
	MSX_DRIVER (hb201)
	MSX_DRIVER (dpc100) 
	MSX_DRIVER (dpc180) 
	MSX_DRIVER (dpc200) 
	MSX_DRIVER (hotbit11) 
	MSX_DRIVER (hotbit12) 
	MSX_DRIVER (expert10) 
	MSX_DRIVER (expert11) 
	MSX_DRIVER (expertdp) 
	MSX_DRIVER (msx2) 
	MSX_DRIVER (nms8220)
	MSX_DRIVER (nms8220a)
	MSX_DRIVER (vg8235)
	MSX_DRIVER (nms8245)
	MSX_DRIVER (nms8250)
	MSX_DRIVER (nms8255)
	MSX_DRIVER (nms8280)
	MSX_DRIVER (hbf9p)
	MSX_DRIVER (hbf500p)
	MSX_DRIVER (hbf700d)
	MSX_DRIVER (hbf700p)
	MSX_DRIVER (hbf700s) 
	MSX_DRIVER (hbg900p)
	MSX_DRIVER (fs5500)
	MSX_DRIVER (fs4500)
	MSX_DRIVER (fs4700)
	MSX_DRIVER (fs5000)
	MSX_DRIVER (fs4600)
	MSX_DRIVER (fsa1)
	MSX_DRIVER (fsa1a)
	MSX_DRIVER (fsa1mk2)
	MSX_DRIVER (fsa1f)
	MSX_DRIVER (fsa1fm)
	MSX_DRIVER (hbf500)
	MSX_DRIVER (hbf900)
	MSX_DRIVER (hbf900a)
	MSX_DRIVER (hbf1)
	MSX_DRIVER (hbf12)
	MSX_DRIVER (hbf1xd)
	MSX_DRIVER (hbf1xdm2)
	MSX_DRIVER (phc23)
	MSX_DRIVER (cpc300)
	MSX_DRIVER (cpc400)
	MSX_DRIVER (cpc400s)
	MSX_DRIVER (msx2p)
	MSX_DRIVER (fsa1fx)
	MSX_DRIVER (fsa1wx)
	MSX_DRIVER (fsa1wxa)
	MSX_DRIVER (fsa1wsx)
 	MSX_DRIVER (hbf1xdj)
	MSX_DRIVER (hbf1xv)
	MSX_DRIVER (phc70fd2)
	MSX_DRIVER (phc35j)
MSX_DRIVER_END

/*	  YEAR	NAME	  PARENT	COMPAT	MACHINE  INPUT	   INIT   CONFIG  COMPANY			   FULLNAME */
COMP( 1983,	msx,	  0,		0,		msx_pal, msx,	   msx,		msx,	"ASCII & Microsoft", "MSX" , 0)
COMP( 1983, hb75d,	  msx,		0,		msx_pal, msx,      msx,		msx,	"Sony", "HB-75D (Germany)" , 0)
COMP( 1983, hb75p,	  msx,		0,		msx_pal, msx,      msx,		msx,	"Sony", "HB-75P" , 0)
COMP( 1984, hb501p,	  msx,		0,		msx_pal, msx,      msx,		msx,	"Sony", "HB-501P" , 0)
COMP( 1985, hb201p,	  msx,		0,		msx_pal, msx,      msx,		msx,	"Sony", "HB-201P" , 0)
COMP(1985, svi738,	  msx,		0,		msx_pal, msx,      msx,		msx,	"Spectravideo", "SVI-738", GAME_NOT_WORKING )
COMP( 1983, cf2000,   msx,      0,      msx,     msxjp,    msx,     msx,    "National / Matsushita", "CF-2000 (Japan)" , 0)
COMP( 1984, cf1200,   msx,      0,      msx,     msxjp,    msx,     msx,    "National / Matsushita", "CF-1200 (Japan)" , 0)
COMP( 1984, cf2700,   msx,		0,      msx,     msxjp,    msx,     msx,    "National / Matsushita", "CF-2700 (Japan)" , 0)
COMP( 1984, cf3000,   msx,		0,      msx,     msxjp,    msx,     msx,    "National / Matsushita", "CF-3000 (Japan)" , 0)
COMP(1985, cf3300,   msx,		0,      msx,     msxjp,    msx,     msx,    "National / Matsushita", "CF-3300 (Japan)", GAME_NOT_WORKING )
COMP( 1985, fs4000,   msx,      0,      msx,     msxjp,    msx,     msx,    "National / Matsushita", "FS-4000 (Japan)" , 0)
COMP( 1985, fs1300,   msx,		0,      msx,     msxjp,    msx,     msx,    "National / Matsushita", "FS-1300 (Japan)" , 0)
COMP( 1985, hb201,    msx,		0,      msx,     msxjp,    msx,     msx,    "Sony", "HB-201 (Japan)" , 0)
COMP( 1984, dpc100,	  msx,		0,		msx,	 msxkr,    msx,		msx,	"Daewoo", "IQ-1000 DPC-100 (Korea)" , 0)
COMP( 1984, dpc180,	  msx,		0,		msx,	 msxkr,    msx,		msx,	"Daewoo", "IQ-1000 DPC-180 (Korea)" , 0)
COMP( 1984, dpc200,	  msx,		0,		msx,	 msxkr,    msx,		msx,	"Daewoo", "IQ-1000 DPC-200 (Korea)" , 0)
COMP( 1985, hotbit11, msx,		0,		msx,	 hotbit,   msx,		msx,	"Sharp / Epcom",	 "HB-8000 Hotbit 1.1" , 0)
COMP( 1985, hotbit12, msx,		0,		msx,	 hotbit,   msx,		msx,	"Sharp / Epcom",	 "HB-8000 Hotbit 1.2" , 0)
COMP( 1983, expert10, msx,		0,		msx,	 expert10, msx,		msx,	"Gradiente", "Expert (Brazil)" , 0)
COMP( 1984, expert11, msx,		0,		msx,	 expert11, msx,		msx,	"Gradiente", "Expert Plus (Brazil)" , 0)
COMP(1985, expertdp, msx,		0,		msx,	 expert11, msx,		msx,	"Gradiente", "Expert DDPlus (Brazil)", GAME_NOT_WORKING )
COMP (1985, msx2,	  0,		msx,	msx2,	 msx2,	   msx2,	msx,	"ASCII & Microsoft", "MSX2", 0)
COMP (1986, nms8220,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Philips", "NMS-8220 / 1st released version", 0)
COMP (1986, nms8220a, msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Philips", "NMS-8220 / 2nd released version", 0)
COMP (1986, vg8235,   msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Philips", "VG-8235", 0)
COMP (1986, nms8245,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Philips", "NMS-8245", 0)
COMP (1986, nms8250,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Philips", "NMS-8250", 0)
COMP (1986, nms8255,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Philips", "NMS-8255", 0)
COMP (1986, nms8280,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Philips", "NMS-8280", 0)
COMP (1985, hbf9p,    msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Sony", "HB-F9P" , 0)
COMP (1985, hbf500p,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Sony", "HB-F500P", 0)
COMP (1985, hbf700d,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Sony", "HB-F700D (Germany)" , 0)
COMP (1985, hbf700p,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Sony", "HB-F700P" , 0)
COMP (1985, hbf700s,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Sony", "HB-F700S (Spain)", 0)
COMP(1986, hbg900p,  msx2,		0,		msx2,	 msx2,	   msx2,	msx,	"Sony", "HB-G900P", GAME_NOT_WORKING )
COMP(1985, fs5500,   msx2,		0,      msx2,    msx2jp,   msx2,    msx,    "National / Matsushita", "FS-5500F1/F2 (Japan)", GAME_NOT_WORKING )
COMP(1986, fs4500,   msx2,		0,      msx2,    msx2jp,   msx2,    msx,    "National / Matsushita", "FS-4500 (Japan)", GAME_NOT_WORKING )
COMP(1986, fs4700,   msx2,		0,      msx2,    msx2jp,   msx2,    msx,    "National / Matsushita", "FS-4700 (Japan)", GAME_NOT_WORKING )
COMP(1986, fs5000,   msx2,		0,      msx2,    msx2jp,   msx2,    msx,    "National / Matsushita", "FS-5000F2 (Japan)", GAME_NOT_WORKING )
COMP(1986, fs4600,   msx2,		0,      msx2,    msx2jp,   msx2,    msx,    "National / Matsushita", "FS-4600 (Japan)", GAME_NOT_WORKING )
COMP (1986, fsa1,     msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Panasonic / Matsushita", "FS-A1 / 1st released version (Japan)", 0)
COMP (1986, fsa1a,    msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Panasonic / Matsushita", "FS-A1 / 2nd released version (Japan)", 0)
COMP (1987, fsa1mk2,  msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Panasonic / Matsushita", "FS-A1MK2 (Japan)", 0)
COMP(1987, fsa1f,    msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Panasonic / Matsushita", "FS-A1F (Japan)", GAME_NOT_WORKING )
COMP(1987, fsa1fm,   msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Panasonic / Matsushita", "FS-A1FM (Japan)", GAME_NOT_WORKING )
COMP (1986, hbf500,   msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Sony", "HB-F500 (Japan)", 0)
COMP (1986, hbf900,   msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Sony", "HB-F900 / 1st released version (Japan)", 0)
COMP (1986, hbf900a,  msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Sony", "HB-F900 / 2nd released version (Japan)", 0)
COMP(1986, hbf1,     msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Sony", "HB-F1 (Japan)", GAME_NOT_WORKING )
COMP(1987, hbf12,    msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Sony", "HB-F1II (Japan)", GAME_NOT_WORKING )
COMP (1987, hbf1xd,   msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Sony", "HB-F1XD (Japan)", 0)
COMP (1988, hbf1xdm2, msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Sony", "HB-F1XDMK2 (Japan)", 0)
COMP (1988, phc23,    msx2,     0,      msx2,    msx2jp,   msx2,    msx,    "Sanyo", "WAVY PHC-23 (Japan)", 0)
COMP (1986, cpc300,	  msx2,		0,		msx2,	 msx2kr,   msx2,	msx,	"Daewoo", "IQ-2000 CPC-300 (Korea)", 0)
COMP(1986, cpc400,	  msx2,		0,		msx2,	 msx2kr,   msx2,	msx,	"Daewoo", "X-II CPC-400 (Korea)", GAME_NOT_WORKING )
COMP(1986, cpc400s,  msx2,		0,		msx2,	 msx2kr,   msx2,	msx,	"Daewoo", "X-II CPC-400S (Korea)", GAME_NOT_WORKING )
COMP (1988, msx2p,	  0,		msx,	msx2,	 msx2jp,   msx2,	msx,	"ASCII & Microsoft", "MSX2+", 0)
COMP(1988, fsa1fx,   msx2p,    0,      msx2,    msx2jp,   msx2,    msx,    "Panasonic / Matsushita", "FS-A1FX (Japan)", GAME_NOT_WORKING )
COMP(1988, fsa1wx,   msx2p,    0,      msx2,    msx2jp,   msx2,    msx,    "Panasonic / Matsushita", "FS-A1WX / 1st released version (Japan)", GAME_NOT_WORKING )
COMP(1988, fsa1wxa,  msx2p,    0,      msx2,    msx2jp,   msx2,    msx,    "Panasonic / Matsushita", "FS-A1WX / 2nd released version (Japan)", GAME_NOT_WORKING )
COMP(1989, fsa1wsx,  msx2p,    0,      msx2,    msx2jp,   msx2,    msx,    "Panasonic / Matsushita", "FS-A1WSX (Japan)", GAME_NOT_WORKING )
COMP(1988, hbf1xdj,  msx2p,    0,      msx2,    msx2jp,   msx2,    msx,    "Sony", "HB-F1XDJ (Japan)", GAME_NOT_WORKING )
COMP(1989, hbf1xv,   msx2p,    0,      msx2,    msx2jp,   msx2,    msx,    "Sony", "HB-F1XV (Japan)", GAME_NOT_WORKING )
COMP(1988, phc70fd,  msx2p,    0,      msx2,    msx2jp,   msx2,    msx,    "Sanyo", "WAVY PHC-70FD (Japan)", GAME_NOT_WORKING )
COMP(1988, phc70fd2, msx2p,    0,      msx2,    msx2jp,   msx2,    msx,    "Sanyo", "WAVY PHC-70FD2 (Japan)", GAME_NOT_WORKING )
COMP (1989, phc35j,   msx2p,    0,      msx2,    msx2jp,   msx2,    msx,    "Sanyo", "WAVY PHC-35J (Japan)", 0)

