/* Steve, the jobserver
 * (c) 2025 Michał Górny
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include <climits>
#include <cstdlib>

#include <unistd.h>

struct fd_guard {
	int fd;
	~fd_guard() { close(fd); }
};

static bool arg_to_long(const char *optarg, long *out) {
	char *endptr;
	errno = 0;
	*out = strtol(optarg, &endptr, 10);
	return (
		!*endptr && errno == 0 && *out >= 0 && *out < INT_MAX
	);
}

static bool arg_to_double(const char *optarg, double *out) {
	char *endptr;
	errno = 0;
	*out = strtod(optarg, &endptr);
	return (
		!*endptr && errno == 0
	);
}

#define SIGSTR(x) case SIG##x: return #x

static const char *signal_name(int signo)
{
	switch (signo) {
		SIGSTR(HUP);
		SIGSTR(INT);
		SIGSTR(TERM);
		SIGSTR(USR1);
		SIGSTR(USR2);
		default:
			assert(0 && "not reached");
			return "?";
	}
}

#undef SIGSTR
