# Documentation issues

Our documentation is composed of more than 80 pages and includes extensive
information on features, configurations, customizations, and much more. If you
have found an inconsistency or see room for improvement, please follow this
guide to submit an issue on our [issue tracker].

  [issue tracker]: https://github.com/squidfunk/mkdocs-material/issues

## Issue template

Reporting a documentation issue is usually less involved than reporting a bug,
as we don't need a [reproduction]. Please thoroughly read this guide before
creating a new documentation issue, and provide the following information as
part of the issue:

- [Title]
- [Description]
- [Related links]
- [Proposed change] <small>optional</small>
- [Checklist]

  [reproduction]: ../guides/creating-a-reproduction.md
  [Title]: #title
  [Description]: #description
  [Related links]: #related-links
  [Proposed change]: #proposed-change
  [Checklist]: #checklist

### Title

A good title should be a short, one-sentence description of the issue, contain
all relevant information and, in particular, keywords to simplify the search in
our issue tracker.

| <!-- --> | Example  |
| -------- | -------- |
| :material-check:{ style="color: #4DB6AC" } __Clear__ | Clarify social cards setup on Windows
| :material-close:{ style="color: #EF5350" } __Unclear__ | Missing information in the docs
| :material-close:{ style="color: #EF5350" } __Useless__ | Help

### Description

Provide a clear and concise summary of the inconsistency or issue you
encountered in the documentation or the documentation section that needs
improvement. Explain why you think the documentation should be adjusted and
describe the severity of the issue:

-   __Keep it short and concise__ – if the inconsistency or issue can be
    precisely explained in one or two sentences, perfect. Maintainers and future
    users will be grateful for having to read less.

-   __One issue at a time__ – if you encounter several unrelated inconsistencies,
    please create separate issues for them. Don't report them in the same issue
    – it makes attribution difficult.

> __Why we need this__: describing the problem clearly and concisely is a
> prerequisite for improving our documentation – we need to understand what's
> wrong, so we can fix it.

### Related links

After you described the documentation section that needs to be adjusted above,
we now ask you to share the link to this specific documentation section and
other possibly related sections. Make sure to use anchor links (permanent links)
where possible, as it simplifies discovery.

> __Why we need this__: providing the links to the documentation help us
> understand which sections of our documentation need to be adjusted, extended,
> or overhauled.


### Proposed change <small>optional</small> { #proposed-change }

Now that you have provided us with the description and links to the
documentation sections, you can help us, maintainers, and the community by
proposing an improvement. You can sketch out rough ideas or write a concrete
proposal. This field is optional but very helpful.

> __Why we need this__: an improvement proposal can be beneficial for other
> users who encounter the same issue, as they offer solutions before we
> maintainers can update the documentation.

### Checklist

Thanks for following the guide and providing valuable feedback for our
documentation – you are almost done. The checklist ensures that you have read
this guide and have worked to your best knowledge to provide us with every piece
of information we need to improve it.

__We'll take it from here.__
