/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.Animation;
import org.eclipse.draw2d.Animator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.geometry.Rectangle;

public class LayoutAnimator
extends Animator
implements LayoutListener {
    static final LayoutAnimator INSTANCE = new LayoutAnimator();

    protected LayoutAnimator() {
    }

    @Override
    protected Object getCurrentState(IFigure container) {
        HashMap locations = new HashMap();
        container.getChildren().forEach(child -> {
            Rectangle rectangle = locations.put(child, child.getBounds().getCopy());
        });
        return locations;
    }

    public static LayoutAnimator getDefault() {
        return INSTANCE;
    }

    @Override
    public final void invalidate(IFigure container) {
        if (Animation.isInitialRecording()) {
            Animation.hookAnimator(container, this);
        }
    }

    @Override
    public final boolean layout(IFigure container) {
        if (Animation.isAnimating()) {
            return Animation.hookPlayback(container, this);
        }
        return false;
    }

    @Override
    protected boolean playback(IFigure container) {
        Map initial = (Map)Animation.getInitialState(this, container);
        Map ending = (Map)Animation.getFinalState(this, container);
        if (initial == null) {
            return false;
        }
        float progress = Animation.getProgress();
        float ssergorp = 1.0f - progress;
        for (IFigure iFigure : container.getChildren()) {
            Rectangle rect1 = (Rectangle)initial.get(iFigure);
            Rectangle rect2 = (Rectangle)ending.get(iFigure);
            if (rect1 == null) continue;
            iFigure.setBounds(new Rectangle(Math.round(progress * (float)rect2.x + ssergorp * (float)rect1.x), Math.round(progress * (float)rect2.y + ssergorp * (float)rect1.y), Math.round(progress * (float)rect2.width + ssergorp * (float)rect1.width), Math.round(progress * (float)rect2.height + ssergorp * (float)rect1.height)));
        }
        return true;
    }

    @Override
    public final void postLayout(IFigure container) {
        if (Animation.isFinalRecording()) {
            Animation.hookNeedsCapture(container, this);
        }
    }

    @Override
    public final void remove(IFigure child) {
    }

    @Override
    public final void setConstraint(IFigure child, Object constraint) {
    }
}

