# This file is part of Cantera. See License.txt in the top-level directory or
# at https://cantera.org/license.txt for license and copyright information.

from typing import Any, ClassVar, TypedDict

from typing_extensions import Required

from ._types import Array, ArrayLike
from .constants import gas_constant

_SpeciesThermoInput = TypedDict(
    "_SpeciesThermoInput",
    {
        "model": Required[str],
        "temperature-ranges": list[float],
        "data": list[list[float]],
        "note": str,
    },
    total=False,
)

class SpeciesThermo:
    derived_type: ClassVar[int]
    def _check_n_coeffs(self, n: int) -> bool: ...
    def __init__(
        self,
        T_low: float | None = None,
        T_high: float | None = None,
        P_ref: float | None = None,
        coeffs: ArrayLike | None = None,
        *args: Any,
        init: bool = True,
        **kwargs: Any,
    ) -> None: ...
    @property
    def min_temp(self) -> float: ...
    @property
    def max_temp(self) -> float: ...
    @property
    def reference_pressure(self) -> float: ...
    @property
    def n_coeffs(self) -> int: ...
    @property
    def coeffs(self) -> Array: ...
    @property
    def input_data(self) -> _SpeciesThermoInput: ...
    def update_user_data(self, data: dict[str, Any]) -> None: ...
    def clear_user_data(self) -> None: ...
    def cp(self, T: float) -> float: ...
    def h(self, T: float) -> float: ...
    def s(self, T: float) -> float: ...

class ConstantCp(SpeciesThermo): ...
class Mu0Poly(SpeciesThermo): ...
class NasaPoly2(SpeciesThermo): ...
class Nasa9PolyMultiTempRegion(SpeciesThermo): ...
class ShomatePoly2(SpeciesThermo): ...
