/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.ldap.sdk.unboundidds.controls.MatchingEntryCountRequestControl;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;

@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class MatchingEntryCountRequestControlProperties
implements Serializable {
    private static final long serialVersionUID = -7231704969312951204L;
    private boolean alwaysExamineCandidates;
    private boolean includeDebugInfo;
    private boolean includeExtendedResponseData;
    private boolean processSearchIfUnindexed;
    private boolean skipResolvingExplodedIndexes;
    private int maxCandidatesToExamine;
    @Nullable
    private Long slowShortCircuitThreshold;
    @Nullable
    private Long fastShortCircuitThreshold;

    public MatchingEntryCountRequestControlProperties() {
        this.maxCandidatesToExamine = 0;
        this.alwaysExamineCandidates = false;
        this.processSearchIfUnindexed = false;
        this.skipResolvingExplodedIndexes = false;
        this.fastShortCircuitThreshold = null;
        this.slowShortCircuitThreshold = null;
        this.includeExtendedResponseData = false;
        this.includeDebugInfo = false;
    }

    public MatchingEntryCountRequestControlProperties(@NotNull MatchingEntryCountRequestControlProperties properties) {
        this.maxCandidatesToExamine = properties.getMaxCandidatesToExamine();
        this.alwaysExamineCandidates = properties.alwaysExamineCandidates();
        this.processSearchIfUnindexed = properties.processSearchIfUnindexed();
        this.skipResolvingExplodedIndexes = properties.skipResolvingExplodedIndexes();
        this.fastShortCircuitThreshold = properties.getFastShortCircuitThreshold();
        this.slowShortCircuitThreshold = properties.getSlowShortCircuitThreshold();
        this.includeExtendedResponseData = properties.includeExtendedResponseData();
        this.includeDebugInfo = properties.includeDebugInfo();
    }

    public MatchingEntryCountRequestControlProperties(@NotNull MatchingEntryCountRequestControl control) {
        this.maxCandidatesToExamine = control.getMaxCandidatesToExamine();
        this.alwaysExamineCandidates = control.alwaysExamineCandidates();
        this.processSearchIfUnindexed = control.processSearchIfUnindexed();
        this.skipResolvingExplodedIndexes = control.skipResolvingExplodedIndexes();
        this.fastShortCircuitThreshold = control.getFastShortCircuitThreshold();
        this.slowShortCircuitThreshold = control.getSlowShortCircuitThreshold();
        this.includeExtendedResponseData = control.includeExtendedResponseData();
        this.includeDebugInfo = control.includeDebugInfo();
    }

    public int getMaxCandidatesToExamine() {
        return this.maxCandidatesToExamine;
    }

    public void setMaxCandidatesToExamine(int maxCandidatesToExamine) {
        Validator.ensureTrue(maxCandidatesToExamine >= 0, "MatchingEntryCountRequestControlProperties.maxCandidatesToExamine must be greater than or equal to zero.");
        this.maxCandidatesToExamine = maxCandidatesToExamine;
    }

    public boolean alwaysExamineCandidates() {
        return this.alwaysExamineCandidates;
    }

    public void setAlwaysExamineCandidates(boolean alwaysExamineCandidates) {
        this.alwaysExamineCandidates = alwaysExamineCandidates;
    }

    public boolean processSearchIfUnindexed() {
        return this.processSearchIfUnindexed;
    }

    public void setProcessSearchIfUnindexed(boolean processSearchIfUnindexed) {
        this.processSearchIfUnindexed = processSearchIfUnindexed;
    }

    public boolean skipResolvingExplodedIndexes() {
        return this.skipResolvingExplodedIndexes;
    }

    public void setSkipResolvingExplodedIndexes(boolean skipResolvingExplodedIndexes) {
        this.skipResolvingExplodedIndexes = skipResolvingExplodedIndexes;
    }

    @Nullable
    public Long getFastShortCircuitThreshold() {
        return this.fastShortCircuitThreshold;
    }

    public void setFastShortCircuitThreshold(@Nullable Long fastShortCircuitThreshold) {
        this.fastShortCircuitThreshold = fastShortCircuitThreshold == null || fastShortCircuitThreshold >= 0L ? fastShortCircuitThreshold : Long.valueOf(0L);
    }

    @Nullable
    public Long getSlowShortCircuitThreshold() {
        return this.slowShortCircuitThreshold;
    }

    public void setSlowShortCircuitThreshold(@Nullable Long slowShortCircuitThreshold) {
        this.slowShortCircuitThreshold = slowShortCircuitThreshold == null || slowShortCircuitThreshold >= 0L ? slowShortCircuitThreshold : Long.valueOf(0L);
    }

    public boolean includeExtendedResponseData() {
        return this.includeExtendedResponseData;
    }

    public void setIncludeExtendedResponseData(boolean includeExtendedResponseData) {
        this.includeExtendedResponseData = includeExtendedResponseData;
    }

    public boolean includeDebugInfo() {
        return this.includeDebugInfo;
    }

    public void setIncludeDebugInfo(boolean includeDebugInfo) {
        this.includeDebugInfo = includeDebugInfo;
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("MatchingEntryCountRequestControlProperties(maxCandidatesToExamine=");
        buffer.append(this.maxCandidatesToExamine);
        buffer.append(", alwaysExamineCandidates=");
        buffer.append(this.alwaysExamineCandidates);
        buffer.append(", processSearchIfUnindexed=");
        buffer.append(this.processSearchIfUnindexed);
        buffer.append(", skipResolvingExplodedIndexes=");
        buffer.append(this.skipResolvingExplodedIndexes);
        if (this.fastShortCircuitThreshold != null) {
            buffer.append(", fastShortCircuitThreshold=");
            buffer.append(this.fastShortCircuitThreshold);
        }
        if (this.slowShortCircuitThreshold != null) {
            buffer.append(", slowShortCircuitThreshold=");
            buffer.append(this.slowShortCircuitThreshold);
        }
        buffer.append(", includeExtendedResponseData=");
        buffer.append(this.includeExtendedResponseData);
        buffer.append(", includeDebugInfo=");
        buffer.append(this.includeDebugInfo);
        buffer.append(')');
    }
}

