/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.Map;
import org.cts.Identifier;
import org.cts.datum.Ellipsoid;
import org.cts.op.projection.Projection;
import org.cts.units.Measure;

public class AlbersEqualArea
extends Projection {
    public static final Identifier AEA = new Identifier("EPSG", "9822", "Albers Equal Area", "AEA");
    protected final double lat0;
    protected final double lon0 = this.getCentralMeridian();
    protected final double FE;
    protected final double FN;
    protected final double rho0;
    protected final double C;
    protected final double n;

    public AlbersEqualArea(Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(AEA, ellipsoid, parameters);
        this.lat0 = this.getLatitudeOfOrigin();
        this.FE = this.getFalseEasting();
        this.FN = this.getFalseNorthing();
        double e2 = ellipsoid.getSquareEccentricity();
        double lat1 = this.getStandardParallel1();
        double alpha1 = this.q(lat1);
        double m1 = Math.cos(lat1) / Math.sqrt(1.0 - e2 * Math.sin(lat1) * Math.sin(lat1));
        double lat2 = this.getStandardParallel2();
        double alpha2 = this.q(lat2);
        double m2 = Math.cos(lat2) / Math.sqrt(1.0 - e2 * Math.sin(lat2) * Math.sin(lat2));
        this.n = (m1 * m1 - m2 * m2) / (alpha2 - alpha1);
        this.C = m1 * m1 + this.n * alpha1;
        this.rho0 = ellipsoid.getSemiMajorAxis() / this.n * Math.sqrt(this.C - this.n * this.q(this.lat0));
    }

    private double q(double lat) {
        double e = this.ellipsoid.getEccentricity();
        double esin = e * Math.sin(lat);
        return (1.0 - e * e) * (Math.sin(lat) / (1.0 - esin * esin) - Math.log((1.0 - esin) / (1.0 + esin)) / 2.0 / e);
    }

    @Override
    public Projection.Surface getSurface() {
        return Projection.Surface.CYLINDRICAL;
    }

    @Override
    public Projection.Property getProperty() {
        return Projection.Property.CONFORMAL;
    }

    @Override
    public Projection.Orientation getOrientation() {
        return Projection.Orientation.TANGENT;
    }

    @Override
    public double[] transform(double[] coord) {
        double theta = this.n * (coord[1] - this.lon0);
        double rho = this.ellipsoid.getSemiMajorAxis() / this.n * Math.sqrt(this.C - this.n * this.q(coord[0]));
        coord[0] = this.FE + rho * Math.sin(theta);
        coord[1] = this.FN + this.rho0 - rho * Math.cos(theta);
        return coord;
    }

    @Override
    public Projection inverse() {
        return new AlbersEqualArea(this.ellipsoid, this.parameters){

            @Override
            public double[] transform(double[] coord) {
                double e = this.ellipsoid.getEccentricity();
                double e2 = this.ellipsoid.getSquareEccentricity();
                double e4 = e2 * e2;
                double e6 = e4 * e2;
                double x = coord[0] - this.FE;
                double y = this.rho0 - (coord[1] - this.FN);
                double theta = Math.atan(x / y);
                double rho = Math.sqrt(x * x + y * y);
                double alphap = (this.C - Math.pow(rho * this.n / this.ellipsoid.getSemiMajorAxis(), 2.0)) / this.n;
                double betap = Math.asin(alphap / (1.0 - (1.0 - e2) / 2.0 / e * Math.log((1.0 - e) / (1.0 + e))));
                coord[0] = betap + (e2 / 3.0 + 0.0 * e4 + 0.0 * e6) * Math.sin(2.0 * betap) + (0.0 * e4 + 0.0 * e6) * Math.sin(4.0 * betap) + 0.0 * e6 * Math.sin(6.0 * betap);
                coord[1] = this.lon0 + theta / this.n;
                return coord;
            }

            @Override
            public Projection inverse() {
                return AlbersEqualArea.this;
            }

            @Override
            public boolean isDirect() {
                return false;
            }

            @Override
            public String toString() {
                return AlbersEqualArea.this.toString() + " inverse";
            }
        };
    }
}

