/*

Copyright (c) Microsoft Corporation. All rights reserved.

Module Name:

    winpackagefamily.h

Abstract:

    API family partitioning based on packages.

*/

#ifndef _INC_WINPACKAGEFAMILY
#define _INC_WINPACKAGEFAMILY

#if defined(_MSC_VER) && !defined(MOFCOMP_PASS)
#if _MSC_VER >= 1200
#pragma warning(push)
#pragma warning(disable:4001) /* nonstandard extension 'single line comment' was used */
#endif
#pragma once
#endif // defined(_MSC_VER) && !defined(MOFCOMP_PASS)


/*
 * PARTITIONS based on packages are each #undef'ed below, and then will be #define-ed
 * to be either 1 or 0 or depending on the active WINAPI_FAMILY.
 */
#undef WINAPI_PARTITION_PKG_WINTRUST
#undef WINAPI_PARTITION_PKG_WEBSERVICES
#undef WINAPI_PARTITION_PKG_EVENTLOGSERVICE
#undef WINAPI_PARTITION_PKG_VHD
#undef WINAPI_PARTITION_PKG_PERFCOUNTER
#undef WINAPI_PARTITION_PKG_SECURESTARTUP
#undef WINAPI_PARTITION_PKG_REMOTEFS
#undef WINAPI_PARTITION_PKG_BOOTABLESKU
#undef WINAPI_PARTITION_PKG_CMD
#undef WINAPI_PARTITION_PKG_CMDTOOLS
#undef WINAPI_PARTITION_PKG_DISM
#undef WINAPI_PARTITION_PKG_CORESETUP
#undef WINAPI_PARTITION_PKG_APPRUNTIME
#undef WINAPI_PARTITION_PKG_ESENT
#undef WINAPI_PARTITION_PKG_WINMGMT

/* 
 * PARTITIONS for feature packages. Each package might be active for one or more editions
 */
#define WINAPI_PARTITION_PKG_WINTRUST         (WINAPI_FAMILY == WINAPI_FAMILY_SERVER)
#define WINAPI_PARTITION_PKG_WEBSERVICES      (WINAPI_FAMILY == WINAPI_FAMILY_SERVER)
#define WINAPI_PARTITION_PKG_EVENTLOGSERVICE  (WINAPI_FAMILY == WINAPI_FAMILY_SERVER)
#define WINAPI_PARTITION_PKG_VHD              (WINAPI_FAMILY == WINAPI_FAMILY_SERVER)
#define WINAPI_PARTITION_PKG_PERFCOUNTER      (WINAPI_FAMILY == WINAPI_FAMILY_SERVER)
#define WINAPI_PARTITION_PKG_SECURESTARTUP    (WINAPI_FAMILY == WINAPI_FAMILY_SERVER)
#define WINAPI_PARTITION_PKG_REMOTEFS         (WINAPI_FAMILY == WINAPI_FAMILY_SERVER)
#define WINAPI_PARTITION_PKG_BOOTABLESKU      (WINAPI_FAMILY == WINAPI_FAMILY_SERVER)
#define WINAPI_PARTITION_PKG_CMD              (WINAPI_FAMILY == WINAPI_FAMILY_SERVER)
#define WINAPI_PARTITION_PKG_CMDTOOLS         (WINAPI_FAMILY == WINAPI_FAMILY_SERVER)
#define WINAPI_PARTITION_PKG_DISM             (WINAPI_FAMILY == WINAPI_FAMILY_SERVER)
#define WINAPI_PARTITION_PKG_CORESETUP        (WINAPI_FAMILY == WINAPI_FAMILY_SERVER)
#define WINAPI_PARTITION_PKG_APPRUNTIME       (WINAPI_FAMILY == WINAPI_FAMILY_SERVER)
#define WINAPI_PARTITION_PKG_ESENT            (WINAPI_FAMILY == WINAPI_FAMILY_SERVER)
#define WINAPI_PARTITION_PKG_WINMGMT          (WINAPI_FAMILY == WINAPI_FAMILY_SERVER)

#if defined(_MSC_VER) && !defined(MOFCOMP_PASS)
#if _MSC_VER >= 1200
#pragma warning(pop)
#endif
#endif

#endif  /* !_INC_WINPACKAGEFAMILY */
