.TH Fotocx 1 2026-01-01 "Linux" "Fotocx man page"

.B NAME
   Fotocx - photo/image editor and collection manager

.B SHORT DESCRIPTION
   Organize and manage a large image collection. Edit and optimize photos and 
   other images, add special effects, edit metadata, search images, create a
   photomontage, perform batch operations. Fotocx is a GTK GUI application. 
   The included user manual explains Fotocx operation in great detail. 

.B LONG DESCRIPTION
   Image folders can be viewed as a scrolling gallery of thumbnail images. Navigation 
   through folders and subfolders is simple and fast. Click on a thumbnail for a full 
   window view of the image. The image can be zoomed, panned and scrolled using the 
   mouse. Gallery thumbnails can be zoomed small to huge. Popup windows can be used to 
   view or compare multiple images at any scale. Thumbnail galleries are also used to 
   display image search results and albums. Albums are selected images arranged in a 
   desired order. Fotocx has many editing tools that go beyond the basics. Images with 
   severe problems (underexposed, false colors, blurred, uneven lighting, fog/haze) can 
   be brought back to life. Details lost in shadows or haze can be brought out. Images 
   with distorted perspective (esp. wide-angle photos) can be corrected.

   Fotocx is standards compliant. Nothing done by Fotocx makes your images less usable 
   with other applications. Fotocx uses your image files wherever they are: they are 
   not moved or duplicated. Fotocx does create an index for fast image searching, and 
   thumbnail images for fast gallery displays. These typically add 2% to overall 
   storage requirements. Fotocx does not need SQL or other database tools.

   Fotocx can import RAW images and perform all processing in deep color (24 bits per 
   color is used internally). Edited images can be saved as JPEG (8 bits/color), TIFF 
   (8/16), PNG (8/16), or JXL (16). Convert single RAW files or selected batches 
   (select thumbnails from gallery pages).

   Image edit functions are interactive with rapid visual feedback, using the full 
   image or a chosen zoom-in area. Undo and Redo can be applied serially to all the 
   edits of an image. Intermediate and final results can be saved as new files or as 
   versions of the input file (e.g. filename.v02.jpg).

   Objects or areas within an image can be selected and edited separately from the 
   background. Areas can be selected using several methods: drag the mouse to select 
   and flood into matching tones, follow feature edges, or outline an area freehand. 
   Complex feature edges, such as hair or foliage, can be accurately selected. Selected 
   areas can be copied and pasted into the same or other images, resized, rotated, or 
   otherwise edited. 

   Layers are not used. Each edit stage can be saved separately as a file version. 
   These can be re-used to make new versions. You can create a new version using 
   selected parts from different prior versions. 

   An image location can be "mouse painted" onto the same or other image being edited
    - paint from any source location to any destination location, with simultaneous 
    rescale if wanted. 

   Batch functions are available to copy, move, rename, resize, upright, convert 
   format, convert RAW files, and add or revise metadata.

   Several tools are available to change size and shape: crop, resize (rescale), 
   rotate, fix perspective, curve/warp the whole image or selected areas within the 
   image. There is a special tool to 'flatten' photos of curved surfaces, e.g. a page 
   from a thick book or a poster on a round column.

   Text can be added to an image. Any font and size can be used, any color, any angle. 
   The text can have variable transparency, an outline, a shadow, or an embossed effect
    - good for a signature or copyright. Other basic markups are available: lines, 
    arrows, box, oval/circle.

   Advanced editing functions: Dust spots from old slides or photos can be removed, 
   roadside trash or power lines can be erased. Panoramas can be made by stitching 
   photos together seamlessly, automatically matching brightness and color. Photos 
   with a range of exposure values can be combined into an HDR image with adjustable 
   contributions. Photos with varying focus depths can be combined into an image that 
   is sharp over the combined range. Photos of one scene taken at different moments 
   can be combined to remove passing autos or tourists. Multiple photos made under 
   low light conditions can be combined to reduce noise. Photos made with a hand-held 
   camera can be combined and aligned together with high accuracy, as long as the 
   camera is not moved too much. Images and text can be combined in a mashup (montage), 
   using the mouse to position and resize the components and adjust overlaps and
   transparencies.

   Fotocx has a batch scripting tool to speed the processing of multiple images 
   requiring the same edits: record the edits made to a base image and then apply 
   these edits automatically to any number of selected images.

   Many special effects ('filters') are available to convert a photo into a line 
   drawing, sketch, painting, embossing, cartoon, dithered image, mosaic, or abstract
   distortions (shphere, tiny planet, others). Background patterns and textures can be 
   added.

   Images can be rapidly searched using folder/file names or partial names, dates, 
   assigned keywords, ratings, locations, and any other metadata stored in the image. 
   Some data is automatic from the camera (date, location, exposure data), and other 
   data can be manually entered (keywords, descriptions ...). Search criteria can be 
   used in combination; e.g. find Chicago photos for years 2008-2020 containing 
   keywords 'barbara' or 'barbie' or 'barb*'.

   Locations (from a camera GPS sensor or entered manually) can also be searched. List 
   image counts by country and/or location and/or date range. Click on a report line 
   for a gallery of images.

   List metadata tag values and corresponding image counts for any tag name. Click on 
   a report line for a gallery of images.

   You can view a map of any region in the world, at any scale, using an internet map 
   service. Images having location data show as markers on these maps. Click a marker 
   to get a gallery of corresponding images. You can jump from a given photo to its 
   location on a world map, where you can find other photos from the same or nearby 
   locations.

   Albums can be made using selected images from your collection. The files are not 
   duplicated. Select images by clicking gallery thumbnails. Arrange the images with 
   drag and drop. Albums can be made into slide shows. Choose animated transitions 
   between images, pan and zoom effects, and places to pause for narration.

   Fotocx includes a comprehensive user manual that also serves as interactive help: 
   press F1 while using any function in Fotocx. You should take the time to read the 
   overview pages. Function details can be viewed as needed. Fotocx is easy to use 
   but unconventional, so RTFM to avoid frustration. 

.B CAPABILITIES LIST
 • Organize and manage a large photo/image collection 
   (up to 1 million images on a strong PC). 
 • Comprehensive user guide and popup context help via F1 key.
 • Thumbnail browser/navigator with variable thumb size and metadata view.
 • Click thumbnail for full-size view, image zoom in/out and pan/scroll.
 • RAW file conversion, single or batch, output 8 or 16 bits per color.
 • Large set of functions to edit, repair, refine, and transform images.
 • Internal processing in 24 bits per color (float), output 8 or 16 bits.
 • Edit common image types: JPG, PNG, TIF, JXL, WEBP, HEIC, JP2, others.
 • Most video formats can be played within the app. Select thumbnail from
   any frame in the video (default first frame). 
 • Edited files have a version number, originals are retained by default.
 • Fast edit visual feedback using the full image or selected zoom-in area.
 • Undo/Redo button - compare original/edited versions (instant replace). 
 • Compare original/edited images with split-screen and movable boundary.
 • Conventional edit functions: rotate, upright, crop, rescale, add margins,
   retouch: brightness/color/contrast/saturation/temperature/white balance,
   markup: text (decorative features)/lines/arrows/boxes/circles/ellipses,
   edit RGB colors, convert B&W/color/negative/positive/sepia.
 • Repair functions: sharpen, blur selected areas, denoise, defog, red eyes,
   smart erase (remove spoilers), remove halos, suppress JPEG artifacts,
   anti-alias (suppress jaggies), remove dust spots, fix color fringes.
 • Refine functions: edit or flatten brightness histogram (enhance detail),
   increase local contrast (enhance detail), match colors to master image, 
   add soft focus, suppress fine details, amplify existing contrast, global 
   and local retinex, add brightness ramp, add/remove vignette (curve edit).
 • Special effect conversions: sketch, outlines, cartoon, emboss, painting,
   fusion, tiles, texture, pattern, dither, engrave, mosaic, shift colors,
   add noise (hide color bands), set no. colors per RGB, alien colors.
 • Warp image: unbend (wide-angle photos, panoramas), warp selected area,
   fix perspective (photo from an angle), warp image (linear/curved/affine),
   unwarp closeup (fix balloon face), add waves, twist image, make sphere, 
   turn inside-out, tiny planet, escher spiral, flatten curved horizon,
   flatten photo of curved surface (thick book page, poster on a column).
 • Edit functions can be 'painted' locally and gradually, using the mouse.
 • Copy areas within and across images by mouse painting and blending.
 • Create or maintain transparent image areas while editing.
 • Combine images: HDR (combine bright/dark images, adjust contributions), 
   HDF (combine different focus depths), stack/layer combinations by area,
   panorama (2-6 images), make an array or matrix of many images.
 • Mashup: arrange images and text in an arbitrary layout using the mouse.
   (objects can be resized, rotated, overlapped with transparent areas ...)
 • Custom user menu: collect frequently used functions into one menu.
 • Plugins: use Gimp, Imagemagick ... as embedded Fotocx edit functions.
 • Scripts: record image edits, package as an edit function to re-use.
 • Select image objects or areas to edit separately from the background:
   outline by hand, follow feature edges, 'flood' into matching colors ...
 • Complex feature edges can be accurately selected (e.g. hair, foliage).
 • Batch tools: rename, resize, convert, export, add/revise/report metadata,
   convert RAW files, add overlay text, apply custom edit script.
 • Metadata edit and report keywords, titles, dates, geotags ... any metadata.
 • Search images using any metadata and folder/file names or partial names:
   dates, keywords, locations, ratings, titles, descriptions ... any metadata.
 • Search can include original or edited versions of targeted search images.
 • List image counts by location and date range, click line for image gallery.
 • List metadata tag values and corresponding image counts for a given tag 
   name, click line item for image gallery.
 • Show an image calendar, click on year or month for a gallery of images.
 • Scaleable internet map, click on marker for gallery of images at location.
 • Add location names and geocoordinates to an image by clicking on the map.
 • View 360 degree panorama image (Google Street View format).
 • Show video files as thumbnails (selected video frame), play video.
 • Show animated GIF files as thumbnails (first frame), play animation.
 • Bookmarks: assign names to folder/file locations, go to name (gallery).
 • Create albums with chosen images arranged by drag & drop. No duplication.
 • Slide show: show album images with animated transitions and pan/zoom.
 • Print an image at any scale. Printer color calibration tool is available.
 • Custom keyboard shortcuts can be assigned to chosen functions.
 • Cycle wallpaper images from a Fotocx album or any folder of image files.
 • Source and binary packages are installable on most recent Linux flavors.
 • Gnu GPL3 license (everything is free to use as you please). 

.B SEE ALSO
   The User Guide is available from the menu Help > User Guide 
   The home page for Fotocx is at https://kornelix.net

.B AUTHORS
   Written by Mike Cornelison <mkornelix@gmail.com>

