/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.Spacer;
import java.util.function.BiConsumer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class RemovableListCell<T>
extends ListCell<T> {
    private final HBox containerBox;
    private final Label label;
    private ObjectProperty<BiConsumer<ListView<T>, T>> onRemove;

    public RemovableListCell() {
        this.getStyleClass().add((Object)"removable-list-cell");
        this.label = new Label();
        this.setPrefWidth(0.0);
        StackPane removeBtn = new StackPane(new Node[]{new FontIcon((Ikon)MaterialDesign.MDI_CLOSE)});
        removeBtn.getStyleClass().add((Object)"remove-button");
        removeBtn.addEventHandler(MouseEvent.MOUSE_PRESSED, this::removeItem);
        removeBtn.visibleProperty().bind((ObservableValue)this.onRemoveProperty().isNotNull());
        removeBtn.managedProperty().bind((ObservableValue)this.onRemoveProperty().isNotNull());
        this.containerBox = new HBox(new Node[]{this.label, new Spacer(), removeBtn});
        this.containerBox.getStyleClass().add((Object)"container-box");
        this.containerBox.setAlignment(Pos.CENTER_LEFT);
        this.containerBox.visibleProperty().bind((ObservableValue)this.itemProperty().isNotNull());
    }

    public RemovableListCell(BiConsumer<ListView<T>, T> onRemove) {
        this();
        this.setOnRemove(onRemove);
    }

    protected void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (item == null || empty) {
            this.label.setText(null);
            this.setText(null);
            this.setGraphic(null);
        } else {
            this.label.setText(item.toString());
            this.setText(null);
            this.setGraphic((Node)this.containerBox);
        }
    }

    private void removeItem(MouseEvent event) {
        if (this.getOnRemove() != null) {
            event.consume();
            if (this.isSelected()) {
                this.getListView().getSelectionModel().clearSelection();
            }
            this.getOnRemove().accept((ListView<ListView>)this.getListView(), (ListView)this.getItem());
        }
    }

    public final ObjectProperty<BiConsumer<ListView<T>, T>> onRemoveProperty() {
        if (this.onRemove == null) {
            this.onRemove = new SimpleObjectProperty((Object)this, "onRemove");
        }
        return this.onRemove;
    }

    public final BiConsumer<ListView<T>, T> getOnRemove() {
        return this.onRemove == null ? null : (BiConsumer)this.onRemoveProperty().get();
    }

    public final void setOnRemove(BiConsumer<ListView<T>, T> onRemove) {
        this.onRemoveProperty().set(onRemove);
    }
}

