/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference.constraintformulas;

import java.util.List;
import org.javamodularity.moduleplugin.shadow.javaparser.resolution.types.ResolvedType;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference.BoundSet;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference.ConstraintFormula;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference.TypeHelper;
import org.javamodularity.moduleplugin.shadow.javaparser.symbolsolver.resolution.typeinference.bounds.SameAsBound;

public class TypeSameAsType
extends ConstraintFormula {
    private ResolvedType S;
    private ResolvedType T;

    public TypeSameAsType(ResolvedType s, ResolvedType t) {
        this.S = s;
        this.T = t;
    }

    @Override
    public ConstraintFormula.ReductionResult reduce(BoundSet currentBoundSet) {
        if (!this.S.isWildcard() && !this.T.isWildcard()) {
            if (TypeHelper.isProperType(this.S) && TypeHelper.isProperType(this.T)) {
                if (this.S.equals(this.T)) {
                    return ConstraintFormula.ReductionResult.trueResult();
                }
                return ConstraintFormula.ReductionResult.falseResult();
            }
            if (this.S.isNull() || this.T.isNull()) {
                return ConstraintFormula.ReductionResult.falseResult();
            }
            if (this.S.isInferenceVariable() && !this.T.isPrimitive()) {
                return ConstraintFormula.ReductionResult.oneBound(new SameAsBound(this.S, this.T));
            }
            if (this.T.isInferenceVariable() && !this.S.isPrimitive()) {
                return ConstraintFormula.ReductionResult.oneBound(new SameAsBound(this.S, this.T));
            }
            if (this.S.isReferenceType() && this.T.isReferenceType() && this.S.asReferenceType().toRawType().equals(this.T.asReferenceType().toRawType())) {
                ConstraintFormula.ReductionResult res = ConstraintFormula.ReductionResult.empty();
                List<ResolvedType> Bs = this.S.asReferenceType().typeParametersValues();
                List<ResolvedType> As = this.T.asReferenceType().typeParametersValues();
                for (int i = 0; i < Bs.size(); ++i) {
                    res = res.withConstraint(new TypeSameAsType(Bs.get(i), As.get(i)));
                }
                return res;
            }
            if (this.S.isArray() && this.T.isArray()) {
                return ConstraintFormula.ReductionResult.oneConstraint(new TypeSameAsType(this.S.asArrayType().getComponentType(), this.T.asArrayType().getComponentType()));
            }
            return ConstraintFormula.ReductionResult.falseResult();
        }
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeSameAsType that = (TypeSameAsType)o;
        if (!this.S.equals(that.S)) {
            return false;
        }
        return this.T.equals(that.T);
    }

    public int hashCode() {
        int result = this.S.hashCode();
        result = 31 * result + this.T.hashCode();
        return result;
    }

    public String toString() {
        return "TypeSameAsType{S=" + this.S + ", T=" + this.T + '}';
    }
}

