/*
 * Decompiled with CFR 0.152.
 */
package org.javamodularity.moduleplugin.tasks;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.util.GradleVersion;
import org.javamodularity.moduleplugin.TestEngine;
import org.javamodularity.moduleplugin.extensions.CompileTestModuleOptions;
import org.javamodularity.moduleplugin.extensions.PatchModuleContainer;
import org.javamodularity.moduleplugin.internal.TaskOption;
import org.javamodularity.moduleplugin.tasks.AbstractModulePluginTask;
import org.javamodularity.moduleplugin.tasks.ModuleInfoTestHelper;

public class CompileTestTask
extends AbstractModulePluginTask {
    private static final Logger LOGGER = Logging.getLogger(CompileTestTask.class);

    public CompileTestTask(Project project) {
        super(project);
    }

    public void configureCompileTestJava() {
        this.helper().findTask("compileTestJava", JavaCompile.class).ifPresent(this::configureCompileTestJava);
        this.project.afterEvaluate(p -> this.helper().findTask("compileTestFixturesJava", JavaCompile.class).ifPresent(task -> task.exclude(new String[]{"module-info.java"})));
    }

    private void configureCompileTestJava(final JavaCompile compileTestJava) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.4")) >= 0) {
            compileTestJava.getModularity().getInferModulePath().set((Object)false);
        }
        final CompileTestModuleOptions moduleOptions = (CompileTestModuleOptions)compileTestJava.getExtensions().create("moduleOptions", CompileTestModuleOptions.class, new Object[]{this.project});
        this.project.afterEvaluate(p -> {
            LOGGER.info(compileTestJava.getName() + ".compileOnClasspath: {}", (Object)moduleOptions.isCompileOnClasspath());
            if (!moduleOptions.isCompileOnClasspath()) {
                compileTestJava.doFirst((Action)new Action<Task>(){

                    public void execute(Task task) {
                        List<String> compilerArgs = CompileTestTask.this.buildCompilerArgs(compileTestJava, moduleOptions);
                        compileTestJava.getOptions().setCompilerArgs(compilerArgs);
                        LOGGER.info("compiler args for task {}: {}", (Object)compileTestJava.getName(), (Object)compileTestJava.getOptions().getAllCompilerArgs());
                        compileTestJava.setClasspath((FileCollection)CompileTestTask.this.project.files(new Object[0]));
                    }
                });
            }
        });
    }

    private List<String> buildCompilerArgs(JavaCompile compileTestJava, CompileTestModuleOptions moduleOptions) {
        ArrayList<String> compilerArgs = new ArrayList<String>(compileTestJava.getOptions().getCompilerArgs());
        String moduleName = this.helper().moduleName();
        FileCollection classpath = this.mergeClassesHelper().getMergeAdjustedClasspath(compileTestJava.getClasspath());
        PatchModuleContainer patchModuleContainer = PatchModuleContainer.copyOf(this.helper().modularityExtension().optionContainer().getPatchModuleContainer());
        FileCollection testSourceDirs = this.helper().testSourceSet().getJava().getSourceDirectories();
        FileCollection testFixturesSourceDirs = this.helper().findTestFixturesSourceSet().map(sourceSet -> sourceSet.getJava().getSourceDirectories()).orElse((FileCollection)this.project.files(new Object[0]));
        FileCollection allTestSourceDirs = testSourceDirs.plus(testFixturesSourceDirs);
        allTestSourceDirs.forEach(dir -> patchModuleContainer.addDir(moduleName, dir.getAbsolutePath()));
        patchModuleContainer.buildModulePathOption(classpath).ifPresent(option -> option.mutateArgs(compilerArgs));
        TestEngine.selectMultiple(this.project, classpath.getFiles()).forEach(testEngine -> {
            new TaskOption("--add-modules", testEngine.moduleName).mutateArgs(compilerArgs);
            new TaskOption("--add-reads", moduleName + "=" + testEngine.moduleName).mutateArgs(compilerArgs);
            testEngine.additionalTaskOptions.forEach(option -> option.mutateArgs(compilerArgs));
        });
        moduleOptions.mutateArgs(compilerArgs);
        patchModuleContainer.mutator(classpath).mutateArgs(compilerArgs);
        ModuleInfoTestHelper.mutateArgs(this.project, true, compilerArgs::add);
        return compilerArgs;
    }
}

