/*
 * Decompiled with CFR 0.152.
 */
package com.tobiasdiez.easybind;

import com.tobiasdiez.easybind.ConditionalBinding;
import com.tobiasdiez.easybind.EasyBinding;
import com.tobiasdiez.easybind.EasyObservableList;
import com.tobiasdiez.easybind.EasyObservableValue;
import com.tobiasdiez.easybind.EasyPreboundBinding;
import com.tobiasdiez.easybind.FlatMapBinding;
import com.tobiasdiez.easybind.FlatMapProperty;
import com.tobiasdiez.easybind.FlattenedList;
import com.tobiasdiez.easybind.ListCombinationBinding;
import com.tobiasdiez.easybind.ListContentBinding;
import com.tobiasdiez.easybind.MappedBackedList;
import com.tobiasdiez.easybind.MappedList;
import com.tobiasdiez.easybind.PropertyBinding;
import com.tobiasdiez.easybind.Subscription;
import com.tobiasdiez.easybind.When;
import com.tobiasdiez.easybind.optional.ObservableOptionalValue;
import com.tobiasdiez.easybind.optional.OptionalBinding;
import com.tobiasdiez.easybind.optional.OptionalWrapper;
import com.tobiasdiez.easybind.optional.PreboundOptionalBinding;
import com.tobiasdiez.easybind.select.SelectBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;

public class EasyBind {
    public static <T> EasyObservableValue<T> wrap(final ObservableValue<T> value) {
        return new EasyObservableValue<T>(){

            public T get() {
                return value.getValue();
            }

            public void addListener(ChangeListener<? super T> listener) {
                value.addListener(listener);
            }

            public void removeListener(ChangeListener<? super T> listener) {
                value.removeListener(listener);
            }

            public T getValue() {
                return value.getValue();
            }

            public void addListener(InvalidationListener listener) {
                value.addListener(listener);
            }

            public void removeListener(InvalidationListener listener) {
                value.removeListener(listener);
            }
        };
    }

    public static <T> ObservableOptionalValue<T> wrapNullable(ObservableValue<T> value) {
        return new OptionalWrapper<T>(value);
    }

    public static <E> EasyObservableList<E> wrapList(final ObservableList<E> list) {
        return new EasyObservableList<E>(){

            public int size() {
                return list.size();
            }

            public boolean isEmpty() {
                return list.isEmpty();
            }

            public boolean contains(Object o) {
                return list.contains(o);
            }

            public Iterator<E> iterator() {
                return list.iterator();
            }

            public Object[] toArray() {
                return list.toArray();
            }

            public <T> T[] toArray(T[] a) {
                return list.toArray((Object[])a);
            }

            public boolean add(E e) {
                return list.add(e);
            }

            public boolean remove(Object o) {
                return list.remove(o);
            }

            public boolean containsAll(Collection<?> c) {
                return list.containsAll(c);
            }

            public boolean addAll(Collection<? extends E> c) {
                return list.addAll(c);
            }

            public boolean addAll(int index, Collection<? extends E> c) {
                return list.addAll(index, c);
            }

            public boolean removeAll(Collection<?> c) {
                return list.removeAll(c);
            }

            public boolean retainAll(Collection<?> c) {
                return list.retainAll(c);
            }

            public void clear() {
                list.clear();
            }

            public boolean equals(Object o) {
                return list.equals(o);
            }

            public int hashCode() {
                return list.hashCode();
            }

            public E get(int index) {
                return list.get(index);
            }

            public E set(int index, E element) {
                return list.set(index, element);
            }

            public void add(int index, E element) {
                list.add(index, element);
            }

            public E remove(int index) {
                return list.remove(index);
            }

            public int indexOf(Object o) {
                return list.indexOf(o);
            }

            public int lastIndexOf(Object o) {
                return list.lastIndexOf(o);
            }

            public ListIterator<E> listIterator() {
                return list.listIterator();
            }

            public ListIterator<E> listIterator(int index) {
                return list.listIterator(index);
            }

            public List<E> subList(int fromIndex, int toIndex) {
                return list.subList(fromIndex, toIndex);
            }

            public void addListener(InvalidationListener listener) {
                list.addListener(listener);
            }

            public void removeListener(InvalidationListener listener) {
                list.removeListener(listener);
            }

            public void addListener(ListChangeListener<? super E> listener) {
                list.addListener(listener);
            }

            public void removeListener(ListChangeListener<? super E> listener) {
                list.removeListener(listener);
            }

            public boolean addAll(E ... elements) {
                return list.addAll((Object[])elements);
            }

            public boolean setAll(E ... elements) {
                return list.setAll((Object[])elements);
            }

            public boolean setAll(Collection<? extends E> col) {
                return list.setAll(col);
            }

            public boolean removeAll(E ... elements) {
                return list.removeAll((Object[])elements);
            }

            public boolean retainAll(E ... elements) {
                return list.retainAll((Object[])elements);
            }

            public void remove(int from, int to) {
                list.remove(from, to);
            }
        };
    }

    public static <T, U> EasyBinding<U> map(final ObservableValue<T> source, final Function<? super T, ? extends U> mapper) {
        return new EasyPreboundBinding<U>(new Observable[]{source}){

            protected U computeValue() {
                return mapper.apply(source.getValue());
            }
        };
    }

    public static <T, O, R extends ObservableValue<O>> EasyBinding<O> mapObservable(ObservableValue<T> source, Function<? super T, R> mapper) {
        return new FlatMapBinding(source, mapper);
    }

    public static <T, U> PropertyBinding<U> selectProperty(ObservableValue<T> source, Function<? super T, ? extends Property<U>> mapper) {
        return new FlatMapProperty(source, mapper);
    }

    public static <T, U> EasyObservableList<U> map(ObservableList<? extends T> sourceList, Function<? super T, ? extends U> f) {
        return new MappedList<U, T>(sourceList, f);
    }

    public static <T> EasyObservableList<T> flatten(ObservableList<ObservableList<? extends T>> sources) {
        return new FlattenedList<T>(sources);
    }

    @SafeVarargs
    public static <T> EasyObservableList<T> concat(ObservableList<? extends T> ... sources) {
        return new FlattenedList(FXCollections.observableArrayList((Object[])sources));
    }

    public static <A, B> EasyObservableList<B> mapBacked(ObservableList<A> source, Function<A, B> mapper) {
        return new MappedBackedList<B, A>(source, mapper);
    }

    public static <A, B, R> EasyBinding<R> combine(final ObservableValue<A> src1, final ObservableValue<B> src2, final BiFunction<A, B, R> f) {
        return new EasyPreboundBinding<R>(new Observable[]{src1, src2}){

            protected R computeValue() {
                return f.apply(src1.getValue(), src2.getValue());
            }
        };
    }

    public static <A, B, C, R> EasyBinding<R> combine(final ObservableValue<A> src1, final ObservableValue<B> src2, final ObservableValue<C> src3, final TriFunction<A, B, C, R> f) {
        return new EasyPreboundBinding<R>(new Observable[]{src1, src2, src3}){

            protected R computeValue() {
                return f.apply(src1.getValue(), src2.getValue(), src3.getValue());
            }
        };
    }

    public static <A, B, C, D, R> EasyBinding<R> combine(final ObservableValue<A> src1, final ObservableValue<B> src2, final ObservableValue<C> src3, final ObservableValue<D> src4, final TetraFunction<A, B, C, D, R> f) {
        return new EasyPreboundBinding<R>(new Observable[]{src1, src2, src3, src4}){

            protected R computeValue() {
                return f.apply(src1.getValue(), src2.getValue(), src3.getValue(), src4.getValue());
            }
        };
    }

    public static <A, B, C, D, E, R> EasyBinding<R> combine(final ObservableValue<A> src1, final ObservableValue<B> src2, final ObservableValue<C> src3, final ObservableValue<D> src4, final ObservableValue<E> src5, final PentaFunction<A, B, C, D, E, R> f) {
        return new EasyPreboundBinding<R>(new Observable[]{src1, src2, src3, src4, src5}){

            protected R computeValue() {
                return f.apply(src1.getValue(), src2.getValue(), src3.getValue(), src4.getValue(), src5.getValue());
            }
        };
    }

    public static <A, B, C, D, E, F, R> EasyBinding<R> combine(final ObservableValue<A> src1, final ObservableValue<B> src2, final ObservableValue<C> src3, final ObservableValue<D> src4, final ObservableValue<E> src5, final ObservableValue<F> src6, final HexaFunction<A, B, C, D, E, F, R> f) {
        return new EasyPreboundBinding<R>(new Observable[]{src1, src2, src3, src4, src5, src6}){

            protected R computeValue() {
                return f.apply(src1.getValue(), src2.getValue(), src3.getValue(), src4.getValue(), src5.getValue(), src6.getValue());
            }
        };
    }

    public static <T, R> EasyBinding<R> combine(ObservableList<? extends ObservableValue<? extends T>> list, Function<? super Stream<T>, ? extends R> f) {
        return new ListCombinationBinding(list, f);
    }

    public static <T, R> EasyBinding<R> reduce(final ObservableList<? extends T> list, final Function<? super Stream<? extends T>, ? extends R> accumulator) {
        return new EasyPreboundBinding<R>(new Observable[]{list}){

            protected R computeValue() {
                return accumulator.apply(list.stream());
            }
        };
    }

    public static <T> SelectBuilder<T> select(ObservableValue<T> selectionRoot) {
        return SelectBuilder.startAt(selectionRoot);
    }

    @Deprecated
    public static <T> Subscription bindConditionally(Property<T> target, ObservableValue<? extends T> source, ObservableValue<Boolean> condition) {
        return new ConditionalBinding<T>(target, source, condition);
    }

    public static <T> Subscription bindContent(List<? super T> target, ObservableList<? extends T> source) {
        if (target instanceof ObservableList) {
            ((ObservableList)target).setAll(source);
        } else {
            target.clear();
            target.addAll((Collection<T>)source);
        }
        ListContentBinding listener = new ListContentBinding(target);
        source.addListener(listener);
        return () -> source.removeListener(listener);
    }

    public static When when(ObservableValue<Boolean> condition) {
        return new When(condition);
    }

    public static <T> Subscription includeWhen(final Collection<T> collection, final T element, ObservableValue<Boolean> condition) {
        return EasyBind.subscribe(condition, new Consumer<Boolean>(){
            private boolean included = false;

            @Override
            public void accept(Boolean value) {
                if (value.booleanValue() && !this.included) {
                    this.included = collection.add(element);
                } else if (!value.booleanValue() && this.included) {
                    collection.remove(element);
                    this.included = false;
                }
            }
        });
    }

    public static <T> Subscription subscribe(ObservableValue<T> observable, Consumer<? super T> subscriber) {
        subscriber.accept(observable.getValue());
        ChangeListener listener = (obs, oldValue, newValue) -> subscriber.accept(newValue);
        return EasyBind.listen(observable, listener);
    }

    public static <T> Subscription listen(ObservableValue<T> observable, InvalidationListener listener) {
        observable.addListener(listener);
        return () -> observable.removeListener(listener);
    }

    public static <T> Subscription listen(ObservableValue<T> observable, ChangeListener<? super T> listener) {
        observable.addListener(listener);
        return () -> observable.removeListener(listener);
    }

    public static <E> OptionalBinding<E> valueAt(final ObservableList<E> list, final int index) {
        if (list == null) {
            throw new NullPointerException("List cannot be null.");
        }
        if (index < 0) {
            throw new IllegalArgumentException("Index cannot be negative");
        }
        return new PreboundOptionalBinding<E>(new Observable[]{list}){

            protected Optional<E> computeValue() {
                try {
                    return Optional.ofNullable(list.get(index));
                }
                catch (IndexOutOfBoundsException ex) {
                    return Optional.empty();
                }
            }
        };
    }

    public static <K, V> OptionalBinding<V> valueAt(final ObservableMap<K, V> map, final K key) {
        if (map == null) {
            throw new NullPointerException("Map cannot be null.");
        }
        return new PreboundOptionalBinding<V>(new Observable[]{map}){

            protected Optional<V> computeValue() {
                try {
                    return Optional.ofNullable(map.get(key));
                }
                catch (ClassCastException | NullPointerException ex) {
                    return Optional.empty();
                }
            }
        };
    }

    @FunctionalInterface
    public static interface TriFunction<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }

    @FunctionalInterface
    public static interface TetraFunction<A, B, C, D, R> {
        public R apply(A var1, B var2, C var3, D var4);
    }

    @FunctionalInterface
    public static interface PentaFunction<A, B, C, D, E, R> {
        public R apply(A var1, B var2, C var3, D var4, E var5);
    }

    @FunctionalInterface
    public static interface HexaFunction<A, B, C, D, E, F, R> {
        public R apply(A var1, B var2, C var3, D var4, E var5, F var6);
    }
}

