/*
 * Decompiled with CFR 0.152.
 */
package kong.unirest.core.java;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Flow;
import kong.unirest.core.ProgressMonitor;
import kong.unirest.core.java.MultipartSubscription;
import kong.unirest.core.java.Part;
import kong.unirest.core.java.Prefetcher;
import kong.unirest.core.java.Upstream;

class PartSubscriber
implements Flow.Subscriber<ByteBuffer> {
    static final ByteBuffer END_OF_PART = ByteBuffer.allocate(0);
    private final MultipartSubscription downstream;
    private final Part part;
    private final ProgressMonitor monitor;
    private final ConcurrentLinkedQueue<ByteBuffer> buffers;
    private final Upstream upstream;
    private final Prefetcher prefetcher;
    private long total;

    PartSubscriber(MultipartSubscription downstream, Part part, ProgressMonitor monitor) {
        this.downstream = downstream;
        this.part = part;
        this.monitor = monitor;
        this.buffers = new ConcurrentLinkedQueue();
        this.upstream = new Upstream();
        this.prefetcher = new Prefetcher();
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        Objects.requireNonNull(subscription);
        if (this.upstream.setOrCancel(subscription)) {
            this.prefetcher.initialize(this.upstream);
        }
    }

    @Override
    public void onNext(ByteBuffer item) {
        Objects.requireNonNull(item);
        this.buffers.offer(item);
        if (this.monitor != null) {
            this.total += (long)item.remaining();
            this.monitor.accept(this.part.getFieldName(), this.part.getFilename(), Long.valueOf(item.remaining()), this.total);
        }
        this.downstream.signal(false);
    }

    @Override
    public void onError(Throwable throwable) {
        Objects.requireNonNull(throwable);
        this.abortUpstream(false);
        this.downstream.signalError(throwable);
    }

    @Override
    public void onComplete() {
        this.abortUpstream(false);
        this.buffers.offer(END_OF_PART);
        this.downstream.signal(true);
    }

    void abortUpstream(boolean cancel) {
        if (cancel) {
            this.upstream.cancel();
        } else {
            this.upstream.clear();
        }
    }

    ByteBuffer pollNext() {
        ByteBuffer next = this.buffers.peek();
        if (next != null && next != END_OF_PART) {
            this.buffers.poll();
            this.prefetcher.update(this.upstream);
        }
        return next;
    }

    public Part getPart() {
        return this.part;
    }
}

