/*
 * Decompiled with CFR 0.152.
 */
package de.saxsys.mvvmfx.internal.viewloader;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;

public class ResourceBundleManager {
    private static final ResourceBundleManager SINGLETON = new ResourceBundleManager();
    private ResourceBundle globalResourceBundle;
    public static final ResourceBundle EMPTY_RESOURCE_BUNDLE = new ListResourceBundle(){

        @Override
        protected Object[][] getContents() {
            return new Object[0][];
        }
    };

    ResourceBundleManager() {
    }

    public static ResourceBundleManager getInstance() {
        return SINGLETON;
    }

    public void setGlobalResourceBundle(ResourceBundle resourceBundle) {
        this.globalResourceBundle = resourceBundle;
    }

    public ResourceBundle getGlobalResourceBundle() {
        return this.globalResourceBundle;
    }

    public ResourceBundle mergeWithGlobal(ResourceBundle resourceBundle) {
        if (this.globalResourceBundle == null) {
            if (resourceBundle == null) {
                return EMPTY_RESOURCE_BUNDLE;
            }
            return new ResourceBundleWrapper(resourceBundle);
        }
        if (resourceBundle == null) {
            return new ResourceBundleWrapper(this.globalResourceBundle);
        }
        return ResourceBundleManager.merge(resourceBundle, this.globalResourceBundle);
    }

    private static ResourceBundle reduce(List<ResourceBundle> bundles) {
        return bundles.stream().filter(Objects::nonNull).reduce(EMPTY_RESOURCE_BUNDLE, (a, b) -> ResourceBundleManager.merge(b, a));
    }

    public ResourceBundle mergeListWithGlobal(List<ResourceBundle> bundles) {
        if (this.globalResourceBundle == null) {
            if (bundles == null) {
                return EMPTY_RESOURCE_BUNDLE;
            }
            return ResourceBundleManager.reduce(bundles);
        }
        if (bundles == null) {
            return new ResourceBundleWrapper(this.globalResourceBundle);
        }
        ArrayList<ResourceBundle> resourceBundles = new ArrayList<ResourceBundle>();
        resourceBundles.add(this.globalResourceBundle);
        resourceBundles.addAll(bundles);
        return ResourceBundleManager.reduce(resourceBundles);
    }

    private static ResourceBundle merge(ResourceBundle highPriority, ResourceBundle lowPriority) {
        return new MergedResourceBundle(highPriority, lowPriority);
    }

    private static class ResourceBundleWrapper
    extends ResourceBundle {
        private final ResourceBundle bundle;

        ResourceBundleWrapper(ResourceBundle bundle) {
            this.bundle = bundle;
        }

        @Override
        protected Object handleGetObject(String key) {
            return this.bundle.getObject(key);
        }

        @Override
        public Enumeration<String> getKeys() {
            return this.bundle.getKeys();
        }

        @Override
        public boolean containsKey(String key) {
            return this.bundle.containsKey(key);
        }

        @Override
        public Locale getLocale() {
            return this.bundle.getLocale();
        }

        @Override
        public Set<String> keySet() {
            return this.bundle.keySet();
        }
    }

    private static class MergedEnumeration
    implements Enumeration<String> {
        final Iterator<String> iterator;

        public MergedEnumeration(Set<String> highPriority, Set<String> lowPriority) {
            HashSet<String> allElements = new HashSet<String>();
            allElements.addAll(highPriority);
            allElements.addAll(lowPriority);
            this.iterator = allElements.iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public String nextElement() {
            return this.iterator.next();
        }
    }

    private static class MergedResourceBundle
    extends ResourceBundle {
        private ResourceBundle highPriority;
        private ResourceBundle lowPriority;

        public MergedResourceBundle(ResourceBundle highPriority, ResourceBundle lowPriority) {
            Objects.nonNull(highPriority);
            Objects.nonNull(lowPriority);
            this.highPriority = highPriority;
            this.lowPriority = lowPriority;
        }

        @Override
        protected Object handleGetObject(String key) {
            if (this.highPriority.containsKey(key)) {
                return this.highPriority.getObject(key);
            }
            if (this.lowPriority.containsKey(key)) {
                return this.lowPriority.getObject(key);
            }
            return null;
        }

        @Override
        public Enumeration<String> getKeys() {
            return new MergedEnumeration(this.highPriority.keySet(), this.lowPriority.keySet());
        }
    }
}

