/*
 * MOTIS API
 *
 * This is the MOTIS routing API.
 *
 * The version of the OpenAPI document: v1
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

/// StopTime : departure or arrival event at a stop
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct StopTime {
    /// information about the stop place and time
    #[serde(rename = "place")]
    pub place: Box<models::Place>,
    /// Transport mode for this leg
    #[serde(rename = "mode")]
    pub mode: models::Mode,
    /// Whether there is real-time data about this leg
    #[serde(rename = "realTime")]
    pub real_time: bool,
    /// For transit legs, the headsign of the bus or train being used. For non-transit legs, null 
    #[serde(rename = "headsign")]
    pub headsign: String,
    #[serde(rename = "agencyId")]
    pub agency_id: String,
    #[serde(rename = "agencyName")]
    pub agency_name: String,
    #[serde(rename = "agencyUrl")]
    pub agency_url: String,
    #[serde(rename = "routeColor", skip_serializing_if = "Option::is_none")]
    pub route_color: Option<String>,
    #[serde(rename = "routeTextColor", skip_serializing_if = "Option::is_none")]
    pub route_text_color: Option<String>,
    #[serde(rename = "tripId")]
    pub trip_id: String,
    #[serde(rename = "routeShortName")]
    pub route_short_name: String,
    /// Filename and line number where this trip is from
    #[serde(rename = "source")]
    pub source: String,
}

impl StopTime {
    /// departure or arrival event at a stop
    pub fn new(place: models::Place, mode: models::Mode, real_time: bool, headsign: String, agency_id: String, agency_name: String, agency_url: String, trip_id: String, route_short_name: String, source: String) -> StopTime {
        StopTime {
            place: Box::new(place),
            mode,
            real_time,
            headsign,
            agency_id,
            agency_name,
            agency_url,
            route_color: None,
            route_text_color: None,
            trip_id,
            route_short_name,
            source,
        }
    }
}

