#
# CDDL HEADER START
#
# The contents of this file are subject to the terms of the
# Common Development and Distribution License (the "License").
# You may not use this file except in compliance with the License.
#
# You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
# or http://www.opensolaris.org/os/licensing.
# See the License for the specific language governing permissions
# and limitations under the License.
#
# When distributing Covered Code, include this CDDL HEADER in each
# file and include the License file at usr/src/OPENSOLARIS.LICENSE.
# If applicable, add the following below this CDDL HEADER, with the
# fields enclosed by brackets "[]" replaced with your own identifying
# information: Portions Copyright [yyyy] [name of copyright owner]
#
# CDDL HEADER END
#
#
# Copyright 2009 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.

# Sequential write() of a 1G file, size picked from a table in
# the [1K,64K] range with a mean of 5.5K, followed by close(), cached.



set $dir=/tmp
set $nthreads=1
set $cached=false
set $sync=false
set $count=128k

define randvar name=$iosize, type=tabular, min=1k, randtable =
{{ 80, 1k, 4k},
 { 15, 4k, 16k},
 { 05, 16k, 64k}}

define fileset name=bigfileset,path=$dir,size=0,entries=$nthreads,dirwidth=1024,prealloc=100,cached=$cached

define process name=filewriter,instances=1
{
  thread name=filewriterthread,memsize=10m,instances=$nthreads
  {
    flowop openfile name=open-file,filesetname=bigfileset,fd=1
    flowop appendfile name=write-file,dsync=$sync,iosize=$iosize,fd=1,iters=$count
    flowop closefile name=close,fd=1
    flowop finishoncount name=finish,value=1
  }
}

echo  "FileMicro-SeqWriteRandVarTab Version 1.1 personality successfully loaded"
