/*
 * Decompiled with CFR 0.152.
 */
package org.testng.junit;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.testng.internal.Utils;
import org.testng.junit.JUnitTestConverter;
import org.testng.reporters.XMLStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUnitDirectoryConverter {
    private File m_sourceDir = null;
    private File m_outDir = null;
    private String m_release = null;
    private boolean m_useAnnotations;
    private Map<File, File> m_fileNames = new HashMap<File, File>();

    public JUnitDirectoryConverter(File srcDir, File outDir, String release, boolean useAnnotation) {
        this.m_sourceDir = srcDir;
        this.m_outDir = outDir;
        this.m_useAnnotations = useAnnotation;
        this.m_release = release;
    }

    public int convert() {
        this.m_fileNames = this.convert(this.m_sourceDir);
        File[] files = this.m_fileNames.keySet().toArray(new File[this.m_fileNames.size()]);
        JUnitTestConverter fc = new JUnitTestConverter(files, this.m_outDir, this.m_release, this.m_useAnnotations);
        int converted = fc.convert();
        if (-1 == converted) {
            return converted;
        }
        this.generateConfiguration(fc.getClassNames());
        return converted;
    }

    private void generateConfiguration(String[] classNames) {
        XMLStringBuffer xsb = new XMLStringBuffer("");
        xsb.setDocType("suite SYSTEM \"http://testng.org/testng-1.0.dtd\"");
        Properties props = new Properties();
        props.setProperty("name", "Generated Suite");
        xsb.push("suite", props);
        props.setProperty("name", "Generated Test");
        xsb.push("test", props);
        xsb.push("classes");
        for (String className : classNames) {
            Properties p = new Properties();
            p.setProperty("name", className);
            xsb.addEmptyElement("class", p);
        }
        xsb.pop("classes");
        xsb.pop("test");
        xsb.pop("suite");
        Utils.writeFile(this.m_outDir, "testng.xml", xsb.toXML());
    }

    private boolean isTestFile(File f) {
        return f.getName().endsWith(".java");
    }

    private Map<File, File> convert(File f) {
        HashMap<File, File> result = new HashMap<File, File>();
        if (f.isDirectory()) {
            File[] files;
            for (File file : files = f.listFiles()) {
                File f2 = file.getAbsoluteFile();
                Map<File, File> others = this.convert(f2);
                result.putAll(others);
            }
        } else if (this.isTestFile(f)) {
            result.put(f, f);
        }
        return result;
    }

    private void ppp(String s) {
        System.out.println("[JUnitDirectoryConverter]" + s);
    }
}

