%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0": ["0x3FF0000000000000", "0xEEEEEEEEEEEEEEEE", "0xFFFFFFFFFFFFFFFF", "0xAAAAAAAAAAAAAAAA"],
    "XMM1": ["0xBBBBBBBBBBBBBBBB", "0xDDDDDDDDDDDDDDDD", "0xCCCCCCCCCCCCCCCC", "0x9999999999999999"],
    "XMM2": ["0x3FF0000000000000", "0xEEEEEEEEEEEEEEEE", "0xBBBBBBBBBBBBBBBB", "0xDDDDDDDDDDDDDDDD"],
    "XMM3": ["0x3FF0000000000000", "0xEEEEEEEEEEEEEEEE", "0xBBBBBBBBBBBBBBBB", "0xDDDDDDDDDDDDDDDD"],
    "XMM4": ["0xBBBBBBBBBBBBBBBB", "0xDDDDDDDDDDDDDDDD", "0xFFFFFFFFFFFFFFFF", "0xAAAAAAAAAAAAAAAA"],
    "XMM5": ["0xBBBBBBBBBBBBBBBB", "0xDDDDDDDDDDDDDDDD", "0xFFFFFFFFFFFFFFFF", "0xAAAAAAAAAAAAAAAA"],
    "XMM6": ["0x3FF0000000000000", "0xEEEEEEEEEEEEEEEE", "0xBBBBBBBBBBBBBBBB", "0xDDDDDDDDDDDDDDDD"],
    "XMM7": ["0x3FF0000000000000", "0xEEEEEEEEEEEEEEEE", "0xBBBBBBBBBBBBBBBB", "0xDDDDDDDDDDDDDDDD"],
    "XMM8": ["0xBBBBBBBBBBBBBBBB", "0xDDDDDDDDDDDDDDDD", "0xFFFFFFFFFFFFFFFF", "0xAAAAAAAAAAAAAAAA"],
    "XMM9": ["0xBBBBBBBBBBBBBBBB", "0xDDDDDDDDDDDDDDDD", "0xFFFFFFFFFFFFFFFF", "0xAAAAAAAAAAAAAAAA"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rdx]
vmovapd ymm1, [rdx + 32]

; Insert into upper lane
vinserti128 ymm2, ymm0, xmm1, 1
vinserti128 ymm3, ymm0, [rdx + 32], 1

; Insert into lower lane
vinserti128 ymm4, ymm0, xmm1, 0
vinserti128 ymm5, ymm0, [rdx + 32], 0

; Insert into upper lane - With garbage
vinserti128 ymm6, ymm0, xmm1, 0xFF
vinserti128 ymm7, ymm0, [rdx + 32], 0xFF

; Insert into lower lane - With garbage
vinserti128 ymm8, ymm0, xmm1, 0xFE
vinserti128 ymm9, ymm0, [rdx + 32], 0xFE

hlt

align 32
.data:
dq 0x3FF0000000000000
dq 0xEEEEEEEEEEEEEEEE
dq 0xFFFFFFFFFFFFFFFF
dq 0xAAAAAAAAAAAAAAAA

dq 0xBBBBBBBBBBBBBBBB
dq 0xDDDDDDDDDDDDDDDD
dq 0xCCCCCCCCCCCCCCCC
dq 0x9999999999999999
