﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/amplifybackend/model/GetBackendAPIModelsRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::AmplifyBackend::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String GetBackendAPIModelsRequest::SerializePayload() const {
  JsonValue payload;

  if (m_resourceNameHasBeenSet) {
    payload.WithString("resourceName", m_resourceName);
  }

  return payload.View().WriteReadable();
}
