﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/batch/model/DescribeServiceEnvironmentsResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::Batch::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DescribeServiceEnvironmentsResult::DescribeServiceEnvironmentsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

DescribeServiceEnvironmentsResult& DescribeServiceEnvironmentsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("serviceEnvironments")) {
    Aws::Utils::Array<JsonView> serviceEnvironmentsJsonList = jsonValue.GetArray("serviceEnvironments");
    for (unsigned serviceEnvironmentsIndex = 0; serviceEnvironmentsIndex < serviceEnvironmentsJsonList.GetLength();
         ++serviceEnvironmentsIndex) {
      m_serviceEnvironments.push_back(serviceEnvironmentsJsonList[serviceEnvironmentsIndex].AsObject());
    }
    m_serviceEnvironmentsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
