﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/clouddirectory/CloudDirectory_EXPORTS.h>
#include <aws/clouddirectory/model/TypedLinkSpecifier.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CloudDirectory {
namespace Model {

/**
 * <p>Retrieves attributes that are associated with a typed link inside a
 * <a>BatchRead</a> operation. For more information, see <a>GetLinkAttributes</a>
 * and <a>BatchReadRequest$Operations</a>.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/BatchGetLinkAttributes">AWS
 * API Reference</a></p>
 */
class BatchGetLinkAttributes {
 public:
  AWS_CLOUDDIRECTORY_API BatchGetLinkAttributes() = default;
  AWS_CLOUDDIRECTORY_API BatchGetLinkAttributes(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDDIRECTORY_API BatchGetLinkAttributes& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CLOUDDIRECTORY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Allows a typed link specifier to be accepted as input.</p>
   */
  inline const TypedLinkSpecifier& GetTypedLinkSpecifier() const { return m_typedLinkSpecifier; }
  inline bool TypedLinkSpecifierHasBeenSet() const { return m_typedLinkSpecifierHasBeenSet; }
  template <typename TypedLinkSpecifierT = TypedLinkSpecifier>
  void SetTypedLinkSpecifier(TypedLinkSpecifierT&& value) {
    m_typedLinkSpecifierHasBeenSet = true;
    m_typedLinkSpecifier = std::forward<TypedLinkSpecifierT>(value);
  }
  template <typename TypedLinkSpecifierT = TypedLinkSpecifier>
  BatchGetLinkAttributes& WithTypedLinkSpecifier(TypedLinkSpecifierT&& value) {
    SetTypedLinkSpecifier(std::forward<TypedLinkSpecifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of attribute names whose values will be retrieved.</p>
   */
  inline const Aws::Vector<Aws::String>& GetAttributeNames() const { return m_attributeNames; }
  inline bool AttributeNamesHasBeenSet() const { return m_attributeNamesHasBeenSet; }
  template <typename AttributeNamesT = Aws::Vector<Aws::String>>
  void SetAttributeNames(AttributeNamesT&& value) {
    m_attributeNamesHasBeenSet = true;
    m_attributeNames = std::forward<AttributeNamesT>(value);
  }
  template <typename AttributeNamesT = Aws::Vector<Aws::String>>
  BatchGetLinkAttributes& WithAttributeNames(AttributeNamesT&& value) {
    SetAttributeNames(std::forward<AttributeNamesT>(value));
    return *this;
  }
  template <typename AttributeNamesT = Aws::String>
  BatchGetLinkAttributes& AddAttributeNames(AttributeNamesT&& value) {
    m_attributeNamesHasBeenSet = true;
    m_attributeNames.emplace_back(std::forward<AttributeNamesT>(value));
    return *this;
  }
  ///@}
 private:
  TypedLinkSpecifier m_typedLinkSpecifier;
  bool m_typedLinkSpecifierHasBeenSet = false;

  Aws::Vector<Aws::String> m_attributeNames;
  bool m_attributeNamesHasBeenSet = false;
};

}  // namespace Model
}  // namespace CloudDirectory
}  // namespace Aws
