// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates crash-consistent snapshots of multiple EBS volumes attached to an
// Amazon EC2 instance. Volumes are chosen by specifying an instance. Each volume
// attached to the specified instance will produce one snapshot that is
// crash-consistent across the instance. You can include all of the volumes
// currently attached to the instance, or you can exclude the root volume or
// specific data (non-root) volumes from the multi-volume snapshot set.
//
// The location of the source instance determines where you can create the
// snapshots.
//
//   - If the source instance is in a Region, you must create the snapshots in the
//     same Region as the instance.
//
//   - If the source instance is in a Local Zone, you can create the snapshots in
//     the same Local Zone or in its parent Amazon Web Services Region.
//
//   - If the source instance is on an Outpost, you can create the snapshots on
//     the same Outpost or in its parent Amazon Web Services Region.
func (c *Client) CreateSnapshots(ctx context.Context, params *CreateSnapshotsInput, optFns ...func(*Options)) (*CreateSnapshotsOutput, error) {
	if params == nil {
		params = &CreateSnapshotsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateSnapshots", params, optFns, c.addOperationCreateSnapshotsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateSnapshotsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateSnapshotsInput struct {

	// The instance to specify which volumes should be included in the snapshots.
	//
	// This member is required.
	InstanceSpecification *types.InstanceSpecification

	// Copies the tags from the specified volume to corresponding snapshot.
	CopyTagsFromSource types.CopyTagsFromSource

	//  A description propagated to every snapshot specified by the instance.
	Description *string

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// Only supported for instances in Local Zones. If the source instance is not in a
	// Local Zone, omit this parameter.
	//
	//   - To create local snapshots in the same Local Zone as the source instance,
	//   specify local .
	//
	//   - To create a regional snapshots in the parent Region of the Local Zone,
	//   specify regional or omit this parameter.
	//
	// Default value: regional
	Location types.SnapshotLocationEnum

	// Only supported for instances on Outposts. If the source instance is not on an
	// Outpost, omit this parameter.
	//
	//   - To create the snapshots on the same Outpost as the source instance, specify
	//   the ARN of that Outpost. The snapshots must be created on the same Outpost as
	//   the instance.
	//
	//   - To create the snapshots in the parent Region of the Outpost, omit this
	//   parameter.
	//
	// For more information, see [Create local snapshots from volumes on an Outpost] in the Amazon EBS User Guide.
	//
	// [Create local snapshots from volumes on an Outpost]: https://docs.aws.amazon.com/ebs/latest/userguide/snapshots-outposts.html#create-snapshot
	OutpostArn *string

	// Tags to apply to every snapshot specified by the instance.
	TagSpecifications []types.TagSpecification

	noSmithyDocumentSerde
}

type CreateSnapshotsOutput struct {

	// List of snapshots.
	Snapshots []types.SnapshotInfo

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateSnapshotsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpCreateSnapshots{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpCreateSnapshots{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateSnapshots"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateSnapshotsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateSnapshots(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateSnapshots(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateSnapshots",
	}
}
