// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (C) 2024 Nuvoton Technology Corp.
 *
 * Author: Shan-Chun Hung <schung@nuvoton.com>
 * *       Jacky Huang <ychuang3@nuvoton.com>
 */
#include <linux/init.h>
#include <linux/io.h>
#include <linux/mod_devicetable.h>
#include <linux/module.h>
#include <linux/platform_device.h>
#include <linux/pm.h>

#include <linux/pinctrl/pinctrl.h>

#include "pinctrl-ma35.h"

static const struct pinctrl_pin_desc ma35d1_pins[] = {
	MA35_PIN(0, PA0, 0x80, 0x0,
		MA35_MUX(0x0, "GPA0"),
		MA35_MUX(0x2, "UART1_nCTS"),
		MA35_MUX(0x3, "UART16_RXD"),
		MA35_MUX(0x6, "NAND_DATA0"),
		MA35_MUX(0x7, "EBI_AD0"),
		MA35_MUX(0x9, "EBI_ADR0")),
	MA35_PIN(1, PA1, 0x80, 0x4,
		MA35_MUX(0x0, "GPA1"),
		MA35_MUX(0x2, "UART1_nRTS"),
		MA35_MUX(0x3, "UART16_TXD"),
		MA35_MUX(0x6, "NAND_DATA1"),
		MA35_MUX(0x7, "EBI_AD1"),
		MA35_MUX(0x9, "EBI_ADR1")),
	MA35_PIN(2, PA2, 0x80, 0x8,
		MA35_MUX(0x0, "GPA2"),
		MA35_MUX(0x2, "UART1_RXD"),
		MA35_MUX(0x6, "NAND_DATA2"),
		MA35_MUX(0x7, "EBI_AD2"),
		MA35_MUX(0x9, "EBI_ADR2")),
	MA35_PIN(3, PA3, 0x80, 0xc,
		MA35_MUX(0x0, "GPA3"),
		MA35_MUX(0x2, "UART1_TXD"),
		MA35_MUX(0x6, "NAND_DATA3"),
		MA35_MUX(0x7, "EBI_AD3"),
		MA35_MUX(0x9, "EBI_ADR3")),
	MA35_PIN(4, PA4, 0x80, 0x10,
		MA35_MUX(0x0, "GPA4"),
		MA35_MUX(0x2, "UART3_nCTS"),
		MA35_MUX(0x3, "UART2_RXD"),
		MA35_MUX(0x6, "NAND_DATA4"),
		MA35_MUX(0x7, "EBI_AD4"),
		MA35_MUX(0x9, "EBI_ADR4")),
	MA35_PIN(5, PA5, 0x80, 0x14,
		MA35_MUX(0x0, "GPA5"),
		MA35_MUX(0x2, "UART3_nRTS"),
		MA35_MUX(0x3, "UART2_TXD"),
		MA35_MUX(0x6, "NAND_DATA5"),
		MA35_MUX(0x7, "EBI_AD5"),
		MA35_MUX(0x9, "EBI_ADR5")),
	MA35_PIN(6, PA6, 0x80, 0x18,
		MA35_MUX(0x0, "GPA6"),
		MA35_MUX(0x2, "UART3_RXD"),
		MA35_MUX(0x6, "NAND_DATA6"),
		MA35_MUX(0x7, "EBI_AD6"),
		MA35_MUX(0x9, "EBI_ADR6")),
	MA35_PIN(7, PA7, 0x80, 0x1c,
		MA35_MUX(0x0, "GPA7"),
		MA35_MUX(0x2, "UART3_TXD"),
		MA35_MUX(0x6, "NAND_DATA7"),
		MA35_MUX(0x7, "EBI_AD7"),
		MA35_MUX(0x9, "EBI_ADR7")),
	MA35_PIN(8, PA8, 0x84, 0x0,
		MA35_MUX(0x0, "GPA8"),
		MA35_MUX(0x2, "UART5_nCTS"),
		MA35_MUX(0x3, "UART4_RXD"),
		MA35_MUX(0x6, "NAND_RDY0"),
		MA35_MUX(0x7, "EBI_AD8"),
		MA35_MUX(0x9, "EBI_ADR8")),
	MA35_PIN(9, PA9, 0x84, 0x4,
		MA35_MUX(0x0, "GPA9"),
		MA35_MUX(0x2, "UART5_nRTS"),
		MA35_MUX(0x3, "UART4_TXD"),
		MA35_MUX(0x6, "NAND_nRE"),
		MA35_MUX(0x7, "EBI_AD9"),
		MA35_MUX(0x9, "EBI_ADR9")),
	MA35_PIN(10, PA10, 0x84, 0x8,
		MA35_MUX(0x0, "GPA10"),
		MA35_MUX(0x2, "UART5_RXD"),
		MA35_MUX(0x6, "NAND_nWE"),
		MA35_MUX(0x7, "EBI_AD10"),
		MA35_MUX(0x9, "EBI_ADR10")),
	MA35_PIN(11, PA11, 0x84, 0xc,
		MA35_MUX(0x0, "GPA11"),
		MA35_MUX(0x2, "UART5_TXD"),
		MA35_MUX(0x6, "NAND_CLE"),
		MA35_MUX(0x7, "EBI_AD11"),
		MA35_MUX(0x9, "EBI_ADR11")),
	MA35_PIN(12, PA12, 0x84, 0x10,
		MA35_MUX(0x0, "GPA12"),
		MA35_MUX(0x2, "UART7_nCTS"),
		MA35_MUX(0x3, "UART8_RXD"),
		MA35_MUX(0x6, "NAND_ALE"),
		MA35_MUX(0x7, "EBI_AD12"),
		MA35_MUX(0x9, "EBI_ADR12")),
	MA35_PIN(13, PA13, 0x84, 0x14,
		MA35_MUX(0x0, "GPA13"),
		MA35_MUX(0x2, "UART7_nRTS"),
		MA35_MUX(0x3, "UART8_TXD"),
		MA35_MUX(0x6, "NAND_nCS0"),
		MA35_MUX(0x7, "EBI_AD13"),
		MA35_MUX(0x9, "EBI_ADR13")),
	MA35_PIN(14, PA14, 0x84, 0x18,
		MA35_MUX(0x0, "GPA14"),
		MA35_MUX(0x2, "UART7_RXD"),
		MA35_MUX(0x3, "CAN3_RXD"),
		MA35_MUX(0x6, "NAND_nWP"),
		MA35_MUX(0x7, "EBI_AD14"),
		MA35_MUX(0x9, "EBI_ADR14")),
	MA35_PIN(15, PA15, 0x84, 0x1c,
		MA35_MUX(0x0, "GPA15"),
		MA35_MUX(0x1, "EPWM0_CH2"),
		MA35_MUX(0x2, "UART9_nCTS"),
		MA35_MUX(0x3, "UART6_RXD"),
		MA35_MUX(0x4, "I2C4_SDA"),
		MA35_MUX(0x5, "CAN2_RXD"),
		MA35_MUX(0x7, "EBI_ALE"),
		MA35_MUX(0x9, "QEI0_A"),
		MA35_MUX(0xb, "TM1"),
		MA35_MUX(0xe, "RGMII0_PPS"),
		MA35_MUX(0xf, "RMII0_PPS")),
	MA35_PIN(16, PB0, 0x88, 0x0,
		MA35_MUX(0x0, "GPB0"),
		MA35_MUX(0x8, "EADC0_CH0")),
	MA35_PIN(17, PB1, 0x88, 0x4,
		MA35_MUX(0x0, "GPB1"),
		MA35_MUX(0x8, "EADC0_CH1")),
	MA35_PIN(18, PB2, 0x88, 0x8,
		MA35_MUX(0x0, "GPB2"),
		MA35_MUX(0x8, "EADC0_CH2")),
	MA35_PIN(19, PB3, 0x88, 0xc,
		MA35_MUX(0x0, "GPB3"),
		MA35_MUX(0x8, "EADC0_CH3")),
	MA35_PIN(20, PB4, 0x88, 0x10,
		MA35_MUX(0x0, "GPB4"),
		MA35_MUX(0x8, "EADC0_CH4")),
	MA35_PIN(21, PB5, 0x88, 0x14,
		MA35_MUX(0x0, "GPB5"),
		MA35_MUX(0x8, "EADC0_CH5")),
	MA35_PIN(22, PB6, 0x88, 0x18,
		MA35_MUX(0x0, "GPB6"),
		MA35_MUX(0x8, "EADC0_CH6")),
	MA35_PIN(23, PB7, 0x88, 0x1c,
		MA35_MUX(0x0, "GPB7"),
		MA35_MUX(0x8, "EADC0_CH7")),
	MA35_PIN(24, PB8, 0x8c, 0x0,
		MA35_MUX(0x0, "GPB8"),
		MA35_MUX(0x1, "EPWM2_BRAKE0"),
		MA35_MUX(0x2, "UART2_nCTS"),
		MA35_MUX(0x3, "UART1_RXD"),
		MA35_MUX(0x4, "I2C2_SDA"),
		MA35_MUX(0x5, "SPI0_SS1"),
		MA35_MUX(0x6, "SPI0_I2SMCLK"),
		MA35_MUX(0x8, "ADC0_CH0"),
		MA35_MUX(0x9, "EBI_nCS0"),
		MA35_MUX(0xb, "TM4"),
		MA35_MUX(0xe, "QEI2_INDEX"),
		MA35_MUX(0xf, "KPI_ROW6")),
	MA35_PIN(25, PB9, 0x8c, 0x4,
		MA35_MUX(0x0, "GPB9"),
		MA35_MUX(0x1, "EPWM2_CH4"),
		MA35_MUX(0x2, "UART2_nRTS"),
		MA35_MUX(0x3, "UART1_TXD"),
		MA35_MUX(0x4, "I2C2_SCL"),
		MA35_MUX(0x5, "SPI0_CLK"),
		MA35_MUX(0x6, "I2S0_MCLK"),
		MA35_MUX(0x7, "CCAP1_HSYNC"),
		MA35_MUX(0x8, "ADC0_CH1"),
		MA35_MUX(0x9, "EBI_ALE"),
		MA35_MUX(0xa, "EBI_AD13"),
		MA35_MUX(0xb, "TM0_EXT"),
		MA35_MUX(0xc, "I2S1_MCLK"),
		MA35_MUX(0xd, "SC0_nCD"),
		MA35_MUX(0xe, "QEI2_A"),
		MA35_MUX(0xf, "KPI_ROW7")),
	MA35_PIN(26, PB10, 0x8c, 0x8,
		MA35_MUX(0x0, "GPB10"),
		MA35_MUX(0x1, "EPWM2_CH5"),
		MA35_MUX(0x2, "UART2_RXD"),
		MA35_MUX(0x3, "CAN0_RXD"),
		MA35_MUX(0x5, "SPI0_MOSI"),
		MA35_MUX(0x6, "EBI_MCLK"),
		MA35_MUX(0x7, "CCAP1_VSYNC"),
		MA35_MUX(0x8, "ADC0_CH2"),
		MA35_MUX(0x9, "EBI_ADR15"),
		MA35_MUX(0xa, "EBI_AD14"),
		MA35_MUX(0xb, "TM5"),
		MA35_MUX(0xc, "I2C1_SDA"),
		MA35_MUX(0xd, "INT1"),
		MA35_MUX(0xe, "QEI2_B")),
	MA35_PIN(27, PB11, 0x8c, 0xc,
		MA35_MUX(0x0, "GPB11"),
		MA35_MUX(0x1, "EPWM2_BRAKE1"),
		MA35_MUX(0x2, "UART2_TXD"),
		MA35_MUX(0x3, "CAN0_TXD"),
		MA35_MUX(0x5, "SPI0_MISO"),
		MA35_MUX(0x6, "I2S1_MCLK"),
		MA35_MUX(0x7, "CCAP1_SFIELD"),
		MA35_MUX(0x8, "ADC0_CH3"),
		MA35_MUX(0x9, "EBI_nCS2"),
		MA35_MUX(0xa, "EBI_ALE"),
		MA35_MUX(0xb, "TM5_EXT"),
		MA35_MUX(0xc, "I2C1_SCL"),
		MA35_MUX(0xd, "INT2"),
		MA35_MUX(0xe, "QEI2_INDEX")),
	MA35_PIN(28, PB12, 0x8c, 0x10,
		MA35_MUX(0x0, "GPB12"),
		MA35_MUX(0x1, "EPWM2_CH0"),
		MA35_MUX(0x2, "UART4_nCTS"),
		MA35_MUX(0x3, "UART3_RXD"),
		MA35_MUX(0x4, "I2C3_SDA"),
		MA35_MUX(0x5, "CAN2_RXD"),
		MA35_MUX(0x6, "I2S1_LRCK"),
		MA35_MUX(0x8, "ADC0_CH4"),
		MA35_MUX(0x9, "EBI_ADR16"),
		MA35_MUX(0xe, "ECAP2_IC0")),
	MA35_PIN(29, PB13, 0x8c, 0x14,
		MA35_MUX(0x0, "GPB13"),
		MA35_MUX(0x1, "EPWM2_CH1"),
		MA35_MUX(0x2, "UART4_nRTS"),
		MA35_MUX(0x3, "UART3_TXD"),
		MA35_MUX(0x4, "I2C3_SCL"),
		MA35_MUX(0x5, "CAN2_TXD"),
		MA35_MUX(0x6, "I2S1_BCLK"),
		MA35_MUX(0x8, "ADC0_CH5"),
		MA35_MUX(0x9, "EBI_ADR17"),
		MA35_MUX(0xe, "ECAP2_IC1")),
	MA35_PIN(30, PB14, 0x8c, 0x18,
		MA35_MUX(0x0, "GPB14"),
		MA35_MUX(0x1, "EPWM2_CH2"),
		MA35_MUX(0x2, "UART4_RXD"),
		MA35_MUX(0x3, "CAN1_RXD"),
		MA35_MUX(0x5, "I2C4_SDA"),
		MA35_MUX(0x6, "I2S1_DI"),
		MA35_MUX(0x8, "ADC0_CH6"),
		MA35_MUX(0x9, "EBI_ADR18"),
		MA35_MUX(0xe, "ECAP2_IC2")),
	MA35_PIN(31, PB15, 0x8c, 0x1c,
		MA35_MUX(0x0, "GPB15"),
		MA35_MUX(0x1, "EPWM2_CH3"),
		MA35_MUX(0x2, "UART4_TXD"),
		MA35_MUX(0x3, "CAN1_TXD"),
		MA35_MUX(0x5, "I2C4_SCL"),
		MA35_MUX(0x6, "I2S1_DO"),
		MA35_MUX(0x8, "ADC0_CH7"),
		MA35_MUX(0x9, "EBI_ADR19")),
	MA35_PIN(32, PC0, 0x90, 0x0,
		MA35_MUX(0x0, "GPC0"),
		MA35_MUX(0x4, "I2C4_SDA"),
		MA35_MUX(0x6, "SD0_CMD/eMMC0_CMD")),
	MA35_PIN(33, PC1, 0x90, 0x4,
		MA35_MUX(0x0, "GPC1"),
		MA35_MUX(0x4, "I2C4_SCL"),
		MA35_MUX(0x6, "SD0_CLK/eMMC0_CLK")),
	MA35_PIN(34, PC2, 0x90, 0x8,
		MA35_MUX(0x0, "GPC2"),
		MA35_MUX(0x3, "CAN0_RXD"),
		MA35_MUX(0x6, "SD0_DAT0/eMMC0_DAT0")),
	MA35_PIN(35, PC3, 0x90, 0xc,
		MA35_MUX(0x0, "GPC3"),
		MA35_MUX(0x3, "CAN0_TXD"),
		MA35_MUX(0x6, "SD0_DAT1/eMMC0_DAT1")),
	MA35_PIN(36, PC4, 0x90, 0x10,
		MA35_MUX(0x0, "GPC4"),
		MA35_MUX(0x4, "I2C5_SDA"),
		MA35_MUX(0x6, "SD0_DAT2/eMMC0_DAT2")),
	MA35_PIN(37, PC5, 0x90, 0x14,
		MA35_MUX(0x0, "GPC5"),
		MA35_MUX(0x4, "I2C5_SCL"),
		MA35_MUX(0x6, "SD0_DAT3/eMMC0_DAT3")),
	MA35_PIN(38, PC6, 0x90, 0x18,
		MA35_MUX(0x0, "GPC6"),
		MA35_MUX(0x3, "CAN1_RXD"),
		MA35_MUX(0x6, "SD0_nCD")),
	MA35_PIN(39, PC7, 0x90, 0x1c,
		MA35_MUX(0x0, "GPC7"),
		MA35_MUX(0x3, "CAN1_TXD"),
		MA35_MUX(0x6, "SD0_WP")),
	MA35_PIN(40, PC12, 0x94, 0x10,
		MA35_MUX(0x0, "GPC12"),
		MA35_MUX(0x2, "UART12_nCTS"),
		MA35_MUX(0x3, "UART11_RXD"),
		MA35_MUX(0x6, "LCM_DATA16")),
	MA35_PIN(41, PC13, 0x94, 0x14,
		MA35_MUX(0x0, "GPC13"),
		MA35_MUX(0x2, "UART12_nRTS"),
		MA35_MUX(0x3, "UART11_TXD"),
		MA35_MUX(0x6, "LCM_DATA17")),
	MA35_PIN(42, PC14, 0x94, 0x18,
		MA35_MUX(0x0, "GPC14"),
		MA35_MUX(0x2, "UART12_RXD"),
		MA35_MUX(0x6, "LCM_DATA18")),
	MA35_PIN(43, PC15, 0x94, 0x1c,
		MA35_MUX(0x0, "GPC15"),
		MA35_MUX(0x2, "UART12_TXD"),
		MA35_MUX(0x6, "LCM_DATA19"),
		MA35_MUX(0x7, "LCM_MPU_TE"),
		MA35_MUX(0x8, "LCM_MPU_VSYNC")),
	MA35_PIN(44, PD0, 0x98, 0x0,
		MA35_MUX(0x0, "GPD0"),
		MA35_MUX(0x2, "UART3_nCTS"),
		MA35_MUX(0x3, "UART4_RXD"),
		MA35_MUX(0x5, "QSPI0_SS0")),
	MA35_PIN(45, PD1, 0x98, 0x4,
		MA35_MUX(0x0, "GPD1"),
		MA35_MUX(0x2, "UART3_nRTS"),
		MA35_MUX(0x3, "UART4_TXD"),
		MA35_MUX(0x5, "QSPI0_CLK")),
	MA35_PIN(46, PD2, 0x98, 0x8,
		MA35_MUX(0x0, "GPD2"),
		MA35_MUX(0x2, "UART3_RXD"),
		MA35_MUX(0x5, "QSPI0_MOSI0")),
	MA35_PIN(47, PD3, 0x98, 0xc,
		MA35_MUX(0x0, "GPD3"),
		MA35_MUX(0x2, "UART3_TXD"),
		MA35_MUX(0x5, "QSPI0_MISO0")),
	MA35_PIN(48, PD4, 0x98, 0x10,
		MA35_MUX(0x0, "GPD4"),
		MA35_MUX(0x2, "UART1_nCTS"),
		MA35_MUX(0x3, "UART2_RXD"),
		MA35_MUX(0x4, "I2C2_SDA"),
		MA35_MUX(0x5, "QSPI0_MOSI1")),
	MA35_PIN(49, PD5, 0x98, 0x14,
		MA35_MUX(0x0, "GPD5"),
		MA35_MUX(0x2, "UART1_nRTS"),
		MA35_MUX(0x3, "UART2_TXD"),
		MA35_MUX(0x4, "I2C2_SCL"),
		MA35_MUX(0x5, "QSPI0_MISO1")),
	MA35_PIN(50, PD6, 0x98, 0x18,
		MA35_MUX(0x0, "GPD6"),
		MA35_MUX(0x1, "EPWM0_SYNC_IN"),
		MA35_MUX(0x2, "UART1_RXD"),
		MA35_MUX(0x5, "QSPI1_MOSI1"),
		MA35_MUX(0x6, "I2C0_SDA"),
		MA35_MUX(0x7, "I2S0_MCLK"),
		MA35_MUX(0x8, "EPWM0_CH0"),
		MA35_MUX(0x9, "EBI_AD5"),
		MA35_MUX(0xa, "SPI3_SS1"),
		MA35_MUX(0xb, "TRACE_CLK")),
	MA35_PIN(51, PD7, 0x98, 0x1c,
		MA35_MUX(0x0, "GPD7"),
		MA35_MUX(0x1, "EPWM0_SYNC_OUT"),
		MA35_MUX(0x2, "UART1_TXD"),
		MA35_MUX(0x5, "QSPI1_MISO1"),
		MA35_MUX(0x6, "I2C0_SCL"),
		MA35_MUX(0x7, "I2S1_MCLK"),
		MA35_MUX(0x8, "EPWM0_CH1"),
		MA35_MUX(0x9, "EBI_AD6"),
		MA35_MUX(0xa, "SC1_nCD"),
		MA35_MUX(0xb, "EADC0_ST")),
	MA35_PIN(52, PD8, 0x9c, 0x0,
		MA35_MUX(0x0, "GPD8"),
		MA35_MUX(0x1, "EPWM0_BRAKE0"),
		MA35_MUX(0x2, "UART16_nCTS"),
		MA35_MUX(0x3, "UART15_RXD"),
		MA35_MUX(0x5, "QSPI1_SS0"),
		MA35_MUX(0x7, "I2S1_LRCK"),
		MA35_MUX(0x8, "EPWM0_CH2"),
		MA35_MUX(0x9, "EBI_AD7"),
		MA35_MUX(0xa, "SC1_CLK"),
		MA35_MUX(0xb, "TM0")),
	MA35_PIN(53, PD9, 0x9c, 0x4,
		MA35_MUX(0x0, "GPD9"),
		MA35_MUX(0x1, "EPWM0_BRAKE1"),
		MA35_MUX(0x2, "UART16_nRTS"),
		MA35_MUX(0x3, "UART15_TXD"),
		MA35_MUX(0x5, "QSPI1_CLK"),
		MA35_MUX(0x7, "I2S1_BCLK"),
		MA35_MUX(0x8, "EPWM0_CH3"),
		MA35_MUX(0x9, "EBI_AD8"),
		MA35_MUX(0xa, "SC1_DAT"),
		MA35_MUX(0xb, "TM0_EXT")),
	MA35_PIN(54, PD10, 0x9c, 0x8,
		MA35_MUX(0x0, "GPD10"),
		MA35_MUX(0x1, "EPWM1_BRAKE0"),
		MA35_MUX(0x2, "UART16_RXD"),
		MA35_MUX(0x5, "QSPI1_MOSI0"),
		MA35_MUX(0x7, "I2S1_DI"),
		MA35_MUX(0x8, "EPWM0_CH4"),
		MA35_MUX(0x9, "EBI_AD9"),
		MA35_MUX(0xa, "SC1_RST"),
		MA35_MUX(0xb, "TM2")),
	MA35_PIN(55, PD11, 0x9c, 0xc,
		MA35_MUX(0x0, "GPD11"),
		MA35_MUX(0x1, "EPWM1_BRAKE1"),
		MA35_MUX(0x2, "UART16_TXD"),
		MA35_MUX(0x5, "QSPI1_MISO0"),
		MA35_MUX(0x7, "I2S1_DO"),
		MA35_MUX(0x8, "EPWM0_CH5"),
		MA35_MUX(0x9, "EBI_AD10"),
		MA35_MUX(0xa, "SC1_PWR"),
		MA35_MUX(0xb, "TM2_EXT")),
	MA35_PIN(56, PD12, 0x9c, 0x10,
		MA35_MUX(0x0, "GPD12"),
		MA35_MUX(0x1, "EPWM0_BRAKE0"),
		MA35_MUX(0x2, "UART11_TXD"),
		MA35_MUX(0x3, "UART10_RXD"),
		MA35_MUX(0x4, "I2C4_SDA"),
		MA35_MUX(0x6, "TRACE_DATA0"),
		MA35_MUX(0x7, "EBI_nCS1"),
		MA35_MUX(0x8, "EBI_AD4"),
		MA35_MUX(0x9, "QEI0_INDEX"),
		MA35_MUX(0xb, "TM5"),
		MA35_MUX(0xc, "I2S1_LRCK"),
		MA35_MUX(0xd, "INT1")),
	MA35_PIN(57, PD13, 0x9c, 0x14,
		MA35_MUX(0x0, "GPD13"),
		MA35_MUX(0x1, "EPWM0_BRAKE1"),
		MA35_MUX(0x2, "UART11_RXD"),
		MA35_MUX(0x3, "UART10_TXD"),
		MA35_MUX(0x4, "I2C4_SCL"),
		MA35_MUX(0x6, "TRACE_DATA1"),
		MA35_MUX(0x7, "EBI_nCS2"),
		MA35_MUX(0x8, "EBI_AD5"),
		MA35_MUX(0x9, "ECAP0_IC0"),
		MA35_MUX(0xb, "TM5_EXT"),
		MA35_MUX(0xc, "I2S1_BCLK")),
	MA35_PIN(58, PD14, 0x9c, 0x18,
		MA35_MUX(0x0, "GPD14"),
		MA35_MUX(0x1, "EPWM0_SYNC_IN"),
		MA35_MUX(0x2, "UART11_nCTS"),
		MA35_MUX(0x3, "CAN3_RXD"),
		MA35_MUX(0x6, "TRACE_DATA2"),
		MA35_MUX(0x7, "EBI_MCLK"),
		MA35_MUX(0x8, "EBI_AD6"),
		MA35_MUX(0x9, "ECAP0_IC1"),
		MA35_MUX(0xb, "TM6"),
		MA35_MUX(0xc, "I2S1_DI"),
		MA35_MUX(0xd, "INT3")),
	MA35_PIN(59, PD15, 0x9c, 0x1c,
		MA35_MUX(0x0, "GPD15"),
		MA35_MUX(0x1, "EPWM0_SYNC_OUT"),
		MA35_MUX(0x2, "UART11_nRTS"),
		MA35_MUX(0x3, "CAN3_TXD"),
		MA35_MUX(0x6, "TRACE_DATA3"),
		MA35_MUX(0x7, "EBI_ALE"),
		MA35_MUX(0x8, "EBI_AD7"),
		MA35_MUX(0x9, "ECAP0_IC2"),
		MA35_MUX(0xb, "TM6_EXT"),
		MA35_MUX(0xc, "I2S1_DO")),
	MA35_PIN(60, PE0, 0xa0, 0x0,
		MA35_MUX(0x0, "GPE0"),
		MA35_MUX(0x2, "UART9_nCTS"),
		MA35_MUX(0x3, "UART8_RXD"),
		MA35_MUX(0x7, "CCAP1_DATA0"),
		MA35_MUX(0x8, "RGMII0_MDC"),
		MA35_MUX(0x9, "RMII0_MDC")),
	MA35_PIN(61, PE1, 0xa0, 0x4,
		MA35_MUX(0x0, "GPE1"),
		MA35_MUX(0x2, "UART9_nRTS"),
		MA35_MUX(0x3, "UART8_TXD"),
		MA35_MUX(0x7, "CCAP1_DATA1"),
		MA35_MUX(0x8, "RGMII0_MDIO"),
		MA35_MUX(0x9, "RMII0_MDIO")),
	MA35_PIN(62, PE2, 0xa0, 0x8,
		MA35_MUX(0x0, "GPE2"),
		MA35_MUX(0x2, "UART9_RXD"),
		MA35_MUX(0x7, "CCAP1_DATA2"),
		MA35_MUX(0x8, "RGMII0_TXCTL"),
		MA35_MUX(0x9, "RMII0_TXEN")),
	MA35_PIN(63, PE3, 0xa0, 0xc,
		MA35_MUX(0x0, "GPE3"),
		MA35_MUX(0x2, "UART9_TXD"),
		MA35_MUX(0x7, "CCAP1_DATA3"),
		MA35_MUX(0x8, "RGMII0_TXD0"),
		MA35_MUX(0x9, "RMII0_TXD0")),
	MA35_PIN(64, PE4, 0xa0, 0x10,
		MA35_MUX(0x0, "GPE4"),
		MA35_MUX(0x2, "UART4_nCTS"),
		MA35_MUX(0x3, "UART3_RXD"),
		MA35_MUX(0x7, "CCAP1_DATA4"),
		MA35_MUX(0x8, "RGMII0_TXD1"),
		MA35_MUX(0x9, "RMII0_TXD1")),
	MA35_PIN(65, PE5, 0xa0, 0x14,
		MA35_MUX(0x0, "GPE5"),
		MA35_MUX(0x2, "UART4_nRTS"),
		MA35_MUX(0x3, "UART3_TXD"),
		MA35_MUX(0x7, "CCAP1_DATA5"),
		MA35_MUX(0x8, "RGMII0_RXCLK"),
		MA35_MUX(0x9, "RMII0_REFCLK")),
	MA35_PIN(66, PE6, 0xa0, 0x18,
		MA35_MUX(0x0, "GPE6"),
		MA35_MUX(0x2, "UART4_RXD"),
		MA35_MUX(0x7, "CCAP1_DATA6"),
		MA35_MUX(0x8, "RGMII0_RXCTL"),
		MA35_MUX(0x9, "RMII0_CRSDV")),
	MA35_PIN(67, PE7, 0xa0, 0x1c,
		MA35_MUX(0x0, "GPE7"),
		MA35_MUX(0x2, "UART4_TXD"),
		MA35_MUX(0x7, "CCAP1_DATA7"),
		MA35_MUX(0x8, "RGMII0_RXD0"),
		MA35_MUX(0x9, "RMII0_RXD0")),
	MA35_PIN(68, PE8, 0xa4, 0x0,
		MA35_MUX(0x0, "GPE8"),
		MA35_MUX(0x2, "UART13_nCTS"),
		MA35_MUX(0x3, "UART12_RXD"),
		MA35_MUX(0x7, "CCAP1_SCLK"),
		MA35_MUX(0x8, "RGMII0_RXD1"),
		MA35_MUX(0x9, "RMII0_RXD1")),
	MA35_PIN(69, PE9, 0xa4, 0x4,
		MA35_MUX(0x0, "GPE9"),
		MA35_MUX(0x2, "UART13_nRTS"),
		MA35_MUX(0x3, "UART12_TXD"),
		MA35_MUX(0x7, "CCAP1_PIXCLK"),
		MA35_MUX(0x8, "RGMII0_RXD2"),
		MA35_MUX(0x9, "RMII0_RXERR")),
	MA35_PIN(70, PE10, 0xa4, 0x8,
		MA35_MUX(0x0, "GPE10"),
		MA35_MUX(0x2, "UART15_nCTS"),
		MA35_MUX(0x3, "UART14_RXD"),
		MA35_MUX(0x5, "SPI1_SS0"),
		MA35_MUX(0x7, "CCAP1_HSYNC"),
		MA35_MUX(0x8, "RGMII0_RXD3")),
	MA35_PIN(71, PE11, 0xa4, 0xc,
		MA35_MUX(0x0, "GPE11"),
		MA35_MUX(0x2, "UART15_nRTS"),
		MA35_MUX(0x3, "UART14_TXD"),
		MA35_MUX(0x5, "SPI1_CLK"),
		MA35_MUX(0x7, "CCAP1_VSYNC"),
		MA35_MUX(0x8, "RGMII0_TXCLK")),
	MA35_PIN(72, PE12, 0xa4, 0x10,
		MA35_MUX(0x0, "GPE12"),
		MA35_MUX(0x2, "UART15_RXD"),
		MA35_MUX(0x5, "SPI1_MOSI"),
		MA35_MUX(0x7, "CCAP1_DATA8"),
		MA35_MUX(0x8, "RGMII0_TXD2")),
	MA35_PIN(73, PE13, 0xa4, 0x14,
		MA35_MUX(0x0, "GPE13"),
		MA35_MUX(0x2, "UART15_TXD"),
		MA35_MUX(0x5, "SPI1_MISO"),
		MA35_MUX(0x7, "CCAP1_DATA9"),
		MA35_MUX(0x8, "RGMII0_TXD3")),
	MA35_PIN(74, PE14, 0xa4, 0x18,
		MA35_MUX(0x0, "GPE14"),
		MA35_MUX(0x1, "UART0_TXD")),
	MA35_PIN(75, PE15, 0xa4, 0x1c,
		MA35_MUX(0x0, "GPE15"),
		MA35_MUX(0x1, "UART0_RXD")),
	MA35_PIN(76, PF0, 0xa8, 0x0,
		MA35_MUX(0x0, "GPF0"),
		MA35_MUX(0x2, "UART2_nCTS"),
		MA35_MUX(0x3, "UART1_RXD"),
		MA35_MUX(0x6, "RGMII0_RXD3"),
		MA35_MUX(0x8, "RGMII1_MDC"),
		MA35_MUX(0x9, "RMII1_MDC"),
		MA35_MUX(0xe, "KPI_COL0")),
	MA35_PIN(77, PF1, 0xa8, 0x4,
		MA35_MUX(0x0, "GPF1"),
		MA35_MUX(0x2, "UART2_nRTS"),
		MA35_MUX(0x3, "UART1_TXD"),
		MA35_MUX(0x6, "RGMII0_TXCLK"),
		MA35_MUX(0x8, "RGMII1_MDIO"),
		MA35_MUX(0x9, "RMII1_MDIO"),
		MA35_MUX(0xe, "KPI_COL1")),
	MA35_PIN(78, PF2, 0xa8, 0x8,
		MA35_MUX(0x0, "GPF2"),
		MA35_MUX(0x2, "UART2_RXD"),
		MA35_MUX(0x6, "RGMII0_TXD2"),
		MA35_MUX(0x8, "RGMII1_TXCTL"),
		MA35_MUX(0x9, "RMII1_TXEN"),
		MA35_MUX(0xe, "KPI_COL2")),
	MA35_PIN(79, PF3, 0xa8, 0xc,
		MA35_MUX(0x0, "GPF3"),
		MA35_MUX(0x2, "UART2_TXD"),
		MA35_MUX(0x6, "RGMII0_TXD3"),
		MA35_MUX(0x8, "RGMII1_TXD0"),
		MA35_MUX(0x9, "RMII1_TXD0"),
		MA35_MUX(0xe, "KPI_COL3")),
	MA35_PIN(80, PF4, 0xa8, 0x10,
		MA35_MUX(0x0, "GPF4"),
		MA35_MUX(0x2, "UART11_nCTS"),
		MA35_MUX(0x3, "UART10_RXD"),
		MA35_MUX(0x4, "I2S0_LRCK"),
		MA35_MUX(0x5, "SPI1_SS0"),
		MA35_MUX(0x8, "RGMII1_TXD1"),
		MA35_MUX(0x9, "RMII1_TXD1"),
		MA35_MUX(0xd, "CAN2_RXD"),
		MA35_MUX(0xe, "KPI_ROW0")),
	MA35_PIN(81, PF5, 0xa8, 0x14,
		MA35_MUX(0x0, "GPF5"),
		MA35_MUX(0x2, "UART11_nRTS"),
		MA35_MUX(0x3, "UART10_TXD"),
		MA35_MUX(0x4, "I2S0_BCLK"),
		MA35_MUX(0x5, "SPI1_CLK"),
		MA35_MUX(0x8, "RGMII1_RXCLK"),
		MA35_MUX(0x9, "RMII1_REFCLK"),
		MA35_MUX(0xd, "CAN2_TXD"),
		MA35_MUX(0xe, "KPI_ROW1")),
	MA35_PIN(82, PF6, 0xa8, 0x18,
		MA35_MUX(0x0, "GPF6"),
		MA35_MUX(0x2, "UART11_RXD"),
		MA35_MUX(0x4, "I2S0_DI"),
		MA35_MUX(0x5, "SPI1_MOSI"),
		MA35_MUX(0x8, "RGMII1_RXCTL"),
		MA35_MUX(0x9, "RMII1_CRSDV"),
		MA35_MUX(0xa, "I2C4_SDA"),
		MA35_MUX(0xd, "SC0_CLK"),
		MA35_MUX(0xe, "KPI_ROW2")),
	MA35_PIN(83, PF7, 0xa8, 0x1c,
		MA35_MUX(0x0, "GPF7"),
		MA35_MUX(0x2, "UART11_TXD"),
		MA35_MUX(0x4, "I2S0_DO"),
		MA35_MUX(0x5, "SPI1_MISO"),
		MA35_MUX(0x8, "RGMII1_RXD0"),
		MA35_MUX(0x9, "RMII1_RXD0"),
		MA35_MUX(0xa, "I2C4_SCL"),
		MA35_MUX(0xd, "SC0_DAT"),
		MA35_MUX(0xe, "KPI_ROW3")),
	MA35_PIN(84, PF8, 0xac, 0x0,
		MA35_MUX(0x0, "GPF8"),
		MA35_MUX(0x2, "UART13_RXD"),
		MA35_MUX(0x4, "I2C5_SDA"),
		MA35_MUX(0x5, "SPI0_SS0"),
		MA35_MUX(0x8, "RGMII1_RXD1"),
		MA35_MUX(0x9, "RMII1_RXD1"),
		MA35_MUX(0xd, "SC0_RST"),
		MA35_MUX(0xe, "KPI_COL4")),
	MA35_PIN(85, PF9, 0xac, 0x4,
		MA35_MUX(0x0, "GPF9"),
		MA35_MUX(0x2, "UART13_TXD"),
		MA35_MUX(0x4, "I2C5_SCL"),
		MA35_MUX(0x5, "SPI0_SS1"),
		MA35_MUX(0x8, "RGMII1_RXD2"),
		MA35_MUX(0x9, "RMII1_RXERR"),
		MA35_MUX(0xd, "SC0_PWR"),
		MA35_MUX(0xe, "KPI_COL5")),
	MA35_PIN(86, PF10, 0xac, 0x8,
		MA35_MUX(0x0, "GPF10"),
		MA35_MUX(0x2, "UART13_nCTS"),
		MA35_MUX(0x5, "I2S0_LRCK"),
		MA35_MUX(0x6, "SPI1_SS0"),
		MA35_MUX(0x8, "RGMII1_RXD3"),
		MA35_MUX(0x9, "SC0_CLK"),
		MA35_MUX(0xe, "KPI_COL6")),
	MA35_PIN(87, PF11, 0xac, 0xc,
		MA35_MUX(0x0, "GPF11"),
		MA35_MUX(0x2, "UART13_nRTS"),
		MA35_MUX(0x5, "I2S0_BCLK"),
		MA35_MUX(0x6, "SPI1_CLK"),
		MA35_MUX(0x8, "RGMII1_TXCLK"),
		MA35_MUX(0x9, "SC0_DAT"),
		MA35_MUX(0xe, "KPI_COL7")),
	MA35_PIN(88, PF12, 0xac, 0x10,
		MA35_MUX(0x0, "GPF12"),
		MA35_MUX(0x5, "I2S0_DI"),
		MA35_MUX(0x6, "SPI1_MOSI"),
		MA35_MUX(0x8, "RGMII1_TXD2"),
		MA35_MUX(0x9, "SC0_RST"),
		MA35_MUX(0xe, "KPI_ROW4")),
	MA35_PIN(89, PF13, 0xac, 0x14,
		MA35_MUX(0x0, "GPF13"),
		MA35_MUX(0x5, "I2S0_DO"),
		MA35_MUX(0x6, "SPI1_MISO"),
		MA35_MUX(0x8, "RGMII1_TXD3"),
		MA35_MUX(0x9, "SC0_PWR"),
		MA35_MUX(0xe, "KPI_ROW5")),
	MA35_PIN(90, PF14, 0xac, 0x18,
		MA35_MUX(0x0, "GPF14"),
		MA35_MUX(0x1, "EPWM2_BRAKE0"),
		MA35_MUX(0x2, "EADC0_ST"),
		MA35_MUX(0x3, "RGMII1_PPS"),
		MA35_MUX(0x4, "RMII1_PPS"),
		MA35_MUX(0x5, "SPI0_I2SMCLK"),
		MA35_MUX(0x6, "SPI1_I2SMCLK"),
		MA35_MUX(0x7, "CCAP1_SFIELD"),
		MA35_MUX(0x8, "RGMII0_PPS"),
		MA35_MUX(0x9, "RMII0_PPS"),
		MA35_MUX(0xb, "TM0"),
		MA35_MUX(0xc, "INT0"),
		MA35_MUX(0xd, "SPI1_SS1"),
		MA35_MUX(0xe, "QEI2_INDEX"),
		MA35_MUX(0xf, "I2S0_MCLK")),
	MA35_PIN(91, PF15, 0xac, 0x1c,
		MA35_MUX(0x0, "GPF15"),
		MA35_MUX(0x1, "HSUSB0_VBUSVLD")),
	MA35_PIN(92, PG0, 0xb0, 0x0,
		MA35_MUX(0x0, "GPG0"),
		MA35_MUX(0x1, "EPWM0_CH0"),
		MA35_MUX(0x2, "UART7_TXD"),
		MA35_MUX(0x3, "CAN3_TXD"),
		MA35_MUX(0x5, "SPI0_SS0"),
		MA35_MUX(0x6, "EADC0_ST"),
		MA35_MUX(0x7, "EBI_AD15"),
		MA35_MUX(0x9, "I2S1_MCLK"),
		MA35_MUX(0xa, "QEI0_INDEX"),
		MA35_MUX(0xb, "TM1"),
		MA35_MUX(0xc, "CLKO"),
		MA35_MUX(0xd, "INT0"),
		MA35_MUX(0xf, "EBI_ADR15")),
	MA35_PIN(93, PG1, 0xb0, 0x4,
		MA35_MUX(0x0, "GPG1"),
		MA35_MUX(0x1, "EPWM0_CH3"),
		MA35_MUX(0x2, "UART9_nRTS"),
		MA35_MUX(0x3, "UART6_TXD"),
		MA35_MUX(0x4, "I2C4_SCL"),
		MA35_MUX(0x5, "CAN2_TXD"),
		MA35_MUX(0x7, "EBI_nCS0"),
		MA35_MUX(0x9, "QEI0_B"),
		MA35_MUX(0xb, "TM1_EXT"),
		MA35_MUX(0xe, "RGMII1_PPS"),
		MA35_MUX(0xf, "RMII1_PPS")),
	MA35_PIN(94, PG2, 0xb0, 0x8,
		MA35_MUX(0x0, "GPG2"),
		MA35_MUX(0x1, "EPWM0_CH4"),
		MA35_MUX(0x2, "UART9_RXD"),
		MA35_MUX(0x3, "CAN0_RXD"),
		MA35_MUX(0x5, "SPI0_SS1"),
		MA35_MUX(0x7, "EBI_ADR16"),
		MA35_MUX(0x8, "EBI_nCS2"),
		MA35_MUX(0xa, "QEI0_A"),
		MA35_MUX(0xb, "TM3"),
		MA35_MUX(0xd, "INT1")),
	MA35_PIN(95, PG3, 0xb0, 0xc,
		MA35_MUX(0x0, "GPG3"),
		MA35_MUX(0x1, "EPWM0_CH5"),
		MA35_MUX(0x2, "UART9_TXD"),
		MA35_MUX(0x3, "CAN0_TXD"),
		MA35_MUX(0x5, "SPI0_I2SMCLK"),
		MA35_MUX(0x7, "EBI_ADR17"),
		MA35_MUX(0x8, "EBI_nCS1"),
		MA35_MUX(0x9, "EBI_MCLK"),
		MA35_MUX(0xa, "QEI0_B"),
		MA35_MUX(0xb, "TM3_EXT"),
		MA35_MUX(0xc, "I2S1_MCLK")),
	MA35_PIN(96, PG4, 0xb0, 0x10,
		MA35_MUX(0x0, "GPG4"),
		MA35_MUX(0x1, "EPWM1_CH0"),
		MA35_MUX(0x2, "UART5_nCTS"),
		MA35_MUX(0x3, "UART6_RXD"),
		MA35_MUX(0x5, "SPI3_SS0"),
		MA35_MUX(0x6, "QEI1_INDEX"),
		MA35_MUX(0x7, "EBI_ADR18"),
		MA35_MUX(0x8, "EBI_nCS0"),
		MA35_MUX(0x9, "I2S1_DO"),
		MA35_MUX(0xa, "SC1_CLK"),
		MA35_MUX(0xb, "TM4"),
		MA35_MUX(0xd, "INT2"),
		MA35_MUX(0xe, "ECAP1_IC2")),
	MA35_PIN(97, PG5, 0xb0, 0x14,
		MA35_MUX(0x0, "GPG5"),
		MA35_MUX(0x1, "EPWM1_CH1"),
		MA35_MUX(0x2, "UART5_nRTS"),
		MA35_MUX(0x3, "UART6_TXD"),
		MA35_MUX(0x5, "SPI3_CLK"),
		MA35_MUX(0x6, "ECAP0_IC0"),
		MA35_MUX(0x7, "EBI_ADR19"),
		MA35_MUX(0x8, "EBI_ALE"),
		MA35_MUX(0x9, "I2S1_DI"),
		MA35_MUX(0xa, "SC1_DAT"),
		MA35_MUX(0xb, "TM4_EXT")),
	MA35_PIN(98, PG6, 0xb0, 0x18,
		MA35_MUX(0x0, "GPG6"),
		MA35_MUX(0x1, "EPWM1_CH2"),
		MA35_MUX(0x2, "UART5_RXD"),
		MA35_MUX(0x3, "CAN1_RXD"),
		MA35_MUX(0x5, "SPI3_MOSI"),
		MA35_MUX(0x6, "ECAP0_IC1"),
		MA35_MUX(0x7, "EBI_nRD"),
		MA35_MUX(0x9, "I2S1_BCLK"),
		MA35_MUX(0xa, "SC1_RST"),
		MA35_MUX(0xb, "TM7"),
		MA35_MUX(0xd, "INT3")),
	MA35_PIN(99, PG7, 0xb0, 0x1c,
		MA35_MUX(0x0, "GPG7"),
		MA35_MUX(0x1, "EPWM1_CH3"),
		MA35_MUX(0x2, "UART5_TXD"),
		MA35_MUX(0x3, "CAN1_TXD"),
		MA35_MUX(0x5, "SPI3_MISO"),
		MA35_MUX(0x6, "ECAP0_IC2"),
		MA35_MUX(0x7, "EBI_nWR"),
		MA35_MUX(0x9, "I2S1_LRCK"),
		MA35_MUX(0xa, "SC1_PWR"),
		MA35_MUX(0xb, "TM7_EXT")),
	MA35_PIN(100, PG8, 0xb4, 0x0,
		MA35_MUX(0x0, "GPG8"),
		MA35_MUX(0x1, "EPWM1_CH4"),
		MA35_MUX(0x2, "UART12_RXD"),
		MA35_MUX(0x3, "CAN3_RXD"),
		MA35_MUX(0x5, "SPI2_SS0"),
		MA35_MUX(0x6, "LCM_VSYNC"),
		MA35_MUX(0x7, "I2C3_SDA"),
		MA35_MUX(0xc, "EBI_AD7"),
		MA35_MUX(0xd, "EBI_nCS0")),
	MA35_PIN(101, PG9, 0xb4, 0x4,
		MA35_MUX(0x0, "GPG9"),
		MA35_MUX(0x1, "EPWM1_CH5"),
		MA35_MUX(0x2, "UART12_TXD"),
		MA35_MUX(0x3, "CAN3_TXD"),
		MA35_MUX(0x5, "SPI2_CLK"),
		MA35_MUX(0x6, "LCM_HSYNC"),
		MA35_MUX(0x7, "I2C3_SCL"),
		MA35_MUX(0xc, "EBI_AD8"),
		MA35_MUX(0xd, "EBI_nCS1")),
	MA35_PIN(102, PG10, 0xb4, 0x8,
		MA35_MUX(0x0, "GPG10"),
		MA35_MUX(0x2, "UART12_nRTS"),
		MA35_MUX(0x3, "UART13_TXD"),
		MA35_MUX(0x5, "SPI2_MOSI"),
		MA35_MUX(0x6, "LCM_CLK"),
		MA35_MUX(0xc, "EBI_AD9"),
		MA35_MUX(0xd, "EBI_nWRH")),
	MA35_PIN(103, PG11, 0xb4, 0xc,
		MA35_MUX(0x0, "GPG11"),
		MA35_MUX(0x3, "JTAG_TDO"),
		MA35_MUX(0x5, "I2S0_MCLK"),
		MA35_MUX(0x6, "NAND_RDY1"),
		MA35_MUX(0x7, "EBI_nWRH"),
		MA35_MUX(0x8, "EBI_nCS1"),
		MA35_MUX(0xa, "EBI_AD0")),
	MA35_PIN(104, PG12, 0xb4, 0x10,
		MA35_MUX(0x0, "GPG12"),
		MA35_MUX(0x3, "JTAG_TCK/SW_CLK"),
		MA35_MUX(0x5, "I2S0_LRCK"),
		MA35_MUX(0x7, "EBI_nWRL"),
		MA35_MUX(0xa, "EBI_AD1")),
	MA35_PIN(105, PG13, 0xb4, 0x14,
		MA35_MUX(0x0, "GPG13"),
		MA35_MUX(0x3, "JTAG_TMS/SW_DIO"),
		MA35_MUX(0x5, "I2S0_BCLK"),
		MA35_MUX(0x7, "EBI_MCLK"),
		MA35_MUX(0xa, "EBI_AD2")),
	MA35_PIN(106, PG14, 0xb4, 0x18,
		MA35_MUX(0x0, "GPG14"),
		MA35_MUX(0x3, "JTAG_TDI"),
		MA35_MUX(0x5, "I2S0_DI"),
		MA35_MUX(0x6, "NAND_nCS1"),
		MA35_MUX(0x7, "EBI_ALE"),
		MA35_MUX(0xa, "EBI_AD3")),
	MA35_PIN(107, PG15, 0xb4, 0x1c,
		MA35_MUX(0x0, "GPG15"),
		MA35_MUX(0x3, "JTAG_nTRST"),
		MA35_MUX(0x5, "I2S0_DO"),
		MA35_MUX(0x7, "EBI_nCS0"),
		MA35_MUX(0xa, "EBI_AD4")),
	MA35_PIN(108, PH0, 0xb8, 0x0,
		MA35_MUX(0x0, "GPH0"),
		MA35_MUX(0x2, "UART8_nCTS"),
		MA35_MUX(0x3, "UART7_RXD"),
		MA35_MUX(0x6, "LCM_DATA8")),
	MA35_PIN(109, PH1, 0xb8, 0x4,
		MA35_MUX(0x0, "GPH1"),
		MA35_MUX(0x2, "UART8_nRTS"),
		MA35_MUX(0x3, "UART7_TXD"),
		MA35_MUX(0x6, "LCM_DATA9")),
	MA35_PIN(110, PH2, 0xb8, 0x8,
		MA35_MUX(0x0, "GPH2"),
		MA35_MUX(0x2, "UART8_RXD"),
		MA35_MUX(0x6, "LCM_DATA10")),
	MA35_PIN(111, PH3, 0xb8, 0xc,
		MA35_MUX(0x0, "GPH3"),
		MA35_MUX(0x2, "UART8_TXD"),
		MA35_MUX(0x6, "LCM_DATA11")),
	MA35_PIN(112, PH4, 0xb8, 0x10,
		MA35_MUX(0x0, "GPH4"),
		MA35_MUX(0x2, "UART10_nCTS"),
		MA35_MUX(0x3, "UART9_RXD"),
		MA35_MUX(0x6, "LCM_DATA12")),
	MA35_PIN(113, PH5, 0xb8, 0x14,
		MA35_MUX(0x0, "GPH5"),
		MA35_MUX(0x2, "UART10_nRTS"),
		MA35_MUX(0x3, "UART9_TXD"),
		MA35_MUX(0x6, "LCM_DATA13")),
	MA35_PIN(114, PH6, 0xb8, 0x18,
		MA35_MUX(0x0, "GPH6"),
		MA35_MUX(0x2, "UART10_RXD"),
		MA35_MUX(0x6, "LCM_DATA14")),
	MA35_PIN(115, PH7, 0xb8, 0x1c,
		MA35_MUX(0x0, "GPH7"),
		MA35_MUX(0x2, "UART10_TXD"),
		MA35_MUX(0x6, "LCM_DATA15")),
	MA35_PIN(116, PH8, 0xbc, 0x0,
		MA35_MUX(0x0, "GPH8"),
		MA35_MUX(0x6, "TAMPER0")),
	MA35_PIN(117, PH9, 0xbc, 0x4,
		MA35_MUX(0x0, "GPH9"),
		MA35_MUX(0x4, "CLK_32KOUT"),
		MA35_MUX(0x6, "TAMPER1")),
	MA35_PIN(118, PH12, 0xbc, 0x10,
		MA35_MUX(0x0, "GPH12"),
		MA35_MUX(0x2, "UART14_nCTS"),
		MA35_MUX(0x3, "UART13_RXD"),
		MA35_MUX(0x6, "LCM_DATA20")),
	MA35_PIN(119, PH13, 0xbc, 0x14,
		MA35_MUX(0x0, "GPH13"),
		MA35_MUX(0x2, "UART14_nRTS"),
		MA35_MUX(0x3, "UART13_TXD"),
		MA35_MUX(0x6, "LCM_DATA21")),
	MA35_PIN(120, PH14, 0xbc, 0x18,
		MA35_MUX(0x0, "GPH14"),
		MA35_MUX(0x2, "UART14_RXD"),
		MA35_MUX(0x6, "LCM_DATA22")),
	MA35_PIN(121, PH15, 0xbc, 0x1c,
		MA35_MUX(0x0, "GPH15"),
		MA35_MUX(0x2, "UART14_TXD"),
		MA35_MUX(0x6, "LCM_DATA23")),
	MA35_PIN(122, PI0, 0xc0, 0x0,
		MA35_MUX(0x0, "GPI0"),
		MA35_MUX(0x1, "EPWM0_CH0"),
		MA35_MUX(0x2, "UART12_nCTS"),
		MA35_MUX(0x3, "UART11_RXD"),
		MA35_MUX(0x4, "I2C2_SDA"),
		MA35_MUX(0x5, "SPI3_SS0"),
		MA35_MUX(0x7, "SC0_nCD"),
		MA35_MUX(0x8, "EBI_ADR0"),
		MA35_MUX(0xb, "TM0"),
		MA35_MUX(0xc, "ECAP1_IC0")),
	MA35_PIN(123, PI1, 0xc0, 0x4,
		MA35_MUX(0x0, "GPI1"),
		MA35_MUX(0x1, "EPWM0_CH1"),
		MA35_MUX(0x2, "UART12_nRTS"),
		MA35_MUX(0x3, "UART11_TXD"),
		MA35_MUX(0x4, "I2C2_SCL"),
		MA35_MUX(0x5, "SPI3_CLK"),
		MA35_MUX(0x7, "SC0_CLK"),
		MA35_MUX(0x8, "EBI_ADR1"),
		MA35_MUX(0xb, "TM0_EXT"),
		MA35_MUX(0xc, "ECAP1_IC1")),
	MA35_PIN(124, PI2, 0xc0, 0x8,
		MA35_MUX(0x0, "GPI2"),
		MA35_MUX(0x1, "EPWM0_CH2"),
		MA35_MUX(0x2, "UART12_RXD"),
		MA35_MUX(0x3, "CAN0_RXD"),
		MA35_MUX(0x5, "SPI3_MOSI"),
		MA35_MUX(0x7, "SC0_DAT"),
		MA35_MUX(0x8, "EBI_ADR2"),
		MA35_MUX(0xb, "TM1"),
		MA35_MUX(0xc, "ECAP1_IC2")),
	MA35_PIN(125, PI3, 0xc0, 0xc,
		MA35_MUX(0x0, "GPI3"),
		MA35_MUX(0x1, "EPWM0_CH3"),
		MA35_MUX(0x2, "UART12_TXD"),
		MA35_MUX(0x3, "CAN0_TXD"),
		MA35_MUX(0x5, "SPI3_MISO"),
		MA35_MUX(0x7, "SC0_RST"),
		MA35_MUX(0x8, "EBI_ADR3"),
		MA35_MUX(0xb, "TM1_EXT")),
	MA35_PIN(126, PI4, 0xc0, 0x10,
		MA35_MUX(0x0, "GPI4"),
		MA35_MUX(0x1, "EPWM0_CH4"),
		MA35_MUX(0x2, "UART14_nCTS"),
		MA35_MUX(0x3, "UART13_RXD"),
		MA35_MUX(0x4, "I2C3_SDA"),
		MA35_MUX(0x5, "SPI2_SS1"),
		MA35_MUX(0x6, "I2S1_LRCK"),
		MA35_MUX(0x8, "EBI_ADR4"),
		MA35_MUX(0xd, "INT0")),
	MA35_PIN(127, PI5, 0xc0, 0x14,
		MA35_MUX(0x0, "GPI5"),
		MA35_MUX(0x1, "EPWM0_CH5"),
		MA35_MUX(0x2, "UART14_nRTS"),
		MA35_MUX(0x3, "UART13_TXD"),
		MA35_MUX(0x4, "I2C3_SCL"),
		MA35_MUX(0x6, "I2S1_BCLK"),
		MA35_MUX(0x8, "EBI_ADR5"),
		MA35_MUX(0xd, "INT1")),
	MA35_PIN(128, PI6, 0xc0, 0x18,
		MA35_MUX(0x0, "GPI6"),
		MA35_MUX(0x1, "EPWM0_BRAKE0"),
		MA35_MUX(0x2, "UART14_RXD"),
		MA35_MUX(0x3, "CAN1_RXD"),
		MA35_MUX(0x6, "I2S1_DI"),
		MA35_MUX(0x8, "EBI_ADR6"),
		MA35_MUX(0xc, "QEI1_INDEX"),
		MA35_MUX(0xd, "INT2")),
	MA35_PIN(129, PI7, 0xc0, 0x1c,
		MA35_MUX(0x0, "GPI7"),
		MA35_MUX(0x1, "EPWM0_BRAKE1"),
		MA35_MUX(0x2, "UART14_TXD"),
		MA35_MUX(0x3, "CAN1_TXD"),
		MA35_MUX(0x6, "I2S1_DO"),
		MA35_MUX(0x8, "EBI_ADR7"),
		MA35_MUX(0xc, "ECAP0_IC0"),
		MA35_MUX(0xd, "INT3")),
	MA35_PIN(130, PI8, 0xc4, 0x0,
		MA35_MUX(0x0, "GPI8"),
		MA35_MUX(0x2, "UART4_nCTS"),
		MA35_MUX(0x3, "UART3_RXD"),
		MA35_MUX(0x6, "LCM_DATA0"),
		MA35_MUX(0xc, "EBI_AD11")),
	MA35_PIN(131, PI9, 0xc4, 0x4,
		MA35_MUX(0x0, "GPI9"),
		MA35_MUX(0x2, "UART4_nRTS"),
		MA35_MUX(0x3, "UART3_TXD"),
		MA35_MUX(0x6, "LCM_DATA1"),
		MA35_MUX(0xc, "EBI_AD12")),
	MA35_PIN(132, PI10, 0xc4, 0x8,
		MA35_MUX(0x0, "GPI10"),
		MA35_MUX(0x2, "UART4_RXD"),
		MA35_MUX(0x6, "LCM_DATA2"),
		MA35_MUX(0xc, "EBI_AD13")),
	MA35_PIN(133, PI11, 0xC4, 0xc,
		MA35_MUX(0x0, "GPI11"),
		MA35_MUX(0x2, "UART4_TXD"),
		MA35_MUX(0x6, "LCM_DATA3"),
		MA35_MUX(0xc, "EBI_AD14")),
	MA35_PIN(134, PI12, 0xc4, 0x10,
		MA35_MUX(0x0, "GPI12"),
		MA35_MUX(0x2, "UART6_nCTS"),
		MA35_MUX(0x3, "UART5_RXD"),
		MA35_MUX(0x6, "LCM_DATA4")),
	MA35_PIN(135, PI13, 0xc4, 0x14,
		MA35_MUX(0x0, "GPI13"),
		MA35_MUX(0x2, "UART6_nRTS"),
		MA35_MUX(0x3, "UART5_TXD"),
		MA35_MUX(0x6, "LCM_DATA5")),
	MA35_PIN(136, PI14, 0xc4, 0x18,
		MA35_MUX(0x0, "GPI14"),
		MA35_MUX(0x2, "UART6_RXD"),
		MA35_MUX(0x6, "LCM_DATA6")),
	MA35_PIN(137, PI15, 0xc4, 0x1c,
		MA35_MUX(0x0, "GPI15"),
		MA35_MUX(0x2, "UART6_TXD"),
		MA35_MUX(0x6, "LCM_DATA7")),
	MA35_PIN(138, PJ0, 0xc8, 0x0,
		MA35_MUX(0x0, "GPJ0"),
		MA35_MUX(0x1, "EPWM1_BRAKE0"),
		MA35_MUX(0x2, "UART8_nCTS"),
		MA35_MUX(0x3, "UART7_RXD"),
		MA35_MUX(0x4, "I2C2_SDA"),
		MA35_MUX(0x5, "SPI2_SS0"),
		MA35_MUX(0x6, "eMMC1_DAT4"),
		MA35_MUX(0x7, "I2S0_LRCK"),
		MA35_MUX(0x8, "SC0_CLK"),
		MA35_MUX(0x9, "EBI_AD11"),
		MA35_MUX(0xa, "EBI_ADR16"),
		MA35_MUX(0xb, "EBI_nCS0"),
		MA35_MUX(0xc, "EBI_AD7")),
	MA35_PIN(139, PJ1, 0xc8, 0x4,
		MA35_MUX(0x0, "GPJ1"),
		MA35_MUX(0x1, "EPWM1_BRAKE1"),
		MA35_MUX(0x2, "UART8_nRTS"),
		MA35_MUX(0x3, "UART7_TXD"),
		MA35_MUX(0x4, "I2C2_SCL"),
		MA35_MUX(0x5, "SPI2_CLK"),
		MA35_MUX(0x6, "eMMC1_DAT5"),
		MA35_MUX(0x7, "I2S0_BCLK"),
		MA35_MUX(0x8, "SC0_DAT"),
		MA35_MUX(0x9, "EBI_AD12"),
		MA35_MUX(0xa, "EBI_ADR17"),
		MA35_MUX(0xb, "EBI_nCS1"),
		MA35_MUX(0xc, "EBI_AD8")),
	MA35_PIN(140, PJ2, 0xc8, 0x8,
		MA35_MUX(0x0, "GPJ2"),
		MA35_MUX(0x1, "EPWM1_CH4"),
		MA35_MUX(0x2, "UART8_RXD"),
		MA35_MUX(0x3, "CAN1_RXD"),
		MA35_MUX(0x5, "SPI2_MOSI"),
		MA35_MUX(0x6, "eMMC1_DAT6"),
		MA35_MUX(0x7, "I2S0_DI"),
		MA35_MUX(0x8, "SC0_RST"),
		MA35_MUX(0x9, "EBI_AD13"),
		MA35_MUX(0xa, "EBI_ADR18"),
		MA35_MUX(0xb, "EBI_nWRH"),
		MA35_MUX(0xc, "EBI_AD9")),
	MA35_PIN(141, PJ3, 0xc8, 0xc,
		MA35_MUX(0x0, "GPJ3"),
		MA35_MUX(0x1, "EPWM1_CH5"),
		MA35_MUX(0x2, "UART8_TXD"),
		MA35_MUX(0x3, "CAN1_TXD"),
		MA35_MUX(0x5, "SPI2_MISO"),
		MA35_MUX(0x6, "eMMC1_DAT7"),
		MA35_MUX(0x7, "I2S0_DO"),
		MA35_MUX(0x8, "SC0_PWR"),
		MA35_MUX(0x9, "EBI_AD14"),
		MA35_MUX(0xa, "EBI_ADR19"),
		MA35_MUX(0xb, "EBI_nWRL"),
		MA35_MUX(0xc, "EBI_AD10")),
	MA35_PIN(142, PJ4, 0xc8, 0x10,
		MA35_MUX(0x0, "GPJ4"),
		MA35_MUX(0x4, "I2C3_SDA"),
		MA35_MUX(0x6, "SD1_WP")),
	MA35_PIN(143, PJ5, 0xc8, 0x14,
		MA35_MUX(0x0, "GPJ5"),
		MA35_MUX(0x4, "I2C3_SCL"),
		MA35_MUX(0x6, "SD1_nCD")),
	MA35_PIN(144, PJ6, 0xc8, 0x18,
		MA35_MUX(0x0, "GPJ6"),
		MA35_MUX(0x3, "CAN3_RXD"),
		MA35_MUX(0x6, "SD1_CMD/eMMC1_CMD")),
	MA35_PIN(145, PJ7, 0xc8, 0x1c,
		MA35_MUX(0x0, "GPJ7"),
		MA35_MUX(0x3, "CAN3_TXD"),
		MA35_MUX(0x6, "SD1_CLK/eMMC1_CLK")),
	MA35_PIN(146, PJ8, 0xcc, 0x0,
		MA35_MUX(0x0, "GPJ8"),
		MA35_MUX(0x4, "I2C4_SDA"),
		MA35_MUX(0x6, "SD1_DAT0/eMMC1_DAT0")),
	MA35_PIN(147, PJ9, 0xcc, 0x4,
		MA35_MUX(0x0, "GPJ9"),
		MA35_MUX(0x4, "I2C4_SCL"),
		MA35_MUX(0x6, "SD1_DAT1/eMMC1_DAT1")),
	MA35_PIN(148, PJ10, 0xcc, 0x8,
		MA35_MUX(0x0, "GPJ10"),
		MA35_MUX(0x3, "CAN0_RXD"),
		MA35_MUX(0x6, "SD1_DAT2/eMMC1_DAT2")),
	MA35_PIN(149, PJ11, 0xcc, 0xc,
		MA35_MUX(0x0, "GPJ11"),
		MA35_MUX(0x3, "CAN0_TXD"),
		MA35_MUX(0x6, "SD1_DAT3/eMMC1_DAT3")),
	MA35_PIN(150, PJ12, 0xcc, 0x10,
		MA35_MUX(0x0, "GPJ12"),
		MA35_MUX(0x1, "EPWM1_CH2"),
		MA35_MUX(0x2, "UART2_nCTS"),
		MA35_MUX(0x3, "UART1_RXD"),
		MA35_MUX(0x4, "I2C5_SDA"),
		MA35_MUX(0x5, "SPI3_SS0"),
		MA35_MUX(0x7, "SC1_CLK"),
		MA35_MUX(0x8, "EBI_ADR12"),
		MA35_MUX(0xb, "TM2"),
		MA35_MUX(0xc, "QEI0_INDEX")),
	MA35_PIN(151, PJ13, 0xcc, 0x14,
		MA35_MUX(0x0, "GPJ13"),
		MA35_MUX(0x1, "EPWM1_CH3"),
		MA35_MUX(0x2, "UART2_nRTS"),
		MA35_MUX(0x3, "UART1_TXD"),
		MA35_MUX(0x4, "I2C5_SCL"),
		MA35_MUX(0x5, "SPI3_MOSI"),
		MA35_MUX(0x7, "SC1_DAT"),
		MA35_MUX(0x8, "EBI_ADR13"),
		MA35_MUX(0xb, "TM2_EXT")),
	MA35_PIN(152, PJ14, 0xcc, 0x18,
		MA35_MUX(0x0, "GPJ14"),
		MA35_MUX(0x1, "EPWM1_CH4"),
		MA35_MUX(0x2, "UART2_RXD"),
		MA35_MUX(0x3, "CAN3_RXD"),
		MA35_MUX(0x5, "SPI3_MISO"),
		MA35_MUX(0x7, "SC1_RST"),
		MA35_MUX(0x8, "EBI_ADR14"),
		MA35_MUX(0xb, "TM3")),
	MA35_PIN(153, PJ15, 0xcc, 0x1c,
		MA35_MUX(0x0, "GPJ15"),
		MA35_MUX(0x1, "EPWM1_CH5"),
		MA35_MUX(0x2, "UART2_TXD"),
		MA35_MUX(0x3, "CAN3_TXD"),
		MA35_MUX(0x5, "SPI3_CLK"),
		MA35_MUX(0x6, "EADC0_ST"),
		MA35_MUX(0x7, "SC1_PWR"),
		MA35_MUX(0x8, "EBI_ADR15"),
		MA35_MUX(0xb, "TM3_EXT"),
		MA35_MUX(0xd, "INT1")),
	MA35_PIN(154, PK0, 0xd0, 0x0,
		MA35_MUX(0x0, "GPK0"),
		MA35_MUX(0x1, "EPWM0_SYNC_IN"),
		MA35_MUX(0x2, "UART16_nCTS"),
		MA35_MUX(0x3, "UART15_RXD"),
		MA35_MUX(0x4, "I2C4_SDA"),
		MA35_MUX(0x6, "I2S1_MCLK"),
		MA35_MUX(0x8, "EBI_ADR8"),
		MA35_MUX(0xb, "TM7"),
		MA35_MUX(0xc, "ECAP0_IC1")),
	MA35_PIN(155, PK1, 0xd0, 0x4,
		MA35_MUX(0x0, "GPK1"),
		MA35_MUX(0x1, "EPWM0_SYNC_OUT"),
		MA35_MUX(0x2, "UART16_nRTS"),
		MA35_MUX(0x3, "UART15_TXD"),
		MA35_MUX(0x4, "I2C4_SCL"),
		MA35_MUX(0x6, "EADC0_ST"),
		MA35_MUX(0x8, "EBI_ADR9"),
		MA35_MUX(0xb, "TM7_EXT"),
		MA35_MUX(0xc, "ECAP0_IC2")),
	MA35_PIN(156, PK2, 0xd0, 0x8,
		MA35_MUX(0x0, "GPK2"),
		MA35_MUX(0x1, "EPWM1_CH0"),
		MA35_MUX(0x2, "UART16_RXD"),
		MA35_MUX(0x3, "CAN2_RXD"),
		MA35_MUX(0x5, "SPI3_I2SMCLK"),
		MA35_MUX(0x7, "SC0_PWR"),
		MA35_MUX(0x8, "EBI_ADR10"),
		MA35_MUX(0xc, "QEI0_A")),
	MA35_PIN(157, PK3, 0xd0, 0xc,
		MA35_MUX(0x0, "GPK3"),
		MA35_MUX(0x1, "EPWM1_CH1"),
		MA35_MUX(0x2, "UART16_TXD"),
		MA35_MUX(0x3, "CAN2_TXD"),
		MA35_MUX(0x5, "SPI3_SS1"),
		MA35_MUX(0x7, "SC1_nCD"),
		MA35_MUX(0x8, "EBI_ADR11"),
		MA35_MUX(0xc, "QEI0_B")),
	MA35_PIN(158, PK4, 0xd0, 0x10,
		MA35_MUX(0x0, "GPK4"),
		MA35_MUX(0x2, "UART12_nCTS"),
		MA35_MUX(0x3, "UART13_RXD"),
		MA35_MUX(0x5, "SPI2_MISO"),
		MA35_MUX(0x6, "LCM_DEN"),
		MA35_MUX(0xc, "EBI_AD10"),
		MA35_MUX(0xd, "EBI_nWRL")),
	MA35_PIN(159, PK5, 0xd0, 0x14,
		MA35_MUX(0x0, "GPK5"),
		MA35_MUX(0x1, "EPWM1_CH1"),
		MA35_MUX(0x2, "UART12_nRTS"),
		MA35_MUX(0x3, "UART13_TXD"),
		MA35_MUX(0x4, "I2C4_SCL"),
		MA35_MUX(0x5, "SPI2_CLK"),
		MA35_MUX(0x7, "I2S1_DI"),
		MA35_MUX(0x8, "SC0_DAT"),
		MA35_MUX(0x9, "EADC0_ST"),
		MA35_MUX(0xb, "TM8_EXT"),
		MA35_MUX(0xd, "INT1")),
	MA35_PIN(160, PK6, 0xd0, 0x18,
		MA35_MUX(0x0, "GPK6"),
		MA35_MUX(0x1, "EPWM1_CH2"),
		MA35_MUX(0x2, "UART12_RXD"),
		MA35_MUX(0x3, "CAN0_RXD"),
		MA35_MUX(0x5, "SPI2_MOSI"),
		MA35_MUX(0x7, "I2S1_BCLK"),
		MA35_MUX(0x8, "SC0_RST"),
		MA35_MUX(0xb, "TM6"),
		MA35_MUX(0xd, "INT2")),
	MA35_PIN(161, PK7, 0xd0, 0x1c,
		MA35_MUX(0x0, "GPK7"),
		MA35_MUX(0x1, "EPWM1_CH3"),
		MA35_MUX(0x2, "UART12_TXD"),
		MA35_MUX(0x3, "CAN0_TXD"),
		MA35_MUX(0x5, "SPI2_MISO"),
		MA35_MUX(0x7, "I2S1_LRCK"),
		MA35_MUX(0x8, "SC0_PWR"),
		MA35_MUX(0x9, "CLKO"),
		MA35_MUX(0xb, "TM6_EXT"),
		MA35_MUX(0xd, "INT3")),
	MA35_PIN(162, PK8, 0xd4, 0x0,
		MA35_MUX(0x0, "GPK8"),
		MA35_MUX(0x1, "EPWM1_CH0"),
		MA35_MUX(0x4, "I2C3_SDA"),
		MA35_MUX(0x5, "SPI3_CLK"),
		MA35_MUX(0x7, "EADC0_ST"),
		MA35_MUX(0x8, "EBI_AD15"),
		MA35_MUX(0x9, "EBI_MCLK"),
		MA35_MUX(0xa, "EBI_ADR15"),
		MA35_MUX(0xb, "TM8"),
		MA35_MUX(0xc, "QEI1_INDEX")),
	MA35_PIN(163, PK9, 0xd4, 0x4,
		MA35_MUX(0x0, "GPK9"),
		MA35_MUX(0x4, "I2C3_SCL"),
		MA35_MUX(0x6, "CCAP0_SCLK"),
		MA35_MUX(0x8, "EBI_AD0"),
		MA35_MUX(0xa, "EBI_ADR0")),
	MA35_PIN(164, PK10, 0xd4, 0x8,
		MA35_MUX(0x0, "GPK10"),
		MA35_MUX(0x3, "CAN1_RXD"),
		MA35_MUX(0x6, "CCAP0_PIXCLK"),
		MA35_MUX(0x8, "EBI_AD1"),
		MA35_MUX(0xa, "EBI_ADR1")),
	MA35_PIN(165, PK11, 0xd4, 0xc,
		MA35_MUX(0x0, "GPK11"),
		MA35_MUX(0x3, "CAN1_TXD"),
		MA35_MUX(0x6, "CCAP0_HSYNC"),
		MA35_MUX(0x8, "EBI_AD2"),
		MA35_MUX(0xa, "EBI_ADR2")),
	MA35_PIN(166, PK12, 0xd4, 0x10,
		MA35_MUX(0x0, "GPK12"),
		MA35_MUX(0x1, "EPWM2_CH0"),
		MA35_MUX(0x2, "UART1_nCTS"),
		MA35_MUX(0x3, "UART13_RXD"),
		MA35_MUX(0x4, "I2C4_SDA"),
		MA35_MUX(0x5, "I2S0_LRCK"),
		MA35_MUX(0x6, "SPI1_SS0"),
		MA35_MUX(0x8, "SC0_CLK"),
		MA35_MUX(0xb, "TM10"),
		MA35_MUX(0xd, "INT2")),
	MA35_PIN(167, PK13, 0xd4, 0x14,
		MA35_MUX(0x0, "GPK13"),
		MA35_MUX(0x1, "EPWM2_CH1"),
		MA35_MUX(0x2, "UART1_nRTS"),
		MA35_MUX(0x3, "UART13_TXD"),
		MA35_MUX(0x4, "I2C4_SCL"),
		MA35_MUX(0x5, "I2S0_BCLK"),
		MA35_MUX(0x6, "SPI1_CLK"),
		MA35_MUX(0x8, "SC0_DAT"),
		MA35_MUX(0xb, "TM10_EXT")),
	MA35_PIN(168, PK14, 0xd4, 0x18,
		MA35_MUX(0x0, "GPK14"),
		MA35_MUX(0x1, "EPWM2_CH2"),
		MA35_MUX(0x2, "UART1_RXD"),
		MA35_MUX(0x3, "CAN3_RXD"),
		MA35_MUX(0x5, "I2S0_DI"),
		MA35_MUX(0x6, "SPI1_MOSI"),
		MA35_MUX(0x8, "SC0_RST"),
		MA35_MUX(0xa, "I2C5_SDA"),
		MA35_MUX(0xb, "TM11"),
		MA35_MUX(0xd, "INT3")),
	MA35_PIN(169, PK15, 0xd4, 0x1c,
		MA35_MUX(0x0, "GPK15"),
		MA35_MUX(0x1, "EPWM2_CH3"),
		MA35_MUX(0x2, "UART1_TXD"),
		MA35_MUX(0x3, "CAN3_TXD"),
		MA35_MUX(0x5, "I2S0_DO"),
		MA35_MUX(0x6, "SPI1_MISO"),
		MA35_MUX(0x8, "SC0_PWR"),
		MA35_MUX(0xa, "I2C5_SCL"),
		MA35_MUX(0xb, "TM11_EXT")),
	MA35_PIN(170, PL0, 0xd8, 0x0,
		MA35_MUX(0x0, "GPL0"),
		MA35_MUX(0x1, "EPWM1_CH0"),
		MA35_MUX(0x2, "UART11_nCTS"),
		MA35_MUX(0x3, "UART10_RXD"),
		MA35_MUX(0x4, "I2C3_SDA"),
		MA35_MUX(0x5, "SPI2_MOSI"),
		MA35_MUX(0x6, "QSPI1_MOSI1"),
		MA35_MUX(0x7, "I2S0_LRCK"),
		MA35_MUX(0x8, "EBI_AD11"),
		MA35_MUX(0x9, "SC1_CLK"),
		MA35_MUX(0xb, "TM5"),
		MA35_MUX(0xc, "QEI1_A")),
	MA35_PIN(171, PL1, 0xd8, 0x4,
		MA35_MUX(0x0, "GPL1"),
		MA35_MUX(0x1, "EPWM1_CH1"),
		MA35_MUX(0x2, "UART11_nRTS"),
		MA35_MUX(0x3, "UART10_TXD"),
		MA35_MUX(0x4, "I2C3_SCL"),
		MA35_MUX(0x5, "SPI2_MISO"),
		MA35_MUX(0x6, "QSPI1_MISO1"),
		MA35_MUX(0x7, "I2S0_BCLK"),
		MA35_MUX(0x8, "EBI_AD12"),
		MA35_MUX(0x9, "SC1_DAT"),
		MA35_MUX(0xb, "TM5_EXT"),
		MA35_MUX(0xc, "QEI1_B")),
	MA35_PIN(172, PL2, 0xd8, 0x8,
		MA35_MUX(0x0, "GPL2"),
		MA35_MUX(0x1, "EPWM1_CH2"),
		MA35_MUX(0x2, "UART11_RXD"),
		MA35_MUX(0x3, "CAN3_RXD"),
		MA35_MUX(0x5, "SPI2_SS0"),
		MA35_MUX(0x6, "QSPI1_SS1"),
		MA35_MUX(0x7, "I2S0_DI"),
		MA35_MUX(0x8, "EBI_AD13"),
		MA35_MUX(0x9, "SC1_RST"),
		MA35_MUX(0xb, "TM7"),
		MA35_MUX(0xc, "QEI1_INDEX")),
	MA35_PIN(173, PL3, 0xd8, 0xc,
		MA35_MUX(0x0, "GPL3"),
		MA35_MUX(0x1, "EPWM1_CH3"),
		MA35_MUX(0x2, "UART11_TXD"),
		MA35_MUX(0x3, "CAN3_TXD"),
		MA35_MUX(0x5, "SPI2_CLK"),
		MA35_MUX(0x6, "QSPI1_CLK"),
		MA35_MUX(0x7, "I2S0_DO"),
		MA35_MUX(0x8, "EBI_AD14"),
		MA35_MUX(0x9, "SC1_PWR"),
		MA35_MUX(0xb, "TM7_EXT"),
		MA35_MUX(0xc, "ECAP0_IC0")),
	MA35_PIN(174, PL4, 0xd8, 0x10,
		MA35_MUX(0x0, "GPL4"),
		MA35_MUX(0x1, "EPWM1_CH4"),
		MA35_MUX(0x2, "UART2_nCTS"),
		MA35_MUX(0x3, "UART1_RXD"),
		MA35_MUX(0x4, "I2C4_SDA"),
		MA35_MUX(0x5, "SPI3_MOSI"),
		MA35_MUX(0x6, "QSPI1_MOSI0"),
		MA35_MUX(0x7, "I2S0_MCLK"),
		MA35_MUX(0x8, "EBI_nRD"),
		MA35_MUX(0x9, "SC1_nCD"),
		MA35_MUX(0xb, "TM9"),
		MA35_MUX(0xc, "ECAP0_IC1")),
	MA35_PIN(175, PL5, 0xd8, 0x14,
		MA35_MUX(0x0, "GPL5"),
		MA35_MUX(0x1, "EPWM1_CH5"),
		MA35_MUX(0x2, "UART2_nRTS"),
		MA35_MUX(0x3, "UART1_TXD"),
		MA35_MUX(0x4, "I2C4_SCL"),
		MA35_MUX(0x5, "SPI3_MISO"),
		MA35_MUX(0x6, "QSPI1_MISO0"),
		MA35_MUX(0x7, "I2S1_MCLK"),
		MA35_MUX(0x8, "EBI_nWR"),
		MA35_MUX(0x9, "SC0_nCD"),
		MA35_MUX(0xb, "TM9_EXT"),
		MA35_MUX(0xc, "ECAP0_IC2")),
	MA35_PIN(176, PL6, 0xd8, 0x18,
		MA35_MUX(0x0, "GPL6"),
		MA35_MUX(0x1, "EPWM0_CH0"),
		MA35_MUX(0x2, "UART2_RXD"),
		MA35_MUX(0x3, "CAN0_RXD"),
		MA35_MUX(0x6, "QSPI1_MOSI1"),
		MA35_MUX(0x7, "TRACE_CLK"),
		MA35_MUX(0x8, "EBI_AD5"),
		MA35_MUX(0xb, "TM3"),
		MA35_MUX(0xc, "ECAP1_IC0"),
		MA35_MUX(0xd, "INT0")),
	MA35_PIN(177, PL7, 0xd8, 0x1c,
		MA35_MUX(0x0, "GPL7"),
		MA35_MUX(0x1, "EPWM0_CH1"),
		MA35_MUX(0x2, "UART2_TXD"),
		MA35_MUX(0x3, "CAN0_TXD"),
		MA35_MUX(0x6, "QSPI1_MISO1"),
		MA35_MUX(0x8, "EBI_AD6"),
		MA35_MUX(0xb, "TM3_EXT"),
		MA35_MUX(0xc, "ECAP1_IC1"),
		MA35_MUX(0xd, "INT1")),
	MA35_PIN(178, PL8, 0xdc, 0x0,
		MA35_MUX(0x0, "GPL8"),
		MA35_MUX(0x1, "EPWM0_CH2"),
		MA35_MUX(0x2, "UART14_nCTS"),
		MA35_MUX(0x3, "UART13_RXD"),
		MA35_MUX(0x4, "I2C5_SDA"),
		MA35_MUX(0x5, "SPI3_SS0"),
		MA35_MUX(0x6, "EPWM0_CH4"),
		MA35_MUX(0x7, "I2S1_LRCK"),
		MA35_MUX(0x8, "EBI_AD7"),
		MA35_MUX(0x9, "SC0_CLK"),
		MA35_MUX(0xb, "TM4"),
		MA35_MUX(0xc, "ECAP1_IC2"),
		MA35_MUX(0xd, "INT2")),
	MA35_PIN(179, PL9, 0xdc, 0x4,
		MA35_MUX(0x0, "GPL9"),
		MA35_MUX(0x1, "EPWM0_CH3"),
		MA35_MUX(0x2, "UART14_nRTS"),
		MA35_MUX(0x3, "UART13_TXD"),
		MA35_MUX(0x4, "I2C5_SCL"),
		MA35_MUX(0x5, "SPI3_CLK"),
		MA35_MUX(0x6, "EPWM1_CH4"),
		MA35_MUX(0x7, "I2S1_BCLK"),
		MA35_MUX(0x8, "EBI_AD8"),
		MA35_MUX(0x9, "SC0_DAT"),
		MA35_MUX(0xb, "TM4_EXT"),
		MA35_MUX(0xc, "QEI0_A"),
		MA35_MUX(0xd, "INT3")),
	MA35_PIN(180, PL10, 0xdc, 0x8,
		MA35_MUX(0x0, "GPL10"),
		MA35_MUX(0x1, "EPWM0_CH4"),
		MA35_MUX(0x2, "UART14_RXD"),
		MA35_MUX(0x3, "CAN3_RXD"),
		MA35_MUX(0x5, "SPI3_MOSI"),
		MA35_MUX(0x6, "EPWM0_CH5"),
		MA35_MUX(0x7, "I2S1_DI"),
		MA35_MUX(0x8, "EBI_AD9"),
		MA35_MUX(0x9, "SC0_RST"),
		MA35_MUX(0xb, "EBI_nWRH"),
		MA35_MUX(0xc, "QEI0_B")),
	MA35_PIN(181, PL11, 0xdc, 0xc,
		MA35_MUX(0x0, "GPL11"),
		MA35_MUX(0x1, "EPWM0_CH5"),
		MA35_MUX(0x2, "UART14_TXD"),
		MA35_MUX(0x3, "CAN3_TXD"),
		MA35_MUX(0x5, "SPI3_MISO"),
		MA35_MUX(0x6, "EPWM1_CH5"),
		MA35_MUX(0x7, "I2S1_DO"),
		MA35_MUX(0x8, "EBI_AD10"),
		MA35_MUX(0x9, "SC0_PWR"),
		MA35_MUX(0xb, "EBI_nWRL"),
		MA35_MUX(0xc, "QEI0_INDEX")),
	MA35_PIN(182, PL12, 0xdc, 0x10,
		MA35_MUX(0x0, "GPL12"),
		MA35_MUX(0x1, "EPWM0_SYNC_IN"),
		MA35_MUX(0x2, "UART7_nCTS"),
		MA35_MUX(0x3, "ECAP1_IC0"),
		MA35_MUX(0x4, "UART14_RXD"),
		MA35_MUX(0x5, "SPI0_SS0"),
		MA35_MUX(0x6, "I2S1_LRCK"),
		MA35_MUX(0x7, "SC1_CLK"),
		MA35_MUX(0x8, "EBI_AD0"),
		MA35_MUX(0x9, "HSUSBH_PWREN"),
		MA35_MUX(0xa, "I2C2_SDA"),
		MA35_MUX(0xb, "TM0"),
		MA35_MUX(0xc, "EPWM0_CH2"),
		MA35_MUX(0xd, "EBI_AD11"),
		MA35_MUX(0xe, "RGMII0_PPS"),
		MA35_MUX(0xf, "RMII0_PPS")),
	MA35_PIN(183, PL13, 0xdc, 0x14,
		MA35_MUX(0x0, "GPL13"),
		MA35_MUX(0x1, "EPWM0_SYNC_OUT"),
		MA35_MUX(0x2, "UART7_nRTS"),
		MA35_MUX(0x3, "ECAP1_IC1"),
		MA35_MUX(0x4, "UART14_TXD"),
		MA35_MUX(0x5, "SPI0_CLK"),
		MA35_MUX(0x6, "I2S1_BCLK"),
		MA35_MUX(0x7, "SC1_DAT"),
		MA35_MUX(0x8, "EBI_AD1"),
		MA35_MUX(0x9, "HSUSBH_OVC"),
		MA35_MUX(0xa, "I2C2_SCL"),
		MA35_MUX(0xb, "TM0_EXT"),
		MA35_MUX(0xc, "EPWM0_CH3"),
		MA35_MUX(0xd, "EBI_AD12"),
		MA35_MUX(0xe, "RGMII1_PPS"),
		MA35_MUX(0xf, "RMII1_PPS")),
	MA35_PIN(184, PL14, 0xdc, 0x18,
		MA35_MUX(0x0, "GPL14"),
		MA35_MUX(0x1, "EPWM0_CH2"),
		MA35_MUX(0x2, "UART7_RXD"),
		MA35_MUX(0x4, "CAN1_RXD"),
		MA35_MUX(0x5, "SPI0_MOSI"),
		MA35_MUX(0x6, "I2S1_DI"),
		MA35_MUX(0x7, "SC1_RST"),
		MA35_MUX(0x8, "EBI_AD2"),
		MA35_MUX(0xb, "TM2"),
		MA35_MUX(0xc, "INT0"),
		MA35_MUX(0xd, "EBI_AD13")),
	MA35_PIN(185, PL15, 0xdc, 0x1c,
		MA35_MUX(0x0, "GPL15"),
		MA35_MUX(0x1, "EPWM0_CH1"),
		MA35_MUX(0x2, "UART7_TXD"),
		MA35_MUX(0x3, "TRACE_CLK"),
		MA35_MUX(0x4, "CAN1_TXD"),
		MA35_MUX(0x5, "SPI0_MISO"),
		MA35_MUX(0x6, "I2S1_DO"),
		MA35_MUX(0x7, "SC1_PWR"),
		MA35_MUX(0x8, "EBI_AD3"),
		MA35_MUX(0xb, "TM2_EXT"),
		MA35_MUX(0xc, "INT2"),
		MA35_MUX(0xd, "EBI_AD14")),
	MA35_PIN(186, PM0, 0xe0, 0x0,
		MA35_MUX(0x0, "GPM0"),
		MA35_MUX(0x4, "I2C4_SDA"),
		MA35_MUX(0x6, "CCAP0_VSYNC"),
		MA35_MUX(0x8, "EBI_AD3"),
		MA35_MUX(0xa, "EBI_ADR3")),
	MA35_PIN(187, PM1, 0xe0, 0x4,
		MA35_MUX(0x0, "GPM1"),
		MA35_MUX(0x4, "I2C4_SCL"),
		MA35_MUX(0x5, "SPI3_I2SMCLK"),
		MA35_MUX(0x6, "CCAP0_SFIELD"),
		MA35_MUX(0x8, "EBI_AD4"),
		MA35_MUX(0xa, "EBI_ADR4")),
	MA35_PIN(188, PM2, 0xe0, 0x8,
		MA35_MUX(0x0, "GPM2"),
		MA35_MUX(0x3, "CAN3_RXD"),
		MA35_MUX(0x6, "CCAP0_DATA0"),
		MA35_MUX(0x8, "EBI_AD5"),
		MA35_MUX(0xa, "EBI_ADR5")),
	MA35_PIN(189, PM3, 0xe0, 0xc,
		MA35_MUX(0x0, "GPM3"),
		MA35_MUX(0x3, "CAN3_TXD"),
		MA35_MUX(0x6, "CCAP0_DATA1"),
		MA35_MUX(0x8, "EBI_AD6"),
		MA35_MUX(0xa, "EBI_ADR6")),
	MA35_PIN(190, PM4, 0xe0, 0x10,
		MA35_MUX(0x0, "GPM4"),
		MA35_MUX(0x4, "I2C5_SDA"),
		MA35_MUX(0x6, "CCAP0_DATA2"),
		MA35_MUX(0x8, "EBI_AD7"),
		MA35_MUX(0xa, "EBI_ADR7")),
	MA35_PIN(191, PM5, 0xe0, 0x14,
		MA35_MUX(0x0, "GPM5"),
		MA35_MUX(0x4, "I2C5_SCL"),
		MA35_MUX(0x6, "CCAP0_DATA3"),
		MA35_MUX(0x8, "EBI_AD8"),
		MA35_MUX(0xa, "EBI_ADR8")),
	MA35_PIN(192, PM6, 0xe0, 0x18,
		MA35_MUX(0x0, "GPM6"),
		MA35_MUX(0x3, "CAN0_RXD"),
		MA35_MUX(0x6, "CCAP0_DATA4"),
		MA35_MUX(0x8, "EBI_AD9"),
		MA35_MUX(0xa, "EBI_ADR9")),
	MA35_PIN(193, PM7, 0xe0, 0x1c,
		MA35_MUX(0x0, "GPM7"),
		MA35_MUX(0x3, "CAN0_TXD"),
		MA35_MUX(0x6, "CCAP0_DATA5"),
		MA35_MUX(0x8, "EBI_AD10"),
		MA35_MUX(0xa, "EBI_ADR10")),
	MA35_PIN(194, PM8, 0xe4, 0x0,
		MA35_MUX(0x0, "GPM8"),
		MA35_MUX(0x4, "I2C0_SDA"),
		MA35_MUX(0x6, "CCAP0_DATA6"),
		MA35_MUX(0x8, "EBI_AD11"),
		MA35_MUX(0xa, "EBI_ADR11")),
	MA35_PIN(195, PM9, 0xe4, 0x4,
		MA35_MUX(0x0, "GPM9"),
		MA35_MUX(0x4, "I2C0_SCL"),
		MA35_MUX(0x6, "CCAP0_DATA7"),
		MA35_MUX(0x8, "EBI_AD12"),
		MA35_MUX(0xa, "EBI_ADR12")),
	MA35_PIN(196, PM10, 0xe4, 0x8,
		MA35_MUX(0x0, "GPM10"),
		MA35_MUX(0x1, "EPWM1_CH2"),
		MA35_MUX(0x3, "CAN2_RXD"),
		MA35_MUX(0x5, "SPI3_SS0"),
		MA35_MUX(0x6, "CCAP0_DATA8"),
		MA35_MUX(0x7, "SPI2_I2SMCLK"),
		MA35_MUX(0x8, "EBI_AD13"),
		MA35_MUX(0xa, "EBI_ADR13")),
	MA35_PIN(197, PM11, 0xe4, 0xc,
		MA35_MUX(0x0, "GPM11"),
		MA35_MUX(0x1, "EPWM1_CH3"),
		MA35_MUX(0x3, "CAN2_TXD"),
		MA35_MUX(0x5, "SPI3_SS1"),
		MA35_MUX(0x6, "CCAP0_DATA9"),
		MA35_MUX(0x7, "SPI2_SS1"),
		MA35_MUX(0x8, "EBI_AD14"),
		MA35_MUX(0xa, "EBI_ADR14")),
	MA35_PIN(198, PM12, 0xe4, 0x10,
		MA35_MUX(0x0, "GPM12"),
		MA35_MUX(0x1, "EPWM1_CH4"),
		MA35_MUX(0x2, "UART10_nCTS"),
		MA35_MUX(0x3, "TRACE_DATA0"),
		MA35_MUX(0x4, "UART11_RXD"),
		MA35_MUX(0x5, "I2C2_SDA"),
		MA35_MUX(0x7, "SC1_nCD"),
		MA35_MUX(0x8, "EBI_AD8"),
		MA35_MUX(0x9, "I2S1_MCLK"),
		MA35_MUX(0xb, "TM8")),
	MA35_PIN(199, PM13, 0xe4, 0x14,
		MA35_MUX(0x0, "GPM13"),
		MA35_MUX(0x1, "EPWM1_CH5"),
		MA35_MUX(0x2, "UART10_nRTS"),
		MA35_MUX(0x3, "TRACE_DATA1"),
		MA35_MUX(0x4, "UART11_TXD"),
		MA35_MUX(0x5, "I2C2_SCL"),
		MA35_MUX(0x8, "EBI_AD9"),
		MA35_MUX(0x9, "ECAP1_IC0"),
		MA35_MUX(0xb, "TM8_EXT")),
	MA35_PIN(200, PM14, 0xe4, 0x18,
		MA35_MUX(0x0, "GPM14"),
		MA35_MUX(0x1, "EPWM1_BRAKE0"),
		MA35_MUX(0x2, "UART10_RXD"),
		MA35_MUX(0x3, "TRACE_DATA2"),
		MA35_MUX(0x4, "CAN2_RXD"),
		MA35_MUX(0x6, "I2C3_SDA"),
		MA35_MUX(0x8, "EBI_AD10"),
		MA35_MUX(0x9, "ECAP1_IC1"),
		MA35_MUX(0xb, "TM10"),
		MA35_MUX(0xd, "INT1")),
	MA35_PIN(201, PM15, 0xe4, 0x1c,
		MA35_MUX(0x0, "GPM15"),
		MA35_MUX(0x1, "EPWM1_BRAKE1"),
		MA35_MUX(0x2, "UART10_TXD"),
		MA35_MUX(0x3, "TRACE_DATA3"),
		MA35_MUX(0x4, "CAN2_TXD"),
		MA35_MUX(0x6, "I2C3_SCL"),
		MA35_MUX(0x8, "EBI_AD11"),
		MA35_MUX(0x9, "ECAP1_IC2"),
		MA35_MUX(0xb, "TM10_EXT"),
		MA35_MUX(0xd, "INT2")),
	MA35_PIN(202, PN0, 0xe8, 0x0,
		MA35_MUX(0x0, "GPN0"),
		MA35_MUX(0x4, "I2C2_SDA"),
		MA35_MUX(0x6, "CCAP1_DATA0")),
	MA35_PIN(203, PN1, 0xe8, 0x4,
		MA35_MUX(0x0, "GPN1"),
		MA35_MUX(0x4, "I2C2_SCL"),
		MA35_MUX(0x6, "CCAP1_DATA1")),
	MA35_PIN(204, PN2, 0xe8, 0x8,
		MA35_MUX(0x0, "GPN2"),
		MA35_MUX(0x3, "CAN0_RXD"),
		MA35_MUX(0x6, "CCAP1_DATA2")),
	MA35_PIN(205, PN3, 0xe8, 0xc,
		MA35_MUX(0x0, "GPN3"),
		MA35_MUX(0x3, "CAN0_TXD"),
		MA35_MUX(0x6, "CCAP1_DATA3")),
	MA35_PIN(206, PN4, 0xe8, 0x10,
		MA35_MUX(0x0, "GPN4"),
		MA35_MUX(0x4, "I2C1_SDA"),
		MA35_MUX(0x6, "CCAP1_DATA4")),
	MA35_PIN(207, PN5, 0xe8, 0x14,
		MA35_MUX(0x0, "GPN5"),
		MA35_MUX(0x4, "I2C1_SCL"),
		MA35_MUX(0x6, "CCAP1_DATA5")),
	MA35_PIN(208, PN6, 0xe8, 0x18,
		MA35_MUX(0x0, "GPN6"),
		MA35_MUX(0x3, "CAN1_RXD"),
		MA35_MUX(0x6, "CCAP1_DATA6")),
	MA35_PIN(209, PN7, 0xe8, 0x1c,
		MA35_MUX(0x0, "GPN7"),
		MA35_MUX(0x3, "CAN1_TXD"),
		MA35_MUX(0x6, "CCAP1_DATA7")),
	MA35_PIN(210, PN10, 0xec, 0x8,
		MA35_MUX(0x0, "GPN10"),
		MA35_MUX(0x3, "CAN2_RXD"),
		MA35_MUX(0x6, "CCAP1_SCLK")),
	MA35_PIN(211, PN11, 0xec, 0xc,
		MA35_MUX(0x0, "GPN11"),
		MA35_MUX(0x3, "CAN2_TXD"),
		MA35_MUX(0x6, "CCAP1_PIXCLK")),
	MA35_PIN(212, PN12, 0xec, 0x10,
		MA35_MUX(0x0, "GPN12"),
		MA35_MUX(0x2, "UART6_nCTS"),
		MA35_MUX(0x3, "UART12_RXD"),
		MA35_MUX(0x4, "I2C5_SDA"),
		MA35_MUX(0x6, "CCAP1_HSYNC")),
	MA35_PIN(213, PN13, 0xec, 0x14,
		MA35_MUX(0x0, "GPN13"),
		MA35_MUX(0x2, "UART6_nRTS"),
		MA35_MUX(0x3, "UART12_TXD"),
		MA35_MUX(0x4, "I2C5_SCL"),
		MA35_MUX(0x6, "CCAP1_VSYNC")),
	MA35_PIN(214, PN14, 0xec, 0x18,
		MA35_MUX(0x0, "GPN14"),
		MA35_MUX(0x2, "UART6_RXD"),
		MA35_MUX(0x3, "CAN3_RXD"),
		MA35_MUX(0x5, "SPI1_SS1"),
		MA35_MUX(0x6, "CCAP1_SFIELD"),
		MA35_MUX(0x7, "SPI1_I2SMCLK")),
	MA35_PIN(215, PN15, 0xec, 0x1c,
		MA35_MUX(0x0, "GPN15"),
		MA35_MUX(0x1, "EPWM2_CH4"),
		MA35_MUX(0x2, "UART6_TXD"),
		MA35_MUX(0x3, "CAN3_TXD"),
		MA35_MUX(0x5, "I2S0_MCLK"),
		MA35_MUX(0x6, "SPI1_SS1"),
		MA35_MUX(0x7, "SPI1_I2SMCLK"),
		MA35_MUX(0x8, "SC0_nCD"),
		MA35_MUX(0x9, "EADC0_ST"),
		MA35_MUX(0xa, "CLKO"),
		MA35_MUX(0xb, "TM6")),
	MA35_PIN(216, PN8, 0xec, 0x0,
		MA35_MUX(0x0, "GPN8"),
		MA35_MUX(0x1, "EPWM2_CH4"),
		MA35_MUX(0x4, "I2C0_SDA"),
		MA35_MUX(0x5, "SPI2_I2SMCLK"),
		MA35_MUX(0x6, "CCAP1_DATA8")),
	MA35_PIN(217, PN9, 0xec, 0x4,
		MA35_MUX(0x0, "GPN9"),
		MA35_MUX(0x1, "EPWM2_CH5"),
		MA35_MUX(0x4, "I2C0_SCL"),
		MA35_MUX(0x5, "SPI1_I2SMCLK"),
		MA35_MUX(0x6, "CCAP1_DATA9")),
	MA35_PIN(218, PN10, 0xec, 0x8,
		MA35_MUX(0x0, "GPN10"),
		MA35_MUX(0x3, "CAN2_RXD"),
		MA35_MUX(0x4, "USBHL2_DM"),
		MA35_MUX(0x6, "CCAP1_SCLK")),
	MA35_PIN(219, PN11, 0xec, 0xc,
		MA35_MUX(0x0, "GPN11"),
		MA35_MUX(0x3, "CAN2_TXD"),
		MA35_MUX(0x4, "USBHL2_DP"),
		MA35_MUX(0x6, "CCAP1_PIXCLK")),
	MA35_PIN(220, PN12, 0xec, 0x10,
		MA35_MUX(0x0, "GPN12"),
		MA35_MUX(0x2, "UART6_nCTS"),
		MA35_MUX(0x3, "UART12_RXD"),
		MA35_MUX(0x4, "I2C5_SDA"),
		MA35_MUX(0x6, "CCAP1_HSYNC")),
	MA35_PIN(221, PN13, 0xec, 0x14,
		MA35_MUX(0x0, "GPN13"),
		MA35_MUX(0x2, "UART6_nRTS"),
		MA35_MUX(0x3, "UART12_TXD"),
		MA35_MUX(0x4, "I2C5_SCL"),
		MA35_MUX(0x6, "CCAP1_VSYNC")),
	MA35_PIN(222, PN14, 0xec, 0x18,
		MA35_MUX(0x0, "GPN14"),
		MA35_MUX(0x2, "UART6_RXD"),
		MA35_MUX(0x3, "CAN3_RXD"),
		MA35_MUX(0x4, "USBHL3_DM"),
		MA35_MUX(0x5, "SPI1_SS1"),
		MA35_MUX(0x6, "CCAP1_SFIELD"),
		MA35_MUX(0x7, "SPI1_I2SMCLK")),
	MA35_PIN(223, PN15, 0xec, 0x1c,
		MA35_MUX(0x0, "GPN15"),
		MA35_MUX(0x1, "EPWM2_CH4"),
		MA35_MUX(0x2, "UART6_TXD"),
		MA35_MUX(0x3, "CAN3_TXD"),
		MA35_MUX(0x4, "USBHL3_DP"),
		MA35_MUX(0x5, "I2S0_MCLK"),
		MA35_MUX(0x6, "SPI1_SS1"),
		MA35_MUX(0x7, "SPI1_I2SMCLK"),
		MA35_MUX(0x8, "SC0_nCD"),
		MA35_MUX(0x9, "EADC0_ST"),
		MA35_MUX(0xa, "CLKO"),
		MA35_MUX(0xb, "TM6")),
};

static int ma35d1_get_pin_num(int offset, int shift)
{
	return (offset - 0x80) * 2 + shift / 4;
}

static struct ma35_pinctrl_soc_info ma35d1_pinctrl_info = {
	.pins = ma35d1_pins,
	.npins = ARRAY_SIZE(ma35d1_pins),
	.get_pin_num = ma35d1_get_pin_num,
};

static DEFINE_NOIRQ_DEV_PM_OPS(ma35_pinctrl_pm_ops, ma35_pinctrl_suspend, ma35_pinctrl_resume);

static int ma35d1_pinctrl_probe(struct platform_device *pdev)
{
	return ma35_pinctrl_probe(pdev, &ma35d1_pinctrl_info);
}

static const struct of_device_id ma35d1_pinctrl_of_match[] = {
	{ .compatible = "nuvoton,ma35d1-pinctrl" },
	{ },
};

static struct platform_driver ma35d1_pinctrl_driver = {
	.probe = ma35d1_pinctrl_probe,
	.driver = {
		.name = "ma35d1-pinctrl",
		.pm = pm_sleep_ptr(&ma35_pinctrl_pm_ops),
		.of_match_table = ma35d1_pinctrl_of_match,
	},
};

static int __init ma35d1_pinctrl_init(void)
{
	return platform_driver_register(&ma35d1_pinctrl_driver);
}
arch_initcall(ma35d1_pinctrl_init);

MODULE_AUTHOR("schung@nuvoton.com");
MODULE_DESCRIPTION("Nuvoton MA35D1 pinctrl driver");
MODULE_LICENSE("GPL");
