#!/bin/bash

pkgAfull=$1
pkgBfull=$2
pkgA=`basename $pkgAfull`
pkgB=`basename $pkgBfull`
TMPA=/tmp/pkga/
TMPB=/tmp/pkgb/
mkdir $TMPA
mkdir $TMPB
# get provides
rm -f $TMPA/$pkgA-provides $TMPB/$pkgB-provides
rpm -qp --provides $pkgAfull | sort > $TMPA/$pkgA-provides
rpm -qp --provides $pkgBfull | sort > $TMPB/$pkgB-provides
# get requires
rm -f $TMPA/$pkgA-requires $TMPB/$pkgB-requires
rpm -qp --requires $pkgAfull | sort > $TMPA/$pkgA-requires
rpm -qp --requires $pkgBfull | sort > $TMPB/$pkgB-requires
# extract package to separate roots
rm -rf $TMPA/$pkgA-root $TMPB/$pkgB-root
mkdir $TMPA/$pkgA-root $TMPB/$pkgB-root
rpm2cpio $pkgAfull | (cd $TMPA/$pkgA-root; cpio -id) 2> /dev/null > /dev/null
rpm2cpio $pkgBfull | (cd $TMPB/$pkgB-root; cpio -id) 2> /dev/null > /dev/null
# get ldd output
rm -f $TMPA/$pkgA-ldd $TMPB/$pkgB-ldd
(cd $TMPA/$pkgA-root; find . -type f -exec file {} \; | grep ELF | cut -d: -f1 | xargs ldd | sort -u) 2> /dev/null > $TMPA/$pkgA-ldd
(cd $TMPB/$pkgB-root; find . -type f -exec file {} \; | grep ELF | cut -d: -f1 | xargs ldd | sort -u) 2> /dev/null > $TMPB/$pkgB-ldd
# get nm output (cut addresses out)
rm -f $TMPA/$pkgA-nm $TMPB/$pkgB-nm
(cd $TMPA/$pkgA-root; find . -type f -exec file {} \; | grep ELF | cut -d: -f1 | xargs nm | cut -c10- | sort -u) 2> /dev/null > $TMPA/$pkgA-nm
(cd $TMPB/$pkgB-root; find . -type f -exec file {} \; | grep ELF | cut -d: -f1 | xargs nm | cut -c10- | sort -u) 2> /dev/null > $TMPB/$pkgB-nm

# print report
(echo ===============================================================================
echo Differences between:
echo
echo $pkgAfull
echo $pkgBfull
echo
if ! diff -q $TMPA/$pkgA-provides $TMPB/$pkgB-provides 2> /dev/null > /dev/null; then
    echo -------------------------------------------------------------------------------
    echo RPM Provides:
    echo
    diff -ub $TMPA/$pkgA-provides $TMPB/$pkgB-provides
    echo
fi
if ! diff -q $TMPA/$pkgA-requires $TMPB/$pkgB-requires 2> /dev/null > /dev/null; then
    echo -------------------------------------------------------------------------------
    echo RPM Requires:
    echo
    diff -ub $TMPA/$pkgA-requires $TMPB/$pkgB-requires
    echo
fi
if ! diff -q $TMPA/$pkgA-ldd $TMPB/$pkgB-ldd 2> /dev/null > /dev/null; then
    echo -------------------------------------------------------------------------------
    echo 'Dynamic Link Libraries (ldd):'
    echo
    diff -ub $TMPA/$pkgA-ldd $TMPB/$pkgB-ldd
    echo
fi
if ! diff -q $TMPA/$pkgA-nm $TMPB/$pkgB-nm 2> /dev/null > /dev/null; then
    echo -------------------------------------------------------------------------------
    echo 'Symbol Tables (nm):'
    echo
    diff -ub $TMPA/$pkgA-nm $TMPB/$pkgB-nm
    echo
fi
if ! diff -qr $TMPA/$pkgA-root $TMPB/$pkgB-root 2> /dev/null > /dev/null; then
    echo -------------------------------------------------------------------------------
    echo RPM Packaged Files:
    echo
    diff -urb $TMPA/$pkgA-root $TMPB/$pkgB-root 2> /dev/null
    echo
fi
echo ===============================================================================
) > $TMPB/$pkgB-diff.txt
