#!/bin/bash
#
# Erik Troan <ewt@redhat.com> 
#
# Copyright 1998 Red Hat Software
#
# This software may be freely redistributed under the terms of the GNU
# public license.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

while [ $# -gt 0 ]; do
    case $1 in
	--arch)
	    shift
	    ARCH=$1
	    ;;

	--version)
	    shift
	    VERSION=$1
	    ;;

	--site)
	    shift
	    SITE=$1
	    ;;
	
	--dest)
	    shift
	    DEST=$1
	    ;;

	--subdir)
	    shift
	    SUBDIR=$1
	    ;;

	*)
	    break
	    ;;
    esac

    shift
done

. ../../locations.include
echo $SITE
echo $RELEASEDIR

TREE=$RELEASEDIR
if [ ! -d $TREE/$SUBDIR ]; then
    echo "subdir must be the directory to place at the root of the CD"
    exit 1
fi

if [ -z "$DEST" ]; then
    echo "--dest needs to be defined"
    exit 1
fi

echo "Creating $DEST from $TREE/$SUBDIR"

cd $TREE/$SUBDIR
BOOTIMG="isolinux/isolinux.bin"
echo "Boot image is" $BOOTIMG
BOOTCAT="isolinux/boot.cat"
BOOTOPTS="-no-emul-boot -boot-load-size 4 -boot-info-table"

# Create the image (This is for disk 1)
mkisofs \
	-A "$SITE $DEFAULT DISC1" \
	-R -l -v -J \
	-x ./lost+found \
        -c $BOOTCAT $BOOTOPTS \
 	-b $BOOTIMG \
	-o $DEST \
	. 
