/* c-strcasecmp.c -- case insensitive string comparator in C locale
   Copyright (C) 1998-1999, 2005-2006, 2009-2026 Free Software Foundation, Inc.

   This file is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as
   published by the Free Software Foundation; either version 2.1 of the
   License, or (at your option) any later version.

   This file is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

#include <config.h>

/* Specification.  */
#include "c-strcase.h"

#include <limits.h>

#include "c-ctype.h"

int
c_strcasecmp (const char *s1, const char *s2)
{
  register const unsigned char *p1 = (const unsigned char *) s1;
  register const unsigned char *p2 = (const unsigned char *) s2;

  if (p1 == p2)
    return 0;

  for (;; p1++, p2++)
    {
      unsigned char c1 = c_tolower (*p1);
      unsigned char c2 = c_tolower (*p2);

      if (c1 == '\0' || c1 != c2)
        {
          if (UCHAR_MAX <= INT_MAX)
            return c1 - c2;
          else
            /* On machines where 'char' and 'int' are types of the same size,
               the difference of two 'unsigned char' values - including the
               sign bit - doesn't fit in an 'int'.  */
            return _GL_CMP (c1, c2);
        }
    }
}
