; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx700 < %s | FileCheck --check-prefixes=GFX7 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1010 < %s | FileCheck --check-prefixes=GFX10-WGP %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1010 -mattr=+cumode < %s | FileCheck --check-prefixes=GFX10-CU %s
; RUN: llc -mtriple=amdgcn-amd-amdpal -O0 -mcpu=gfx700 -amdgcn-skip-cache-invalidations < %s | FileCheck --check-prefixes=SKIP-CACHE-INV %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1100 < %s | FileCheck --check-prefixes=GFX11-WGP %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1100 -mattr=+cumode < %s | FileCheck --check-prefixes=GFX11-CU %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1200 < %s | FileCheck --check-prefixes=GFX12-WGP %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -O0 -mcpu=gfx1200 -mattr=+cumode < %s | FileCheck --check-prefixes=GFX12-CU %s

define amdgpu_kernel void @flat_nontemporal_load_0(
; GFX7-LABEL: flat_nontemporal_load_0:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX7-NEXT:    s_add_i32 s12, s12, s17
; GFX7-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x2
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    flat_load_dword v2, v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    flat_store_dword v[0:1], v2
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: flat_nontemporal_load_0:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_add_u32 s12, s12, s17
; GFX10-WGP-NEXT:    s_addc_u32 s13, s13, 0
; GFX10-WGP-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX10-WGP-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX10-WGP-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s7
; GFX10-WGP-NEXT:    flat_load_dword v2, v[0:1] glc dlc
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    flat_store_dword v[0:1], v2
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: flat_nontemporal_load_0:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_add_u32 s12, s12, s17
; GFX10-CU-NEXT:    s_addc_u32 s13, s13, 0
; GFX10-CU-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX10-CU-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX10-CU-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s7
; GFX10-CU-NEXT:    flat_load_dword v2, v[0:1] glc dlc
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    flat_store_dword v[0:1], v2
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: flat_nontemporal_load_0:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s3
; SKIP-CACHE-INV-NEXT:    flat_load_dword v2, v[0:1] glc
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    flat_store_dword v[0:1], v2
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: flat_nontemporal_load_0:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-WGP-NEXT:    flat_load_b32 v2, v[0:1] glc dlc
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    flat_store_b32 v[0:1], v2
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: flat_nontemporal_load_0:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-CU-NEXT:    flat_load_b32 v2, v[0:1] glc dlc
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    flat_store_b32 v[0:1], v2
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: flat_nontemporal_load_0:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s3
; GFX12-WGP-NEXT:    flat_load_b32 v2, v[0:1] scope:SCOPE_SYS
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    flat_store_b32 v[0:1], v2
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: flat_nontemporal_load_0:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s3
; GFX12-CU-NEXT:    flat_load_b32 v2, v[0:1] scope:SCOPE_SYS
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    flat_store_b32 v[0:1], v2
; GFX12-CU-NEXT:    s_endpgm
    ptr %in, ptr %out) {
entry:
  %val = load volatile i32, ptr %in, align 4
  store i32 %val, ptr %out
  ret void
}

define amdgpu_kernel void @flat_nontemporal_load_1(
; GFX7-LABEL: flat_nontemporal_load_1:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX7-NEXT:    s_add_i32 s12, s12, s17
; GFX7-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX7-NEXT:    s_mov_b64 s[4:5], s[8:9]
; GFX7-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x2
; GFX7-NEXT:    s_mov_b32 s6, 2
; GFX7-NEXT:    v_lshlrev_b32_e64 v1, s6, v0
; GFX7-NEXT:    s_mov_b32 s6, 0
; GFX7-NEXT:    ; implicit-def: $sgpr6
; GFX7-NEXT:    v_mov_b32_e32 v0, 0
; GFX7-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX7-NEXT:    v_mov_b32_e32 v2, v0
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    s_mov_b32 s6, s8
; GFX7-NEXT:    v_mov_b32_e32 v0, v1
; GFX7-NEXT:    s_mov_b32 s8, s9
; GFX7-NEXT:    ; kill: def $vgpr2 killed $vgpr2 killed $vgpr1_vgpr2 killed $exec
; GFX7-NEXT:    v_add_i32_e64 v0, s[6:7], s6, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, s8
; GFX7-NEXT:    v_addc_u32_e64 v2, s[6:7], v1, v2, s[6:7]
; GFX7-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX7-NEXT:    v_mov_b32_e32 v1, v2
; GFX7-NEXT:    flat_load_dword v2, v[0:1] glc
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    flat_store_dword v[0:1], v2
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: flat_nontemporal_load_1:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_add_u32 s12, s12, s17
; GFX10-WGP-NEXT:    s_addc_u32 s13, s13, 0
; GFX10-WGP-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX10-WGP-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX10-WGP-NEXT:    s_mov_b64 s[4:5], s[8:9]
; GFX10-WGP-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; GFX10-WGP-NEXT:    s_nop 0
; GFX10-WGP-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x8
; GFX10-WGP-NEXT:    s_mov_b32 s6, 2
; GFX10-WGP-NEXT:    v_lshlrev_b32_e64 v1, s6, v0
; GFX10-WGP-NEXT:    s_mov_b32 s6, 0
; GFX10-WGP-NEXT:    ; implicit-def: $sgpr6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-WGP-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, v0
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    s_mov_b32 s7, s8
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, v1
; GFX10-WGP-NEXT:    s_mov_b32 s6, s9
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, v2
; GFX10-WGP-NEXT:    v_add_co_u32 v0, s7, s7, v0
; GFX10-WGP-NEXT:    v_add_co_ci_u32_e64 v2, s6, s6, v1, s7
; GFX10-WGP-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, v2
; GFX10-WGP-NEXT:    flat_load_dword v2, v[0:1] glc dlc
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    flat_store_dword v[0:1], v2
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: flat_nontemporal_load_1:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_add_u32 s12, s12, s17
; GFX10-CU-NEXT:    s_addc_u32 s13, s13, 0
; GFX10-CU-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX10-CU-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX10-CU-NEXT:    s_mov_b64 s[4:5], s[8:9]
; GFX10-CU-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x0
; GFX10-CU-NEXT:    s_nop 0
; GFX10-CU-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x8
; GFX10-CU-NEXT:    s_mov_b32 s6, 2
; GFX10-CU-NEXT:    v_lshlrev_b32_e64 v1, s6, v0
; GFX10-CU-NEXT:    s_mov_b32 s6, 0
; GFX10-CU-NEXT:    ; implicit-def: $sgpr6
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-CU-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, v0
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    s_mov_b32 s7, s8
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, v1
; GFX10-CU-NEXT:    s_mov_b32 s6, s9
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, v2
; GFX10-CU-NEXT:    v_add_co_u32 v0, s7, s7, v0
; GFX10-CU-NEXT:    v_add_co_ci_u32_e64 v2, s6, s6, v1, s7
; GFX10-CU-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, v2
; GFX10-CU-NEXT:    flat_load_dword v2, v[0:1] glc dlc
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    flat_store_dword v[0:1], v2
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: flat_nontemporal_load_1:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_mov_b64 s[0:1], s[4:5]
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[4:5], s[0:1], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[0:1], s[0:1], 0x2
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s2, 2
; SKIP-CACHE-INV-NEXT:    v_lshlrev_b32_e64 v1, s2, v0
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s2, 0
; SKIP-CACHE-INV-NEXT:    ; implicit-def: $sgpr2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, 0
; SKIP-CACHE-INV-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, v0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s2, s4
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, v1
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s4, s5
; SKIP-CACHE-INV-NEXT:    ; kill: def $vgpr2 killed $vgpr2 killed $vgpr1_vgpr2 killed $exec
; SKIP-CACHE-INV-NEXT:    v_add_i32_e64 v0, s[2:3], s2, v0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s4
; SKIP-CACHE-INV-NEXT:    v_addc_u32_e64 v2, s[2:3], v1, v2, s[2:3]
; SKIP-CACHE-INV-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, v2
; SKIP-CACHE-INV-NEXT:    flat_load_dword v2, v[0:1] glc
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    flat_store_dword v[0:1], v2
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: flat_nontemporal_load_1:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_mov_b64 s[0:1], s[4:5]
; GFX11-WGP-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX11-WGP-NEXT:    s_load_b64 s[0:1], s[0:1], 0x8
; GFX11-WGP-NEXT:    s_mov_b32 s2, 0x3ff
; GFX11-WGP-NEXT:    v_and_b32_e64 v0, v0, s2
; GFX11-WGP-NEXT:    s_mov_b32 s2, 2
; GFX11-WGP-NEXT:    v_lshlrev_b32_e64 v1, s2, v0
; GFX11-WGP-NEXT:    s_mov_b32 s2, 0
; GFX11-WGP-NEXT:    ; implicit-def: $sgpr2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-WGP-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, v0
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    s_mov_b32 s3, s4
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, v1
; GFX11-WGP-NEXT:    s_mov_b32 s2, s5
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, v2
; GFX11-WGP-NEXT:    v_add_co_u32 v0, s3, s3, v0
; GFX11-WGP-NEXT:    v_add_co_ci_u32_e64 v2, s2, s2, v1, s3
; GFX11-WGP-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, v2
; GFX11-WGP-NEXT:    flat_load_b32 v2, v[0:1] glc dlc
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    flat_store_b32 v[0:1], v2
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: flat_nontemporal_load_1:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_mov_b64 s[0:1], s[4:5]
; GFX11-CU-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX11-CU-NEXT:    s_load_b64 s[0:1], s[0:1], 0x8
; GFX11-CU-NEXT:    s_mov_b32 s2, 0x3ff
; GFX11-CU-NEXT:    v_and_b32_e64 v0, v0, s2
; GFX11-CU-NEXT:    s_mov_b32 s2, 2
; GFX11-CU-NEXT:    v_lshlrev_b32_e64 v1, s2, v0
; GFX11-CU-NEXT:    s_mov_b32 s2, 0
; GFX11-CU-NEXT:    ; implicit-def: $sgpr2
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-CU-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, v0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    s_mov_b32 s3, s4
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, v1
; GFX11-CU-NEXT:    s_mov_b32 s2, s5
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, v2
; GFX11-CU-NEXT:    v_add_co_u32 v0, s3, s3, v0
; GFX11-CU-NEXT:    v_add_co_ci_u32_e64 v2, s2, s2, v1, s3
; GFX11-CU-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, v2
; GFX11-CU-NEXT:    flat_load_b32 v2, v[0:1] glc dlc
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    flat_store_b32 v[0:1], v2
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: flat_nontemporal_load_1:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_mov_b64 s[0:1], s[4:5]
; GFX12-WGP-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX12-WGP-NEXT:    s_load_b64 s[0:1], s[0:1], 0x8
; GFX12-WGP-NEXT:    s_mov_b32 s2, 0x3ff
; GFX12-WGP-NEXT:    v_and_b32_e64 v0, v0, s2
; GFX12-WGP-NEXT:    s_mov_b32 s2, 2
; GFX12-WGP-NEXT:    s_wait_alu 0xfffe
; GFX12-WGP-NEXT:    v_lshlrev_b32_e64 v1, s2, v0
; GFX12-WGP-NEXT:    s_mov_b32 s2, 0
; GFX12-WGP-NEXT:    ; implicit-def: $sgpr2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-WGP-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, v0
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    s_mov_b32 s3, s4
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, v1
; GFX12-WGP-NEXT:    s_mov_b32 s2, s5
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, v2
; GFX12-WGP-NEXT:    s_wait_alu 0xfffe
; GFX12-WGP-NEXT:    v_add_co_u32 v0, s3, s3, v0
; GFX12-WGP-NEXT:    s_wait_alu 0xf1ff
; GFX12-WGP-NEXT:    v_add_co_ci_u32_e64 v2, s2, s2, v1, s3
; GFX12-WGP-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, v2
; GFX12-WGP-NEXT:    flat_load_b32 v2, v[0:1] scope:SCOPE_SYS
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    s_wait_dscnt 0x0
; GFX12-WGP-NEXT:    flat_store_b32 v[0:1], v2
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: flat_nontemporal_load_1:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_mov_b64 s[0:1], s[4:5]
; GFX12-CU-NEXT:    s_load_b64 s[4:5], s[0:1], 0x0
; GFX12-CU-NEXT:    s_load_b64 s[0:1], s[0:1], 0x8
; GFX12-CU-NEXT:    s_mov_b32 s2, 0x3ff
; GFX12-CU-NEXT:    v_and_b32_e64 v0, v0, s2
; GFX12-CU-NEXT:    s_mov_b32 s2, 2
; GFX12-CU-NEXT:    s_wait_alu 0xfffe
; GFX12-CU-NEXT:    v_lshlrev_b32_e64 v1, s2, v0
; GFX12-CU-NEXT:    s_mov_b32 s2, 0
; GFX12-CU-NEXT:    ; implicit-def: $sgpr2
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-CU-NEXT:    ; kill: def $vgpr1 killed $vgpr1 def $vgpr1_vgpr2 killed $exec
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, v0
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    s_mov_b32 s3, s4
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, v1
; GFX12-CU-NEXT:    s_mov_b32 s2, s5
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, v2
; GFX12-CU-NEXT:    s_wait_alu 0xfffe
; GFX12-CU-NEXT:    v_add_co_u32 v0, s3, s3, v0
; GFX12-CU-NEXT:    s_wait_alu 0xf1ff
; GFX12-CU-NEXT:    v_add_co_ci_u32_e64 v2, s2, s2, v1, s3
; GFX12-CU-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, v2
; GFX12-CU-NEXT:    flat_load_b32 v2, v[0:1] scope:SCOPE_SYS
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    flat_store_b32 v[0:1], v2
; GFX12-CU-NEXT:    s_endpgm
    ptr %in, ptr %out) {
entry:
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %val.gep = getelementptr inbounds i32, ptr %in, i32 %tid
  %val = load volatile i32, ptr %val.gep, align 4
  store i32 %val, ptr %out
  ret void
}

define amdgpu_kernel void @flat_nontemporal_store_0(
; GFX7-LABEL: flat_nontemporal_store_0:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX7-NEXT:    s_add_i32 s12, s12, s17
; GFX7-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x2
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    flat_load_dword v2, v[0:1]
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_store_dword v[0:1], v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: flat_nontemporal_store_0:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_add_u32 s12, s12, s17
; GFX10-WGP-NEXT:    s_addc_u32 s13, s13, 0
; GFX10-WGP-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX10-WGP-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX10-WGP-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s7
; GFX10-WGP-NEXT:    flat_load_dword v2, v[0:1]
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-WGP-NEXT:    flat_store_dword v[0:1], v2
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: flat_nontemporal_store_0:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_add_u32 s12, s12, s17
; GFX10-CU-NEXT:    s_addc_u32 s13, s13, 0
; GFX10-CU-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX10-CU-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX10-CU-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s7
; GFX10-CU-NEXT:    flat_load_dword v2, v[0:1]
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-CU-NEXT:    flat_store_dword v[0:1], v2
; GFX10-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: flat_nontemporal_store_0:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s3
; SKIP-CACHE-INV-NEXT:    flat_load_dword v2, v[0:1]
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    flat_store_dword v[0:1], v2
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: flat_nontemporal_store_0:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-WGP-NEXT:    flat_load_b32 v2, v[0:1]
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-WGP-NEXT:    flat_store_b32 v[0:1], v2 dlc
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: flat_nontemporal_store_0:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-CU-NEXT:    flat_load_b32 v2, v[0:1]
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-CU-NEXT:    flat_store_b32 v[0:1], v2 dlc
; GFX11-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: flat_nontemporal_store_0:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s3
; GFX12-WGP-NEXT:    flat_load_b32 v2, v[0:1]
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-WGP-NEXT:    flat_store_b32 v[0:1], v2 scope:SCOPE_SYS
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: flat_nontemporal_store_0:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s3
; GFX12-CU-NEXT:    flat_load_b32 v2, v[0:1]
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-CU-NEXT:    flat_store_b32 v[0:1], v2 scope:SCOPE_SYS
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    s_endpgm
    ptr %in, ptr %out) {
entry:
  %val = load i32, ptr %in, align 4
  store volatile i32 %val, ptr %out
  ret void
}

define amdgpu_kernel void @flat_nontemporal_store_1(
; GFX7-LABEL: flat_nontemporal_store_1:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX7-NEXT:    s_add_i32 s12, s12, s17
; GFX7-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x2
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v1, s4
; GFX7-NEXT:    v_mov_b32_e32 v2, s5
; GFX7-NEXT:    flat_load_dword v2, v[1:2]
; GFX7-NEXT:    s_mov_b32 s4, 2
; GFX7-NEXT:    v_lshlrev_b32_e64 v3, s4, v0
; GFX7-NEXT:    s_mov_b32 s4, 0
; GFX7-NEXT:    ; implicit-def: $sgpr4
; GFX7-NEXT:    v_mov_b32_e32 v0, 0
; GFX7-NEXT:    ; kill: def $vgpr3 killed $vgpr3 def $vgpr3_vgpr4 killed $exec
; GFX7-NEXT:    v_mov_b32_e32 v4, v0
; GFX7-NEXT:    s_mov_b32 s4, s6
; GFX7-NEXT:    v_mov_b32_e32 v0, v3
; GFX7-NEXT:    s_mov_b32 s6, s7
; GFX7-NEXT:    v_mov_b32_e32 v3, v4
; GFX7-NEXT:    v_add_i32_e64 v0, s[4:5], s4, v0
; GFX7-NEXT:    v_mov_b32_e32 v1, s6
; GFX7-NEXT:    v_addc_u32_e64 v3, s[4:5], v1, v3, s[4:5]
; GFX7-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX7-NEXT:    v_mov_b32_e32 v1, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX7-NEXT:    flat_store_dword v[0:1], v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: flat_nontemporal_store_1:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_add_u32 s12, s12, s17
; GFX10-WGP-NEXT:    s_addc_u32 s13, s13, 0
; GFX10-WGP-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX10-WGP-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX10-WGP-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-WGP-NEXT:    flat_load_dword v2, v[1:2]
; GFX10-WGP-NEXT:    s_mov_b32 s4, 2
; GFX10-WGP-NEXT:    v_lshlrev_b32_e64 v3, s4, v0
; GFX10-WGP-NEXT:    s_mov_b32 s4, 0
; GFX10-WGP-NEXT:    ; implicit-def: $sgpr4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-WGP-NEXT:    ; kill: def $vgpr3 killed $vgpr3 def $vgpr3_vgpr4 killed $exec
; GFX10-WGP-NEXT:    v_mov_b32_e32 v4, v0
; GFX10-WGP-NEXT:    s_mov_b32 s5, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-WGP-NEXT:    s_mov_b32 s4, s7
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, v4
; GFX10-WGP-NEXT:    v_add_co_u32 v0, s5, s5, v0
; GFX10-WGP-NEXT:    v_add_co_ci_u32_e64 v3, s4, s4, v1, s5
; GFX10-WGP-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, v3
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-WGP-NEXT:    flat_store_dword v[0:1], v2
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: flat_nontemporal_store_1:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_add_u32 s12, s12, s17
; GFX10-CU-NEXT:    s_addc_u32 s13, s13, 0
; GFX10-CU-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX10-CU-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX10-CU-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s5
; GFX10-CU-NEXT:    flat_load_dword v2, v[1:2]
; GFX10-CU-NEXT:    s_mov_b32 s4, 2
; GFX10-CU-NEXT:    v_lshlrev_b32_e64 v3, s4, v0
; GFX10-CU-NEXT:    s_mov_b32 s4, 0
; GFX10-CU-NEXT:    ; implicit-def: $sgpr4
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, 0
; GFX10-CU-NEXT:    ; kill: def $vgpr3 killed $vgpr3 def $vgpr3_vgpr4 killed $exec
; GFX10-CU-NEXT:    v_mov_b32_e32 v4, v0
; GFX10-CU-NEXT:    s_mov_b32 s5, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, v3
; GFX10-CU-NEXT:    s_mov_b32 s4, s7
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, v4
; GFX10-CU-NEXT:    v_add_co_u32 v0, s5, s5, v0
; GFX10-CU-NEXT:    v_add_co_ci_u32_e64 v3, s4, s4, v1, s5
; GFX10-CU-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, v3
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-CU-NEXT:    flat_store_dword v[0:1], v2
; GFX10-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: flat_nontemporal_store_1:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s1
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s0
; SKIP-CACHE-INV-NEXT:    flat_load_dword v2, v[1:2]
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s0, 2
; SKIP-CACHE-INV-NEXT:    v_lshlrev_b32_e64 v3, s0, v0
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s0, 0
; SKIP-CACHE-INV-NEXT:    ; implicit-def: $sgpr0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, 0
; SKIP-CACHE-INV-NEXT:    ; kill: def $vgpr3 killed $vgpr3 def $vgpr3_vgpr4 killed $exec
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v4, v0
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, v3
; SKIP-CACHE-INV-NEXT:    s_mov_b32 s2, s3
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v3, v4
; SKIP-CACHE-INV-NEXT:    v_add_i32_e64 v0, s[0:1], s0, v0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s2
; SKIP-CACHE-INV-NEXT:    v_addc_u32_e64 v3, s[0:1], v1, v3, s[0:1]
; SKIP-CACHE-INV-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, v3
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    flat_store_dword v[0:1], v2
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: flat_nontemporal_store_1:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-WGP-NEXT:    flat_load_b32 v2, v[1:2]
; GFX11-WGP-NEXT:    s_mov_b32 s0, 0x3ff
; GFX11-WGP-NEXT:    v_and_b32_e64 v0, v0, s0
; GFX11-WGP-NEXT:    s_mov_b32 s0, 2
; GFX11-WGP-NEXT:    v_lshlrev_b32_e64 v3, s0, v0
; GFX11-WGP-NEXT:    s_mov_b32 s0, 0
; GFX11-WGP-NEXT:    ; implicit-def: $sgpr0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-WGP-NEXT:    ; kill: def $vgpr3 killed $vgpr3 def $vgpr3_vgpr4 killed $exec
; GFX11-WGP-NEXT:    v_mov_b32_e32 v4, v0
; GFX11-WGP-NEXT:    s_mov_b32 s1, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-WGP-NEXT:    s_mov_b32 s0, s3
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, v4
; GFX11-WGP-NEXT:    v_add_co_u32 v0, s1, s1, v0
; GFX11-WGP-NEXT:    v_add_co_ci_u32_e64 v3, s0, s0, v1, s1
; GFX11-WGP-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, v3
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-WGP-NEXT:    flat_store_b32 v[0:1], v2 dlc
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: flat_nontemporal_store_1:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-CU-NEXT:    flat_load_b32 v2, v[1:2]
; GFX11-CU-NEXT:    s_mov_b32 s0, 0x3ff
; GFX11-CU-NEXT:    v_and_b32_e64 v0, v0, s0
; GFX11-CU-NEXT:    s_mov_b32 s0, 2
; GFX11-CU-NEXT:    v_lshlrev_b32_e64 v3, s0, v0
; GFX11-CU-NEXT:    s_mov_b32 s0, 0
; GFX11-CU-NEXT:    ; implicit-def: $sgpr0
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, 0
; GFX11-CU-NEXT:    ; kill: def $vgpr3 killed $vgpr3 def $vgpr3_vgpr4 killed $exec
; GFX11-CU-NEXT:    v_mov_b32_e32 v4, v0
; GFX11-CU-NEXT:    s_mov_b32 s1, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, v3
; GFX11-CU-NEXT:    s_mov_b32 s0, s3
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, v4
; GFX11-CU-NEXT:    v_add_co_u32 v0, s1, s1, v0
; GFX11-CU-NEXT:    v_add_co_ci_u32_e64 v3, s0, s0, v1, s1
; GFX11-CU-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, v3
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-CU-NEXT:    flat_store_b32 v[0:1], v2 dlc
; GFX11-CU-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: flat_nontemporal_store_1:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-WGP-NEXT:    flat_load_b32 v2, v[1:2]
; GFX12-WGP-NEXT:    s_mov_b32 s0, 0x3ff
; GFX12-WGP-NEXT:    s_wait_alu 0xfffe
; GFX12-WGP-NEXT:    v_and_b32_e64 v0, v0, s0
; GFX12-WGP-NEXT:    s_mov_b32 s0, 2
; GFX12-WGP-NEXT:    s_wait_alu 0xfffe
; GFX12-WGP-NEXT:    v_lshlrev_b32_e64 v3, s0, v0
; GFX12-WGP-NEXT:    s_mov_b32 s0, 0
; GFX12-WGP-NEXT:    ; implicit-def: $sgpr0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-WGP-NEXT:    ; kill: def $vgpr3 killed $vgpr3 def $vgpr3_vgpr4 killed $exec
; GFX12-WGP-NEXT:    v_mov_b32_e32 v4, v0
; GFX12-WGP-NEXT:    s_mov_b32 s1, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, v3
; GFX12-WGP-NEXT:    s_mov_b32 s0, s3
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, v4
; GFX12-WGP-NEXT:    s_wait_alu 0xfffe
; GFX12-WGP-NEXT:    v_add_co_u32 v0, s1, s1, v0
; GFX12-WGP-NEXT:    s_wait_alu 0xf1ff
; GFX12-WGP-NEXT:    v_add_co_ci_u32_e64 v3, s0, s0, v1, s1
; GFX12-WGP-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, v3
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-WGP-NEXT:    flat_store_b32 v[0:1], v2 scope:SCOPE_SYS
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: flat_nontemporal_store_1:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b64 s[0:1], s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s1
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-CU-NEXT:    flat_load_b32 v2, v[1:2]
; GFX12-CU-NEXT:    s_mov_b32 s0, 0x3ff
; GFX12-CU-NEXT:    s_wait_alu 0xfffe
; GFX12-CU-NEXT:    v_and_b32_e64 v0, v0, s0
; GFX12-CU-NEXT:    s_mov_b32 s0, 2
; GFX12-CU-NEXT:    s_wait_alu 0xfffe
; GFX12-CU-NEXT:    v_lshlrev_b32_e64 v3, s0, v0
; GFX12-CU-NEXT:    s_mov_b32 s0, 0
; GFX12-CU-NEXT:    ; implicit-def: $sgpr0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, 0
; GFX12-CU-NEXT:    ; kill: def $vgpr3 killed $vgpr3 def $vgpr3_vgpr4 killed $exec
; GFX12-CU-NEXT:    v_mov_b32_e32 v4, v0
; GFX12-CU-NEXT:    s_mov_b32 s1, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, v3
; GFX12-CU-NEXT:    s_mov_b32 s0, s3
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, v4
; GFX12-CU-NEXT:    s_wait_alu 0xfffe
; GFX12-CU-NEXT:    v_add_co_u32 v0, s1, s1, v0
; GFX12-CU-NEXT:    s_wait_alu 0xf1ff
; GFX12-CU-NEXT:    v_add_co_ci_u32_e64 v3, s0, s0, v1, s1
; GFX12-CU-NEXT:    ; kill: def $vgpr0 killed $vgpr0 def $vgpr0_vgpr1 killed $exec
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, v3
; GFX12-CU-NEXT:    s_wait_samplecnt 0x0
; GFX12-CU-NEXT:    s_wait_bvhcnt 0x0
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-CU-NEXT:    flat_store_b32 v[0:1], v2 scope:SCOPE_SYS
; GFX12-CU-NEXT:    s_wait_storecnt 0x0
; GFX12-CU-NEXT:    s_endpgm
    ptr %in, ptr %out) {
entry:
  %tid = call i32 @llvm.amdgcn.workitem.id.x()
  %val = load i32, ptr %in, align 4
  %out.gep = getelementptr inbounds i32, ptr %out, i32 %tid
  store volatile i32 %val, ptr %out.gep
  ret void
}

define amdgpu_kernel void @flat_volatile_workgroup_acquire_load(
; GFX7-LABEL: flat_volatile_workgroup_acquire_load:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX7-NEXT:    s_add_i32 s12, s12, s17
; GFX7-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX7-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x2
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    flat_load_dword v2, v[0:1]
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s4
; GFX7-NEXT:    v_mov_b32_e32 v1, s5
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    flat_store_dword v[0:1], v2
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: flat_volatile_workgroup_acquire_load:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_add_u32 s12, s12, s17
; GFX10-WGP-NEXT:    s_addc_u32 s13, s13, 0
; GFX10-WGP-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX10-WGP-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX10-WGP-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s7
; GFX10-WGP-NEXT:    flat_load_dword v2, v[0:1] glc
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-WGP-NEXT:    buffer_gl0_inv
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-WGP-NEXT:    flat_store_dword v[0:1], v2
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: flat_volatile_workgroup_acquire_load:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_add_u32 s12, s12, s17
; GFX10-CU-NEXT:    s_addc_u32 s13, s13, 0
; GFX10-CU-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX10-CU-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX10-CU-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dwordx2 s[4:5], s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s7
; GFX10-CU-NEXT:    flat_load_dword v2, v[0:1]
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s4
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s5
; GFX10-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX10-CU-NEXT:    flat_store_dword v[0:1], v2
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: flat_volatile_workgroup_acquire_load:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s3
; SKIP-CACHE-INV-NEXT:    flat_load_dword v2, v[0:1]
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s0
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s1
; SKIP-CACHE-INV-NEXT:    s_waitcnt vmcnt(0)
; SKIP-CACHE-INV-NEXT:    flat_store_dword v[0:1], v2
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: flat_volatile_workgroup_acquire_load:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-WGP-NEXT:    flat_load_b32 v2, v[0:1] glc
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-WGP-NEXT:    buffer_gl0_inv
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-WGP-NEXT:    flat_store_b32 v[0:1], v2
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: flat_volatile_workgroup_acquire_load:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-CU-NEXT:    flat_load_b32 v2, v[0:1]
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX11-CU-NEXT:    s_waitcnt vmcnt(0)
; GFX11-CU-NEXT:    flat_store_b32 v[0:1], v2
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: flat_volatile_workgroup_acquire_load:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s3
; GFX12-WGP-NEXT:    flat_load_b32 v2, v[0:1] scope:SCOPE_SE
; GFX12-WGP-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-WGP-NEXT:    global_inv scope:SCOPE_SE
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-WGP-NEXT:    flat_store_b32 v[0:1], v2
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: flat_volatile_workgroup_acquire_load:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b64 s[0:1], s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s3
; GFX12-CU-NEXT:    flat_load_b32 v2, v[0:1]
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s0
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s1
; GFX12-CU-NEXT:    s_wait_loadcnt 0x0
; GFX12-CU-NEXT:    flat_store_b32 v[0:1], v2
; GFX12-CU-NEXT:    s_endpgm
    ptr %in, ptr %out) {
entry:
  %val = load atomic volatile i32, ptr %in syncscope("workgroup") acquire, align 4
  store i32 %val, ptr %out
  ret void
}

define amdgpu_kernel void @flat_volatile_workgroup_release_store(
; GFX7-LABEL: flat_volatile_workgroup_release_store:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_mov_b32 flat_scratch_lo, s13
; GFX7-NEXT:    s_add_i32 s12, s12, s17
; GFX7-NEXT:    s_lshr_b32 flat_scratch_hi, s12, 8
; GFX7-NEXT:    s_load_dword s4, s[8:9], 0x0
; GFX7-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x2
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v0, s6
; GFX7-NEXT:    v_mov_b32_e32 v1, s7
; GFX7-NEXT:    v_mov_b32_e32 v2, s4
; GFX7-NEXT:    s_waitcnt lgkmcnt(0)
; GFX7-NEXT:    flat_store_dword v[0:1], v2
; GFX7-NEXT:    s_endpgm
;
; GFX10-WGP-LABEL: flat_volatile_workgroup_release_store:
; GFX10-WGP:       ; %bb.0: ; %entry
; GFX10-WGP-NEXT:    s_add_u32 s12, s12, s17
; GFX10-WGP-NEXT:    s_addc_u32 s13, s13, 0
; GFX10-WGP-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX10-WGP-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX10-WGP-NEXT:    s_load_dword s4, s[8:9], 0x0
; GFX10-WGP-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x8
; GFX10-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-WGP-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-WGP-NEXT:    v_mov_b32_e32 v1, s7
; GFX10-WGP-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-WGP-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-WGP-NEXT:    flat_store_dword v[0:1], v2
; GFX10-WGP-NEXT:    s_endpgm
;
; GFX10-CU-LABEL: flat_volatile_workgroup_release_store:
; GFX10-CU:       ; %bb.0: ; %entry
; GFX10-CU-NEXT:    s_add_u32 s12, s12, s17
; GFX10-CU-NEXT:    s_addc_u32 s13, s13, 0
; GFX10-CU-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s12
; GFX10-CU-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s13
; GFX10-CU-NEXT:    s_load_dword s4, s[8:9], 0x0
; GFX10-CU-NEXT:    s_load_dwordx2 s[6:7], s[8:9], 0x8
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    v_mov_b32_e32 v0, s6
; GFX10-CU-NEXT:    v_mov_b32_e32 v1, s7
; GFX10-CU-NEXT:    v_mov_b32_e32 v2, s4
; GFX10-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-CU-NEXT:    flat_store_dword v[0:1], v2
; GFX10-CU-NEXT:    s_endpgm
;
; SKIP-CACHE-INV-LABEL: flat_volatile_workgroup_release_store:
; SKIP-CACHE-INV:       ; %bb.0: ; %entry
; SKIP-CACHE-INV-NEXT:    s_load_dword s0, s[4:5], 0x0
; SKIP-CACHE-INV-NEXT:    s_load_dwordx2 s[2:3], s[4:5], 0x2
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v0, s2
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v1, s3
; SKIP-CACHE-INV-NEXT:    v_mov_b32_e32 v2, s0
; SKIP-CACHE-INV-NEXT:    s_waitcnt lgkmcnt(0)
; SKIP-CACHE-INV-NEXT:    flat_store_dword v[0:1], v2
; SKIP-CACHE-INV-NEXT:    s_endpgm
;
; GFX11-WGP-LABEL: flat_volatile_workgroup_release_store:
; GFX11-WGP:       ; %bb.0: ; %entry
; GFX11-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x8
; GFX11-WGP-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-WGP-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-WGP-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-WGP-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-WGP-NEXT:    flat_store_b32 v[0:1], v2
; GFX11-WGP-NEXT:    s_endpgm
;
; GFX11-CU-LABEL: flat_volatile_workgroup_release_store:
; GFX11-CU:       ; %bb.0: ; %entry
; GFX11-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x8
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-CU-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX11-CU-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-CU-NEXT:    flat_store_b32 v[0:1], v2
; GFX11-CU-NEXT:    s_endpgm
;
; GFX12-WGP-LABEL: flat_volatile_workgroup_release_store:
; GFX12-WGP:       ; %bb.0: ; %entry
; GFX12-WGP-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-WGP-NEXT:    s_load_b64 s[2:3], s[4:5], 0x8
; GFX12-WGP-NEXT:    s_wait_kmcnt 0x0
; GFX12-WGP-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-WGP-NEXT:    v_mov_b32_e32 v1, s3
; GFX12-WGP-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-WGP-NEXT:    s_wait_bvhcnt 0x0
; GFX12-WGP-NEXT:    s_wait_samplecnt 0x0
; GFX12-WGP-NEXT:    s_wait_storecnt 0x0
; GFX12-WGP-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-WGP-NEXT:    flat_store_b32 v[0:1], v2 scope:SCOPE_SE
; GFX12-WGP-NEXT:    s_endpgm
;
; GFX12-CU-LABEL: flat_volatile_workgroup_release_store:
; GFX12-CU:       ; %bb.0: ; %entry
; GFX12-CU-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-CU-NEXT:    s_load_b64 s[2:3], s[4:5], 0x8
; GFX12-CU-NEXT:    s_wait_kmcnt 0x0
; GFX12-CU-NEXT:    v_mov_b32_e32 v0, s2
; GFX12-CU-NEXT:    v_mov_b32_e32 v1, s3
; GFX12-CU-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-CU-NEXT:    s_wait_dscnt 0x0
; GFX12-CU-NEXT:    flat_store_b32 v[0:1], v2
; GFX12-CU-NEXT:    s_endpgm
   i32 %in, ptr %out) {
entry:
  store atomic volatile i32 %in, ptr %out syncscope("workgroup") release, align 4
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x()
