; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-annotate-decl-cs  -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

;
; This is an evolved example to stress test SCC parameter attribute propagation.
; The SCC in this test is made up of the following six function, three of which
; are internal and three externally visible:
;
; static int *internal_ret0_nw(int *n0, int *w0);
; static int *internal_ret1_rw(int *r0, int *w0);
; static int *internal_ret1_rrw(int *r0, int *r1, int *w0);
;        int *external_ret2_nrw(int *n0, int *r0, int *w0);
;        int *external_sink_ret2_nrw(int *n0, int *r0, int *w0);
;        int *external_source_ret2_nrw(int *n0, int *r0, int *w0);
;
; The top four functions call each other while the "sink" function will not
; call anything and the "source" function will not be called in this module.
; The names of the functions define the returned parameter (X for "_retX_"),
; as well as how the parameters are (transitively) used (n = readnone,
; r = readonly, w = writeonly).
;
; What we should see is something along the lines of:
;   1 - Number of functions marked as norecurse
;   6 - Number of functions marked argmemonly
;   6 - Number of functions marked as nounwind
;  16 - Number of arguments marked nocapture
;   4 - Number of arguments marked readnone
;   6 - Number of arguments marked writeonly
;   6 - Number of arguments marked readonly
;   6 - Number of arguments marked returned
;
target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

define ptr @external_ret2_nrw(ptr %n0, ptr %r0, ptr %w0) {
; TUNIT: Function Attrs: nofree nosync nounwind memory(argmem: readwrite)
; TUNIT-LABEL: define {{[^@]+}}@external_ret2_nrw
; TUNIT-SAME: (ptr nofree [[N0:%.*]], ptr nofree [[R0:%.*]], ptr nofree returned [[W0:%.*]]) #[[ATTR0:[0-9]+]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[CALL:%.*]] = call ptr @internal_ret0_nw(ptr nofree [[N0]], ptr nofree [[W0]]) #[[ATTR3:[0-9]+]]
; TUNIT-NEXT:    [[CALL1:%.*]] = call ptr @internal_ret1_rrw(ptr nofree noundef align 4 [[R0]], ptr nofree align 4 [[R0]], ptr nofree [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    [[CALL2:%.*]] = call ptr @external_sink_ret2_nrw(ptr nofree [[N0]], ptr nofree readonly align 4 captures(none) [[R0]], ptr nofree writeonly "no-capture-maybe-returned" [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    [[CALL3:%.*]] = call ptr @internal_ret1_rw(ptr nofree noundef align 4 [[R0]], ptr nofree [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    ret ptr [[W0]]
;
; CGSCC: Function Attrs: nofree nosync nounwind memory(argmem: readwrite)
; CGSCC-LABEL: define {{[^@]+}}@external_ret2_nrw
; CGSCC-SAME: (ptr nofree [[N0:%.*]], ptr nofree [[R0:%.*]], ptr nofree returned [[W0:%.*]]) #[[ATTR0:[0-9]+]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[CALL:%.*]] = call ptr @internal_ret0_nw(ptr nofree [[N0]], ptr nofree [[W0]]) #[[ATTR2:[0-9]+]]
; CGSCC-NEXT:    [[CALL1:%.*]] = call ptr @internal_ret1_rrw(ptr nofree noundef align 4 [[R0]], ptr nofree align 4 [[R0]], ptr nofree [[W0]]) #[[ATTR2]]
; CGSCC-NEXT:    [[CALL2:%.*]] = call ptr @external_sink_ret2_nrw(ptr nofree [[N0]], ptr nofree readonly align 4 captures(none) [[R0]], ptr nofree writeonly [[W0]]) #[[ATTR3:[0-9]+]]
; CGSCC-NEXT:    [[CALL3:%.*]] = call ptr @internal_ret1_rw(ptr nofree noundef align 4 [[R0]], ptr nofree [[W0]]) #[[ATTR2]]
; CGSCC-NEXT:    ret ptr [[W0]]
;
entry:
  %call = call ptr @internal_ret0_nw(ptr %n0, ptr %w0)
  %call1 = call ptr @internal_ret1_rrw(ptr %r0, ptr %r0, ptr %w0)
  %call2 = call ptr @external_sink_ret2_nrw(ptr %n0, ptr %r0, ptr %w0)
  %call3 = call ptr @internal_ret1_rw(ptr %r0, ptr %w0)
  ret ptr %call3
}

define internal ptr @internal_ret0_nw(ptr %n0, ptr %w0) {
; TUNIT: Function Attrs: nofree nosync nounwind memory(argmem: readwrite)
; TUNIT-LABEL: define {{[^@]+}}@internal_ret0_nw
; TUNIT-SAME: (ptr nofree returned [[N0:%.*]], ptr nofree [[W0:%.*]]) #[[ATTR0]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[R0:%.*]] = alloca i32, align 4
; TUNIT-NEXT:    [[R1:%.*]] = alloca i32, align 4
; TUNIT-NEXT:    [[TOBOOL:%.*]] = icmp ne ptr [[N0]], null
; TUNIT-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; TUNIT:       if.then:
; TUNIT-NEXT:    br label [[RETURN:%.*]]
; TUNIT:       if.end:
; TUNIT-NEXT:    store i32 3, ptr [[R0]], align 4
; TUNIT-NEXT:    store i32 5, ptr [[R1]], align 4
; TUNIT-NEXT:    store i32 1, ptr [[W0]], align 4
; TUNIT-NEXT:    [[CALL:%.*]] = call ptr @internal_ret1_rrw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree noundef nonnull align 4 dereferenceable(4) [[R1]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    [[CALL1:%.*]] = call ptr @external_ret2_nrw(ptr nofree nonnull [[N0]], ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    [[CALL2:%.*]] = call ptr @external_ret2_nrw(ptr nofree nonnull [[N0]], ptr nofree noundef nonnull align 4 dereferenceable(4) [[R1]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    [[CALL3:%.*]] = call ptr @external_sink_ret2_nrw(ptr nofree nonnull [[N0]], ptr nofree noundef nonnull readonly align 4 captures(none) dereferenceable(4) [[R0]], ptr nofree nonnull writeonly align 4 dereferenceable(4) "no-capture-maybe-returned" [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    [[CALL4:%.*]] = call ptr @external_sink_ret2_nrw(ptr nofree nonnull [[N0]], ptr nofree noundef nonnull readonly align 4 captures(none) dereferenceable(4) [[R1]], ptr nofree nonnull writeonly align 4 dereferenceable(4) "no-capture-maybe-returned" [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    [[CALL5:%.*]] = call ptr @internal_ret0_nw(ptr nofree nonnull [[N0]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    br label [[RETURN]]
; TUNIT:       return:
; TUNIT-NEXT:    [[RETVAL_0:%.*]] = phi ptr [ [[N0]], [[IF_END]] ], [ [[N0]], [[IF_THEN]] ]
; TUNIT-NEXT:    ret ptr [[N0]]
;
; CGSCC: Function Attrs: nofree nosync nounwind memory(argmem: readwrite)
; CGSCC-LABEL: define {{[^@]+}}@internal_ret0_nw
; CGSCC-SAME: (ptr nofree returned [[N0:%.*]], ptr nofree [[W0:%.*]]) #[[ATTR0]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[R0:%.*]] = alloca i32, align 4
; CGSCC-NEXT:    [[R1:%.*]] = alloca i32, align 4
; CGSCC-NEXT:    [[TOBOOL:%.*]] = icmp ne ptr [[N0]], null
; CGSCC-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CGSCC:       if.then:
; CGSCC-NEXT:    br label [[RETURN:%.*]]
; CGSCC:       if.end:
; CGSCC-NEXT:    store i32 3, ptr [[R0]], align 4
; CGSCC-NEXT:    store i32 5, ptr [[R1]], align 4
; CGSCC-NEXT:    store i32 1, ptr [[W0]], align 4
; CGSCC-NEXT:    [[CALL:%.*]] = call ptr @internal_ret1_rrw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree noundef nonnull align 4 dereferenceable(4) [[R1]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR2]]
; CGSCC-NEXT:    [[CALL1:%.*]] = call ptr @external_ret2_nrw(ptr nofree nonnull [[N0]], ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR2]]
; CGSCC-NEXT:    [[CALL2:%.*]] = call ptr @external_ret2_nrw(ptr nofree nonnull [[N0]], ptr nofree noundef nonnull align 4 dereferenceable(4) [[R1]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR2]]
; CGSCC-NEXT:    [[CALL3:%.*]] = call ptr @external_sink_ret2_nrw(ptr nofree nonnull [[N0]], ptr nofree noundef nonnull readonly align 4 captures(none) dereferenceable(4) [[R0]], ptr nofree nonnull writeonly align 4 dereferenceable(4) [[W0]]) #[[ATTR4:[0-9]+]]
; CGSCC-NEXT:    [[CALL4:%.*]] = call ptr @external_sink_ret2_nrw(ptr nofree nonnull [[N0]], ptr nofree noundef nonnull readonly align 4 captures(none) dereferenceable(4) [[R1]], ptr nofree nonnull writeonly align 4 dereferenceable(4) [[W0]]) #[[ATTR4]]
; CGSCC-NEXT:    [[CALL5:%.*]] = call ptr @internal_ret0_nw(ptr nofree nonnull [[N0]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR2]]
; CGSCC-NEXT:    br label [[RETURN]]
; CGSCC:       return:
; CGSCC-NEXT:    [[RETVAL_0:%.*]] = phi ptr [ [[N0]], [[IF_END]] ], [ [[N0]], [[IF_THEN]] ]
; CGSCC-NEXT:    ret ptr [[N0]]
;
entry:
  %r0 = alloca i32, align 4
  %r1 = alloca i32, align 4
  %tobool = icmp ne ptr %n0, null
  br i1 %tobool, label %if.end, label %if.then

if.then:                                          ; preds = %entry
  br label %return

if.end:                                           ; preds = %entry
  store i32 3, ptr %r0, align 4
  store i32 5, ptr %r1, align 4
  store i32 1, ptr %w0, align 4
  %call = call ptr @internal_ret1_rrw(ptr %r0, ptr %r1, ptr %w0)
  %call1 = call ptr @external_ret2_nrw(ptr %n0, ptr %r0, ptr %w0)
  %call2 = call ptr @external_ret2_nrw(ptr %n0, ptr %r1, ptr %w0)
  %call3 = call ptr @external_sink_ret2_nrw(ptr %n0, ptr %r0, ptr %w0)
  %call4 = call ptr @external_sink_ret2_nrw(ptr %n0, ptr %r1, ptr %w0)
  %call5 = call ptr @internal_ret0_nw(ptr %n0, ptr %w0)
  br label %return

return:                                           ; preds = %if.end, %if.then
  %retval.0 = phi ptr [ %call5, %if.end ], [ %n0, %if.then ]
  ret ptr %retval.0
}

define internal ptr @internal_ret1_rrw(ptr %r0, ptr %r1, ptr %w0) {
; TUNIT: Function Attrs: nofree nosync nounwind memory(argmem: readwrite)
; TUNIT-LABEL: define {{[^@]+}}@internal_ret1_rrw
; TUNIT-SAME: (ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0:%.*]], ptr nofree align 4 [[R1:%.*]], ptr nofree [[W0:%.*]]) #[[ATTR0]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[TMP0:%.*]] = load i32, ptr [[R0]], align 4
; TUNIT-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP0]], 0
; TUNIT-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; TUNIT:       if.then:
; TUNIT-NEXT:    br label [[RETURN:%.*]]
; TUNIT:       if.end:
; TUNIT-NEXT:    [[CALL:%.*]] = call ptr @internal_ret1_rw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    [[TMP1:%.*]] = load i32, ptr [[R0]], align 4
; TUNIT-NEXT:    [[TMP2:%.*]] = load i32, ptr [[R1]], align 4
; TUNIT-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[TMP2]]
; TUNIT-NEXT:    store i32 [[ADD]], ptr [[W0]], align 4
; TUNIT-NEXT:    [[CALL1:%.*]] = call ptr @internal_ret1_rw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R1]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    [[CALL2:%.*]] = call ptr @internal_ret0_nw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    [[CALL3:%.*]] = call ptr @internal_ret0_nw(ptr nofree nonnull align 4 dereferenceable(4) [[W0]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    [[CALL4:%.*]] = call ptr @external_ret2_nrw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree nonnull align 4 dereferenceable(4) [[R1]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    [[CALL5:%.*]] = call ptr @external_ret2_nrw(ptr nofree nonnull align 4 dereferenceable(4) [[R1]], ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    [[CALL6:%.*]] = call ptr @external_sink_ret2_nrw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree nonnull readonly align 4 captures(none) dereferenceable(4) [[R1]], ptr nofree nonnull writeonly align 4 dereferenceable(4) "no-capture-maybe-returned" [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    [[CALL7:%.*]] = call ptr @external_sink_ret2_nrw(ptr nofree nonnull align 4 dereferenceable(4) [[R1]], ptr nofree noundef nonnull readonly align 4 captures(none) dereferenceable(4) [[R0]], ptr nofree nonnull writeonly align 4 dereferenceable(4) "no-capture-maybe-returned" [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    [[CALL8:%.*]] = call ptr @internal_ret0_nw(ptr nofree nonnull align 4 dereferenceable(4) [[R1]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    br label [[RETURN]]
; TUNIT:       return:
; TUNIT-NEXT:    [[RETVAL_0:%.*]] = phi ptr [ [[R1]], [[IF_END]] ], [ [[R1]], [[IF_THEN]] ]
; TUNIT-NEXT:    ret ptr undef
;
; CGSCC: Function Attrs: nofree nosync nounwind memory(argmem: readwrite)
; CGSCC-LABEL: define {{[^@]+}}@internal_ret1_rrw
; CGSCC-SAME: (ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0:%.*]], ptr nofree align 4 [[R1:%.*]], ptr nofree [[W0:%.*]]) #[[ATTR0]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[TMP0:%.*]] = load i32, ptr [[R0]], align 4
; CGSCC-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP0]], 0
; CGSCC-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CGSCC:       if.then:
; CGSCC-NEXT:    br label [[RETURN:%.*]]
; CGSCC:       if.end:
; CGSCC-NEXT:    [[CALL:%.*]] = call ptr @internal_ret1_rw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree [[W0]]) #[[ATTR2]]
; CGSCC-NEXT:    [[TMP1:%.*]] = load i32, ptr [[R0]], align 4
; CGSCC-NEXT:    [[TMP2:%.*]] = load i32, ptr [[R1]], align 4
; CGSCC-NEXT:    [[ADD:%.*]] = add nsw i32 [[TMP1]], [[TMP2]]
; CGSCC-NEXT:    store i32 [[ADD]], ptr [[W0]], align 4
; CGSCC-NEXT:    [[CALL1:%.*]] = call ptr @internal_ret1_rw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R1]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR2]]
; CGSCC-NEXT:    [[CALL2:%.*]] = call ptr @internal_ret0_nw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR2]]
; CGSCC-NEXT:    [[CALL3:%.*]] = call ptr @internal_ret0_nw(ptr nofree nonnull align 4 dereferenceable(4) [[W0]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR2]]
; CGSCC-NEXT:    [[CALL4:%.*]] = call ptr @external_ret2_nrw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree nonnull align 4 dereferenceable(4) [[R1]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR2]]
; CGSCC-NEXT:    [[CALL5:%.*]] = call ptr @external_ret2_nrw(ptr nofree nonnull align 4 dereferenceable(4) [[R1]], ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR2]]
; CGSCC-NEXT:    [[CALL6:%.*]] = call ptr @external_sink_ret2_nrw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree nonnull readonly align 4 captures(none) dereferenceable(4) [[R1]], ptr nofree nonnull writeonly align 4 dereferenceable(4) [[W0]]) #[[ATTR4]]
; CGSCC-NEXT:    [[CALL7:%.*]] = call ptr @external_sink_ret2_nrw(ptr nofree nonnull align 4 dereferenceable(4) [[R1]], ptr nofree noundef nonnull readonly align 4 captures(none) dereferenceable(4) [[R0]], ptr nofree nonnull writeonly align 4 dereferenceable(4) [[W0]]) #[[ATTR4]]
; CGSCC-NEXT:    [[CALL8:%.*]] = call ptr @internal_ret0_nw(ptr nofree nonnull align 4 dereferenceable(4) [[R1]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR2]]
; CGSCC-NEXT:    br label [[RETURN]]
; CGSCC:       return:
; CGSCC-NEXT:    [[RETVAL_0:%.*]] = phi ptr [ [[R1]], [[IF_END]] ], [ [[R1]], [[IF_THEN]] ]
; CGSCC-NEXT:    ret ptr undef
;
entry:
  %0 = load i32, ptr %r0, align 4
  %tobool = icmp ne i32 %0, 0
  br i1 %tobool, label %if.end, label %if.then

if.then:                                          ; preds = %entry
  br label %return

if.end:                                           ; preds = %entry
  %call = call ptr @internal_ret1_rw(ptr %r0, ptr %w0)
  %1 = load i32, ptr %r0, align 4
  %2 = load i32, ptr %r1, align 4
  %add = add nsw i32 %1, %2
  store i32 %add, ptr %w0, align 4
  %call1 = call ptr @internal_ret1_rw(ptr %r1, ptr %w0)
  %call2 = call ptr @internal_ret0_nw(ptr %r0, ptr %w0)
  %call3 = call ptr @internal_ret0_nw(ptr %w0, ptr %w0)
  %call4 = call ptr @external_ret2_nrw(ptr %r0, ptr %r1, ptr %w0)
  %call5 = call ptr @external_ret2_nrw(ptr %r1, ptr %r0, ptr %w0)
  %call6 = call ptr @external_sink_ret2_nrw(ptr %r0, ptr %r1, ptr %w0)
  %call7 = call ptr @external_sink_ret2_nrw(ptr %r1, ptr %r0, ptr %w0)
  %call8 = call ptr @internal_ret0_nw(ptr %r1, ptr %w0)
  br label %return

return:                                           ; preds = %if.end, %if.then
  %retval.0 = phi ptr [ %call8, %if.end ], [ %r1, %if.then ]
  ret ptr %retval.0
}

define ptr @external_sink_ret2_nrw(ptr %n0, ptr %r0, ptr %w0) {
; CHECK: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: readwrite)
; CHECK-LABEL: define {{[^@]+}}@external_sink_ret2_nrw
; CHECK-SAME: (ptr nofree [[N0:%.*]], ptr nofree readonly captures(none) [[R0:%.*]], ptr nofree returned writeonly "no-capture-maybe-returned" [[W0:%.*]]) #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp ne ptr [[N0]], null
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    br label [[RETURN:%.*]]
; CHECK:       if.end:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[R0]], align 4
; CHECK-NEXT:    store i32 [[TMP0]], ptr [[W0]], align 4
; CHECK-NEXT:    br label [[RETURN]]
; CHECK:       return:
; CHECK-NEXT:    ret ptr [[W0]]
;
entry:
  %tobool = icmp ne ptr %n0, null
  br i1 %tobool, label %if.end, label %if.then

if.then:                                          ; preds = %entry
  br label %return

if.end:                                           ; preds = %entry
  %0 = load i32, ptr %r0, align 4
  store i32 %0, ptr %w0, align 4
  br label %return

return:                                           ; preds = %if.end, %if.then
  ret ptr %w0
}

define internal ptr @internal_ret1_rw(ptr %r0, ptr %w0) {
; TUNIT: Function Attrs: nofree nosync nounwind memory(argmem: readwrite)
; TUNIT-LABEL: define {{[^@]+}}@internal_ret1_rw
; TUNIT-SAME: (ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0:%.*]], ptr nofree returned [[W0:%.*]]) #[[ATTR0]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[TMP0:%.*]] = load i32, ptr [[R0]], align 4
; TUNIT-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP0]], 0
; TUNIT-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; TUNIT:       if.then:
; TUNIT-NEXT:    br label [[RETURN:%.*]]
; TUNIT:       if.end:
; TUNIT-NEXT:    [[CALL:%.*]] = call ptr @internal_ret1_rrw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    [[TMP1:%.*]] = load i32, ptr [[R0]], align 4
; TUNIT-NEXT:    store i32 [[TMP1]], ptr [[W0]], align 4
; TUNIT-NEXT:    [[CALL1:%.*]] = call ptr @internal_ret0_nw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    [[CALL2:%.*]] = call ptr @internal_ret0_nw(ptr nofree nonnull align 4 dereferenceable(4) [[W0]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    [[CALL3:%.*]] = call ptr @external_sink_ret2_nrw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree noundef nonnull readonly align 4 captures(none) dereferenceable(4) [[R0]], ptr nofree nonnull writeonly align 4 dereferenceable(4) "no-capture-maybe-returned" [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    [[CALL4:%.*]] = call ptr @external_ret2_nrw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    br label [[RETURN]]
; TUNIT:       return:
; TUNIT-NEXT:    [[RETVAL_0:%.*]] = phi ptr [ [[W0]], [[IF_END]] ], [ [[W0]], [[IF_THEN]] ]
; TUNIT-NEXT:    ret ptr [[W0]]
;
; CGSCC: Function Attrs: nofree nosync nounwind memory(argmem: readwrite)
; CGSCC-LABEL: define {{[^@]+}}@internal_ret1_rw
; CGSCC-SAME: (ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0:%.*]], ptr nofree returned [[W0:%.*]]) #[[ATTR0]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[TMP0:%.*]] = load i32, ptr [[R0]], align 4
; CGSCC-NEXT:    [[TOBOOL:%.*]] = icmp ne i32 [[TMP0]], 0
; CGSCC-NEXT:    br i1 [[TOBOOL]], label [[IF_END:%.*]], label [[IF_THEN:%.*]]
; CGSCC:       if.then:
; CGSCC-NEXT:    br label [[RETURN:%.*]]
; CGSCC:       if.end:
; CGSCC-NEXT:    [[CALL:%.*]] = call ptr @internal_ret1_rrw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree [[W0]]) #[[ATTR2]]
; CGSCC-NEXT:    [[TMP1:%.*]] = load i32, ptr [[R0]], align 4
; CGSCC-NEXT:    store i32 [[TMP1]], ptr [[W0]], align 4
; CGSCC-NEXT:    [[CALL1:%.*]] = call ptr @internal_ret0_nw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR2]]
; CGSCC-NEXT:    [[CALL2:%.*]] = call ptr @internal_ret0_nw(ptr nofree nonnull align 4 dereferenceable(4) [[W0]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR2]]
; CGSCC-NEXT:    [[CALL3:%.*]] = call ptr @external_sink_ret2_nrw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree noundef nonnull readonly align 4 captures(none) dereferenceable(4) [[R0]], ptr nofree nonnull writeonly align 4 dereferenceable(4) [[W0]]) #[[ATTR4]]
; CGSCC-NEXT:    [[CALL4:%.*]] = call ptr @external_ret2_nrw(ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree noundef nonnull align 4 dereferenceable(4) [[R0]], ptr nofree nonnull align 4 dereferenceable(4) [[W0]]) #[[ATTR2]]
; CGSCC-NEXT:    br label [[RETURN]]
; CGSCC:       return:
; CGSCC-NEXT:    [[RETVAL_0:%.*]] = phi ptr [ [[W0]], [[IF_END]] ], [ [[W0]], [[IF_THEN]] ]
; CGSCC-NEXT:    ret ptr [[W0]]
;
entry:
  %0 = load i32, ptr %r0, align 4
  %tobool = icmp ne i32 %0, 0
  br i1 %tobool, label %if.end, label %if.then

if.then:                                          ; preds = %entry
  br label %return

if.end:                                           ; preds = %entry
  %call = call ptr @internal_ret1_rrw(ptr %r0, ptr %r0, ptr %w0)
  %1 = load i32, ptr %r0, align 4
  store i32 %1, ptr %w0, align 4
  %call1 = call ptr @internal_ret0_nw(ptr %r0, ptr %w0)
  %call2 = call ptr @internal_ret0_nw(ptr %w0, ptr %w0)
  %call3 = call ptr @external_sink_ret2_nrw(ptr %r0, ptr %r0, ptr %w0)
  %call4 = call ptr @external_ret2_nrw(ptr %r0, ptr %r0, ptr %w0)
  br label %return

return:                                           ; preds = %if.end, %if.then
  %retval.0 = phi ptr [ %call4, %if.end ], [ %w0, %if.then ]
  ret ptr %retval.0
}

define ptr @external_source_ret2_nrw(ptr %n0, ptr %r0, ptr %w0) {
; TUNIT: Function Attrs: nofree norecurse nosync nounwind memory(argmem: readwrite)
; TUNIT-LABEL: define {{[^@]+}}@external_source_ret2_nrw
; TUNIT-SAME: (ptr nofree [[N0:%.*]], ptr nofree [[R0:%.*]], ptr nofree returned [[W0:%.*]]) #[[ATTR2:[0-9]+]] {
; TUNIT-NEXT:  entry:
; TUNIT-NEXT:    [[CALL:%.*]] = call ptr @external_sink_ret2_nrw(ptr nofree [[N0]], ptr nofree readonly captures(none) [[R0]], ptr nofree writeonly "no-capture-maybe-returned" [[W0]]) #[[ATTR4:[0-9]+]]
; TUNIT-NEXT:    [[CALL1:%.*]] = call ptr @external_ret2_nrw(ptr nofree [[N0]], ptr nofree [[R0]], ptr nofree [[W0]]) #[[ATTR3]]
; TUNIT-NEXT:    ret ptr [[W0]]
;
; CGSCC: Function Attrs: nofree nosync nounwind memory(argmem: readwrite)
; CGSCC-LABEL: define {{[^@]+}}@external_source_ret2_nrw
; CGSCC-SAME: (ptr nofree [[N0:%.*]], ptr nofree [[R0:%.*]], ptr nofree [[W0:%.*]]) #[[ATTR0]] {
; CGSCC-NEXT:  entry:
; CGSCC-NEXT:    [[CALL:%.*]] = call ptr @external_sink_ret2_nrw(ptr nofree [[N0]], ptr nofree readonly captures(none) [[R0]], ptr nofree writeonly [[W0]]) #[[ATTR5:[0-9]+]]
; CGSCC-NEXT:    [[CALL1:%.*]] = call ptr @external_ret2_nrw(ptr nofree [[N0]], ptr nofree [[R0]], ptr nofree [[W0]]) #[[ATTR3]]
; CGSCC-NEXT:    ret ptr [[CALL1]]
;
entry:
  %call = call ptr @external_sink_ret2_nrw(ptr %n0, ptr %r0, ptr %w0)
  %call1 = call ptr @external_ret2_nrw(ptr %n0, ptr %r0, ptr %w0)
  ret ptr %call1
}

; Verify that we see only expected attribute sets, the above lines only check
; for a subset relation.
;.
; TUNIT: attributes #[[ATTR0]] = { nofree nosync nounwind memory(argmem: readwrite) }
; TUNIT: attributes #[[ATTR1]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: readwrite) }
; TUNIT: attributes #[[ATTR2]] = { nofree norecurse nosync nounwind memory(argmem: readwrite) }
; TUNIT: attributes #[[ATTR3]] = { nofree nosync nounwind }
; TUNIT: attributes #[[ATTR4]] = { nofree nosync nounwind willreturn }
;.
; CGSCC: attributes #[[ATTR0]] = { nofree nosync nounwind memory(argmem: readwrite) }
; CGSCC: attributes #[[ATTR1]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: readwrite) }
; CGSCC: attributes #[[ATTR2]] = { nofree nosync nounwind }
; CGSCC: attributes #[[ATTR3]] = { nofree nounwind }
; CGSCC: attributes #[[ATTR4]] = { nofree nounwind memory(readwrite) }
; CGSCC: attributes #[[ATTR5]] = { nofree nounwind willreturn }
;.
