// NOTE: Assertions have been autogenerated by utils/update_mc_test_checks.py UTC_ARGS: --unique --version 5
// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1200 -mattr=+wavefrontsize32,+real-true16 -show-encoding %s | FileCheck --check-prefix=GFX12 %s
// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1250 -mattr=+wavefrontsize32,+real-true16 -show-encoding %s | FileCheck --check-prefix=GFX12 %s

v_bfrev_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_bfrev_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_bfrev_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_bfrev_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_mirror
// GFX12: v_bfrev_b32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_bfrev_b32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_shl:1
// GFX12: v_bfrev_b32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_shl:15
// GFX12: v_bfrev_b32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_shr:1
// GFX12: v_bfrev_b32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_shr:15
// GFX12: v_bfrev_b32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_ror:1
// GFX12: v_bfrev_b32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_ror:15
// GFX12: v_bfrev_b32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_bfrev_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_bfrev_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_bfrev_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_bfrev_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_bfrev_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_bfrev_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_bfrev_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x00,0xb8,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_ceil_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_ceil_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_ceil_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_ceil_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_ceil_f16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_ceil_f16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_ceil_f16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_ceil_f16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_ceil_f16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_ceil_f16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_ceil_f16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_ceil_f16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_ceil_f16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_ceil_f16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_ceil_f16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_ceil_f16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_ceil_f16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_ceil_f16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_ceil_f16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_ceil_f16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_ceil_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_ceil_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_ceil_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_ceil_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_ceil_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_ceil_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xdc,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_ceil_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_ceil_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xdc,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_ceil_f16_e64_dpp v5.h, v1.h mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_ceil_f16_e64_dpp v5.h, v1.h op_sel:[1,1] mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xdc,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_ceil_f16_e64_dpp v5.l, v1.h mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_ceil_f16_e64_dpp v5.l, v1.h op_sel:[1,0] mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xdc,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_ceil_f16_e64_dpp v255.h, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_ceil_f16_e64_dpp v255.h, -|v255.l| op_sel:[0,1] clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0xc1,0xdc,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_ceil_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_ceil_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_ceil_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_ceil_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_ceil_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_ceil_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_ceil_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_ceil_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_ceil_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_ceil_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_ceil_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_ceil_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_ceil_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_ceil_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_ceil_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_ceil_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_ceil_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_ceil_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xa2,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_ceil_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_ceil_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xa2,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_cls_i32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_cls_i32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cls_i32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_cls_i32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cls_i32_e64_dpp v5, v1 row_mirror
// GFX12: v_cls_i32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_cls_i32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_shl:1
// GFX12: v_cls_i32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_shl:15
// GFX12: v_cls_i32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_shr:1
// GFX12: v_cls_i32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_shr:15
// GFX12: v_cls_i32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_ror:1
// GFX12: v_cls_i32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_ror:15
// GFX12: v_cls_i32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cls_i32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cls_i32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cls_i32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cls_i32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cls_i32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cls_i32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cls_i32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_clz_i32_u32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_clz_i32_u32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_mirror
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_shl:1
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_shl:15
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_shr:1
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_shr:15
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_ror:1
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_ror:15
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_clz_i32_u32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_clz_i32_u32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_clz_i32_u32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_clz_i32_u32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_cos_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_cos_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cos_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_cos_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cos_f16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_cos_f16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cos_f16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_cos_f16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cos_f16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_cos_f16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cos_f16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_cos_f16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cos_f16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_cos_f16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cos_f16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_cos_f16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cos_f16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_cos_f16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cos_f16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_cos_f16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cos_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cos_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cos_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cos_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cos_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cos_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xe1,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cos_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cos_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xe1,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_cos_f16_e64_dpp v5.h, v1.h mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cos_f16_e64_dpp v5.h, v1.h op_sel:[1,1] mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xe1,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cos_f16_e64_dpp v5.l, v1.h mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cos_f16_e64_dpp v5.l, v1.h op_sel:[1,0] mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xe1,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cos_f16_e64_dpp v255.h, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cos_f16_e64_dpp v255.h, -|v255.l| op_sel:[0,1] clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0xc1,0xe1,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_cos_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_cos_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cos_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_cos_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cos_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_cos_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_cos_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_cos_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_cos_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_cos_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_cos_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_cos_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_cos_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cos_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cos_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cos_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cos_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cos_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xb6,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cos_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cos_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xb6,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_ctz_i32_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_mirror
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_shl:1
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_shl:15
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_shr:1
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_shr:15
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_ror:1
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_ror:15
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_ctz_i32_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_ctz_i32_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_ctz_i32_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_ctz_i32_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

V_CVT_F32_FP8_e64_dpp v5, v1 quad_perm:[3,1,2,0] row_mask:0x2 bank_mask:0xd
// GFX12: v_cvt_f32_fp8_e64_dpp v5, v1 quad_perm:[3,1,2,0] row_mask:0x2 bank_mask:0xd ; encoding: [0x05,0x00,0xec,0xd5,0xfa,0x00,0x00,0x00,0x01,0x27,0x00,0x2d]

V_CVT_F32_FP8_e64_dpp v1, v3 quad_perm:[2,1,0,3] row_mask:0x5 bank_mask:0xe
// GFX12: v_cvt_f32_fp8_e64_dpp v1, v3 quad_perm:[2,1,0,3] row_mask:0x5 bank_mask:0xe ; encoding: [0x01,0x00,0xec,0xd5,0xfa,0x00,0x00,0x00,0x03,0xc6,0x00,0x5e]

V_CVT_F32_BF8_e64_dpp v5, v1 quad_perm:[0,3,2,1] row_mask:0x2 bank_mask:0xd
// GFX12: v_cvt_f32_bf8_e64_dpp v5, v1 quad_perm:[0,3,2,1] row_mask:0x2 bank_mask:0xd ; encoding: [0x05,0x00,0xed,0xd5,0xfa,0x00,0x00,0x00,0x01,0x6c,0x00,0x2d]

V_CVT_F32_BF8_e64_dpp v1, v3 quad_perm:[0,1,3,2] row_mask:0x5 bank_mask:0xe
// GFX12: v_cvt_f32_bf8_e64_dpp v1, v3 quad_perm:[0,1,3,2] row_mask:0x5 bank_mask:0xe ; encoding: [0x01,0x00,0xed,0xd5,0xfa,0x00,0x00,0x00,0x03,0xb4,0x00,0x5e]

v_cvt_f16_f32_e64_dpp v5.l, v1 quad_perm:[3,2,1,0]
// GFX12: v_cvt_f16_f32_e64_dpp v5.l, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f16_f32_e64_dpp v5.l, v1 quad_perm:[0,1,2,3]
// GFX12: v_cvt_f16_f32_e64_dpp v5.l, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f16_f32_e64_dpp v5.l, v1 row_mirror
// GFX12: v_cvt_f16_f32_e64_dpp v5.l, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5.l, v1 row_half_mirror
// GFX12: v_cvt_f16_f32_e64_dpp v5.l, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5.l, v1 row_shl:1
// GFX12: v_cvt_f16_f32_e64_dpp v5.l, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5.l, v1 row_shl:15
// GFX12: v_cvt_f16_f32_e64_dpp v5.l, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5.l, v1 row_shr:1
// GFX12: v_cvt_f16_f32_e64_dpp v5.l, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5.l, v1 row_shr:15
// GFX12: v_cvt_f16_f32_e64_dpp v5.l, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5.l, v1 row_ror:1
// GFX12: v_cvt_f16_f32_e64_dpp v5.l, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5.l, v1 row_ror:15
// GFX12: v_cvt_f16_f32_e64_dpp v5.l, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5.l, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_f16_f32_e64_dpp v5.l, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f16_f32_e64_dpp v5.l, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_f16_f32_e64_dpp v5.l, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f16_f32_e64_dpp v5.l, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_f16_f32_e64_dpp v5.l, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0x8a,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f16_f32_e64_dpp v255.l, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_f16_f32_e64_dpp v255.l, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0x8a,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_cvt_f16_f32_e64_dpp v255.h, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_f16_f32_e64_dpp v255.h, -|v255| op_sel:[0,1] clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0xc1,0x8a,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_cvt_f16_i16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_cvt_f16_i16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f16_i16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_cvt_f16_i16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f16_i16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_cvt_f16_i16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_cvt_f16_i16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_cvt_f16_i16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_cvt_f16_i16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_cvt_f16_i16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_cvt_f16_i16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_cvt_f16_i16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_cvt_f16_i16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_f16_i16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f16_i16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_f16_i16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f16_i16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_f16_i16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xd1,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f16_i16_e64_dpp v255.l, v255.l clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_f16_i16_e64_dpp v255.l, v255.l clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x80,0xd1,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_f16_i16_e64_dpp v5.h, v1.h mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_f16_i16_e64_dpp v5.h, v1.h op_sel:[1,1] mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xd1,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f16_i16_e64_dpp v5.l, v1.h mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_f16_i16_e64_dpp v5.l, v1.h op_sel:[1,0] mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xd1,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f16_i16_e64_dpp v255.h, v255.l clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_f16_i16_e64_dpp v255.h, v255.l op_sel:[0,1] clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0xc0,0xd1,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_f16_u16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_cvt_f16_u16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f16_u16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_cvt_f16_u16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f16_u16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_cvt_f16_u16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_cvt_f16_u16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_cvt_f16_u16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_cvt_f16_u16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_cvt_f16_u16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_cvt_f16_u16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_cvt_f16_u16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_cvt_f16_u16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_f16_u16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f16_u16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_f16_u16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f16_u16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_f16_u16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xd0,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f16_u16_e64_dpp v255.l, v255.l clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_f16_u16_e64_dpp v255.l, v255.l clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x80,0xd0,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_f16_u16_e64_dpp v5.h, v1.h mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_f16_u16_e64_dpp v5.h, v1.h op_sel:[1,1] mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xd0,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f16_u16_e64_dpp v5.l, v1.h mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_f16_u16_e64_dpp v5.l, v1.h op_sel:[1,0] mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xd0,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f16_u16_e64_dpp v255.h, v255.l clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_f16_u16_e64_dpp v255.h, v255.l op_sel:[0,1] clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0xc0,0xd0,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_f32_f16_e64_dpp v5, v1.l quad_perm:[3,2,1,0]
// GFX12: v_cvt_f32_f16_e64_dpp v5, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_f16_e64_dpp v5, v1.l quad_perm:[0,1,2,3]
// GFX12: v_cvt_f32_f16_e64_dpp v5, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_f16_e64_dpp v5, v1.l row_mirror
// GFX12: v_cvt_f32_f16_e64_dpp v5, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1.l row_half_mirror
// GFX12: v_cvt_f32_f16_e64_dpp v5, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1.l row_shl:1
// GFX12: v_cvt_f32_f16_e64_dpp v5, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1.l row_shl:15
// GFX12: v_cvt_f32_f16_e64_dpp v5, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1.l row_shr:1
// GFX12: v_cvt_f32_f16_e64_dpp v5, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1.l row_shr:15
// GFX12: v_cvt_f32_f16_e64_dpp v5, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1.l row_ror:1
// GFX12: v_cvt_f32_f16_e64_dpp v5, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1.l row_ror:15
// GFX12: v_cvt_f32_f16_e64_dpp v5, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_f32_f16_e64_dpp v5, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_f16_e64_dpp v5, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_f32_f16_e64_dpp v5, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_f16_e64_dpp v5, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_f32_f16_e64_dpp v5, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0x8b,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_f16_e64_dpp v255, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_f32_f16_e64_dpp v255, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0x8b,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_cvt_f32_f16_e64_dpp v255, -|v255.h| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_f32_f16_e64_dpp v255, -|v255.h| op_sel:[1,0] clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x89,0x8b,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_cvt_f32_fp8 v1, v2 quad_perm:[0,1,2,3]
// GFX12: v_cvt_f32_fp8_dpp v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0xfa,0xd8,0x02,0x7e,0x02,0xe4,0x00,0xff]

v_cvt_f32_fp8 v1, v2 byte_sel:0 quad_perm:[0,1,2,3]
// GFX12: v_cvt_f32_fp8_e64_dpp v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x01,0x00,0xec,0xd5,0xfa,0x00,0x00,0x00,0x02,0xe4,0x00,0xff]

v_cvt_f32_fp8 v1, v2 byte_sel:1 quad_perm:[0,1,2,3]
// GFX12: v_cvt_f32_fp8_e64_dpp v1, v2 byte_sel:1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x01,0x10,0xec,0xd5,0xfa,0x00,0x00,0x00,0x02,0xe4,0x00,0xff]

v_cvt_f32_fp8 v1, v2 byte_sel:2 quad_perm:[0,1,2,3]
// GFX12: v_cvt_f32_fp8_e64_dpp v1, v2 byte_sel:2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x01,0x08,0xec,0xd5,0xfa,0x00,0x00,0x00,0x02,0xe4,0x00,0xff]

v_cvt_f32_fp8 v1, v2 byte_sel:3 quad_perm:[0,1,2,3]
// GFX12: v_cvt_f32_fp8_e64_dpp v1, v2 byte_sel:3 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x01,0x18,0xec,0xd5,0xfa,0x00,0x00,0x00,0x02,0xe4,0x00,0xff]

v_cvt_f32_bf8 v1, v2 quad_perm:[0,1,2,3]
// GFX12: v_cvt_f32_bf8_dpp v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0xfa,0xda,0x02,0x7e,0x02,0xe4,0x00,0xff]

v_cvt_f32_bf8 v1, v2 byte_sel:0 quad_perm:[0,1,2,3]
// GFX12: v_cvt_f32_bf8_e64_dpp v1, v2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x01,0x00,0xed,0xd5,0xfa,0x00,0x00,0x00,0x02,0xe4,0x00,0xff]

v_cvt_f32_bf8 v1, v2 byte_sel:1 quad_perm:[0,1,2,3]
// GFX12: v_cvt_f32_bf8_e64_dpp v1, v2 byte_sel:1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x01,0x10,0xed,0xd5,0xfa,0x00,0x00,0x00,0x02,0xe4,0x00,0xff]

v_cvt_f32_bf8 v1, v2 byte_sel:2 quad_perm:[0,1,2,3]
// GFX12: v_cvt_f32_bf8_e64_dpp v1, v2 byte_sel:2 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x01,0x08,0xed,0xd5,0xfa,0x00,0x00,0x00,0x02,0xe4,0x00,0xff]

v_cvt_f32_bf8 v1, v2 byte_sel:3 quad_perm:[0,1,2,3]
// GFX12: v_cvt_f32_bf8_e64_dpp v1, v2 byte_sel:3 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x01,0x18,0xed,0xd5,0xfa,0x00,0x00,0x00,0x02,0xe4,0x00,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_cvt_f32_i32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_cvt_f32_i32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_mirror
// GFX12: v_cvt_f32_i32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_cvt_f32_i32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_shl:1
// GFX12: v_cvt_f32_i32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_shl:15
// GFX12: v_cvt_f32_i32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_shr:1
// GFX12: v_cvt_f32_i32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_shr:15
// GFX12: v_cvt_f32_i32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_ror:1
// GFX12: v_cvt_f32_i32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_ror:15
// GFX12: v_cvt_f32_i32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_f32_i32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_i32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_f32_i32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_i32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_f32_i32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0x85,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_i32_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_f32_i32_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x80,0x85,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_f32_u32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_cvt_f32_u32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_cvt_f32_u32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_mirror
// GFX12: v_cvt_f32_u32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_cvt_f32_u32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_shl:1
// GFX12: v_cvt_f32_u32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_shl:15
// GFX12: v_cvt_f32_u32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_shr:1
// GFX12: v_cvt_f32_u32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_shr:15
// GFX12: v_cvt_f32_u32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_ror:1
// GFX12: v_cvt_f32_u32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_ror:15
// GFX12: v_cvt_f32_u32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_f32_u32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_u32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_f32_u32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_u32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_f32_u32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0x86,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_u32_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_f32_u32_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x80,0x86,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_f32_ubyte0_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_cvt_f32_ubyte0_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_cvt_f32_ubyte0_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_mirror
// GFX12: v_cvt_f32_ubyte0_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_half_mirror
// GFX12: v_cvt_f32_ubyte0_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_shl:1
// GFX12: v_cvt_f32_ubyte0_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_shl:15
// GFX12: v_cvt_f32_ubyte0_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_shr:1
// GFX12: v_cvt_f32_ubyte0_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_shr:15
// GFX12: v_cvt_f32_ubyte0_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_ror:1
// GFX12: v_cvt_f32_ubyte0_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_ror:15
// GFX12: v_cvt_f32_ubyte0_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_f32_ubyte0_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_ubyte0_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_f32_ubyte0_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_ubyte0_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_f32_ubyte0_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0x91,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_ubyte0_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_f32_ubyte0_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x80,0x91,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_f32_ubyte1_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_cvt_f32_ubyte1_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_cvt_f32_ubyte1_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_mirror
// GFX12: v_cvt_f32_ubyte1_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_half_mirror
// GFX12: v_cvt_f32_ubyte1_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_shl:1
// GFX12: v_cvt_f32_ubyte1_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_shl:15
// GFX12: v_cvt_f32_ubyte1_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_shr:1
// GFX12: v_cvt_f32_ubyte1_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_shr:15
// GFX12: v_cvt_f32_ubyte1_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_ror:1
// GFX12: v_cvt_f32_ubyte1_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_ror:15
// GFX12: v_cvt_f32_ubyte1_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_f32_ubyte1_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_ubyte1_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_f32_ubyte1_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_ubyte1_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_f32_ubyte1_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0x92,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_ubyte1_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_f32_ubyte1_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x80,0x92,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_f32_ubyte2_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_cvt_f32_ubyte2_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_cvt_f32_ubyte2_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_mirror
// GFX12: v_cvt_f32_ubyte2_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_half_mirror
// GFX12: v_cvt_f32_ubyte2_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_shl:1
// GFX12: v_cvt_f32_ubyte2_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_shl:15
// GFX12: v_cvt_f32_ubyte2_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_shr:1
// GFX12: v_cvt_f32_ubyte2_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_shr:15
// GFX12: v_cvt_f32_ubyte2_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_ror:1
// GFX12: v_cvt_f32_ubyte2_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_ror:15
// GFX12: v_cvt_f32_ubyte2_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_f32_ubyte2_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_ubyte2_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_f32_ubyte2_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_ubyte2_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_f32_ubyte2_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0x93,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_ubyte2_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_f32_ubyte2_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x80,0x93,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_f32_ubyte3_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_cvt_f32_ubyte3_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_cvt_f32_ubyte3_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_mirror
// GFX12: v_cvt_f32_ubyte3_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_half_mirror
// GFX12: v_cvt_f32_ubyte3_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_shl:1
// GFX12: v_cvt_f32_ubyte3_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_shl:15
// GFX12: v_cvt_f32_ubyte3_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_shr:1
// GFX12: v_cvt_f32_ubyte3_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_shr:15
// GFX12: v_cvt_f32_ubyte3_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_ror:1
// GFX12: v_cvt_f32_ubyte3_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_ror:15
// GFX12: v_cvt_f32_ubyte3_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_f32_ubyte3_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_f32_ubyte3_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_f32_ubyte3_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_f32_ubyte3_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_f32_ubyte3_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0x94,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_f32_ubyte3_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_f32_ubyte3_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x80,0x94,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_floor_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_floor_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_floor_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_floor_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x01,0x8d,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_flr_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_flr_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_floor_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0x8d,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_flr_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_floor_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x01,0x8d,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_i16_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_cvt_i16_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_i16_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_cvt_i16_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_i16_f16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_cvt_i16_f16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_cvt_i16_f16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_cvt_i16_f16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_cvt_i16_f16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_cvt_i16_f16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_cvt_i16_f16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_cvt_i16_f16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_cvt_i16_f16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_i16_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_i16_f16_e64_dpp v5.l, v1.l row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_i16_f16_e64_dpp v5.l, v1.l row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_i16_f16_e64_dpp v5.l, v1.l row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_i16_f16_e64_dpp v5.l, v1.l row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_i16_f16_e64_dpp v255.l, -|v255.l| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_i16_f16_e64_dpp v255.l, -|v255.l| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xd3,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_i16_f16_e64_dpp v5.h, v1.h row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_i16_f16_e64_dpp v5.h, v1.h op_sel:[1,1] row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_i16_f16_e64_dpp v5.l, v1.h row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_i16_f16_e64_dpp v5.l, v1.h op_sel:[1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xd3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_i16_f16_e64_dpp v255.h, -|v255.l| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_i16_f16_e64_dpp v255.h, -|v255.l| op_sel:[0,1] clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0xc1,0xd3,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_cvt_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_cvt_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_cvt_i32_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_cvt_i32_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_cvt_i32_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_cvt_i32_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_cvt_i32_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_cvt_i32_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_cvt_i32_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_cvt_i32_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0x88,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_i32_f32_e64_dpp v255, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_i32_f32_e64_dpp v255, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0x88,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_i32_i16_e64_dpp v5, v1.l quad_perm:[3,2,1,0]
// GFX12: v_cvt_i32_i16_e64_dpp v5, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_i32_i16_e64_dpp v5, v1.l quad_perm:[0,1,2,3]
// GFX12: v_cvt_i32_i16_e64_dpp v5, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_i32_i16_e64_dpp v5, v1.l row_mirror
// GFX12: v_cvt_i32_i16_e64_dpp v5, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1.l row_half_mirror
// GFX12: v_cvt_i32_i16_e64_dpp v5, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1.l row_shl:1
// GFX12: v_cvt_i32_i16_e64_dpp v5, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1.l row_shl:15
// GFX12: v_cvt_i32_i16_e64_dpp v5, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1.l row_shr:1
// GFX12: v_cvt_i32_i16_e64_dpp v5, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1.l row_shr:15
// GFX12: v_cvt_i32_i16_e64_dpp v5, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1.l row_ror:1
// GFX12: v_cvt_i32_i16_e64_dpp v5, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1.l row_ror:15
// GFX12: v_cvt_i32_i16_e64_dpp v5, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_i32_i16_e64_dpp v5, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_i32_i16_e64_dpp v5, v1.l row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_i32_i16_e64_dpp v5, v1.l row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_i32_i16_e64_dpp v5, v1.l row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_i32_i16_e64_dpp v5, v1.l row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_i32_i16_e64_dpp v255, v255.l row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_i32_i16_e64_dpp v255, v255.l row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x00,0xea,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_cvt_i32_i16_e64_dpp v255, v255.h row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_i32_i16_e64_dpp v255, v255.h op_sel:[1,0] row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x08,0xea,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_nearest_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x01,0x8c,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_norm_i16_f16_e64_dpp v5.l, v1.l row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_norm_i16_f16_e64_dpp v255.l, -|v255.l| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_norm_i16_f16_e64_dpp v255.l, -|v255.l| row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x01,0xe3,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_norm_i16_f16_e64_dpp v5.h, v1.h row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_norm_i16_f16_e64_dpp v5.h, v1.h op_sel:[1,1] row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_norm_i16_f16_e64_dpp v5.l, v1.h row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_norm_i16_f16_e64_dpp v5.l, v1.h op_sel:[1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xe3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_norm_i16_f16_e64_dpp v255.h, -|v255.l| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_norm_i16_f16_e64_dpp v255.h, -|v255.l| op_sel:[0,1] row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x41,0xe3,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_norm_u16_f16_e64_dpp v5.l, v1.l row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_norm_u16_f16_e64_dpp v255.l, -|v255.l| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_norm_u16_f16_e64_dpp v255.l, -|v255.l| row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x01,0xe4,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_norm_u16_f16_e64_dpp v5.h, v1.h row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_norm_u16_f16_e64_dpp v5.h, v1.h op_sel:[1,1] row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_norm_u16_f16_e64_dpp v5.l, v1.h row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_norm_u16_f16_e64_dpp v5.l, v1.h op_sel:[1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xe4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_norm_u16_f16_e64_dpp v255.h, -|v255.l| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_norm_u16_f16_e64_dpp v255.h, -|v255.l| op_sel:[0,1] row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x41,0xe4,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_off_f32_i4_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_cvt_off_f32_i4_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_cvt_off_f32_i4_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_mirror
// GFX12: v_cvt_off_f32_i4_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_half_mirror
// GFX12: v_cvt_off_f32_i4_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_shl:1
// GFX12: v_cvt_off_f32_i4_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_shl:15
// GFX12: v_cvt_off_f32_i4_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_shr:1
// GFX12: v_cvt_off_f32_i4_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_shr:15
// GFX12: v_cvt_off_f32_i4_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_ror:1
// GFX12: v_cvt_off_f32_i4_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_ror:15
// GFX12: v_cvt_off_f32_i4_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_off_f32_i4_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_off_f32_i4_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_off_f32_i4_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_cvt_off_f32_i4_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_off_f32_i4_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0x8e,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_cvt_off_f32_i4_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_off_f32_i4_e64_dpp v255, v255 clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x80,0x8e,0xd5,0xfa,0x00,0x00,0x18,0xff,0x6f,0x05,0x30]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_rpi_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0x8c,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_rpi_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_nearest_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x01,0x8c,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_u16_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_cvt_u16_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_u16_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_cvt_u16_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_u16_f16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_cvt_u16_f16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_cvt_u16_f16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_cvt_u16_f16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_cvt_u16_f16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_cvt_u16_f16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_cvt_u16_f16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_cvt_u16_f16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_cvt_u16_f16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_u16_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_u16_f16_e64_dpp v5.l, v1.l row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_u16_f16_e64_dpp v5.l, v1.l row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_u16_f16_e64_dpp v5.l, v1.l row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_u16_f16_e64_dpp v5.l, v1.l row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_u16_f16_e64_dpp v255.l, -|v255.l| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_u16_f16_e64_dpp v255.l, -|v255.l| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xd2,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_u16_f16_e64_dpp v5.h, v1.h row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_u16_f16_e64_dpp v5.h, v1.h op_sel:[1,1] row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_u16_f16_e64_dpp v5.l, v1.h row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_u16_f16_e64_dpp v5.l, v1.h op_sel:[1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xd2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_u16_f16_e64_dpp v255.h, -|v255.l| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_u16_f16_e64_dpp v255.h, -|v255.l| op_sel:[0,1] clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0xc1,0xd2,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_u32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_cvt_u32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_cvt_u32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_cvt_u32_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_cvt_u32_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_cvt_u32_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_cvt_u32_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_cvt_u32_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_cvt_u32_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_cvt_u32_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_cvt_u32_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_u32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_u32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_u32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_u32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_u32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0x87,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_u32_f32_e64_dpp v255, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_u32_f32_e64_dpp v255, -|v255| clamp row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0x87,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_cvt_u32_u16_e64_dpp v5, v1.l quad_perm:[3,2,1,0]
// GFX12: v_cvt_u32_u16_e64_dpp v5, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_cvt_u32_u16_e64_dpp v5, v1.l quad_perm:[0,1,2,3]
// GFX12: v_cvt_u32_u16_e64_dpp v5, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_cvt_u32_u16_e64_dpp v5, v1.l row_mirror
// GFX12: v_cvt_u32_u16_e64_dpp v5, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1.l row_half_mirror
// GFX12: v_cvt_u32_u16_e64_dpp v5, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1.l row_shl:1
// GFX12: v_cvt_u32_u16_e64_dpp v5, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1.l row_shl:15
// GFX12: v_cvt_u32_u16_e64_dpp v5, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1.l row_shr:1
// GFX12: v_cvt_u32_u16_e64_dpp v5, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1.l row_shr:15
// GFX12: v_cvt_u32_u16_e64_dpp v5, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1.l row_ror:1
// GFX12: v_cvt_u32_u16_e64_dpp v5, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1.l row_ror:15
// GFX12: v_cvt_u32_u16_e64_dpp v5, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cvt_u32_u16_e64_dpp v5, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_cvt_u32_u16_e64_dpp v5, v1.l row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cvt_u32_u16_e64_dpp v5, v1.l row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_cvt_u32_u16_e64_dpp v5, v1.l row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cvt_u32_u16_e64_dpp v5, v1.l row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_cvt_u32_u16_e64_dpp v255, v255.l row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_u32_u16_e64_dpp v255, v255.l row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x00,0xeb,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_cvt_u32_u16_e64_dpp v255, v255.h row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cvt_u32_u16_e64_dpp v255, v255.h op_sel:[1,0] row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x08,0xeb,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_exp_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_exp_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_exp_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_exp_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_exp_f16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_exp_f16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_exp_f16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_exp_f16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_exp_f16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_exp_f16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_exp_f16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_exp_f16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_exp_f16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_exp_f16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_exp_f16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_exp_f16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_exp_f16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_exp_f16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_exp_f16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_exp_f16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_exp_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_exp_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_exp_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_exp_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_exp_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_exp_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xd8,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_exp_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_exp_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xd8,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_exp_f16_e64_dpp v5.h, v1.h mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_exp_f16_e64_dpp v5.h, v1.h op_sel:[1,1] mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xd8,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_exp_f16_e64_dpp v5.l, v1.h mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_exp_f16_e64_dpp v5.l, v1.h op_sel:[1,0] mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xd8,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_exp_f16_e64_dpp v255.h, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_exp_f16_e64_dpp v255.h, -|v255.l| op_sel:[0,1] clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0xc1,0xd8,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_exp_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_exp_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_exp_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_exp_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_exp_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_exp_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_exp_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_exp_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_exp_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_exp_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_exp_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_exp_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_exp_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_exp_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_exp_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_exp_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_exp_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_exp_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xa5,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_exp_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_exp_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xa5,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_ffbh_i32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_cls_i32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_ffbh_i32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_cls_i32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_mirror
// GFX12: v_cls_i32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_cls_i32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_shl:1
// GFX12: v_cls_i32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_shl:15
// GFX12: v_cls_i32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_shr:1
// GFX12: v_cls_i32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_shr:15
// GFX12: v_cls_i32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_ror:1
// GFX12: v_cls_i32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_ror:15
// GFX12: v_cls_i32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_cls_i32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_ffbh_i32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_cls_i32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_ffbh_i32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_cls_i32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_ffbh_i32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_cls_i32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x00,0xbb,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_ffbh_u32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_ffbh_u32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_mirror
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_shl:1
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_shl:15
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_shr:1
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_shr:15
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_ror:1
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_ror:15
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_ffbh_u32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_ffbh_u32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_clz_i32_u32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_ffbh_u32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_clz_i32_u32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x00,0xb9,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_ffbl_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_ffbl_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_mirror
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_shl:1
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_shl:15
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_shr:1
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_shr:15
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_ror:1
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_ror:15
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_ffbl_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_ffbl_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_ctz_i32_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_ffbl_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_ctz_i32_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x00,0xba,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_floor_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_floor_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_floor_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_floor_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_floor_f16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_floor_f16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_floor_f16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_floor_f16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_floor_f16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_floor_f16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_floor_f16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_floor_f16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_floor_f16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_floor_f16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_floor_f16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_floor_f16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_floor_f16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_floor_f16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_floor_f16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_floor_f16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_floor_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_floor_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_floor_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_floor_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_floor_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_floor_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xdb,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_floor_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_floor_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xdb,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_floor_f16_e64_dpp v5.h, v1.h mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_floor_f16_e64_dpp v5.h, v1.h op_sel:[1,1] mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xdb,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_floor_f16_e64_dpp v5.l, v1.h mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_floor_f16_e64_dpp v5.l, v1.h op_sel:[1,0] mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xdb,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_floor_f16_e64_dpp v255.h, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_floor_f16_e64_dpp v255.h, -|v255.l| op_sel:[0,1] clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0xc1,0xdb,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_floor_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_floor_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_floor_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_floor_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_floor_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_floor_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_floor_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_floor_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_floor_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_floor_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_floor_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_floor_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_floor_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_floor_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_floor_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_floor_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_floor_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_floor_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xa4,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_floor_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_floor_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xa4,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_fract_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_fract_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_fract_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_fract_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_fract_f16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_fract_f16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_fract_f16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_fract_f16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_fract_f16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_fract_f16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_fract_f16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_fract_f16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_fract_f16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_fract_f16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_fract_f16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_fract_f16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_fract_f16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_fract_f16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_fract_f16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_fract_f16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_fract_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_fract_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_fract_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_fract_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_fract_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_fract_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xdf,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_fract_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_fract_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xdf,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_fract_f16_e64_dpp v5.h, v1.h mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_fract_f16_e64_dpp v5.h, v1.h op_sel:[1,1] mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xdf,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_fract_f16_e64_dpp v5.l, v1.h mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_fract_f16_e64_dpp v5.l, v1.h op_sel:[1,0] mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xdf,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_fract_f16_e64_dpp v255.h, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_fract_f16_e64_dpp v255.h, -|v255.l| op_sel:[0,1] clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0xc1,0xdf,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_fract_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_fract_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_fract_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_fract_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_fract_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_fract_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_fract_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_fract_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_fract_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_fract_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_fract_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_fract_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_fract_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_fract_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_fract_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_fract_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_fract_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_fract_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xa0,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_fract_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_fract_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xa0,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_frexp_exp_i16_f16_e64_dpp v5.l, v1.l row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_frexp_exp_i16_f16_e64_dpp v255.l, -|v255.l| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_frexp_exp_i16_f16_e64_dpp v255.l, -|v255.l| row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x01,0xda,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_frexp_exp_i16_f16_e64_dpp v5.h, v1.h row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_frexp_exp_i16_f16_e64_dpp v5.h, v1.h op_sel:[1,1] row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_frexp_exp_i16_f16_e64_dpp v5.l, v1.h row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_frexp_exp_i16_f16_e64_dpp v5.l, v1.h op_sel:[1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xda,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_frexp_exp_i16_f16_e64_dpp v255.h, -|v255.l| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_frexp_exp_i16_f16_e64_dpp v255.h, -|v255.l| op_sel:[0,1] row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x41,0xda,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_frexp_exp_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_frexp_exp_i32_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_frexp_exp_i32_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_frexp_exp_i32_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_frexp_exp_i32_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_frexp_exp_i32_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_frexp_exp_i32_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_frexp_exp_i32_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_frexp_exp_i32_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_frexp_exp_i32_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_frexp_exp_i32_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_frexp_exp_i32_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_frexp_exp_i32_f32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_frexp_exp_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_frexp_exp_i32_f32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xbf,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_frexp_exp_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_frexp_exp_i32_f32_e64_dpp v255, -|v255| row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x01,0xbf,0xd5,0xfa,0x00,0x00,0x20,0xff,0x6f,0x05,0x30]

v_frexp_mant_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_frexp_mant_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_frexp_mant_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_frexp_mant_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_frexp_mant_f16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_frexp_mant_f16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_frexp_mant_f16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_frexp_mant_f16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_frexp_mant_f16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_frexp_mant_f16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_frexp_mant_f16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_frexp_mant_f16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_frexp_mant_f16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_frexp_mant_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_frexp_mant_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_frexp_mant_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_frexp_mant_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_frexp_mant_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xd9,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_frexp_mant_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_frexp_mant_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xd9,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_frexp_mant_f16_e64_dpp v5.h, v1.h mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_frexp_mant_f16_e64_dpp v5.h, v1.h op_sel:[1,1] mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xd9,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_frexp_mant_f16_e64_dpp v5.l, v1.h mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_frexp_mant_f16_e64_dpp v5.l, v1.h op_sel:[1,0] mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xd9,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_frexp_mant_f16_e64_dpp v255.h, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_frexp_mant_f16_e64_dpp v255.h, -|v255.l| op_sel:[0,1] clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0xc1,0xd9,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_frexp_mant_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_frexp_mant_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_frexp_mant_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_frexp_mant_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_frexp_mant_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_frexp_mant_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_frexp_mant_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_frexp_mant_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_frexp_mant_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_frexp_mant_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_frexp_mant_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_frexp_mant_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_frexp_mant_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_frexp_mant_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_frexp_mant_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_frexp_mant_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xc0,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_frexp_mant_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_frexp_mant_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xc0,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_log_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_log_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_log_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_log_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_log_f16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_log_f16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_log_f16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_log_f16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_log_f16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_log_f16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_log_f16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_log_f16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_log_f16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_log_f16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_log_f16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_log_f16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_log_f16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_log_f16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_log_f16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_log_f16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_log_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_log_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_log_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_log_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_log_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_log_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xd7,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_log_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_log_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xd7,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_log_f16_e64_dpp v5.h, v1.h mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_log_f16_e64_dpp v5.h, v1.h op_sel:[1,1] mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xd7,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_log_f16_e64_dpp v5.l, v1.h mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_log_f16_e64_dpp v5.l, v1.h op_sel:[1,0] mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xd7,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_log_f16_e64_dpp v255.h, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_log_f16_e64_dpp v255.h, -|v255.l| op_sel:[0,1] clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0xc1,0xd7,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_log_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_log_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_log_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_log_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_log_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_log_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_log_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_log_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_log_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_log_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_log_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_log_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_log_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_log_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_log_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_log_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_log_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_log_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_log_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xa7,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_log_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_log_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xa7,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_mov_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_mov_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_mov_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_mov_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_mov_b32_e64_dpp v5, v1 row_mirror
// GFX12: v_mov_b32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_mov_b32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_shl:1
// GFX12: v_mov_b32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_shl:15
// GFX12: v_mov_b32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_shr:1
// GFX12: v_mov_b32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_shr:15
// GFX12: v_mov_b32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_ror:1
// GFX12: v_mov_b32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_ror:15
// GFX12: v_mov_b32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_mov_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_mov_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_mov_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_mov_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_mov_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_mov_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_mov_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x00,0x81,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_movrels_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_movrels_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_movrels_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_movrels_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_movrels_b32_e64_dpp v5, v1 row_mirror
// GFX12: v_movrels_b32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_movrels_b32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_shl:1
// GFX12: v_movrels_b32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_shl:15
// GFX12: v_movrels_b32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_shr:1
// GFX12: v_movrels_b32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_shr:15
// GFX12: v_movrels_b32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_ror:1
// GFX12: v_movrels_b32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_ror:15
// GFX12: v_movrels_b32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_movrels_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_movrels_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_movrels_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_movrels_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_movrels_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_movrels_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_movrels_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x00,0xc3,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_not_b16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_not_b16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_not_b16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_not_b16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_not_b16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_not_b16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_not_b16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_not_b16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_not_b16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_not_b16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_not_b16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_not_b16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_not_b16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_not_b16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_not_b16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_not_b16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_not_b16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_not_b16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_not_b16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_not_b16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_not_b16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_not_b16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_not_b16_e64_dpp v5.l, v1.l row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_not_b16_e64_dpp v5.l, v1.l row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_not_b16_e64_dpp v5.l, v1.l row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_not_b16_e64_dpp v5.l, v1.l row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_not_b16_e64_dpp v255.l, v255.l row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_not_b16_e64_dpp v255.l, v255.l row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x00,0xe9,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_not_b16_e64_dpp v5.h, v1.h row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_not_b16_e64_dpp v5.h, v1.h op_sel:[1,1] row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_not_b16_e64_dpp v5.l, v1.h row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_not_b16_e64_dpp v5.l, v1.h op_sel:[1,0] row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xe9,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_not_b16_e64_dpp v255.h, v255.l row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_not_b16_e64_dpp v255.h, v255.l op_sel:[0,1] row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x40,0xe9,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_not_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_not_b32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_not_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_not_b32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_not_b32_e64_dpp v5, v1 row_mirror
// GFX12: v_not_b32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_not_b32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_shl:1
// GFX12: v_not_b32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_shl:15
// GFX12: v_not_b32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_shr:1
// GFX12: v_not_b32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_shr:15
// GFX12: v_not_b32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_ror:1
// GFX12: v_not_b32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_ror:15
// GFX12: v_not_b32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_not_b32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_not_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_not_b32_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_not_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_not_b32_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_not_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_not_b32_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x00,0xb7,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_rcp_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_rcp_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rcp_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_rcp_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rcp_f16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_rcp_f16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rcp_f16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_rcp_f16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rcp_f16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_rcp_f16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rcp_f16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_rcp_f16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rcp_f16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_rcp_f16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rcp_f16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_rcp_f16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rcp_f16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_rcp_f16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rcp_f16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_rcp_f16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rcp_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_rcp_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rcp_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_rcp_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rcp_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_rcp_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xd4,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rcp_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_rcp_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xd4,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_rcp_f16_e64_dpp v5.h, v1.h mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_rcp_f16_e64_dpp v5.h, v1.h op_sel:[1,1] mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xd4,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rcp_f16_e64_dpp v5.l, v1.h mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_rcp_f16_e64_dpp v5.l, v1.h op_sel:[1,0] mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xd4,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rcp_f16_e64_dpp v255.h, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_rcp_f16_e64_dpp v255.h, -|v255.l| op_sel:[0,1] clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0xc1,0xd4,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_rcp_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_rcp_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rcp_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_rcp_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rcp_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_rcp_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_rcp_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_rcp_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_rcp_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_rcp_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_rcp_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_rcp_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_rcp_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_rcp_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rcp_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_rcp_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rcp_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_rcp_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xaa,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rcp_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_rcp_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xaa,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_rcp_iflag_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_rcp_iflag_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_rcp_iflag_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_rcp_iflag_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_rcp_iflag_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_rcp_iflag_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_rcp_iflag_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_rcp_iflag_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_rcp_iflag_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_rcp_iflag_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_rcp_iflag_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_rcp_iflag_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rcp_iflag_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_rcp_iflag_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rcp_iflag_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_rcp_iflag_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xab,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rcp_iflag_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_rcp_iflag_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xab,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_rndne_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_rndne_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rndne_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_rndne_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rndne_f16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_rndne_f16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rndne_f16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_rndne_f16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rndne_f16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_rndne_f16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rndne_f16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_rndne_f16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rndne_f16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_rndne_f16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rndne_f16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_rndne_f16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rndne_f16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_rndne_f16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rndne_f16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_rndne_f16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rndne_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_rndne_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rndne_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_rndne_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rndne_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_rndne_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xde,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rndne_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_rndne_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xde,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_rndne_f16_e64_dpp v5.h, v1.h mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_rndne_f16_e64_dpp v5.h, v1.h op_sel:[1,1] mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xde,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rndne_f16_e64_dpp v5.l, v1.h mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_rndne_f16_e64_dpp v5.l, v1.h op_sel:[1,0] mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xde,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rndne_f16_e64_dpp v255.h, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_rndne_f16_e64_dpp v255.h, -|v255.l| op_sel:[0,1] clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0xc1,0xde,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_rndne_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_rndne_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rndne_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_rndne_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rndne_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_rndne_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_rndne_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_rndne_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_rndne_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_rndne_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_rndne_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_rndne_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_rndne_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_rndne_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rndne_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_rndne_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rndne_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_rndne_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xa3,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rndne_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_rndne_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xa3,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_rsq_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_rsq_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rsq_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_rsq_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rsq_f16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_rsq_f16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rsq_f16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_rsq_f16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rsq_f16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_rsq_f16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rsq_f16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_rsq_f16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rsq_f16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_rsq_f16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rsq_f16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_rsq_f16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rsq_f16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_rsq_f16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rsq_f16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_rsq_f16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rsq_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_rsq_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rsq_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_rsq_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rsq_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_rsq_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xd6,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rsq_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_rsq_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xd6,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_rsq_f16_e64_dpp v5.h, v1.h mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_rsq_f16_e64_dpp v5.h, v1.h op_sel:[1,1] mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xd6,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rsq_f16_e64_dpp v5.l, v1.h mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_rsq_f16_e64_dpp v5.l, v1.h op_sel:[1,0] mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xd6,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rsq_f16_e64_dpp v255.h, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_rsq_f16_e64_dpp v255.h, -|v255.l| op_sel:[0,1] clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0xc1,0xd6,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_rsq_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_rsq_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_rsq_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_rsq_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_rsq_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_rsq_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_rsq_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_rsq_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_rsq_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_rsq_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_rsq_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_rsq_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_rsq_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_rsq_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_rsq_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_rsq_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_rsq_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_rsq_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xae,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_rsq_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_rsq_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xae,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_sat_pk_u8_i16_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_sat_pk_u8_i16_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_sat_pk_u8_i16_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_mirror
// GFX12: v_sat_pk_u8_i16_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_half_mirror
// GFX12: v_sat_pk_u8_i16_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_shl:1
// GFX12: v_sat_pk_u8_i16_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_shl:15
// GFX12: v_sat_pk_u8_i16_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_shr:1
// GFX12: v_sat_pk_u8_i16_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_shr:15
// GFX12: v_sat_pk_u8_i16_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_ror:1
// GFX12: v_sat_pk_u8_i16_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_ror:15
// GFX12: v_sat_pk_u8_i16_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_sat_pk_u8_i16_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_sat_pk_u8_i16_e64_dpp v5, v1 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x5f,0x01,0x01]

v_sat_pk_u8_i16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_sat_pk_u8_i16_e64_dpp v5, v1 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0x01,0x60,0x09,0x13]

v_sat_pk_u8_i16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_sat_pk_u8_i16_e64_dpp v255, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x00,0xe2,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_sat_pk_u8_i16_e64_dpp v255.h, v255 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_sat_pk_u8_i16_e64_dpp v255.h, v255 op_sel:[0,1] row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x40,0xe2,0xd5,0xfa,0x00,0x00,0x00,0xff,0x6f,0x05,0x30]

v_sin_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_sin_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_sin_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_sin_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_sin_f16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_sin_f16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_sin_f16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_sin_f16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_sin_f16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_sin_f16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_sin_f16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_sin_f16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_sin_f16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_sin_f16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_sin_f16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_sin_f16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_sin_f16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_sin_f16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_sin_f16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_sin_f16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_sin_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_sin_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_sin_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_sin_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_sin_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_sin_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xe0,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_sin_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_sin_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xe0,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_sin_f16_e64_dpp v5.h, v1.h mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_sin_f16_e64_dpp v5.h, v1.h op_sel:[1,1] mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xe0,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_sin_f16_e64_dpp v5.l, v1.h mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_sin_f16_e64_dpp v5.l, v1.h op_sel:[1,0] mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xe0,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_sin_f16_e64_dpp v255.h, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_sin_f16_e64_dpp v255.h, -|v255.l| op_sel:[0,1] clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0xc1,0xe0,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_sin_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_sin_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_sin_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_sin_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_sin_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_sin_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_sin_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_sin_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_sin_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_sin_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_sin_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_sin_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_sin_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_sin_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_sin_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_sin_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_sin_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_sin_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xb5,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_sin_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_sin_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xb5,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_sqrt_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_sqrt_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_sqrt_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_sqrt_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_sqrt_f16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_sqrt_f16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_sqrt_f16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_sqrt_f16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_sqrt_f16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_sqrt_f16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_sqrt_f16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_sqrt_f16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_sqrt_f16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_sqrt_f16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_sqrt_f16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_sqrt_f16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_sqrt_f16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_sqrt_f16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_sqrt_f16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_sqrt_f16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_sqrt_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_sqrt_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_sqrt_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_sqrt_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_sqrt_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_sqrt_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xd5,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_sqrt_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_sqrt_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xd5,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_sqrt_f16_e64_dpp v5.h, v1.h mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_sqrt_f16_e64_dpp v5.h, v1.h op_sel:[1,1] mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xd5,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_sqrt_f16_e64_dpp v5.l, v1.h mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_sqrt_f16_e64_dpp v5.l, v1.h op_sel:[1,0] mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xd5,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_sqrt_f16_e64_dpp v255.h, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_sqrt_f16_e64_dpp v255.h, -|v255.l| op_sel:[0,1] clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0xc1,0xd5,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_sqrt_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_sqrt_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_sqrt_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_sqrt_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_sqrt_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_sqrt_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_sqrt_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_sqrt_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_sqrt_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_sqrt_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_sqrt_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_sqrt_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_sqrt_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_sqrt_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_sqrt_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_sqrt_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_sqrt_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xb3,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_sqrt_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_sqrt_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xb3,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_trunc_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0]
// GFX12: v_trunc_f16_e64_dpp v5.l, v1.l quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_trunc_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3]
// GFX12: v_trunc_f16_e64_dpp v5.l, v1.l quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_trunc_f16_e64_dpp v5.l, v1.l row_mirror
// GFX12: v_trunc_f16_e64_dpp v5.l, v1.l row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_trunc_f16_e64_dpp v5.l, v1.l row_half_mirror
// GFX12: v_trunc_f16_e64_dpp v5.l, v1.l row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_trunc_f16_e64_dpp v5.l, v1.l row_shl:1
// GFX12: v_trunc_f16_e64_dpp v5.l, v1.l row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_trunc_f16_e64_dpp v5.l, v1.l row_shl:15
// GFX12: v_trunc_f16_e64_dpp v5.l, v1.l row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_trunc_f16_e64_dpp v5.l, v1.l row_shr:1
// GFX12: v_trunc_f16_e64_dpp v5.l, v1.l row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_trunc_f16_e64_dpp v5.l, v1.l row_shr:15
// GFX12: v_trunc_f16_e64_dpp v5.l, v1.l row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_trunc_f16_e64_dpp v5.l, v1.l row_ror:1
// GFX12: v_trunc_f16_e64_dpp v5.l, v1.l row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_trunc_f16_e64_dpp v5.l, v1.l row_ror:15
// GFX12: v_trunc_f16_e64_dpp v5.l, v1.l row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_trunc_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_trunc_f16_e64_dpp v5.l, v1.l row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_trunc_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_trunc_f16_e64_dpp v5.l, v1.l mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_trunc_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_trunc_f16_e64_dpp v5.l, v1.l mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xdd,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_trunc_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_trunc_f16_e64_dpp v255.l, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xdd,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_trunc_f16_e64_dpp v5.h, v1.h mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_trunc_f16_e64_dpp v5.h, v1.h op_sel:[1,1] mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x48,0xdd,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_trunc_f16_e64_dpp v5.l, v1.h mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_trunc_f16_e64_dpp v5.l, v1.h op_sel:[1,0] mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x08,0xdd,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_trunc_f16_e64_dpp v255.h, -|v255.l| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_trunc_f16_e64_dpp v255.h, -|v255.l| op_sel:[0,1] clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0xc1,0xdd,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]

v_trunc_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0]
// GFX12: v_trunc_f32_e64_dpp v5, v1 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1b,0x00,0xff]

v_trunc_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3]
// GFX12: v_trunc_f32_e64_dpp v5, v1 quad_perm:[0,1,2,3] row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0xe4,0x00,0xff]

v_trunc_f32_e64_dpp v5, v1 row_mirror
// GFX12: v_trunc_f32_e64_dpp v5, v1 row_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x40,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_half_mirror
// GFX12: v_trunc_f32_e64_dpp v5, v1 row_half_mirror row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x41,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_shl:1
// GFX12: v_trunc_f32_e64_dpp v5, v1 row_shl:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x01,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_shl:15
// GFX12: v_trunc_f32_e64_dpp v5, v1 row_shl:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x0f,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_shr:1
// GFX12: v_trunc_f32_e64_dpp v5, v1 row_shr:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x11,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_shr:15
// GFX12: v_trunc_f32_e64_dpp v5, v1 row_shr:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x1f,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_ror:1
// GFX12: v_trunc_f32_e64_dpp v5, v1 row_ror:1 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x21,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_ror:15
// GFX12: v_trunc_f32_e64_dpp v5, v1 row_ror:15 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x2f,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf
// GFX12: v_trunc_f32_e64_dpp v5, v1 row_share:0 row_mask:0xf bank_mask:0xf ; encoding: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x00,0x01,0x50,0x01,0xff]

v_trunc_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1
// GFX12: v_trunc_f32_e64_dpp v5, v1 mul:2 row_share:15 row_mask:0x0 bank_mask:0x1 ; encoding: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x08,0x01,0x5f,0x01,0x01]

v_trunc_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 fi:0
// GFX12: v_trunc_f32_e64_dpp v5, v1 mul:4 row_xmask:0 row_mask:0x1 bank_mask:0x3 bound_ctrl:1 ; encoding: [0x05,0x00,0xa1,0xd5,0xfa,0x00,0x00,0x10,0x01,0x60,0x09,0x13]

v_trunc_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 bound_ctrl:0 fi:1
// GFX12: v_trunc_f32_e64_dpp v255, -|v255| clamp div:2 row_xmask:15 row_mask:0x3 bank_mask:0x0 fi:1 ; encoding: [0xff,0x81,0xa1,0xd5,0xfa,0x00,0x00,0x38,0xff,0x6f,0x05,0x30]
